//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		FieldDemoPlayer.cpp
 *	@brief  tB[hfvC[
 *	@author	Masayuki Onoue
 *	@date		2012.08.23
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "FieldDemoPlayer.h"
#include <arc/arc_def.h>
#include "sound/sound.h"
#include "arc/demo_sequence.gaix"

namespace field{

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------

  // 
  //----------------------------------------------------------------------------
  /**
   *	@brief  RXgN^
   */
  //-----------------------------------------------------------------------------
  FieldDemoPlayer::FieldDemoPlayer( void ) : 
    m_pHeap(NULL),
    m_pDevice(NULL),
    m_pGraphics(NULL),
    m_SeqInitialize(0),
    m_Initialized(false),
    m_pCamera(NULL),
    mp_player(NULL)
  {
  }

  // 
  //----------------------------------------------------------------------------
  /**
   *	@brief  fXgN^
   */
  //-----------------------------------------------------------------------------
  FieldDemoPlayer::~FieldDemoPlayer()
  {
    this->Delete();
  }
  


  //----------------------------------------------------------------------------
  /**
   *	@brief  `GtFNg@
   */
  //-----------------------------------------------------------------------------
  void FieldDemoPlayer::Create( gfl::heap::HeapBase* p_heap, gfl::heap::HeapBase* p_device, const FieldDemoPlayerParam& param, Graphics* p_graphics ,gfl::fs::FileReadManager* p_readman)
  {
    // p[^Rs[
    m_Param = param;

    m_pHeap       = p_heap;
    m_pDeviceHeap = p_device;
    m_pDevice   = GFL_NEW( p_device ) gfl::heap::NwAllocator( p_device );

    m_pGraphics = p_graphics;

    m_pHeapAllocator = GFL_NEW(m_pHeap) gfl::heap::NwAllocator( m_pHeap );
    m_pDeviceAllocator = GFL_NEW(m_pHeap) gfl::heap::NwAllocator( p_device );

    m_poke_sys = GFL_NEW(m_pHeap) poke_tool::PokeModelSystem();
    m_poke_sys->InitSystem(
        m_pHeapAllocator,
        m_pDeviceAllocator,
        p_readman
        );

  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  `GtFNg@j
   */
  //-----------------------------------------------------------------------------
  void FieldDemoPlayer::Delete( void )
  {
    gfl::grp::g3d::Scene* p_scene = m_pGraphics->GetScene();

    if(m_pDevice)
    {
      if( mp_player )
      {
        mp_player->UnLoad(true);
      }
      GFL_SAFE_DELETE(mp_player);

      // |PfVXe̕Еt
      if( m_poke_sys )
      {
        m_poke_sys->ExitSystem();
      }
      GFL_SAFE_DELETE(m_poke_sys);

      if( m_pCamera )
      {
        p_scene->SetCamera( SCENE_CAMERA_INDEX_EVENT, NULL );
        p_scene->RemoveCameraFromSceneCalculateGroup( m_pCamera );
      }
      GFL_SAFE_DELETE(m_pCamera);

      // AP[^[j
      GFL_SAFE_DELETE(m_pHeapAllocator);
      GFL_SAFE_DELETE(m_pDeviceAllocator);
      GFL_SAFE_DELETE(m_pDevice);
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  `GtFNg@
   *
   *	@retval true  
   *	@retval false 
   */
  //-----------------------------------------------------------------------------
  bool FieldDemoPlayer::Initialize( void )
  {
    enum
    {
      SEQ_INIT,
      SEQ_LOADWAIT,
      SEQ_SETUP,
      SEQ_END,
    };
    bool result;
    
    switch( m_SeqInitialize ){
    case SEQ_INIT:
      // ǂݍ݊Jn
      {
        gfl::grp::g3d::Scene* p_scene = m_pGraphics->GetScene();

        // _[^[Qbg擾
        gfl::grp::GraphicsSystem* graphics_system = m_pGraphics->GetGraphicsSystem();
        gfl::grp::FrameBufferManager* frameBufferManager = graphics_system->GetFrameBufferManager( );
        gfl::grp::RenderTarget* p_render_target =
          frameBufferManager->GetRenderTarget(
              graphics_system->GetCurrentFrameBufferID( gfl::grp::DISPLAY_UPPER ) );

        m_pCamera = GFL_NEW( m_pDeviceHeap ) gfl::grp::g3d::StereoCamera();
        m_pCamera->Create( m_pDeviceAllocator,
            gfl::math::VEC3( 0.0f, 0.0f, 400.0f ),  // Jʒu
            gfl::math::VEC3( 0.0f, 0.0f, 0.0f ),   // _ʒu
            0.1f );

        m_pCamera->GetBaseCamera()->SetAspect(400.0f/240.0f);

        // SăCxgpV[ɂB
        m_pGraphics->GetScene()->AddCameraToSceneCalculateGroup( 
            m_pCamera, SCENE_CALCULATE_GROUP_INDEX_ANIMATION_CAMERA );
        m_pGraphics->GetScene()->SetCamera( SCENE_CAMERA_INDEX_EVENT, m_pCamera );

        // SimpleParamCoreParam擾
        poke_tool::GetSimpleParam(&m_poke_para,m_Param.cp_pokepara);

        static xy_system::sequence::Param param = {
          m_pHeap,
          m_pHeapAllocator,
          m_pDeviceAllocator,
          p_scene,
          m_pCamera,
          p_render_target, // ʃ_[^[Qbg
          m_poke_sys,   // Ƀ|PfVXe
          &m_poke_para, // |PSimpleParam̔z
          1,            // Simpleparam̐
          SCENE_DRAW_GROUP_INDEX_EVENT_DEMO,//f`
          SCENE_CALCULATE_GROUP_INDEX_EVENT_DEMO,//fvZ
          SCENE_DRAW_GROUP_INDEX_EVENT_DEMO,//|Pf`
          SCENE_CALCULATE_GROUP_INDEX_EVENT_DEMO,//|PfvZ
          SCENE_DRAW_GROUP_INDEX_EVENT_DEMO,//p[eBN`
          SCENE_CALCULATE_GROUP_INDEX_EVENT_DEMO,//p[eBNvZ
          SCENE_DRAW_GROUP_INDEX_EVENT_DEMO,//XN[p[eBN`
          SCENE_CALCULATE_GROUP_INDEX_EVENT_DEMO,//XN[p[eBNvZ

          NULL // app::util::G2dUtil*
        };

        mp_player = GFL_NEW(m_pHeap) xy_system::sequence::Player(&param);


      }

      m_pGraphics->StartEventDemoRendering( m_pCamera, CallbackGraphicsCalculateBefore, CallbackGraphicsCalculateAfter, this );

      ++ m_SeqInitialize;
      // break through 

    case SEQ_LOADWAIT:
      ++ m_SeqInitialize;
      // break through 
      
    case SEQ_SETUP:
      {
        // \[XɃA^b`
        {
          mp_player->LoadRequest(ARCID_DEMO_SEQ, m_Param.field_demo_no);
        }
      }
      
      ++ m_SeqInitialize;
      // break through 

    case SEQ_END:
      
        if(mp_player->IsReady())
        {
          mp_player->Play();
          m_Initialized = true;
          return true;
        }
      return false;
    default:
      m_Initialized = true;
      return true;
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  `GtFNg@҂
   *
   *	@retval true  
   *	@retval false ĂȂ
   */
  //-----------------------------------------------------------------------------
  bool FieldDemoPlayer::IsInitialize( void ) const
  {
    return m_Initialized;
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  `GtFNg@XV
   *
   *	@retval true  
   *	@retval false r
   */
  //-----------------------------------------------------------------------------
  bool FieldDemoPlayer::Update( void )
  {
    bool is_end = true;

    if( mp_player )
    {
      mp_player->Update();

      // J̍ւ
      gfl::grp::g3d::StereoCamera* p_cam = mp_player->GetCamera();
      m_pGraphics->SetEventDemoRenderingCamera( p_cam );
        
      if( mp_player->IsPlaying())
      {
        is_end = false;
      }
      else
      {
        // Î
        m_pGraphics->EndEventDemoRendering();
      }
    }
    return is_end;
  }


  //-----------------------------------------------------------------------------
  /**
   *    B֐S
   */
  //-----------------------------------------------------------------------------
  //----------------------------------------------------------------------------
  /**
   *	@brief  Graphics CalculateOɃR[R[obN
   */
  //-----------------------------------------------------------------------------
  void FieldDemoPlayer::CallbackGraphicsCalculateBefore( void* p_work )
  {
    FieldDemoPlayer* p_this = reinterpret_cast<FieldDemoPlayer*>(p_work);

    p_this->GraphicsUpdateBefore();
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  Graphics CalculateɃR[R[obN
   */
  //-----------------------------------------------------------------------------
  void FieldDemoPlayer::CallbackGraphicsCalculateAfter( void* p_work )
  {
    FieldDemoPlayer* p_this = reinterpret_cast<FieldDemoPlayer*>(p_work);
    p_this->GraphicsUpdateAfter();
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  GraphicsCalculateȌ
   */
  //-----------------------------------------------------------------------------
  void FieldDemoPlayer::GraphicsUpdateBefore( void )
  {
    if( m_poke_sys )
    {
      m_poke_sys->UpdateSystem();
      m_poke_sys->UpdateModel();
    }
  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief  GraphicsCalculatȅ
   */
  //-----------------------------------------------------------------------------
  void FieldDemoPlayer::GraphicsUpdateAfter( void )
  {
    if( m_poke_sys )
    {
      // |PfAjXV
      m_poke_sys->UpdateModelAnime();
    }

  }

} // namespace field

