//==============================================================================
/**
 * @file	battle_match_select5_view.cpp
 * @brief	ʃTur[@I5
 * @author	ichiraku_katsuhiko
 * @data	2012/08/22, 12:17
 */
// =============================================================================


#include "battle_match_select5_view.h"

// resource
#include <arc/arc_def.h>
#include <message/message.gaix>
#include <message/msg_battle_match.h>
#include "../battle_match_gra.h"
#include "../battle_match_gra_pane.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)

//-----------------------------------------------------------------------------
/**
 *    ButtonManagerpBoundbox Xg`
 */
//-----------------------------------------------------------------------------
// 1
static const app::ui::ButtonInfo BUTTON5[] ={
  ///< {^1
  {
    PANENAME_BATTLEMATCH_LOWER_PANE_SELECT_BAR_04_01,	// picture_pane
    PANENAME_BATTLEMATCH_LOWER_PANE_BOUND_04_01,			// bound_pane
    ANMID_LOWER_HOLD		+ 0,								// hold_anime_index
    ANMID_LOWER_RELEASE + 0,								// release_anime_index
    ANMID_LOWER_SELECT	+ 0,								// select_anime_index
    ANMID_LOWER_ACTIVE	+ 0,								// active_anime_index
    ANMID_LOWER_PASSIVE	+ 0,								// passive_anime_index
  },
  ///< {^2
  {
    PANENAME_BATTLEMATCH_LOWER_PANE_SELECT_BAR_04_02,	// picture_pane
    PANENAME_BATTLEMATCH_LOWER_PANE_BOUND_04_02,			// bound_pane
    ANMID_LOWER_HOLD		+ 1,								// hold_anime_index
    ANMID_LOWER_RELEASE + 1,								// release_anime_index
    ANMID_LOWER_SELECT	+ 1,								// select_anime_index
    ANMID_LOWER_ACTIVE	+ 1,								// active_anime_index
    ANMID_LOWER_PASSIVE	+ 1,								// passive_anime_index
  },
  ///< {^3
  {
    PANENAME_BATTLEMATCH_LOWER_PANE_SELECT_BAR_04_03,	// picture_pane
    PANENAME_BATTLEMATCH_LOWER_PANE_BOUND_04_03,			// bound_pane
    ANMID_LOWER_HOLD		+ 2,								// hold_anime_index
    ANMID_LOWER_RELEASE + 2,								// release_anime_index
    ANMID_LOWER_SELECT	+ 2,								// select_anime_index
    ANMID_LOWER_ACTIVE	+ 2,								// active_anime_index
    ANMID_LOWER_PASSIVE	+ 2,								// passive_anime_index
  },
  ///< {^4
  {
    PANENAME_BATTLEMATCH_LOWER_PANE_SELECT_BAR_04_04,	// picture_pane
    PANENAME_BATTLEMATCH_LOWER_PANE_BOUND_04_04,			// bound_pane
    ANMID_LOWER_HOLD		+ 3,								// hold_anime_index
    ANMID_LOWER_RELEASE + 3,								// release_anime_index
    ANMID_LOWER_SELECT	+ 3,								// select_anime_index
    ANMID_LOWER_ACTIVE	+ 3,								// active_anime_index
    ANMID_LOWER_PASSIVE	+ 3,								// passive_anime_index
  },
  ///< {^5
  {
    PANENAME_BATTLEMATCH_LOWER_PANE_SELECT_BAR_04_05,	// picture_pane
    PANENAME_BATTLEMATCH_LOWER_PANE_BOUND_04_05,			// bound_pane
    ANMID_LOWER_HOLD		+ 4,								// hold_anime_index
    ANMID_LOWER_RELEASE + 4,								// release_anime_index
    ANMID_LOWER_SELECT	+ 4,								// select_anime_index
    ANMID_LOWER_ACTIVE	+ 4,								// active_anime_index
    ANMID_LOWER_PASSIVE	+ 4,								// passive_anime_index
  },
  ///< ߂
  {
    PANENAME_BATTLEMATCH_LOWER_PANE_SELECT_BAR_04_06,	// picture_pane
    PANENAME_BATTLEMATCH_LOWER_PANE_BOUND_04_06,			// bound_pane
    ANMID_LOWER_HOLD		+ 5,								// hold_anime_index
    ANMID_LOWER_RELEASE + 5,								// release_anime_index
    ANMID_LOWER_SELECT	+ 5,								// select_anime_index
    ANMID_LOWER_ACTIVE	+ 5,								// active_anime_index
    ANMID_LOWER_PASSIVE	+ 5,								// passive_anime_index
  },
};

#if 0
// LAj`
static const app::util::LytUtil::ShareAnimeDesc SHARE_ANIME[] = {
{
		ANMID_LOWER_HOLD,																// Aj擪CfbNX
		BUTTON_NUM,																				// ő勤L
		LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_LOWER_TOUCH_BCLAN,	// Ajf[^CfbNX
		PANENAME_CONNECT_LOWER_GROUP_BUTTON_ANIME_01,								// VFAΏۂ̃O[v
		gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,										// VFAΏۂ̃yC
	},
	{
		ANMID_LOWER_RELEASE,															// Aj擪CfbNX
		BUTTON_NUM,																				// ő勤L
		LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_LOWER_CANSEL_BCLAN,	// Ajf[^CfbNX
		PANENAME_CONNECT_LOWER_GROUP_BUTTON_ANIME_01,								// VFAΏۂ̃O[v
		gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,										// VFAΏۂ̃yC
	},
	{
		ANMID_LOWER_SELECT,															// Aj擪CfbNX
		BUTTON_NUM,																				// ő勤L
		LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_LOWER_RELEASE_BCLAN,// Ajf[^CfbNX
		PANENAME_CONNECT_LOWER_GROUP_BUTTON_ANIME_01,								// VFAΏۂ̃O[v
		gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,										// VFAΏۂ̃yC
	},
	{
		ANMID_LOWER_ACTIVE,															// Aj擪CfbNX
		BUTTON_NUM,																				// ő勤L
		LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_LOWER_ACTIVE_BCLAN,// Ajf[^CfbNX
		PANENAME_CONNECT_LOWER_GROUP_BUTTON_ANIME_01,								// VFAΏۂ̃O[v
		gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,										// VFAΏۂ̃yC
	},
	{
		ANMID_LOWER_PASSIVE	,															// Aj擪CfbNX
		BUTTON_NUM,																				// ő勤L
		LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_LOWER_PASSIVE_BCLAN,// Ajf[^CfbNX
		PANENAME_CONNECT_LOWER_GROUP_BUTTON_ANIME_01,								// VFAΏۂ̃O[v
		gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,										// VFAΏۂ̃yC
	},
};
#endif

// RXgN^
Select5View::Select5View(	app::util::Heap * heap,
													app::util::G2DUtil* g2dUtil,
													app::util::G2DUtil::LAYOUT_WORK* lyt_wk ) :
	ViewBase( heap ),
	m_uiListener( NULL )
{
	// er[̃CAEgg
	Create2D( heap, g2dUtil->GetLayoutSystem(), LAYOUT_ID_MAX,
					  lyt_wk, LAYOUT_ID_MAX,
					  g2dUtil->GetMessageData(), g2dUtil->GetWordSet() );
	
	SetInputListener( this );

	// {^}l[Wo^
	this->SetButtonManager();
}

// fXgN^
Select5View::~Select5View( void )
{
	Delete2D();
}

//--------------------------------------------------------------------------
/**
 *  @brief `
 */
//--------------------------------------------------------------------------
void Select5View::Update( void )
{
  this->app::ui::UIView::Update();
}

//--------------------------------------------------------------------------
/**
 *  @brief `
 */
//--------------------------------------------------------------------------
void Select5View::Draw( void )
{
  m_g2dUtil->Draw2D( GetSuperView()->GetGraphicSystem(), LAYOUT_ID_LOWER );
}

//--------------------------------------------------------------------------
/**
 * @brief		UICxgpXi̓o^
 */
//--------------------------------------------------------------------------
void Select5View::SetBattleMatchUIListener( BattleMatchUIListener *listener )
{
	m_uiListener = listener;
}

//------------------------------------------------------------------
/**
* @brief   yCCxǧm
*
* @param  layoutId ʒm󂯂郌CAEghc
* @param  painId   ʒm󂯂yChc
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// overwride
bool Select5View::OnLayoutPaneEvent( const u32 painId )
{
	if( m_uiListener == NULL ){
		GFL_PRINT("UIXi[o^ĂȂ\n");
		return true;
	}
	// Aj͑얳
	if( IsAnimeEnd() == false )
	{
		GFL_PRINT("AjEEE\n");
		return true;
	}

  switch( painId ){
	case PANENAME_BATTLEMATCH_LOWER_PANE_SELECT_BAR_04_01:
		ICHI_PRINT("{^1\n");
		m_uiListener->OnButtonAction( 0 );
		return false;
	case PANENAME_BATTLEMATCH_LOWER_PANE_SELECT_BAR_04_02:
		ICHI_PRINT("{^2\n");
		m_uiListener->OnButtonAction( 1 );
		return false;
	case PANENAME_BATTLEMATCH_LOWER_PANE_SELECT_BAR_04_03:
		ICHI_PRINT("{^3\n");
		m_uiListener->OnButtonAction( 2 );
		return false;
	case PANENAME_BATTLEMATCH_LOWER_PANE_SELECT_BAR_04_04:
		ICHI_PRINT("{^4\n");
		m_uiListener->OnButtonAction( 3 );
		return false;
	case PANENAME_BATTLEMATCH_LOWER_PANE_SELECT_BAR_04_05:
		ICHI_PRINT("{^5\n");
		m_uiListener->OnButtonAction( 4 );
		return false;
	case PANENAME_BATTLEMATCH_LOWER_PANE_SELECT_BAR_04_06:
		ICHI_PRINT("{^6\n");
		m_uiListener->OnReturnAction();		// ߂
		return false;
	}

	return true;
}

//------------------------------------------------------------------
/**
* @brief   L[͂̌m
*
* @param  pKey    \L[
* @param  pStick  AiOXeBbN
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// overwride
bool Select5View::OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick)
{
	if( m_uiListener == NULL ){
		GFL_PRINT("UIXi[o^ĂȂ\n");
		return true;
	}
	// Aj͑얳
	if( IsAnimeEnd() == false )
	{
		GFL_PRINT("AjEEE\n");
		return true;
	}

	if( pKey->IsTrigger( gfl::ui::BUTTON_B ) ){
		ICHI_PRINT("B{^\n");
		m_uiListener->OnReturnAction();
		return false;
	}

  return true;
}


//--------------------------------------------------------------------------
/**
 * @brief	 ^Cg̕\
 * @param msg_id	\郁bZ[WID
 */
//--------------------------------------------------------------------------
void Select5View::SetTextTitle( u32 msg_id )
{
	SetTextboxPaneMessage( LAYOUT_ID_LOWER, PANENAME_BATTLEMATCH_LOWER_PANE_TEXT_00_00, msg_id );
}

//--------------------------------------------------------------------------
/**
 * @brief	 {^Ƀog[\
 */
//--------------------------------------------------------------------------
void Select5View::SetTextBattleRule( void )
{
	// VO
	SetTextboxPaneMessage( LAYOUT_ID_LOWER, PANENAME_BATTLEMATCH_LOWER_PANE_TEXT_04_01, battle_match_button_09 );
	// _u
	SetTextboxPaneMessage( LAYOUT_ID_LOWER, PANENAME_BATTLEMATCH_LOWER_PANE_TEXT_04_02, battle_match_button_10 );
	// gv
	SetTextboxPaneMessage( LAYOUT_ID_LOWER, PANENAME_BATTLEMATCH_LOWER_PANE_TEXT_04_03, battle_match_button_11 );
	// [e[V
	SetTextboxPaneMessage( LAYOUT_ID_LOWER, PANENAME_BATTLEMATCH_LOWER_PANE_TEXT_04_04, battle_match_button_12 );
	// XyV
	SetTextboxPaneMessage( LAYOUT_ID_LOWER, PANENAME_BATTLEMATCH_LOWER_PANE_TEXT_04_05, battle_match_button_13 );
	// ߂
	SetTextboxPaneMessage( LAYOUT_ID_LOWER, PANENAME_BATTLEMATCH_LOWER_PANE_TEXT_04_06, battle_match_button_14 );
}

//--------------------------------------------------------------------------
/**
 * @breif	 {^}l[WɃ{^ݒ肷
 */
//--------------------------------------------------------------------------
void Select5View::SetButtonManager( void )
{
	const u32	paneNum = ( sizeof(BUTTON5) / sizeof(app::ui::ButtonInfo) );
	ReloadButtonManager( m_heap, GetLayoutWork( LAYOUT_ID_LOWER ), BUTTON5, paneNum );
}

GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)
