//==============================================================================
/**
 * @file	battle_match_result_view.cpp
 * @brief	ʃTur[@
 * @author	ichiraku_katsuhiko
 * @data	2012/08/22, 12:49
 */
// =============================================================================

#include "battle_match_result_view.h"

// resource
#include <arc/arc_def.h>
#include <message/message.gaix>
#include <message/msg_battle_match.h>
#include "../battle_match_gra.h"
#include "../battle_match_gra_pane.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)

// RXgN^
ResultView::ResultView(	app::util::Heap * heap,
													app::util::G2DUtil* g2dUtil,
													app::util::G2DUtil::LAYOUT_WORK* lyt_wk ) :
	ViewBase( heap )
{
	// er[̃CAEgg
	Create2D( heap, g2dUtil->GetLayoutSystem(), LAYOUT_ID_MAX,
					  lyt_wk, LAYOUT_ID_MAX,
					  g2dUtil->GetMessageData(), g2dUtil->GetWordSet() );
}

// fXgN^
ResultView::~ResultView( void )
{
	Delete2D();
}

//--------------------------------------------------------------------------
/**
 *  @brief `
 */
//--------------------------------------------------------------------------
void ResultView::Update( void )
{
  //this->app::ui::UIView::Update();
}

//--------------------------------------------------------------------------
/**
 *  @brief `
 */
//--------------------------------------------------------------------------
void ResultView::Draw( void )
{
  m_g2dUtil->Draw2D( GetSuperView()->GetGraphicSystem(), LAYOUT_ID_LOWER );
}

//--------------------------------------------------------------------------
/**
 * @brief	 ^Cg̕\
 * @param msg_id	\郁bZ[WID
 */
//--------------------------------------------------------------------------
void ResultView::SetTextTitle( u32 msg_id )
{
	SetTextboxPaneMessage( LAYOUT_ID_LOWER, PANENAME_BATTLEMATCH_LOWER_PANE_TEXT_00_00, msg_id );
}



GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)
