//==============================================================================
/**
 * @file	battle_match_proc_select_mode_cup.cpp
 * @brief	og}b`@TuvbN@ogI
 * @author	ichiraku_katsuhiko
 * @data	2012/08/17, 18:09
 */
// =============================================================================


#include "battle_match_proc_select_mode_cup.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)
GFL_NAMESPACE_BEGIN(proc)

// RXgN^
ProcSelectModeCup::ProcSelectModeCup( void ) : ProcBase()
{
	ICHI_PRINT("ProcSelectModeCup::ProcSelectModeCup\n");
}

// fXgN^
ProcSelectModeCup::~ProcSelectModeCup( void )
{
	ICHI_PRINT("ProcSelectModeCup::~ProcSelectModeCup\n");
}

//--------------------------------------------------------------------------
/**
 * @brief			֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂUpdateFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSelectModeCup::InitFunc( void )
{
	// qviewN
	m_view->RegistSelect3( this );

	// qview擾
	m_view_lower = m_view->GetSubViewSelect3();

	// ^Cg
	m_view_lower->SetTextTitle( battle_match_guide_02 );
	m_view_lower->SetTextButton( battle_match_button_04, battle_match_button_05, battle_match_button_06, battle_match_button_14 );

	// AjJn
	switch( GetSwitchType() ){
	case SWITCH_SELECT:				///< Iŗ
		m_view_lower->StartAnime( ANMID_LOWER_3_IN_LEFT );
		break;
	case SWITCH_RETURN:				///< ߂ł
		m_view_lower->StartAnime( ANMID_LOWER_3_IN_RIGHT );
		break;
	case SWITCH_FIRST:				///< ŏ\
	default:
		GFL_ASSERT(0);
		break;
	}

	return RESULT_FINISH;
}

//--------------------------------------------------------------------------
/**
 * @brief			XV֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂExitFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSelectModeCup::UpdateFunc( void )
{

	if( m_isEnd == true )
	{
		return RESULT_FINISH;
	}
	
	return RESULT_CONTINUE;
}

//--------------------------------------------------------------------------
/**
 * @brief			I֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂUpdateFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSelectModeCup::ExitFunc( void )
{
	// qview
	if( m_view->CancelSelect3() == true )
	{
		return RESULT_FINISH;
	}

	return RESULT_CONTINUE;
}

//--------------------------------------------------------------------------
/**
 * @brief		{^ʒm
 */
//--------------------------------------------------------------------------
void ProcSelectModeCup::OnButtonAction( int button_no )
{
	// 3Ȃ̂łȊÕ{^͉Ȃ͂
	GFL_ASSERT_MSG( button_no<3, "Ⴄ{^Ă button_no->%d \n", button_no );

	switch( button_no ){
	case 0:
	case 1:
	case 2:
		//SetFinish( NEXT_ );
		//m_view_lower->StartAnime( ANMID_LOWER_3_OUT_LEFT );		// EɃtF[hAEg
		break;
	}

	// Iސݒ
	SetSwitchType( SWITCH_SELECT );
}

//--------------------------------------------------------------------------
/**
 * @brief		^[ʒm
 */
//--------------------------------------------------------------------------
void ProcSelectModeCup::OnReturnAction( void )
{
	m_view_lower->StartAnime( ANMID_LOWER_3_OUT_RIGHT );		// EɃtF[hAEg

	// Iސݒ
	SetSwitchType( SWITCH_RETURN );

	ICHI_PRINT("߂鉟\n");
	SetFinish( NEXT_SELECT_MATCH );
}

GFL_NAMESPACE_END(proc)
GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)
