//==============================================================================
/**
 * @file	battle_match_parent_view.h
 * @brief	og}b`Oʁ@Cr[
 * @author	ichiraku_katsuhiko
 * @data	2012/08/20, 19:19
 */
// =============================================================================

#if !defined( __BATTLE_MATCH_PARENT_VIEW_H__ )
#define	__BATTLE_MATCH_PARENT_VIEW_H__

#include <app/util/app_util_heap.h>
#include <app/util/app_util_2d.h>
#include <app/ui/UIView.h>
#include <app/ui/UIInputListener.h>

// UIXi
#include "BattleMatchUIListener.h"

// r[x[X
#include "battle_match_view_base.h"

// Tur[
#include "battle_match_view/battle_match_select1_view.h"
#include "battle_match_view/battle_match_select2_view.h"
#include "battle_match_view/battle_match_select3_view.h"
#include "battle_match_view/battle_match_select5_view.h"
#include "battle_match_view/battle_match_result_view.h"
#include "battle_match_view/battle_match_wait_view.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)

class ParentView : public ViewBase
{
	GFL_FORBID_COPY_AND_ASSIGN(ParentView);

public:
  // RXgN^
  ParentView( app::util::Heap * heap );
  // fXgN^
  virtual ~ParentView( void );

	virtual void Draw( void ){};

public:
	// eTur[̓o^
	void RegistSelect1( BattleMatchUIListener *listener );		// Select1View
	void RegistSelect2( BattleMatchUIListener *listener );		// Select2View
	void RegistSelect3( BattleMatchUIListener *listener );		// Select3View
	void RegistSelect5( BattleMatchUIListener *listener );		// Select5View
	void RegistResult( void );		// ResultView
	void RegistWait( void );			// WaitView

	// eTur[̓o^
	bool CancelSelect1( void );		// Select1View
	bool CancelSelect2( void );		// Select2View
	bool CancelSelect3( void );		// Select3View
	bool CancelSelect5( void );		// Select5View
	bool CancelResult( void );			// ResultView
	bool CancelWait( void );				// WaitView

	// eTur[擾
	inline Select1View* GetSubViewSelect1( void ) const { return m_select1_view; };
	inline Select2View* GetSubViewSelect2( void ) const { return m_select2_view; };
	inline Select3View* GetSubViewSelect3( void ) const { return m_select3_view; };
	inline Select5View* GetSubViewSelect5( void ) const { return m_select5_view; };
	inline ResultView*	GetSubViewResult( void ) const { return m_result_view; };
	inline WaitView*		GetSubViewWait( void ) const { return m_wait_view; };

private:
	void Initialize2D( app::util::Heap *heap );

private:
	static const gfl::grp::g2d::LytArcIndex UpperAnmIndex[ ANMID_UPPER_MAX ];	///< Aj[Ve[u
	static const gfl::grp::g2d::LytArcIndex LowerAnmIndex[ ANMID_LOWER_MAX ];	///< Aj[Ve[u

	app::util::G2DUtil::LAYOUT_WORK m_lyt_wk[ LAYOUT_ID_MAX ];	///< CAEg[N

	// Tur[
	Select1View*				m_select1_view;
	Select2View*				m_select2_view;
	Select3View*				m_select3_view;
	Select5View*				m_select5_view;
	ResultView*					m_result_view;
	WaitView*						m_wait_view;

};


GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)

#endif	/* __BATTLE_MATCH_PARENT_VIEW_H__ */

