//==============================================================================
/**
 * @file	battle_match_parent_view.cpp
 * @brief	og}b`Oʁ@Cr[
 * @author	ichiraku_katsuhiko
 * @data	2012/08/20, 19:44
 */
// =============================================================================


#include "battle_match_parent_view.h"

// resource
#include <arc/arc_def.h>
#include <message/message.gaix>
#include <message/msg_battle_match.h>
#include "battle_match_gra.h"
#include "battle_match_gra_pane.h"

#include "common_res/msg_window_res.h"

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)

// Ajf[^()
const gfl::grp::g2d::LytArcIndex ParentView::UpperAnmIndex[ ANMID_UPPER_MAX ] = {
	LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_UPPER_ANIME_A_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_UPPER_ANIME_B_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_UPPER_ANIME_C_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_UPPER_ANIME_D_BCLAN,
};

// Ajf[^iʁj
const gfl::grp::g2d::LytArcIndex ParentView::LowerAnmIndex[ ANMID_LOWER_MAX ] = {
	// wb_[̏ԂƓɂ
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_A_1_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_A_2_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_A_3_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_A_4_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_B_1_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_B_2_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_B_3_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_B_4_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_C_1_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_C_2_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_C_3_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_C_4_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_D_1_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_D_2_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_D_3_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_D_4_BCLAN,
	LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_RESULT_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_YES_NO_BCLAN,
};

#if 0
// LAj`
static const app::util::LytUtil::ShareAnimeDesc SHARE_ANIME[] = {
{
		ParentView::ANMID_LOWER_HOLD,																// Aj擪CfbNX
		ParentView::BUTTON_NUM,																				// ő勤L
		LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_LOWER_TOUCH_BCLAN,	// Ajf[^CfbNX
		PANENAME_CONNECT_LOWER_GROUP_BUTTON_ANIME_01,								// VFAΏۂ̃O[v
		gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,										// VFAΏۂ̃yC
	},
	{
		ParentView::ANMID_LOWER_RELEASE,															// Aj擪CfbNX
		ParentView::BUTTON_NUM,																				// ő勤L
		LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_LOWER_CANSEL_BCLAN,	// Ajf[^CfbNX
		PANENAME_CONNECT_LOWER_GROUP_BUTTON_ANIME_01,								// VFAΏۂ̃O[v
		gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,										// VFAΏۂ̃yC
	},
	{
		ParentView::ANMID_LOWER_SELECT,															// Aj擪CfbNX
		ParentView::BUTTON_NUM,																				// ő勤L
		LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_LOWER_RELEASE_BCLAN,// Ajf[^CfbNX
		PANENAME_CONNECT_LOWER_GROUP_BUTTON_ANIME_01,								// VFAΏۂ̃O[v
		gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,										// VFAΏۂ̃yC
	},
	{
		ParentView::ANMID_LOWER_ACTIVE,															// Aj擪CfbNX
		ParentView::BUTTON_NUM,																				// ő勤L
		LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_LOWER_ACTIVE_BCLAN,// Ajf[^CfbNX
		PANENAME_CONNECT_LOWER_GROUP_BUTTON_ANIME_01,								// VFAΏۂ̃O[v
		gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,										// VFAΏۂ̃yC
	},
	{
		ParentView::ANMID_LOWER_PASSIVE	,															// Aj擪CfbNX
		ParentView::BUTTON_NUM,																				// ő勤L
		LYTRES_PSS_BATTLE_RECEIVE_RES_CONNECT_LOWER_PASSIVE_BCLAN,// Ajf[^CfbNX
		PANENAME_CONNECT_LOWER_GROUP_BUTTON_ANIME_01,								// VFAΏۂ̃O[v
		gfl::grp::g2d::LYTSYS_PANEINDEX_ERROR,										// VFAΏۂ̃yC
	},
};
#endif

// RXgN^
ParentView::ParentView( app::util::Heap * heap ) :
	ViewBase( heap )
{
	// er[쐬
	CreateGraphicsSystem( heap );
	Initialize2D( heap );

	// Tur[쐬
	m_select1_view = GFL_NEW( heap->GetSystemHeap() ) Select1View( heap, GetG2DUtil(), m_lyt_wk );
	m_select2_view = GFL_NEW( heap->GetSystemHeap() ) Select2View( heap, GetG2DUtil(), m_lyt_wk );
	m_select3_view = GFL_NEW( heap->GetSystemHeap() ) Select3View( heap, GetG2DUtil(), m_lyt_wk );
	m_select5_view = GFL_NEW( heap->GetSystemHeap() ) Select5View( heap, GetG2DUtil(), m_lyt_wk );
	m_result_view  = GFL_NEW( heap->GetSystemHeap() ) ResultView( heap, GetG2DUtil(), m_lyt_wk );
	m_wait_view		 = GFL_NEW( heap->GetSystemHeap() )	WaitView( heap, GetG2DUtil(), m_lyt_wk );

}

// fXgN^
ParentView::~ParentView( void )
{
	m_select1_view->RemoveFromSuperView();
	GFL_SAFE_DELETE( m_select1_view );
	
	m_select2_view->RemoveFromSuperView();
	GFL_SAFE_DELETE( m_select2_view );

	m_select3_view->RemoveFromSuperView();
	GFL_SAFE_DELETE( m_select3_view );

	m_select5_view->RemoveFromSuperView();
	GFL_SAFE_DELETE( m_select5_view );

	m_result_view->RemoveFromSuperView();
	GFL_SAFE_DELETE( m_result_view );

	m_wait_view->RemoveFromSuperView();
	GFL_SAFE_DELETE( m_wait_view );

	Delete2D();
	DeleteGraphicsSystem();
}


//--------------------------------------------------------------------------
/**
 *	@brief		qr[o^:Select1View
 *	@param		o^郊Xi[
 */
//--------------------------------------------------------------------------
void ParentView::RegistSelect1( BattleMatchUIListener *listener )
{
	this->AddSubView( m_select1_view );
	m_select1_view->SetBattleMatchUIListener( listener );
}

//--------------------------------------------------------------------------
/**
 *	@brief		qr[o^:Select2View
 *	@param		o^郊Xi[
 */
//--------------------------------------------------------------------------
void ParentView::RegistSelect2( BattleMatchUIListener *listener )
{
	this->AddSubView( m_select2_view );
	m_select2_view->SetBattleMatchUIListener( listener );
}

//--------------------------------------------------------------------------
/**
 *	@brief		qr[o^:Select3View
 *	@param		o^郊Xi[
 */
//--------------------------------------------------------------------------
void ParentView::RegistSelect3( BattleMatchUIListener *listener )
{
	this->AddSubView( m_select3_view );
	m_select3_view->SetBattleMatchUIListener( listener );
}

//--------------------------------------------------------------------------
/**
 *	@brief		qr[o^:Select5View
 *	@param		o^郊Xi[
 */
//--------------------------------------------------------------------------
void ParentView::RegistSelect5( BattleMatchUIListener *listener )
{
	this->AddSubView( m_select5_view );
	m_select5_view->SetBattleMatchUIListener( listener );
}

//--------------------------------------------------------------------------
/**
 *	@brief		qr[o^:ResultView
 */
//--------------------------------------------------------------------------
void ParentView::RegistResult( void )
{
	this->AddSubView( m_result_view );
}

//--------------------------------------------------------------------------
/**
 *	@brief		qr[o^:RegistWait
 */
//--------------------------------------------------------------------------
void ParentView::RegistWait( void )
{
	this->AddSubView( m_wait_view );
}

//--------------------------------------------------------------------------
/**
 *	@brief		qr[o^:Select1View
 *  @return	otrue
 */
//--------------------------------------------------------------------------
bool ParentView::CancelSelect1( void )
{
	if( m_select1_view->IsAnimeEnd() == true )
	{
		// XiȂ
		m_select1_view->SetBattleMatchUIListener( NULL );

		// eq֌W
		m_select1_view->RemoveFromSuperView();
		return true;
	}

	return false;
}

//--------------------------------------------------------------------------
/**
 *	@brief		qr[o^:Select2View
 *  @return	otrue
 */
//--------------------------------------------------------------------------
bool ParentView::CancelSelect2( void )
{
	if( m_select2_view->IsAnimeEnd() == true )
	{
		// XiȂ
		m_select2_view->SetBattleMatchUIListener( NULL );

		// eq֌W
		m_select2_view->RemoveFromSuperView();
		return true;
	}

	return false;
}

//--------------------------------------------------------------------------
/**
 *	@brief		qr[o^:Select3View
 *  @return	otrue
 */
//--------------------------------------------------------------------------
bool ParentView::CancelSelect3( void )
{
	if( m_select3_view->IsAnimeEnd() == true )
	{
		// XiȂ
		m_select3_view->SetBattleMatchUIListener( NULL );

		// eq֌W
		m_select3_view->RemoveFromSuperView();
		return true;
	}

	return false;
}

//--------------------------------------------------------------------------
/**
 *	@brief		qr[o^:Select5View
 *  @return	otrue
 */
//--------------------------------------------------------------------------
bool ParentView::CancelSelect5( void )
{
	if( m_select5_view->IsAnimeEnd() == true )
	{
		// XiȂ
		m_select5_view->SetBattleMatchUIListener( NULL );

		// eq֌W
		m_select5_view->RemoveFromSuperView();
		return true;
	}

	return false;
}

//--------------------------------------------------------------------------
/**
 *	@brief		qr[o^:ResultView
 *  @return	otrue
 */
//--------------------------------------------------------------------------
bool ParentView::CancelResult( void )
{
	// eq֌W
	m_result_view->RemoveFromSuperView();
	return true;
}

//--------------------------------------------------------------------------
/**
 *	@brief		qr[o^:ResultWait
 *  @return	otrue
 */
//--------------------------------------------------------------------------
bool ParentView::CancelWait( void )
{
	// eq֌W
	m_wait_view->RemoveFromSuperView();
	return true;
}

//--------------------------------------------------------------------------
/**
 * @brief		2D֘A쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------
void ParentView::Initialize2D( app::util::Heap * heap )
{
	static const u32 BATTLE_MATCH_RES_ADD_MAX = LYTRES_MSG_WINDOW_RES_END;

	// A[JCuIDe[u
	static const app::util::G2DUtil::LYT_RES_DATA resTbl[]={
		{ ARCID_BATTLE_MATCH_GRA,	0, BATTLE_MATCH_RES_ADD_MAX, app::util::G2DUtil::ATTACH_ROOT     },
		{ ARCID_COMMON_MSGWINDOW, 0,												0, app::util::G2DUtil::ATTACH_RESOURCE }, // 01: ʃ\[X: bZ[WEBhE
		
	};

	static const app::util::G2DUtil::LYTWK_DATA layoutData[] =
	{
		{	// 
			0,
			LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_UPPER_BCLYT,			// resID̃CAEgf[^ID
      UpperAnmIndex,
      GFL_NELEMS(UpperAnmIndex),
      GFL_NELEMS(UpperAnmIndex),
			false,
			app::util::G2DUtil::SETUP_UPPER,						// fBXvC
			true,																				// \ݒ
		},
		{	// 
			0,
			LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_BCLYT,
      LowerAnmIndex,
      GFL_NELEMS(LowerAnmIndex),
			ANMID_LOWER_ANM_NUM,
			false,
			app::util::G2DUtil::SETUP_LOWER,
			true,
		},
	};

	Create2D( heap, NULL, LAYOUT_ID_MAX,
						resTbl, GFL_NELEMS(resTbl),
						layoutData, GFL_NELEMS(layoutData),
						GARC_message_battle_match_DAT );


	// qr[ɓn悤ɃCAEg[N
	for( int i=0; i<LAYOUT_ID_MAX; i++ )
	{
		m_lyt_wk[i].pLytWk = m_g2dUtil->GetLayoutWork( i );
		m_lyt_wk[i].setupDisp = ( i==LAYOUT_ID_UPPER ? app::util::G2DUtil::SETUP_UPPER : app::util::G2DUtil::SETUP_LOWER);
		m_lyt_wk[i].enable = true;
	}
	
}

GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)
