//=============================================================================
/**
 *
 *	@file		WeatherPositionManager.cpp
 *	@brief  VWǗNX
 *	@author hosaka genya
 *	@data		2012.08.20
 *
 */
//=============================================================================
#include "system/skybox/SkyboxDefine.h" 

#include "system/weather/WeatherPositionManager.h"

GFL_NAMESPACE_BEGIN( xy_system );
GFL_NAMESPACE_BEGIN( weather );

void PositionManager::InitializeOriginTransformPackForDefault(
    OriginTransformPack*  origin_transform_pack
)
{
  origin_transform_pack->scale     = gfl::math::VEC3(1.0f, 1.0f, 1.0f);
  origin_transform_pack->rotate_y  = 0.0f;
  origin_transform_pack->translate = gfl::math::VEC3(0.0f, 0.0f, 0.0f);

  // L̂悤ɃXP[1A]0xAsړ0ȂAPʍsɂĂ΂B
  // ȂȂꍇ́As̏lvZŏoĉB
  gfl::math::MTX34Identity(&(origin_transform_pack->origin_transform_matrix));
}

void PositionManager::InitializeSunPositionPackForDefault(
    SunPositionPack*  sun_position_pack
)
{
  sun_position_pack->year          = 0;
  sun_position_pack->month         = 0;
  sun_position_pack->day           = 0;
  sun_position_pack->hour          = 0;
  sun_position_pack->minute        = 0;
  sun_position_pack->second        = 0;
  sun_position_pack->second_rate   = 0.0f;
  sun_position_pack->longitude     = 0.0f;
  sun_position_pack->latitude      = 0.0f;

  sun_position_pack->sun_mid_season_sunrise_angle[skybox::SEASON_TYPE_SPRING] = 0.0f;
  sun_position_pack->sun_mid_season_sunrise_angle[skybox::SEASON_TYPE_SUMMER] = 30.0f;
  sun_position_pack->sun_mid_season_sunrise_angle[skybox::SEASON_TYPE_AUTUMN] = 0.0f;
  sun_position_pack->sun_mid_season_sunrise_angle[skybox::SEASON_TYPE_WINTER] = -30.0f;
  sun_position_pack->start_mid_season_type = skybox::SEASON_TYPE_WINTER;
  sun_position_pack->end_mid_season_type   = skybox::SEASON_TYPE_SPRING;
  sun_position_pack->mid_season_end_rate   = 0.0f;
  sun_position_pack->sun_sky_angle         = 0.0f;
  gfl::math::MTX34Identity(&(sun_position_pack->sun_transform_matrix));
  sun_position_pack->sun_position    = skybox::SUN_INITIAL_POSITION;
  sun_position_pack->period.type     = skybox::PERIOD_TYPE_NIGHT;
  sun_position_pack->period.end_rate = 0.0f;
}


PositionManager::PositionManager( void ) : 
  m_is_setup( false )
{
}

PositionManager::~PositionManager()
{
  Finalize();
}
  
void PositionManager::Setup( const gfl::math::VEC3& scale, const f32 rotate_y, const f32 fps, const gfl::math::VEC3& origin )
{
  InitializeOriginTransformPackForDefault(&m_origin_transform_pack);
  InitializeSunPositionPackForDefault(&m_sun_position_pack);
  
  m_origin_transform_pack.scale    = scale;
  m_origin_transform_pack.rotate_y = rotate_y;
  m_frame_per_second = fps;
  m_is_setup = true;
  
  Calculate( origin );
}

void PositionManager::Finalize( void )
{
  m_is_setup = false;
}

void PositionManager::Calculate( const gfl::math::VEC3& origin )
{
  GFL_ASSERT( m_is_setup );
  
  b32 is_update_origin_transform = UpdateOriginTransform(
      origin
  );
  
  gfl::std::DateTime date_time;
  gfl::std::DateTime::GetNow(&date_time);
  u32 year = date_time.GetYear();
  u32 month = date_time.GetMonth();
  u32 day = date_time.GetDay();
  u32 hour = date_time.GetHour();
  u32 minute = date_time.GetMinute();
  u32 second = date_time.GetSecond();
  u32 frame = static_cast<u32>(date_time.GetMilliSecond() * m_frame_per_second / 1000.0f);
  f32 second_rate = ConvertFrameToSecondRate(frame);
  f32 longitude = 0.0f;
  f32 latitude  = 0.0f;


  b32 is_update_sun_position = UpdateSunPosition(
    year,          
    month,         
    day,           
    hour,         
    minute,       
    second,        
    second_rate,        
    longitude,    
    latitude
  );

  if( is_update_origin_transform || is_update_sun_position )
  {
    UpdateAbsoluteSunPosition();
  }
}

b32 PositionManager::UpdateOriginTransform(
    const gfl::math::VEC3&  origin
)
{
  if(
       m_origin_transform_pack.translate.x != origin.x
    || m_origin_transform_pack.translate.y != origin.y
    || m_origin_transform_pack.translate.z != origin.z
  )
  {
    // ݂̃XJC{bNX͂̏ŋ߂Ă
    m_origin_transform_pack.translate = origin;
    // ŗ^ꂽl͈͊ÔƂAoϐm_origin_transform_pack.???ɑOɏCđĉB
    // ł́Aoϐm_origin_transform_pack.???gȂ悤ɂĂ̂ŁA̕ϐ̏C͕sKvłB

    // XP[
    gfl::math::MTX34  scale_matrix;
    gfl::math::MTX34Scale( &scale_matrix, &(m_origin_transform_pack.scale) );
   
    // ]
    gfl::math::VEC3   y_axis_vector(0.0f, 1.0f, 0.0f);  // [hY
    gfl::math::MTX34  rotate_y_matrix;
    nn::math::MTX34RotAxisDeg( &rotate_y_matrix, &y_axis_vector, m_origin_transform_pack.rotate_y );  // @todo nngĂ

    // sړ
    gfl::math::MTX34  translate_matrix;
    gfl::math::MTX34Translate( &translate_matrix, &(m_origin_transform_pack.translate) );

    // XJC{bNX̕ό`}gNXvZ
    gfl::math::MTX34Mult( &(m_origin_transform_pack.origin_transform_matrix), &rotate_y_matrix, &scale_matrix );
    gfl::math::MTX34Mult( &(m_origin_transform_pack.origin_transform_matrix), &translate_matrix, &(m_origin_transform_pack.origin_transform_matrix) );
  
    return true; 
  }
  else
  {
    return false;
  }
}

b32 PositionManager::UpdateSunPosition(
    const u32  year,          
    const u32  month,         
    const u32  day,           
    const u32  hour,         
    const u32  minute,       
    const u32  second,        
    const f32  second_rate,  // 0.0f<= <1.0f
    const f32  longitude,    
    const f32  latitude
)
{
  if(
       m_sun_position_pack.year        != year       
    || m_sun_position_pack.month       != month      
    || m_sun_position_pack.day         != day        
    || m_sun_position_pack.hour        != hour       
    || m_sun_position_pack.minute      != minute     
    || m_sun_position_pack.second      != second     
    || m_sun_position_pack.second_rate != second_rate
    || m_sun_position_pack.longitude   != longitude  
    || m_sun_position_pack.latitude    != latitude   
  )
  {
    ///////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////
    // zf[^  // ŒlȂ̂ŖvZ͂ȂAoxAܓxWύXꍇǂ邩߂Ă烁oϐƂĕێĂǂ߂邱ƂɂB
    // p
    // sunrise_angle  ̏õ[hY̎̉]px([h-XƂ̊px)    // zYWƂȂ̂Ƃy=0.0f̏oƂ
    // sunset_angle   ̓莞̃[hY̎̉]px([h-XƂ̊px)  // zYWƂȂ̂Ƃy=0.0f̓Ƃ
    // noon_angle     쒆̃[hY̎̉]px([h-XƂ̊px)  // 쒆̊px́A[h-X-90degreeɂȂƂȂ̂ŁAnoon_angle=-90.0f蓾Ȃ
    // sky_angle      SKY_AXIS_VECTOR̎̉]px  // sky_angle=0.0f̂ƂAz͓̏öʒuɂB
                                                         // ̏öʒu͖Ⴄ̂ŁAuz̉]ʂ̉vƓ̏öʒûȂpxႤB
                                                         // ܂葾zɊւẮAȀöʒusky_angle=0.0fƒߒĂ̂łB
    struct SunDataPack
    {
      u32  month;
      u32  day;
      u32  serial_day;           // vZŋ߂  // day1N\  // month, dayƓƂĂ܂B

      // ̏o̎Ɗpx
      u32  sunrise_hour;         // vZŋ߂  
      u32  sunrise_minute;       // vZŋ߂  
      u32  sunrise_second;       // vZŋ߂  
      f32  sunrise_second_rate;  // vZŋ߂  
      f32  sunrise_angle;  // ̏o̊px[h-XƂ̊pxŕ\([hY̎]āA[h-XƂ̊px𑪂)  // [degree]
                           // -90<sunrise_angle<90 (͈̔͊OƓřvZłȒlo邩)
      
      // ̓̎Ɗpx
      u32  sunset_hour;         // vZŋ߂  
      u32  sunset_minute;       // vZŋ߂  
      u32  sunset_second;       // vZŋ߂  
      f32  sunset_second_rate;  // vZŋ߂  
          // ̓̊px́ȀöʒuYZʂŔ]ʒuƂȂƂ̊pxł([h-X 180degree - sunrise_angle ɂȂƂ)

      // 쒆̎Ɗpx
      u32  noon_hour;         // 쒆̎́Ȁo̎Ɠ̓̎̒
      u32  noon_minute;
      u32  noon_second;
      f32  noon_second_rate;
          // 쒆̊px́A[h-X-90degreeɂȂƂ
    };

    // oxAܓxŴƂ̒l  // serial_dayɕׂĂA̕я𗘗pĔrĂ
    SunDataPack sun_data_pack[skybox::SEASON_TYPE_MID_SEASON_NUM] =
    {
      // t
      {
             3,
            21,
             0,  // vZŋ߂
      
        // ̏o̎Ɗpx 
             6,  // vZŋ߂
             0,  // vZŋ߂
             0,  // vZŋ߂
          0.0f,  // vZŋ߂
          0.0f,

        // ̓̎Ɗpx
            18,  // vZŋ߂
             0,  // vZŋ߂
             0,  // vZŋ߂
          0.0f,  // vZŋ߂

        // 쒆̎Ɗpx
            12,  // k  // ox̕ύXɑΉꍇ͓쒆̎ύX̂ŁAkƂA͌oxAܓxŴƂ̒lύXȂĂAgĂȂB
             0,
             0,
          0.0f,
      },

      // Ď
      {
             6,
            21,
             0,   // vZŋ߂
      
        // ̏o̎Ɗpx 
             5,  // vZŋ߂
             0,  // vZŋ߂
             0,  // vZŋ߂
          0.0f,  // vZŋ߂
         30.0f,

        // ̓̎Ɗpx
            19,  // vZŋ߂
             0,  // vZŋ߂
             0,  // vZŋ߂
          0.0f,  // vZŋ߂

        // 쒆̎Ɗpx
            12,  // k  // ox̕ύXɑΉꍇ͓쒆̎ύX̂ŁAkƂA͌oxAܓxŴƂ̒lύXȂĂAgĂȂB
             0,
             0,
          0.0f,
      },

      // H
      {
             9,
            21,
             0,  // vZŋ߂
      
        // ̏o̎Ɗpx 
             6,  // vZŋ߂
             0,  // vZŋ߂
             0,  // vZŋ߂
          0.0f,  // vZŋ߂
          0.0f, 

        // ̓̎Ɗpx
            18,  // vZŋ߂
             0,  // vZŋ߂
             0,  // vZŋ߂
          0.0f,  // vZŋ߂

        // 쒆̎Ɗpx
            12,  // k  // ox̕ύXɑΉꍇ͓쒆̎ύX̂ŁAkƂA͌oxAܓxŴƂ̒lύXȂĂAgĂȂB
             0,
             0,
          0.0f,
      },

      // ~
      {
            12,
            21,
             0,  // vZŋ߂
      
        // ̏o̎Ɗpx 
             7,  // vZŋ߂
             0,  // vZŋ߂
             0,  // vZŋ߂
          0.0f,  // vZŋ߂
        -30.0f,

        // ̓̎Ɗpx
            17,  // vZŋ߂
             0,  // vZŋ߂
             0,  // vZŋ߂
          0.0f,  // vZŋ߂

        // 쒆̎Ɗpx
            12,  // k  // ox̕ύXɑΉꍇ͓쒆̎ύX̂ŁAkƂA͌oxAܓxŴƂ̒lύXȂĂAgĂȂB
             0,
             0,
          0.0f,
      },
    };
    // ɐiށ̏o̎ȂA쒆̎ȂA̓̎ȂB쒆̎ύX΂悢B
    // ɐiށ̏o̎xȂA쒆̎xȂA̓̎xȂB쒆̎ύX΂悢B
    // kɐiށ̉][hZƂ̊pxŕ\ƂA-45degree-60degreeɂȂ(ɋ߂ȂĂ)̉]ύX΂悢B
    // ɐiށ̉][hZƂ̊pxŕ\ƂA-45degree-30degreeɂȂ(ɋ߂ȂĂ)̉]ύX΂悢B

    // vZŋ߂Ƃ𖄂߂
    static const f32 angle_per_second = 360.0f/(24*60*60);  // z1bԂɐiފpx[degree]  // Βl
        // ԂiނɘASKY_AXIS_VECTOR̎𕉕։]邪Ałangle_per_secondΒlŗ^Ă
    
    for( s32 i=0; i<skybox::SEASON_TYPE_MID_SEASON_NUM; ++i )
    {
      f32 noon_serial_second = skybox::ConvertHourMinuteSecondToSerialSecond(
          sun_data_pack[i].noon_hour,
          sun_data_pack[i].noon_minute,
          sun_data_pack[i].noon_second,
          sun_data_pack[i].noon_second_rate
      );
    
      f32 angle_between_sunrise_and_noon_around_sky_axis  //   // ̏oƓ쒆̊ԂSKY_AXIS_VECTOR̎̊px[degree]
          = skybox::MeasureAngleBetweenSunriseAndNoonAroundSkyAxis( sun_data_pack[i].sunrise_angle, skybox::SKY_AXIS_ANGLE );  // k  // ܓx̕ύXɑΉꍇ́AύX邱ƁB
      f32 time_between_sunrise_and_noon = angle_between_sunrise_and_noon_around_sky_axis / angle_per_second;  // second  // 
          // ZXʂɓečlĂ͂ȂȂ̂ŁAL̒ʂ葾z̉]ʏōlĂB
      
      f32 sunrise_serial_second = noon_serial_second - time_between_sunrise_and_noon;  // second1\
      f32 sunset_serial_second  = noon_serial_second + time_between_sunrise_and_noon;  // second1\

#if 0
      {
        GFL_PRINT( "%f, %f, %f, %f\n",
            angle_between_sunrise_and_noon_around_sky_axis, time_between_sunrise_and_noon,
            sunrise_serial_second, sunset_serial_second );
      }
#endif

      sun_data_pack[i].serial_day = skybox::ConvertMonthDayToSerialDay(sun_data_pack[i].month, sun_data_pack[i].day);
     
      skybox::ConvertSerialSecondToHourMinuteSecond(
          sunrise_serial_second,
          &(sun_data_pack[i].sunrise_hour),
          &(sun_data_pack[i].sunrise_minute),
          &(sun_data_pack[i].sunrise_second),
          &(sun_data_pack[i].sunrise_second_rate)
      );
      skybox::ConvertSerialSecondToHourMinuteSecond(
          sunset_serial_second,
          &(sun_data_pack[i].sunset_hour),
          &(sun_data_pack[i].sunset_minute),
          &(sun_data_pack[i].sunset_second),
          &(sun_data_pack[i].sunset_second_rate)
      );
    }

#if 0
    for( s32 i=0; i<skybox::SEASON_TYPE_MID_SEASON_NUM; ++i )
    {
      GFL_PRINT( "%d/%d = %d\n", sun_data_pack[i].month, sun_data_pack[i].day, sun_data_pack[i].serial_day );
      
      GFL_PRINT( "%d:%d:%d:%f, %fdgree\n", 
          sun_data_pack[i].sunrise_hour, sun_data_pack[i].sunrise_minute,
          sun_data_pack[i].sunrise_second, sun_data_pack[i].sunrise_second_rate, sun_data_pack[i].sunrise_angle );
      
      GFL_PRINT( "%d:%d:%d:%f\n",
          sun_data_pack[i].sunset_hour, sun_data_pack[i].sunset_minute,
          sun_data_pack[i].sunset_second, sun_data_pack[i].sunset_second_rate );
      
      GFL_PRINT( "%d:%d:%d:%f\n",
          sun_data_pack[i].noon_hour, sun_data_pack[i].noon_minute,
          sun_data_pack[i].noon_second, sun_data_pack[i].noon_second_rate );
    }
#endif

    ///////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////
    // ݂̑z̈ʒu͂̏ŋ߂Ă
    m_sun_position_pack.year        = year        ;  // ͎gĂȂ
    m_sun_position_pack.month       = month       ;
    m_sun_position_pack.day         = day         ;
    m_sun_position_pack.hour        = hour        ;
    m_sun_position_pack.minute      = minute      ;
    m_sun_position_pack.second      = second      ;
    m_sun_position_pack.second_rate = second_rate ;
    m_sun_position_pack.longitude   = longitude   ;  // ͎gĂȂ
    m_sun_position_pack.latitude    = latitude    ;  // ͎gĂȂ
    // ŗ^ꂽl͈͊ÔƂAoϐm_sun_position_pack.???ɑOɏCđĉB
    // ł́Aoϐm_sun_position_pack.???gȂ悤ɂĂ̂ŁA̕ϐ̏C͕sKvłB

    u32 target_serial_day = skybox::ConvertMonthDayToSerialDay(m_sun_position_pack.month, m_sun_position_pack.day);
    f32 target_current_serial_second = skybox::ConvertHourMinuteSecondToSerialSecond(
        m_sun_position_pack.hour        ,
        m_sun_position_pack.minute      ,
        m_sun_position_pack.second      ,
        m_sun_position_pack.second_rate 
    );
    
    s32 target_start_season_type = skybox::SEASON_TYPE_WINTER;  // target_start_season_type<= <target_end_season_type
    s32 target_end_season_type   = skybox::SEASON_TYPE_SPRING;  // LforifbreakłȂƂ̒lŏĂB
    for( s32 i=0; i<skybox::SEASON_TYPE_MID_SEASON_NUM; ++i )
    {
      if( target_serial_day < sun_data_pack[i].serial_day )
      {
        target_end_season_type   = i;
        target_start_season_type = (target_end_season_type + skybox::SEASON_TYPE_MID_SEASON_NUM -1) % skybox::SEASON_TYPE_MID_SEASON_NUM;
        break;
      }
    }

    u32 target_start_serial_day = sun_data_pack[target_start_season_type].serial_day;
    u32 target_end_serial_day   = sun_data_pack[target_end_season_type].serial_day;
    if( target_end_serial_day < target_start_serial_day )
    {
      target_end_serial_day += skybox::DAY_PER_YEAR;  // 1n܂ƂƂlĂ܂
    }
    if( target_serial_day < target_start_serial_day )
    {
      target_serial_day += skybox::DAY_PER_YEAR;  // 1n܂ƂƂlĂ܂
    }
    // ̎_ target_start_serial_day <= target_serial_day < target_end_serial_day ƂȂĂB
    f32 target_end_season_rate = ( static_cast<f32>( target_serial_day - target_start_serial_day ) ) / ( target_end_serial_day - target_start_serial_day );
        // 0.0f<=target_end_season_rate<=1.0f (target_start_season_type<= <target_end_season_type Ȃ̂ŁAtarget_end_season_rate==1.0fɂȂ邱Ƃ͂Ȃ)
    f32 target_sunrise_angle = \
          ( 1.0f - target_end_season_rate ) * sun_data_pack[target_start_season_type].sunrise_angle \
        + target_end_season_rate * sun_data_pack[target_end_season_type].sunrise_angle;

    u32  target_noon_hour        =   12;  // k  // ox̕ύXɑΉꍇ́AύX邱ƁB
    u32  target_noon_minute      =    0;
    u32  target_noon_second      =    0;
    f32  target_noon_second_rate = 0.0f;
 
    f32 target_noon_serial_second = skybox::ConvertHourMinuteSecondToSerialSecond(
        target_noon_hour,
        target_noon_minute,
        target_noon_second,
        target_noon_second_rate
    );

    f32 target_angle_between_sunrise_and_noon_around_sky_axis  //   // ̏oƓ쒆̊ԂSKY_AXIS_VECTOR̎̊px[degree]
        = skybox::MeasureAngleBetweenSunriseAndNoonAroundSkyAxis( target_sunrise_angle, skybox::SKY_AXIS_ANGLE );  // k  // ܓx̕ύXɑΉꍇ́AύX邱ƁB
    f32 target_time_between_sunrise_and_noon = target_angle_between_sunrise_and_noon_around_sky_axis / angle_per_second;  // 
    
    f32 target_sunrise_serial_second = target_noon_serial_second - target_time_between_sunrise_and_noon;

    f32 target_sky_angle = - (target_current_serial_second - target_sunrise_serial_second) * angle_per_second;
        // ԂiނɘASKY_AXIS_VECTOR̎𕉕։]
        // sky_angle=0.0f̂ƂAz͓̏öʒuɂB
        // ̏öʒu͖Ⴄ̂ŁAuz̉]ʂ̉vƓ̏öʒûȂpxႤB
        // ܂葾zɊւẮAȀöʒusky_angle=0.0fƒߒĂ̂łB
        // target_sky_anglȅ͓öʒu0.0fxƂ̏öʒůpxłB

    m_sun_position_pack.sun_mid_season_sunrise_angle[skybox::SEASON_TYPE_SPRING] = sun_data_pack[skybox::SEASON_TYPE_SPRING].sunrise_angle;
    m_sun_position_pack.sun_mid_season_sunrise_angle[skybox::SEASON_TYPE_SUMMER] = sun_data_pack[skybox::SEASON_TYPE_SUMMER].sunrise_angle;
    m_sun_position_pack.sun_mid_season_sunrise_angle[skybox::SEASON_TYPE_AUTUMN] = sun_data_pack[skybox::SEASON_TYPE_AUTUMN].sunrise_angle;
    m_sun_position_pack.sun_mid_season_sunrise_angle[skybox::SEASON_TYPE_WINTER] = sun_data_pack[skybox::SEASON_TYPE_WINTER].sunrise_angle;
        // t/Ď/H/~̑z̓̏õ[hY̎̉]px([h-XƂ̊px)[degree]
        // tāAāHAH~A~t̊Ԃ̊px̕Ԃ܂l^ĂƁB
        // -90<sunrise_angle<90 (͈̔͊OƕԂ̌vZłȒlo邩)
        // ^ꂽ֐ł͈؂̗^ꂽlCɎĝŁB
    m_sun_position_pack.start_mid_season_type = static_cast<skybox::SeasonType>(target_start_season_type);
    m_sun_position_pack.end_mid_season_type   = static_cast<skybox::SeasonType>(target_end_season_type);
    m_sun_position_pack.mid_season_end_rate   = target_end_season_rate;

    // ݂̑z̈ʒu
    // (1) uskybox::SUN_INITIAL_POSITIONɂ鑾zvA[hY̎u[h-XƂ̊pxtarget_sunrise_anglexv]āA
    //     ȕöʒuvɈړB
    // (2) ȕöʒuɂ鑾zvASKY_AXIS_VECTOR̎uSKY_AXIS_VECTOR̎̉]pxtarget_sky_anglexv]āA
    //     ȗ݂z̈ʒuvɈړB
            // sky_angle=0.0f̂ƂAz͓̏öʒuɂB
            // ̏öʒu͖Ⴄ̂ŁAuz̉]ʂ̉vƓ̏öʒûȂpxႤB
            // ܂葾zɊւẮAȀöʒusky_angle=0.0fƒߒĂ̂łB
            // target_sky_anglȅ͓öʒu0.0fxƂ̏öʒůpxłB
    gfl::math::VEC3  sunrise_axis_vector(0.0f, 1.0f, 0.0f);  // [hY
    gfl::math::MTX34 sunrise_rotate_matrix;
    nn::math::MTX34RotAxisDeg(&sunrise_rotate_matrix, &sunrise_axis_vector, target_sunrise_angle);  // @todo nngĂ

    gfl::math::MTX34 sky_rotate_matrix;
    nn::math::MTX34RotAxisDeg(&sky_rotate_matrix, &skybox::SKY_AXIS_VECTOR, target_sky_angle);  // @todo nngĂ  // k  // ܓx̕ύXɑΉꍇ́AύX邱ƁB

    m_sun_position_pack.sun_sky_angle = //target_sky_angle;  // target_sky_anglȅ͓öʒu0.0fxƂ̏öʒůpxȂ̂ŁA
                                                             // złȂƂŎgpm_sun_position_pack.sun_sky_angleɂ͂̂܂܂ł͓nȂB
                                        target_sky_angle + ( target_angle_between_sunrise_and_noon_around_sky_axis - 90.0f );
                                                // 쒆́uz̉]ʂ̉v90xȂĂ̂ŁA-90.0fB
                                        // złȂƂł̒lgp̂ŁAς̏öʒuƂpxł͂ȂA
                                        // [ȟŒpxƂpxɕϊB
                                        // [h-XɍŏlƂȂʒûƂ̊px0.0fA
                                        // [h+YɍőlƂȂʒûƂ̊px-90.0fƂlɂĂB
    gfl::math::MTX34Mult(&(m_sun_position_pack.sun_transform_matrix), &sky_rotate_matrix, &sunrise_rotate_matrix);
    gfl::math::VEC3Transform(&(m_sun_position_pack.sun_position), &(m_sun_position_pack.sun_transform_matrix), &skybox::SUN_INITIAL_POSITION);  // xNg 4 vfڂ 1 ƂČvZ܂B

    // ԑ
    {
      // 遨, 
      if( m_sun_position_pack.sun_position.x <= 0.0f )
      {
        // YWɔrĂ
        // 遨
        if( m_sun_position_pack.sun_position.y <= skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_NIGHT].full_end_y )
        {
          // 邾
          m_sun_position_pack.period.type     = skybox::PERIOD_TYPE_NIGHT;
          m_sun_position_pack.period.end_rate = 0.0f;  // JڒłȂꍇ0.0fɂĂ
        }
        else if( m_sun_position_pack.sun_position.y <= skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_NIGHT].visible_end_y )
        {
          // 遨
          m_sun_position_pack.period.type     = skybox::PERIOD_TYPE_NIGHT_TO_MORNING;
          m_sun_position_pack.period.end_rate = \
                ( m_sun_position_pack.sun_position.y - skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_NIGHT].full_end_y )
              / ( skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_NIGHT].visible_end_y - skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_NIGHT].full_end_y );
        }

        // 
        else if( m_sun_position_pack.sun_position.y <= skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_MORNING].full_end_y )
        {
          // 
          m_sun_position_pack.period.type     = skybox::PERIOD_TYPE_MORNING;
          m_sun_position_pack.period.end_rate = 0.0f;  // JڒłȂꍇ0.0fɂĂ
        }
        else if( m_sun_position_pack.sun_position.y <= skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_MORNING].visible_end_y )
        {
          // 
          m_sun_position_pack.period.type     = skybox::PERIOD_TYPE_MORNING_TO_DAYTIME;
          m_sun_position_pack.period.end_rate = \
                ( m_sun_position_pack.sun_position.y - skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_MORNING].full_end_y )
              / ( skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_MORNING].visible_end_y - skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_MORNING].full_end_y );
        }

        // 
        else
        {
          // 
          m_sun_position_pack.period.type     = skybox::PERIOD_TYPE_DAYTIME;
          m_sun_position_pack.period.end_rate = 0.0f;  // JڒłȂꍇ0.0fɂĂ
        }

      }

      // [, [
      else //if( m_sun_position_pack.sun_position.x > 0.0f )
      {
        // YW傫ɔrĂ
        // [
        if( m_sun_position_pack.sun_position.y >= skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_DAYTIME].full_end_y )
        {
          // 
          m_sun_position_pack.period.type     = skybox::PERIOD_TYPE_DAYTIME;
          m_sun_position_pack.period.end_rate = 0.0f;  // JڒłȂꍇ0.0fɂĂ
        }
        else if( m_sun_position_pack.sun_position.y >= skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_DAYTIME].visible_end_y )
        {
          // [
          m_sun_position_pack.period.type     = skybox::PERIOD_TYPE_DAYTIME_TO_EVENING;
          m_sun_position_pack.period.end_rate = \
                ( skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_DAYTIME].full_end_y - m_sun_position_pack.sun_position.y )
              / ( skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_DAYTIME].full_end_y - skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_DAYTIME].visible_end_y );
        }

        // [
        else if( m_sun_position_pack.sun_position.y >= skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_EVENING].full_end_y )
        {
          // [
          m_sun_position_pack.period.type     = skybox::PERIOD_TYPE_EVENING;
          m_sun_position_pack.period.end_rate = 0.0f;  // JڒłȂꍇ0.0fɂĂ
        }
        else if( m_sun_position_pack.sun_position.y >= skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_EVENING].visible_end_y )
        {
          // [
          m_sun_position_pack.period.type     = skybox::PERIOD_TYPE_EVENING_TO_NIGHT;
          m_sun_position_pack.period.end_rate = \
                ( skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_EVENING].full_end_y - m_sun_position_pack.sun_position.y )
              / ( skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_EVENING].full_end_y - skybox::PERIOD_SUN_POSITION_Y_PACK[skybox::PERIOD_TYPE_EVENING].visible_end_y );
        }

        // 
        else
        {
          // 邾
          m_sun_position_pack.period.type     = skybox::PERIOD_TYPE_NIGHT;
          m_sun_position_pack.period.end_rate = 0.0f;  // JڒłȂꍇ0.0fɂĂ
        }
      }
    }
#if 0
    {
      GFL_PRINT( "%d/%d = %d ([%d]<= <[%d])\n",
          m_sun_position_pack.month, m_sun_position_pack.day, target_serial_day,
          target_start_season_type, target_end_season_type );
      
      GFL_PRINT( "%d:%d:%d:%f\n", 
          m_sun_position_pack.hour, m_sun_position_pack.minute,
          m_sun_position_pack.second, m_sun_position_pack.second_rate );
      
      GFL_PRINT( "sunrise%fdegree, sky%fdegree\n", target_sunrise_angle, target_sky_angle );
     
      GFL_PRINT( "sun_position=(%f, %f, %f)\n", m_sun_position_pack.sun_position.x, m_sun_position_pack.sun_position.y, m_sun_position_pack.sun_position.z );

      GFL_PRINT( "period type%d, end_rate%f\n", m_sun_position_pack.period.type, m_sun_position_pack.period.end_rate );
    }
#endif
    
    return true; 
  }
  else
  {
    return false;
  }
}

void PositionManager::UpdateAbsoluteSunPosition(void)
{
  // (0,0,0)
  gfl::math::VEC3 zero_vector(0.0f, 0.0f, 0.0f);

  // ړ}gNX
  gfl::math::MTX34 translate_matrix;
  gfl::math::VEC3  translate_vector(-skybox::SUN_DISTANCE, 0.0f, 0.0f);
  gfl::math::MTX34Translate(&translate_matrix, &translate_vector);
 
  // }gNX
  gfl::math::MTX34 transform_matrix;
  gfl::math::MTX34Mult(&transform_matrix, &m_sun_position_pack.sun_transform_matrix, &translate_matrix);
  gfl::math::MTX34Mult(&transform_matrix, &m_origin_transform_pack.origin_transform_matrix, &transform_matrix);

  // OriginTransformPackAXJC{bNX̑傫l(0,0,0)ɒuĂ鑾zɊ|}gNX
  m_sun_position_pack.absolute_sun_transform_matrix_from_zero = transform_matrix;

  // OriginTransformPackAXJC{bNX̑傫lz̈ʒu(z̈ʒû܂)
  gfl::math::VEC3Transform(
      &(m_sun_position_pack.absolute_sun_position),
      &transform_matrix,
      &zero_vector
  );  // xNg 4 vfڂ 1 ƂČvZ܂B

  // OriginTransformPackAXJC{bNX̑傫lz̈ʒu(e𗎂ƂCgƂĎgpłʒu)
  {
    /////////////////////////////////////////////////////////////////////////////////////////////////
    //
    // ݂̑z̈ʒu̓XJC{bNX̌_(0,0,0)̂Ƃ̂̂ł
    // ݂̑z̈ʒu̓XJC{bNX̕(+Y,-Y,k+Z,-Z,+X,-X)̂Ƃ̂̂ł
    // ݂̑z̈ʒu̓XJC{bNX̃XP[(1,1,1)̂Ƃ̂̂ł
    // XJC{bNX̔a1ƂƂ̑z̈ʒuɂĂ
    //
    // ܂́Ȁōl(Aabsolute_sun_positionł͂ȂAsun_positionōl) 
    //
    /////////////////////////////////////////////////////////////////////////////////////////////////

    // xNg
    gfl::math::VEC3 y_axis_vector(0.0f, 1.0f, 0.0f);  // YPʃxNg
    gfl::math::VEC3 sun_direction_vector = m_sun_position_pack.sun_position;  // XJC{bNX(0,0,0)ɂꍇɂ鑾z̒̕PʃxNg
    gfl::math::VEC3Normalize(&sun_direction_vector, &sun_direction_vector);  // (0,0,0)瑾z̕֌xNg
  
    // y_axis_vectorsun_direction_vector̊Ԃ̊pxtheta߂
    f32 theta = nn::math::AcosDeg( gfl::math::VEC3Dot(&y_axis_vector, &sun_direction_vector) );  // degree  // @todo nngĂ
        // y_axis_vectorsun_direction_vector̓ = |y_axis_vector| |sun_direction_vector| cos(theta);
    while( theta < 0.0f )    theta += 360.0f;  // 0.0f<=theta<360.0f
    while( theta >= 360.0f ) theta -= 360.0f;

    // thetåpxCgƂĂӂ킵pxɏCiota߂
    f32 iota;  // CI^  // degree
    if( theta < skybox::SUN_LIGHT_SHADOW_THETA_MIN )
    {
      // y_axis_vectorsun_direction_vector܂ɋ߂ꍇ́AOς̃xNg߂Ȃ̂ŁA
      // 0.0f<=theta<skybox::SUN_LIGHT_SHADOW_THETA_MIN̏ꍇ́Â܂thetaɂĂB
      iota = theta; 
    }
    else if( theta < skybox::SUN_LIGHT_SHADOW_THETA_MID )
    {
      static const f32 SUN_LIGHT_SHADOW_IOTA_MIN = skybox::SUN_LIGHT_SHADOW_THETA_MIN;

      iota =   (theta-skybox::SUN_LIGHT_SHADOW_THETA_MIN) / (skybox::SUN_LIGHT_SHADOW_THETA_MID-skybox::SUN_LIGHT_SHADOW_THETA_MIN) \
             * (skybox::SUN_LIGHT_SHADOW_IOTA_MID - SUN_LIGHT_SHADOW_IOTA_MIN) \
             + SUN_LIGHT_SHADOW_IOTA_MIN;
    }
    else if( theta < skybox::SUN_LIGHT_SHADOW_THETA_MAX )
    {
      iota =   (theta-skybox::SUN_LIGHT_SHADOW_THETA_MID) / (skybox::SUN_LIGHT_SHADOW_THETA_MAX-skybox::SUN_LIGHT_SHADOW_THETA_MID) \
             * (skybox::SUN_LIGHT_SHADOW_IOTA_MAX-skybox::SUN_LIGHT_SHADOW_IOTA_MID) \
             + skybox::SUN_LIGHT_SHADOW_IOTA_MID;
    }
    else
    {
      // skybox::SUN_LIGHT_SHADOW_THETA_MAX<=thetȁꍇ́Askybox::SUN_LIGHT_SHADOW_IOTA_MAXɂB
      iota = skybox::SUN_LIGHT_SHADOW_IOTA_MAX;
    }

    // y_axis_vectorthetapsun_direction_vectorł͂ȂAy_axis_vectoriotapiota_sun_direction_vector߂
    gfl::math::VEC3  iota_sun_direction_vector;
    if( theta < skybox::SUN_LIGHT_SHADOW_THETA_MIN )
    {
      // y_axis_vectorsun_direction_vector܂ɋ߂ꍇ́AOς̃xNg߂Ȃ̂ŁA
      // 0.0f<=theta<skybox::SUN_LIGHT_SHADOW_THETA_MIN̏ꍇ́Â܂sun_direction_vectorɂĂB
      iota_sun_direction_vector = sun_direction_vector;
    }
    else
    {
      // y_axis_vectorsun_direction_vector̊O
      gfl::math::VEC3 rotate_axis_vector;  // ̃xNg]ƂĂ̎y_axis_vector񂹂sun_direction_vectorɂȂ
      gfl::math::VEC3Cross(&rotate_axis_vector, &y_axis_vector, &sun_direction_vector);
      gfl::math::VEC3Normalize(&rotate_axis_vector, &rotate_axis_vector);  // (0,0,0)瑾z̒̕PʃxNg
     
      // rotate_axis_vector̎y_axis_vector񂵂iota_sun_direction_vector߂
      gfl::math::MTX34 rotate_matrix;
      nn::math::MTX34RotAxisDeg(&rotate_matrix, &rotate_axis_vector, iota);  // @todo nngĂ
      gfl::math::VEC3Transform(&iota_sun_direction_vector, &rotate_matrix, &y_axis_vector);  // xNg 4 vfڂ 1 ƂČvZ܂B
    }


    /////////////////////////////////////////////////////////////////////////////////////////////////
    //
    // ɁAOriginTransformPackAXJC{bNX̑傫lōl(Aabsolute_sun_positionōl) 
    //
    /////////////////////////////////////////////////////////////////////////////////////////////////
    
    // OriginTransformPackAXJC{bNX̑傫lz̈ʒu(e𗎂ƂCgƂĎgpłʒu) 
    // (ẑ݂Ȃ̂Ŗ͉ɑzBApx艺ɂ͂ȂȂ悤ɂĂB)
    gfl::math::VEC3 temp_vector;
    gfl::math::VEC3Scale(&temp_vector, &iota_sun_direction_vector, skybox::SUN_DISTANCE);  // iota_sun_direction_vectoȓ傫1A𑾗z܂ł̋ɂ
    
    gfl::math::VEC3Transform(
        &m_sun_position_pack.absolute_sun_light_shadow_position,
        &m_origin_transform_pack.origin_transform_matrix,
        &temp_vector
    );  // xNg 4 vfڂ 1 ƂČvZ܂B
  }
}

GFL_NAMESPACE_END( weather );
GFL_NAMESPACE_END( xy_system );

