//=============================================================================
/**
 *
 *	@file		WeatherPositionManager.h
 *	@brief  VWǗNX
 *	@author hosaka genya
 *	@data		2012.08.20
 *
 */
//=============================================================================
#if !defined( __WEATHERPOSITIONMANAGER_H__ )
#define __WEATHERPOSITIONMANAGER_H__

GFL_NAMESPACE_BEGIN( xy_system );
GFL_NAMESPACE_BEGIN( weather );

//--------------------------------------------------------------
///	VWǗNX
//==============================================================
class PositionManager
{
  GFL_FORBID_COPY_AND_ASSIGN( PositionManager );  
  
public:
  //-------------------------------------
  /// z̈ʒu
  //=====================================
  struct SunPositionPack
  {
    // ݂̑z̈ʒu̓XJC{bNX̌_(0,0,0)̂Ƃ̂̂ł
    // ݂̑z̈ʒu̓XJC{bNX̕(+Y,-Y,k+Z,-Z,+X,-X)̂Ƃ̂̂ł
    // ݂̑z̈ʒu̓XJC{bNX̃XP[(1,1,1)̂Ƃ̂̂ł
    // XJC{bNX̔a1ƂƂ̑z̈ʒuɂĂ
    
    // ݂̑z̈ʒu͂̏ŋ߂Ă
    u32  year;
    u32  month;
    u32  day;
    u32  hour;
    u32  minute;
    u32  second;
    f32  second_rate;  // 0.0f<= <1.0f
    f32  longitude;
    f32  latitude;

    // ݂̑z̈ʒu
    f32              sun_mid_season_sunrise_angle[skybox::SEASON_TYPE_MID_SEASON_NUM];
                         // t/Ď/H/~̑z̓̏õ[hY̎̉]px([h-XƂ̊px)[degree]
                         // tāAāHAH~A~t̊Ԃ̊px̕Ԃ܂l^ĂƁB
                         // -90<sunrise_angle<90 (͈̔͊OƕԂ̌vZłȒlo邩)
                         // ^ꂽ֐ł͈؂̗^ꂽlCɎĝŁB
    skybox::SeasonType       start_mid_season_type;      // ݂͏t/Ď/H/~̂ǂ̊Ԃ̎
    skybox::SeasonType       end_mid_season_type;        // start_mid_season_type<= <end_mid_season_type
    f32              mid_season_end_rate;        // EndMidSeasoniuSEASON_TYPE_SPRINGSEASON_TYPE_SUMMERv̏ꍇSEASON_TYPE_SUMMER̊j  // 0.0f<=mid_season_end_rate<=1.0f
    f32              sun_sky_angle;              // zSKY_AXIS_VECTOR̎̉]px[degree]
                                                 // [h-XɍŏlƂȂʒûƂ̊px0.0fA
                                                 // [h+YɍőlƂȂʒûƂ̊px-90.0fƂlɂĂB
    gfl::math::MTX34 sun_transform_matrix;  // SUN_INITIAL_POSITIONɒuĂ鑾zɊ|}gNX
    gfl::math::VEC3  sun_position;          // z̈ʒu  // SUN_INITIAL_POSITIONsun_transform_matrixňړ
    skybox::Period   period;                // ԑ  // sun_positionYW猈߂ԑ

    // OriginTransformPackA{̃XJC{bNX(a1ł͂Ȃ)̑傫ll
    gfl::math::MTX34 absolute_sun_transform_matrix_from_zero;
                                             // OriginTransformPackAXJC{bNX̑傫l(0,0,0)ɒuĂ鑾zɊ|}gNX
    gfl::math::VEC3  absolute_sun_position;  // OriginTransformPackAXJC{bNX̑傫lz̈ʒu(z̈ʒû܂)
    gfl::math::VEC3  absolute_sun_light_shadow_position;
                                             // OriginTransformPackAXJC{bNX̑傫lz̈ʒu(e𗎂ƂCgƂĎgpłʒu)
                                             // (ẑ݂Ȃ̂Ŗ͉ɑzBApx艺ɂ͂ȂȂ悤ɂĂB)
  };

public:
  PositionManager( void );
  ~PositionManager();

  void Setup( const gfl::math::VEC3& scale, const f32 rotate_y, const f32 fps, const gfl::math::VEC3& origin );
  void Finalize( void );
  void Calculate( const gfl::math::VEC3& origion );

  const gfl::math::MTX34& GetOriginTransformMatrix( void ) const { return m_origin_transform_pack.origin_transform_matrix; }
  const gfl::math::MTX34& GetSunTransformMatrix( void ) const { return m_sun_position_pack.sun_transform_matrix; }
  const skybox::Period& GetPeriod( void ) const { return m_sun_position_pack.period; }
  const SunPositionPack& GetSunPositionPack( void ) const { return m_sun_position_pack; }
  
  void GetOriginTransformTranslate( gfl::math::VEC3& out_translate ) const { out_translate = m_origin_transform_pack.translate; }

  
private:
  //-------------------------------------
  /// XJC{bNX̌_̈ʒuAAXP[Ȃǂ̕ό`Ɋւ܂Ƃ߂\
  //=====================================
  struct OriginTransformPack
  {
    // ݂̃XJC{bNX̕ό`}gNX͂̏ŋ߂Ă
    gfl::math::VEC3   scale;      // [hWnɂXP[
    f32               rotate_y;   // [hỶ]px[degree]
    gfl::math::VEC3   translate;  // [hWnɂړ
 
    // ݂̃XJC{bNX̌_̈ʒuAAXP[Ȃǂό`}gNX
    gfl::math::MTX34  origin_transform_matrix;
  };

  // OriginTransformPackftHg
  static void InitializeOriginTransformPackForDefault(
      OriginTransformPack*  origin_transform_pack
  );
  // SunPositionPackftHg
  static void InitializeSunPositionPackForDefault(
      SunPositionPack*  sun_position_pack
  );
  
  bool m_is_setup;
  f32 m_frame_per_second;
  
  // XJC{bNX̌_̈ʒuAAXP[Ȃǂ̕ό`Ɋւ܂Ƃ߂\
  OriginTransformPack  m_origin_transform_pack;

  // z̈ʒu
  SunPositionPack  m_sun_position_pack;

  
  // XJC{bNX̕ό`}gNXvZ
  // XVƂtrueԂ
  b32 UpdateOriginTransform(
      const gfl::math::VEC3&  origin
  );
  // z̈ʒuvZ
  // XVƂtrueԂ
  b32 UpdateSunPosition(
      const u32  year,          
      const u32  month,         
      const u32  day,           
      const u32  hour,         
      const u32  minute,       
      const u32  second,        
      const f32  second_rate,  // 0.0f<= <1.0f
      const f32  longitude,    
      const f32  latitude
  );
  // OriginTransformPackA{̃XJC{bNX(a1ł͂Ȃ)̑傫lz̈ʒuvZ
  // UpdateOriginTransformUpdateSunPositioňɌĂԂƁB߂lǂ炩truêƂĂׂ΂悢B
  void UpdateAbsoluteSunPosition( void );

  // 1b̉t[ڂ(0<= <=m_frame_per_second-1)1b̂ǂꂭ炢̊(0.0f<= <1.0f)ɕϊ
  f32 ConvertFrameToSecondRate(const u32 frame) const
  {
    f32 second_rate = (static_cast<f32>(frame))/m_frame_per_second;
    return second_rate;
  }
  
};

GFL_NAMESPACE_END( weather );
GFL_NAMESPACE_END( xy_system );

#endif // __WEATHERPOSITIONMANAGER_H__
