//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		EventFieldSkill.cpp
 *	@brief  tB[hZpCxg
 *	@author	takada keisuke
 *	@date		2012.08.21
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "EventFieldSkill.h"

#include "EventHidenDemo.h"

#include "field/movemodel/FieldMoveModelManager.h"

//#include "GimmickSePlay.cdat"  


namespace field
{

  //--------------------------------------------------------------
  /**
   *  Ȃق[IN]
   */
  //--------------------------------------------------------------
  //--------------------------------------------------------------
  /**
   * @brief   Cxg𓮂Ă悢ǂ̔֐ z֐
   * @param   p_gman       Q[}l[W[NX
   * @retval  true  NĂ悢
   * @retval  false NȂ
   */
  //--------------------------------------------------------------

  bool EventFieldSkillAnawohoruIn::BootChk( gamesystem::GameManager* /*p_gman*/ )
  {
    return true;
  }

  //--------------------------------------------------------------
  /**
   * @brief p[^̃Zbg
   *
   */
  //--------------------------------------------------------------

  void EventFieldSkillAnawohoruIn::SetParameter( )
  {
  }

  //--------------------------------------------------------------
  /**
   * @brief   bootchktruȅꍇɂĂяo鏉֐ z֐
   * @param   p_gman       Q[}l[W[NX
   */
  //--------------------------------------------------------------

  void EventFieldSkillAnawohoruIn::InitFunc( gamesystem::GameManager* /*p_gman*/ )
  {
    /// f̃ZbgAbv
    mp_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_EVENT );
    mp_dev = gfl::heap::Manager::GetHeapByHeapId( HEAPID_EVENT_DEVICE );

    // AP[^쐬
    m_heap_allocator = GFL_NEW( mp_heap ) gfl::heap::NwAllocator( mp_heap );
    m_device_allocator = GFL_NEW( mp_heap ) gfl::heap::NwAllocator( mp_dev );

    mp_gmk_mdl_setup = GFL_NEW( mp_heap ) gimmick::GimmickMdlSetup( mp_heap, mp_dev, ANAWOHORU_EFFECT_RES_NUM );
  }

  //--------------------------------------------------------------
  /**
   * @brief   Ăяo֐ z֐
   * @param   p_gman       Q[}l[W[NX
   * @return  GMEVENT_RESULT  Cxg֐̖߂l
   */
  //--------------------------------------------------------------

  gamesystem::GMEVENT_RESULT EventFieldSkillAnawohoruIn::MainFunc( gamesystem::GameManager* p_gman )
  {
    switch ( m_Seq )
    {
      case 0:
      {
        // f̃ZbgAbv
        if ( SetupMdl( p_gman ) == true )
        {
          SetRotation( );
          ++m_Seq;
        }
      }
        break;
      case 1:
      {
        // Aj[VI҂
        if ( CheckEndAnimation( MDLID_EFFECT ) )
        {
          ++m_Seq;
        }
        ONOUE_PRINT( "Aj[V̏I҂\n" );
      }
        break;
      case 2:
        return gamesystem::GMEVENT_RES_FINISH;
    }

    return gamesystem::GMEVENT_RES_CONTINUE;
  }

  //--------------------------------------------------------------
  /**
   * @brief   Ăяo֐ z֐
   * @param   p_gman       Q[}l[W[NX
   */
  //--------------------------------------------------------------

  void EventFieldSkillAnawohoruIn::EndFunc( gamesystem::GameManager* /*p_gman*/ )
  {
    //---------------------------
    /// eJ
    for ( int i = 0; i < MDLID_MAX; i++ )
    {
      GFL_SAFE_DELETE( mp_model[i] );
    }
    // Aj
    for ( int i = 0; i < ANMID_MAX; i++ )
    {
      m_anim[i].Destroy( );
    }
    GFL_SAFE_DELETE( mp_gmk_mdl_setup );

    GFL_SAFE_DELETE( m_device_allocator );
    GFL_SAFE_DELETE( m_heap_allocator );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ZbgAbv֐
   */
  //-----------------------------------------------------------------------------

  void EventFieldSkillAnawohoruIn::SetUp( PlayerGrid* p_player, gfl::grp::g3d::StereoCamera* camera )
  {
    m_pPlayer = p_player;
    m_pCamera = camera;
  }

  /* -------------------------------------------------------------------------*/
  /**
   * @brief ȂقGtFNgFf̃ZbgAbv
   *
   * @param p_gman
   *
   * @return true̎ǂݍݏI
   */

  /* -------------------------------------------------------------------------*/
  b32 EventFieldSkillAnawohoruIn::SetupMdl( gamesystem::GameManager* p_gman )
  {
    mmodel::MoveModel* p_player_model = m_pPlayer->GetModel( );
    Fieldmap* p_fieldmap = p_gman->GetFieldmap( );
    //Graphics* p_graphics = p_fieldmap->GetGraphics( );
    Mapper* p_mapper = p_fieldmap->GetMapper( );

    switch ( m_setup_seq )
    {
      case SETUP_LOAD_ARC:
      {
        mp_gmk_mdl_setup->LoadArc( m_arc_id );
        m_setup_seq++;
      }
        break;
      case SETUP_LOAD_ARC_WAIT:
      {
        //[h҂
        if ( mp_gmk_mdl_setup->LoadArcWait( ) )
        {
          ONOUE_PRINT( "[h\n" );
          m_setup_seq++;
        }
        // through break
      }
        break;
      case SETUP_MDL_DATA_SEQ:
      {
        mp_gmk_mdl_setup->SetupResource( mcp_setup_table, m_device_allocator );
        gfl::grp::g3d::Scene* p_scene = p_fieldmap->GetGraphics( )->GetScene( );

        //---------------------------
        /// GtFNg
        {
          // XP^Aj
          mp_gmk_mdl_setup->CreateAnime(
                                         BL_IDX_ANAWOHORU_EFFECT_ANAWOHORU_BCSKLA,
                                         &m_anim[ANMID_EFFECT_SKLA],
                                         gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_SKELETAL );

#if 0
          // }eAAj
          mp_gmk_mdl_setup->CreateAnime(
                                         BL_IDX_ANAWOHORU_EFFECT_ANAWOHORU_BCMATA,
                                         &m_anim[ANMID_EFFECT_MATA],
                                         gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_MATERIAL );
#endif

          // }eAAj(Shader)
          mp_gmk_mdl_setup->CreateAnime(
                                         BL_IDX_ANAWOHORU_EFFECT_ANAWOHORU_BCSHDR,
                                         &m_anim[ANMID_EFFECT_CSDR],
                                         gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_MATERIAL );
#if 0
          // rWreB[Aj
          mp_gmk_mdl_setup->CreateAnime(
                                         BL_IDX_ANAWOHORU_EFFECT_ANAWOHORU_BCMDLA,
                                         &m_anim[ANMID_EFFECT_MDLA],
                                         gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_VISIBILITY );
#endif
          // Aj[VXg
          gfl::grp::g3d::ResAnim * anime_list[] = {
            &m_anim[ANMID_EFFECT_SKLA],
            // &m_anim[ANMID_EFFECT_MATA] ,
            &m_anim[ANMID_EFFECT_CSDR],
            // &m_anim[ANMID_EFFECT_MDLA],
          };
          // f̍쐬
          mp_gmk_mdl_setup->CreateModel(
                                         m_device_allocator,
                                         m_heap_allocator,
                                         BL_IDX_ANAWOHORU_EFFECT_ANAWOHORU_BCMDL,
                                         &mp_model[MDLID_EFFECT],
                                         anime_list, 2 );
          // V[ւ̒ǉ
          p_scene->AddSceneNode( mp_model[MDLID_EFFECT] );
          // \Ԃ̐ݒ
          mp_model[MDLID_EFFECT]->SetVisible( true );
          // Aj[V[v̐ݒ
          mp_model[MDLID_EFFECT]->SetAnimationStepFrame( 1.0f, 0 );
          mp_model[MDLID_EFFECT]->SetAnimationStepFrame( 1.0f, 1 );
          //mp_model[MDLID_EFFECT]->SetAnimationStepFrame( 1.0f, 2 );
          // mp_model[MDLID_EFFECT]->SetAnimationStepFrame(1.0f,3);

          // @̈ʒu
          gfl::math::VEC3 player_pos;
          Position pos( p_mapper->GetRailSystem( ), p_mapper );
          p_player_model->GetVectorPos( &pos );
          pos.GetTranslate( &player_pos );

          // @Ɠʒuɕ\
          gfl::math::VEC3 ef_pos = player_pos;
          mp_model[MDLID_EFFECT]->SetTranslate( ef_pos );

#if 0
          // ]ݒ肷
          gfl::math::VEC3 way;
          gfl::math::MTX33 rot;
          p_player_model->GetTotalDrawDir( &way );
          PositionData player_pos_data = p_player_model->GetVectorPos( );
          CSpace::CreateMTX33ByFrontUpDirection( &rot, way, player_pos_data.up );
          mp_model[MDLID_EFFECT]->SetRotateMatrix( rot );
#endif
        }
      }
        m_setup_seq++;
        // through break
      case SETUP_END_SEQ:
      {
      }
        return true;
    }

    return false;
  }

  /* -------------------------------------------------------------------------*/
  /**
   * @brief Aj[V̏I`FbN
   *
   * @param mdl_idx fCfbNX
   *
   * @return true̎I
   */

  /* -------------------------------------------------------------------------*/
  bool EventFieldSkillAnawohoruIn::CheckEndAnimation( int mdl_idx )
  {
    u32 slot_num = mp_model[mdl_idx]->GetAnimationSlotNum( );
    // ׂẴXbg`FbNɂ
    for ( int i = 0; i < slot_num; i++ )
    {
      if ( mp_model[mdl_idx]->IsAnimationFrameEndFrame( i ) == false )
      {
        return false;
      }
    }
    return true;
  }

  /**
   * @brief 
   */
  void EventFieldSkillAnawohoruIn::SetRotation( void )
  {
    mmodel::MoveModel* p_player_model = m_pPlayer->GetModel( );

    // ANVR}hXg
    const u8 ROTATION_NUM = 33;
    mmodel::MoveModelAcmdList* acmdList;
    acmdList = GFL_NEW_ARRAY( mp_heap ) mmodel::MoveModelAcmdList[ ROTATION_NUM ];
    acmdList[0].acmd = mmodel::AC_DIR;
    //acmdList[0].dir = p_player_model->GetDirDisp( );
    acmdList[0].dir = DIR_DOWN;
    acmdList[0].num = 1;

    for ( u8 i = 1; i < ROTATION_NUM; ++i )
    {
      acmdList[i].acmd = mmodel::AC_DIR;
      acmdList[i].num = 1;
      switch ( acmdList[i - 1].dir )
      {
        case DIR_UP: ///<
          acmdList[i].dir = DIR_LEFTUP;
          break;
        case DIR_LEFTUP: ///<
          acmdList[i].dir = DIR_LEFT;
          break;
        case DIR_LEFT: ///<
          acmdList[i].dir = DIR_LEFTDOWN;
          break;
        case DIR_LEFTDOWN: ///<
          acmdList[i].dir = DIR_DOWN;
          break;
        case DIR_DOWN: ///<
          acmdList[i].dir = DIR_RIGHTDOWN;
          break;
        case DIR_RIGHTDOWN: ///<E
          acmdList[i].dir = DIR_RIGHT;
          break;
        case DIR_RIGHT: ///<E
          acmdList[i].dir = DIR_RIGHTUP;
          break;
        case DIR_RIGHTUP: ///<E
          acmdList[i].dir = DIR_UP;
          break;
      }
    }
    p_player_model->SetAcmdList( acmdList, ROTATION_NUM );

    GFL_SAFE_DELETE_ARRAY( acmdList );
  }

  //--------------------------------------------------------------
  /**
   *  Ȃق[OUT]
   */
  //--------------------------------------------------------------
  //--------------------------------------------------------------
  /**
   * @brief   Cxg𓮂Ă悢ǂ̔֐ z֐
   * @param   p_gman       Q[}l[W[NX
   * @retval  true  NĂ悢
   * @retval  false NȂ
   */
  //--------------------------------------------------------------

  bool EventFieldSkillAnawohoruOut::BootChk( gamesystem::GameManager* /*p_gman*/ )
  {
    return true;
  }

  //--------------------------------------------------------------
  /**
   * @brief p[^̃Zbg
   *
   */
  //--------------------------------------------------------------

  void EventFieldSkillAnawohoruOut::SetParameter( )
  {
  }

  //--------------------------------------------------------------
  /**
   * @brief   bootchktruȅꍇɂĂяo鏉֐ z֐
   * @param   p_gman       Q[}l[W[NX
   */
  //--------------------------------------------------------------

  void EventFieldSkillAnawohoruOut::InitFunc( gamesystem::GameManager* /*p_gman*/ )
  {
    /// f̃ZbgAbv
    mp_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_EVENT );
    mp_dev = gfl::heap::Manager::GetHeapByHeapId( HEAPID_EVENT_DEVICE );

    // AP[^쐬
    m_heap_allocator = GFL_NEW( mp_heap ) gfl::heap::NwAllocator( mp_heap );
    m_device_allocator = GFL_NEW( mp_heap ) gfl::heap::NwAllocator( mp_dev );
  }

  //--------------------------------------------------------------
  /**
   * @brief   Ăяo֐ z֐
   * @param   p_gman       Q[}l[W[NX
   * @return  GMEVENT_RESULT  Cxg֐̖߂l
   */
  //--------------------------------------------------------------

  gamesystem::GMEVENT_RESULT EventFieldSkillAnawohoruOut::MainFunc( gamesystem::GameManager* p_gman )
  {
    switch ( m_Seq )
    {
      case 0:
      {
        SetRotation( );
        ++m_Seq;
      }
        break;
      case 1:
      {
        // ]I҂
        if ( m_pPlayer->GetModel( )->IsAcmdListEnd( ) )
        {
          ++m_Seq;
        }
      }
        break;
      case 2:
        return gamesystem::GMEVENT_RES_FINISH;
    }

    return gamesystem::GMEVENT_RES_CONTINUE;
  }

  //--------------------------------------------------------------
  /**
   * @brief   Ăяo֐ z֐
   * @param   p_gman       Q[}l[W[NX
   */
  //--------------------------------------------------------------

  void EventFieldSkillAnawohoruOut::EndFunc( gamesystem::GameManager* /*p_gman*/ )
  {
    GFL_SAFE_DELETE( m_device_allocator );
    GFL_SAFE_DELETE( m_heap_allocator );
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ZbgAbv֐
   */
  //-----------------------------------------------------------------------------

  void EventFieldSkillAnawohoruOut::SetUp( PlayerGrid* p_player, gfl::grp::g3d::StereoCamera* camera )
  {
    m_pPlayer = p_player;
    m_pCamera = camera;
  }

  /**
   * @brief 
   */
  void EventFieldSkillAnawohoruOut::SetRotation( void )
  {
    mmodel::MoveModel* p_player_model = m_pPlayer->GetModel( );

    // ANVR}hXg
    const u8 ROTATION_NUM = 33;
    mmodel::MoveModelAcmdList* acmdList;
    acmdList = GFL_NEW_ARRAY( mp_heap ) mmodel::MoveModelAcmdList[ ROTATION_NUM ];
    acmdList[0].acmd = mmodel::AC_DIR;
    //acmdList[0].dir = p_player_model->GetDirDisp( );
    acmdList[0].dir = DIR_DOWN;
    acmdList[0].num = 1;

    for ( u8 i = 1; i < ROTATION_NUM; ++i )
    {
      acmdList[i].acmd = mmodel::AC_DIR;
      acmdList[i].num = 1;
      switch ( acmdList[i - 1].dir )
      {
        case DIR_UP: ///<
          acmdList[i].dir = DIR_LEFTUP;
          break;
        case DIR_LEFTUP: ///<
          acmdList[i].dir = DIR_LEFT;
          break;
        case DIR_LEFT: ///<
          acmdList[i].dir = DIR_LEFTDOWN;
          break;
        case DIR_LEFTDOWN: ///<
          acmdList[i].dir = DIR_DOWN;
          break;
        case DIR_DOWN: ///<
          acmdList[i].dir = DIR_RIGHTDOWN;
          break;
        case DIR_RIGHTDOWN: ///<E
          acmdList[i].dir = DIR_RIGHT;
          break;
        case DIR_RIGHT: ///<E
          acmdList[i].dir = DIR_RIGHTUP;
          break;
        case DIR_RIGHTUP: ///<E
          acmdList[i].dir = DIR_UP;
          break;
      }
    }
    p_player_model->SetAcmdList( acmdList, ROTATION_NUM );

    GFL_SAFE_DELETE_ARRAY( acmdList );
  }

} // namespace field
