###################################################################################
# @brief  BGMf[^Ro[^
# @file   special_bgm.rb
# @author iwasawa 
# @date   2012.08.21
###################################################################################

require "#{ENV["PROJECT_ROOT"]}tools/headerdata.rb"
require "#{ENV["PROJECT_ROOT"]}tools/hash/smid_hash.rb"

arg =$*
$input_txt = arg[0]
$output_cdat = arg[1]

#==================================================================================
# 萔
#==================================================================================
# CfbNX
ROW_FLAG_NO   = 0  # tONo.
ROW_ZONE_ID   = 1  # ][ID
ROW_SOUND_IDX = 2  # BGM No.


#==================================================================================
# ^
#==================================================================================
SUMMARY = "// resource/field/special_bgm/special_bgm.rb ɂ莩\n\n" 

#==================================================================================
# sf[^
#==================================================================================
class Row
  def initialize
    @flagNo_lavel   = 0  # tONo.
    @zoneID_lavel   = 0  # ][ID
    @soundIdx_lavel = 0  # BGM No.
  end
  attr_accessor :flagNo_lavel, :zoneID_lavel, :soundIdx_lavel
end

#----------------------------------------------------------------------------------
# @brief BGMe[u擾
# @param SĂ̍sf[^z
# @return BGMe[u`镶
#----------------------------------------------------------------------------------
def GetSpecialBGMTable( rows )
  string = "static const SpecialBGM sc_specialBGMTable[] = \n"
  string += "{\n"

  rows.each do |row|
    string += "  {#{row.flagNo_lavel}, #{row.zoneID_lavel}, #{row.soundIdx_lavel}},\n"
  end

  string += "};\n\n"

  return string
end


#----------------------------------------------------------------------------------
# @brief tO̎l擾
# @param flagName tO
# @return w肵tO̒l
#----------------------------------------------------------------------------------
def GetFlagNo( flagName ) 
  # `t@CJ
  filename = ENV["PROJECT_ROOT"] + "resource/field/flagwork/flag_define.h"
  file = File.open( filename, "r" )

  # w肳ꂽtOID
  file.each do |line|
		if line.index(/#define.*#{flagName}\s*(\d*)\s*/) != nil then 
			return $1.to_i
		end
  end
  file.close

  # w肳ꂽtOID`ĂȂꍇ
  abort("tOID:#{flagName}͒`Ă܂") 
  exit 1
end

#----------------------------------------------------------------------------------
# @brief ][ID̎l擾
# @param zoneName ][IDx
# @return w肵][ID̒l
#----------------------------------------------------------------------------------
def GetZoneID( zoneName ) 
  # `t@CJ
  filename = ENV["PROJECT_ROOT"] + "resource/field/zonedata/zone_id.h"
  file = File.open( filename, "r" )

  # w肳ꂽ][ID
  file.each do |line|
		if line.index(/#define.*#{zoneName}\s*\(\s*(\d*)\)\s*/) != nil then 
			return $1.to_i
		end
  end
  file.close

  # w肳ꂽ][ID`ĂȂꍇ
  abort("][ID:#{zoneName}͒`Ă܂")
  exit 1
end

#----------------------------------------------------------------------------------
# @brief BGM No.̎l擾
# @param bgmLavel BGMx
# @return w肵BGM̒l
#----------------------------------------------------------------------------------
def GetSoundIdx( bgmLavel )
  id = $smid_hash.fetch( bgmLavel, nil )
  if id == nil then
    abort("BGM:#{bgmLavel}͒`Ă܂") 
    exit 1
  end
  return id
end


#==================================================================================
# @brief C
# @param ARGV[0] Ro[gΏۂ̃J}؂f[^t@C̃pX
#==================================================================================
# t@Cf[^擾
file = File.open( $input_txt, "r" )
fileData = file.readlines
file.close

# sf[^z
rows = Array.new

# f[^o
1.upto( fileData.size - 1 ) do |rowIndex|
  rowData = fileData[rowIndex]
  rowItem = rowData.split(/,/)
  row = Row.new
  row.flagNo_lavel   = rowItem[ROW_FLAG_NO]
  row.zoneID_lavel   = rowItem[ROW_ZONE_ID]
  row.soundIdx_lavel = rowItem[ROW_SOUND_IDX]
  rows << row
end

# x`FbN
rows.each do |row|
  GetFlagNo( row.flagNo_lavel )
  GetZoneID( row.zoneID_lavel )
  GetSoundIdx( row.soundIdx_lavel )
end

# o
file = File.open( $output_cdat, "w" )
file.write( SUMMARY )
file.write( GetSpecialBGMTable(rows) )
file.close 
