//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file   SeqCube.cpp
 *  @brief  V[PXL[u
 *  @author Koji Kawada
 *  @date   2012.08.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


// gflib
#include <gflib.h>

// kujira
#include "gamesystem/GameProc.h"
#include "print/system_font.h"
#include "dll/DllProc.h"
#include "print/WordSet.h"
#include "app/tool/app_tool_YesNoMenu.h"
#include "app/strinput/strinput.h"
#include "app/util/app_util_heap.h"
#include "app/util/app_util_Common.h"

// intro
#include "SeqCube.h"

// arc
#include "arc/arc_def.h"            // ARCID_ 
#include "arc/intro.gaix"


namespace app {
namespace intro {


//-----------------------------------------------------------------------------
/**
 *          NX
 */
//-----------------------------------------------------------------------------

//-------------------------------------
/// V[PXL[u
//=====================================
SeqCube::SeqCube(
  gfl::heap::HeapBase*      heap_memory,
  gfl::heap::HeapBase*      device_memory,
  gfl::heap::NwAllocator*   heap_allocator,
  gfl::heap::NwAllocator*   device_allocator,
  gfl::fs::FileReadManager* file_read_manager
)
  : m_heap_memory(heap_memory),
    m_device_memory(device_memory),
    m_heap_allocator(heap_allocator),
    m_device_allocator(device_allocator),
    m_file_read_manager(file_read_manager),
    m_state(STATE_NONE),
    m_res_buffer(NULL),
    m_res_buffer_size(0),
    m_res_finish(false),
    m_res(NULL),
    m_res_anim(NULL)
{
  // FileReadManager
  {
    gfl::fs::FileReadManager::ReadRequest req;
    req.arcID = ARCID_INTRO;  //   ARCID_???g悤ɂĂĉB
    req.heapForWork = m_heap_memory->GetLowerHandle();
    req.heapForUncomp = NULL;
    req.heapForBuffer = m_device_memory;
    req.destBufferAlignment = 128;

    {
      req.datID           = GARC_intro_intro_cubes_BCSKLA;
      req.ppDestBuffer    = &m_res_buffer;
      req.pDestBufferSize = &m_res_buffer_size;
   
      m_file_read_manager->AddReadRequest(req);
    }
  }

  m_state = STATE_CREATING;
}

SeqCube::~SeqCube(void)
{
  GFL_ASSERT(m_state == STATE_PLAYING);

  GFL_SAFE_DELETE(m_res_anim);
  GFL_SAFE_DELETE(m_res);

  {
    if(m_res_buffer)
    {
      GflHeapFreeMemory(m_res_buffer);
    }
    m_res_buffer = NULL;
    m_res_buffer_size = 0;
    m_res_finish = 0;
  }
}

void SeqCube::Update(void)
{
  switch(m_state)
  {
  case STATE_CREATING:
    {
      // FileReadManager
      {
        if( m_file_read_manager->IsReadFinished(&(m_res_buffer)) )
        {
          m_res = GFL_NEW(m_heap_memory) gfl::grp::g3d::Resource;
          m_res->AttachBuffer(m_device_allocator, m_res_buffer);
          m_res->Setup(m_device_allocator, NULL, gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT);

          m_res_anim = GFL_NEW(m_heap_memory) gfl::grp::g3d::ResAnim;
          m_res->GetResAnim(gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_SKELETAL, 0, m_res_anim);
          
          m_state = STATE_PLAYING;
        }
      }
      break;
    }
  case STATE_PLAYING:
    {
      break;
    }
  }
}


} // namespace intro
} // namespace app

