//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file   KanaKanjiMain.cpp
 *  @brief  ȊI
 *  @author Koji Kawada
 *  @date   2012.08.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


// gflib
#include <gflib.h>

// kujira
#include "gamesystem/GameProc.h"
#include "print/system_font.h"
#include "dll/DllProc.h"
#include "print/WordSet.h"
#include "app/tool/app_tool_YesNoMenu.h"
#include "app/strinput/strinput.h"
#include "app/util/app_util_heap.h"
#include "app/util/app_util_Common.h"

// intro
#include "KanaKanji2d.h"
#include "KanaKanjiMain.h"

// arc
#include "arc/arc_def.h"            // ARCID_ 
#include "arc/message.gaix"

// message
#include "message/msg_intro.h"


namespace app {
namespace intro {


//-----------------------------------------------------------------------------
/**
 *          NX
 */
//-----------------------------------------------------------------------------

//-------------------------------------
/// ȊIMain
//=====================================
KanaKanjiMain::KanaKanjiMain(
  app::util::Heap*         util_heap,
  gfl::heap::HeapBase*     heap_memory,
  gfl::heap::HeapBase*     device_memory,
  gfl::heap::NwAllocator*  heap_allocator,
  gfl::heap::NwAllocator*  device_allocator,
  gamesystem::GameManager* game_manager
)
  : BaseMain(
      util_heap,
      heap_memory,
      device_memory,
      heap_allocator,
      device_allocator,
      game_manager
    )
{
  gfl::grp::GraphicsSystem* graphics_system = m_game_manager->GetGraphicsSystem();
  
  graphics_system->InitializeApplicationMemory( m_device_allocator );
  
  m_2d = GFL_NEW(m_heap_memory) KanaKanji2d(
    util_heap,
    heap_memory,
    device_memory,
    heap_allocator,
    device_allocator,
    m_game_manager
  );

  initializeKanaKanjiSection();
#if APP_INTRO_KANAKANJI_GUIDELINE_EXIST
  initializeGuidelineSection();
#endif
}

KanaKanjiMain::~KanaKanjiMain()
{
  gfl::grp::GraphicsSystem* graphics_system = m_game_manager->GetGraphicsSystem();
  
  GFL_DELETE m_2d;
  m_2d = NULL;

  m_section = SECTION_KANAKANJI;
  m_phase = PHASE_END;
  m_step = 0;
  m_enable_draw = false;

  graphics_system->FinalizeApplicationMemory();
}

b32 KanaKanjiMain::Update(gfl::proc::Manager * proc_manager)
{
  b32 is_continue = false;
  switch(m_section)
  {
#if APP_INTRO_KANAKANJI_GUIDELINE_EXIST
  case SECTION_GUIDELINE:
    {
      is_continue = updateGuideline(proc_manager);
      if( is_continue )
      {
        break;
      }
      else
      {
        initializeKanaKanjiSection();
        //breakȂ
      }
    }
#endif
  case SECTION_KANAKANJI:
    {
      is_continue = updateKanaKanji(proc_manager);
      break;
    }
  }
  return is_continue;
}

void KanaKanjiMain::Draw(void)
{
  switch(m_section)
  {
#if APP_INTRO_KANAKANJI_GUIDELINE_EXIST
  case SECTION_GUIDELINE:
    {
      drawGuideline();
      break;
    }
#endif
  case SECTION_KANAKANJI:
    {
      drawKanaKanji();
      break;
    }
  }
}

#if APP_INTRO_KANAKANJI_GUIDELINE_EXIST
b32 KanaKanjiMain::updateGuideline(gfl::proc::Manager * /*proc_manager*/)
{
  gfl::ui::DeviceManager* device_manager = m_game_manager->GetUiDeviceManager();

  gfl::ui::Button*       button      = device_manager->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
  gfl::ui::VectorDevice* cross_key   = device_manager->GetCrossKey( gfl::ui::CTR_DeviceManager::CROSSKEY_STANDARD );
  gfl::ui::VectorDevice* stick       = device_manager->GetStick( gfl::ui::CTR_DeviceManager::STICK_STANDARD );
  gfl::ui::TouchPanel*   touch_panel = device_manager->GetTouchPanel( gfl::ui::CTR_DeviceManager::TOUCHPANEL_STANDARD );

  b32 onemore = false;
  do
  {
    onemore = false;
    switch(m_phase)
    {
    case GUIDELINEPHASE_START:
      {
        m_enable_draw = true; 
        m_2d->CreateGuideline();
        changePhase(GUIDELINEPHASE_FADE_IN);
        onemore = true;
        break;
      }
    case GUIDELINEPHASE_FADE_IN:
      {
        onemore = exeFade(true, GUIDELINEPHASE_INPUT);
        break;
      }
    case GUIDELINEPHASE_INPUT:
      {
        if( 
               button->IsRelease( gfl::ui::BUTTON_A )  // @todo `邩H
            || touch_panel->IsTouchRelease()
        )
        {
          changePhase(GUIDELINEPHASE_FADE_OUT);
          onemore = true;
        }
        else
        {
          onemore = false;
        }
        break;
      }
    case GUIDELINEPHASE_FADE_OUT:
      {
        onemore = exeFade(false, GUIDELINEPHASE_END);
        break;
      }
    case PHASE_DISABLE_DRAW:
      {
        m_enable_draw = false;
        onemore = false;
        break;
      }
    case GUIDELINEPHASE_END:
      {
        m_2d->Destroy();
        onemore = false;
        break;
      }
    }
  }
  while(onemore);

  m_2d->Update();

  if( m_phase == GUIDELINEPHASE_END ) return false;
  return true;
}

void KanaKanjiMain::drawGuideline(void)
{
  if( m_enable_draw )
  {
    m_2d->Draw();
  }
}

void KanaKanjiMain::initializeGuidelineSection(void)
{
  m_section = SECTION_GUIDELINE;
  m_phase = GUIDELINEPHASE_START;
  m_step = 0;
  m_enable_draw = false;
}
#endif

b32 KanaKanjiMain::updateKanaKanji(gfl::proc::Manager * /*proc_manager*/)
{
  savedata::Config* config = m_game_manager->GetGameData()->GetConfig();

  u32 confirm_str_id = 0;

  b32 onemore = false;
  do
  {
    onemore = false;
    switch(m_phase)
    {
    case PHASE_START:
      {
        m_enable_draw = true;
        m_2d->CreateKanaKanji();
        xy_snd::StartBGM(STRM_BGM_STARTING1, 0);
        changePhase(PHASE_FADE_IN);
        onemore = true;
        break;
      }
    case PHASE_FADE_IN:
      {
        onemore = exeFade(true, PHASE_MSG_QUESTION);
        break;
      }
    case PHASE_MSG_QUESTION:
      {
        onemore = exeMsg(msg_kanamode_01, PHASE_SEL);
        break;
      }
    case PHASE_SEL:
      {
        onemore = exeSel(msg_kanamode_select_01, msg_kanamode_select_02, PHASE_MSG_CONFIRM);
        s32 result = m_2d->GetMenuWinResult();
        if( result >= 0 )
        {
          if( result == 0 )
          {
            // uȁvݒ
            confirm_str_id = msg_kanamode_02;
            config->SetLangId(savedata::Config::LANGID_KANA);
          }
          else
          {
            // uvݒ
            confirm_str_id = msg_kanamode_03;
            config->SetLangId(savedata::Config::LANGID_KANJI);
          }
        }
        break;
      }
    case PHASE_MSG_CONFIRM:
      {
        onemore = exeMsg(confirm_str_id, PHASE_FADE_OUT);
        break;
      }
    case PHASE_FADE_OUT:
      {
        if( m_step == 0 ) xy_snd::StopBGM(FADE_SYNC);
        onemore = exeFade(false, PHASE_WAIT);
        break;
      }
    case PHASE_WAIT:
      {
        if( !xy_snd::IsBGMFade() )
        {
          changePhase(PHASE_END);
          onemore = true;
        }
        else
        {
          onemore = false;
        }
        break;
      }
    case PHASE_DISABLE_DRAW:
      {
        m_enable_draw = false;
        onemore = false;
        break;
      }
    case PHASE_END:
      {
        m_2d->Destroy();
        onemore = false;
        break;
      }
    }
  }
  while(onemore);

  m_2d->Update();
  
  if( m_phase == PHASE_END ) return false;
  return true;
}

void KanaKanjiMain::drawKanaKanji(void)
{
  if( m_enable_draw )
  {
    m_2d->Draw();
  }
}

void KanaKanjiMain::initializeKanaKanjiSection(void)
{
  m_section = SECTION_KANAKANJI;
  m_phase = PHASE_START;
  m_step = 0;
  m_enable_draw = false;
}

void KanaKanjiMain::changePhase(s32 next_phase)
{
  m_phase = next_phase;
  m_step = 0;
}

b32 KanaKanjiMain::exeFade(b32 is_fade_in, s32 next_phase)
{
  b32 onemore = false;
  switch(m_step)
  {
  case 0:
    if( is_fade_in )
    {
      gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_DOUBLE, FADE_SYNC );
    }
    else
    {
      gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_DOUBLE, gfl::grp::Fade::OUTTYPE_BLACK, FADE_SYNC );
    }
    ++m_step;
    //breakȂ
  case 1:
    if( gfl::grp::Fade_IsEnd() )
    {
      changePhase(next_phase);
      onemore = true;
    }
    else
    {
      onemore = false;
    }
    break;
  }
  return onemore;
}

b32 KanaKanjiMain::exeMsg(u32 str_id, s32 next_phase)
{
  b32 onemore = false;
  switch(m_step)
  {
  case 0:
    m_2d->StartMsgWin(str_id);
    ++m_step;
    //breakȂ
  case 1:
    if( m_2d->IsMsgWinDone() )
    {
      changePhase(next_phase);
      onemore = true;
    }
    else
    {
      onemore = false;
    }
    break;
  }
  return onemore;
}

b32 KanaKanjiMain::exeSel(u32 str_id0, u32 str_id1, s32 next_phase)
{
  b32 onemore = false;
  switch(m_step)
  {
  case 0:
    m_2d->StartMenuWin(str_id0, str_id1);
    ++m_step;
    //breakȂ
  case 1:
    if( m_2d->GetMenuWinResult() >= 0 )
    {
      m_2d->EndMenuWin();
      changePhase(next_phase);
      onemore = true;
    }
    else
    {
      onemore = false;
    }
    break;
  }
  return onemore;
}


} // namespace intro
} // namespace app

