//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file   KanaKanji2d.cpp
 *  @brief  ȊI
 *  @author Koji Kawada
 *  @date   2012.08.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


// gflib
#include <gflib.h>

// kujira
#include "gamesystem/GameProc.h"
#include "print/system_font.h"
#include "dll/DllProc.h"
#include "print/WordSet.h"
#include "app/strinput/strinput.h"
#include "app/util/app_util_heap.h"

// kanakanji
#include "KanaKanji2d.h"

// arc
#include "arc/arc_def.h"            // ARCID_ 
#include "arc/kanakanji.gaix"


namespace app {
namespace intro {


// O邽namespacetĂ
namespace kanakanji {

// res_header
#include "res_header/lyt.h"
#include "res_header/lyt_pane.h"

}  // namespace kanakanji


//-----------------------------------------------------------------------------
/**
 *          NX
 */
//-----------------------------------------------------------------------------

//-------------------------------------
/// ȊI2D
//=====================================
KanaKanji2d::KanaKanji2d(
  app::util::Heap*         util_heap,
  gfl::heap::HeapBase*     heap_memory,
  gfl::heap::HeapBase*     device_memory,
  gfl::heap::NwAllocator*  heap_allocator,
  gfl::heap::NwAllocator*  device_allocator,
  gamesystem::GameManager* game_manager
)
  : m_util_heap       (util_heap),
    m_heap_memory     (heap_memory),
    m_device_memory   (device_memory),
    m_heap_allocator  (heap_allocator),
    m_device_allocator(device_allocator),
    m_game_manager    (game_manager)
{
  constructorLyt();
  constructorLytEnv();
  constructorMsg();
  constructorMsgWin();
  constructorMenuWindow();
}

KanaKanji2d::~KanaKanji2d()
{
  Destroy();

  m_util_heap        = NULL;
  m_heap_memory      = NULL;
  m_device_memory    = NULL;
  m_heap_allocator   = NULL;
  m_device_allocator = NULL;
  m_game_manager     = NULL;
}

void KanaKanji2d::Update(void)
{
  b32 no_dialog = true;

  // MenuWindow
  if( m_menu_win_sys )
  {
    m_menu_win_sys->UpdateControl();
    m_menu_win_sys->UpdateView();
 
    if( m_menu_win_sys->IsAlternativeSelected() )
    {
      m_menu_win_result = m_menu_win_sys->GetSelectedAlternativeValue();
    }
    no_dialog = false;
  }

  if( no_dialog )
  {
    // MsgWin
    if( m_msg_win )
    {
      m_msg_win_result = m_msg_win->Proc();
    }
  }

  // lyt
  if( m_lyt_wk_bg )
  {
    m_lyt_wk_bg->Update();
  }
  if( m_lyt_wk )
  {
    m_lyt_wk->Update();
    //m_lyt_sys->UpdateAll();
  }
}

void KanaKanji2d::Draw(void)
{
  gfl::grp::GraphicsSystem* graphics_system = m_game_manager->GetGraphicsSystem();

  gfl::grp::RenderTarget* lower_render_target       = graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_LOWER );
  gfl::grp::RenderTarget* upper_render_target       = graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER );
  gfl::grp::RenderTarget* upper_right_render_target = graphics_system->GetCurrentFrameBuffer( gfl::grp::DISPLAY_UPPER_RIGHT );

  // lyt 3D艜
  if( m_lyt_wk_bg )
  {
    m_lyt_wk_bg->Draw( graphics_system, gfl::grp::DISPLAY_UPPER, upper_render_target, upper_right_render_target );
  }

  // lyt 3DO
  if( m_lyt_wk )
  {
    m_lyt_wk->Draw( graphics_system, gfl::grp::DISPLAY_UPPER, upper_render_target, upper_right_render_target );
    //m_lyt_sys->DrawAll( graphics_system, gfl::grp::DISPLAY_UPPER, upper_render_target, upper_right_render_target );
  }

  // MenuWindow
  if( m_menu_win_sys )
  {
    m_menu_win_sys->DrawMenuWindow();
  }
}

void KanaKanji2d::StartMsgWin(u32 str_id)
{
  m_msg_data->GetString(str_id, *m_msg_win_str_buf);
  m_msg_win->SetString(*m_msg_win_str_buf);
  m_msg_win_result = gfl::str::StrWin::RES_CONTINUE;
}
b32 KanaKanji2d::IsMsgWinDone(void)
{
  if( m_msg_win_result == gfl::str::StrWin::RES_DONE ) return true;
  else                                                 return false;
}

void KanaKanji2d::StartMenuWin(u32 str_id_0, u32 str_id_1)
{
  createMenuWindow(str_id_0, str_id_1);
  m_menu_win_result = -1;
}
void KanaKanji2d::EndMenuWin(void)
{
  destroyMenuWindow();
}
s32 KanaKanji2d::GetMenuWinResult(void) const
{ 
  return m_menu_win_result;
}

void KanaKanji2d::CreateGuideline(void)
{
  createLyt();
  createMsg();

  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_INFO_WIN_00 , false);
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_INFO_TEXT_00, false); 
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_INFO_TEXT_01, false);
  m_lyt_util->SetAlpha(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_SELECT_M_00, 0);
  m_lyt_util->SetAlpha(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_SELECT_F_00, 0);
  m_lyt_util->SetTextboxPaneMessage(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_FIX_TEXT_00, m_msg_data, msg_intro_guideline_01);
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_FRAME_BACK_BG_00, false);
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_FRAME_BACK_TX_00, false);
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_FRAME_BACK_FR_00, false);
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_FRAME_HUMAN_00, false);
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_FRAME_HUMAN_01, false);
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_FRAME_HUMAN_02, false);
}

void KanaKanji2d::CreateKanaKanji(void)
{
  createLyt();
  createMsg();
  createMsgWin();

  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_FIX_TEXT_00, false);
  m_lyt_util->SetVtxColorElementOfPicturePane(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_BG_00, nw::ut::Color8(0, 0, 0, 255));
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_INFO_WIN_00 , true);
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_INFO_TEXT_00, true); 
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_INFO_TEXT_01, true);
  m_lyt_util->SetAlpha(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_SELECT_M_00, 0);
  m_lyt_util->SetAlpha(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_SELECT_F_00, 0);
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_FRAME_BACK_BG_00, false);
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_FRAME_BACK_TX_00, false);
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_FRAME_BACK_FR_00, false);
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_FRAME_HUMAN_00, false);
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_FRAME_HUMAN_01, false);
  m_lyt_util->SetPaneVisibility(m_lyt_wk, kanakanji::PANENAME_INTRO_UPPER_PANE_FRAME_HUMAN_02, false);
}

void KanaKanji2d::Destroy(void)
{
  destroyMenuWindow();
  destroyMsgWin(); 
  destroyMsg();
  destroyLyt();
}

void KanaKanji2d::constructorLyt(void)
{
  m_lyt_sys       = NULL;
  m_lyt_env_upper = NULL;
  m_lyt_env_lower = NULL;
  m_lyt_file      = NULL;
  m_lyt_res_id    = gfl::grp::g2d::LYTSYS_RESID_ERROR;  // G[R[hŏ
  //m_lyt_wk_setup;
  m_lyt_wk        = NULL;
  m_lyt_wk_bg     = NULL;
  m_lyt_util      = NULL;
}

void KanaKanji2d::createLyt(void)
{
  // VXe
  static const gfl::grp::g2d::LytSysSetUp lyt_sys_setup =
  {
    // ̕ + MenuWindow  // @todo MenuWindowpɎ芸4mۂĂ
    1 + 4,  // Ǘ\[Xő吔
    1 + 4   // ǗLytWkő吔
  };
  m_lyt_sys = GFL_NEW(m_heap_memory) gfl::grp::g2d::LytSys(
    &lyt_sys_setup,
    m_heap_allocator,
    m_device_allocator
  );

  // Env
  createLytEnv(true);

  // t@C
  m_lyt_file = GFL_NEW(m_heap_memory) gfl::fs::ArcFile( m_heap_memory, ARCID_KANAKANJI, gfl::fs::ArcFile::OPEN );
  
  // \[X
  m_lyt_res_id = m_lyt_sys->LoadLytRes( m_device_allocator, m_lyt_file, GARC_kanakanji_lyt_LYTDAT );
  m_lyt_sys->TransferAllTexture( m_lyt_res_id, gfl::grp::MEMORY_AREA_FCRAM );

  // [N
  {
    const gfl::grp::g2d::LytWkSetUp lyt_wk_setup =
    {
      gfl::math::VEC3(0,0,0),  // pos
      gfl::math::VEC2(1,1),    // scale
      gfl::math::VEC3(0,0,0),  // rotate
      0,                       // priority
      0                        // groupID
    };
    m_lyt_wk_setup = lyt_wk_setup;
  } 
  m_lyt_wk = m_lyt_sys->CreateLytWk(
    m_lyt_res_id,                  // CAEg\[XID
    kanakanji::LYTRES_LYT_INTRO_UPPER_BCLYT,  // resID̃CAEgf[^ID
    NULL,                          // Aj[Vf[^IDe[u      AĵȂꍇNULL
    0,                             // Aj[Vf[^IDe[u    AĵȂꍇ0
    0,                             // o^Aj[Vő吔ij  // ijanmMax = o^Aj[Vő吔ɂ
    &m_lyt_wk_setup,               // CAEg[N{
    false                          // Aj[ṼoChsB
  );
  m_lyt_wk->SetAutoDrawFlag(false);
  m_lyt_wk->SetUserEnv(m_lyt_env_upper, m_lyt_env_lower);

  m_lyt_wk_bg = m_lyt_sys->CreateLytWk(
    m_lyt_res_id,                     // CAEg\[XID
    kanakanji::LYTRES_LYT_INTRO_UPPER_BG_BCLYT,  // resID̃CAEgf[^ID
    NULL,                             // Aj[Vf[^IDe[u      AĵȂꍇNULL
    0,                                // Aj[Vf[^IDe[u    AĵȂꍇ0
    0,                                // o^Aj[Vő吔ij  // ijanmMax = o^Aj[Vő吔ɂ
    &m_lyt_wk_setup,                  // CAEg[N{
    false                             // Aj[ṼoChsB
  );
  m_lyt_wk_bg->SetAutoDrawFlag(false);
  m_lyt_wk_bg->SetUserEnv(m_lyt_env_upper, m_lyt_env_lower);

  // LytUtil
  m_lyt_util = GFL_NEW(m_heap_memory) app::util::LytUtil(m_heap_memory);
}

void KanaKanji2d::destroyLyt(void)
{
  // LytUtil
  if( m_lyt_util )
  {
    GFL_DELETE m_lyt_util;
    m_lyt_util = NULL;
  }

  // [N
  if( m_lyt_wk_bg )
  {
    m_lyt_sys->RemoveLytWk( m_lyt_wk_bg );
    m_lyt_wk_bg = NULL;
  }
  if( m_lyt_wk )
  {
    m_lyt_sys->RemoveLytWk( m_lyt_wk );
    m_lyt_wk = NULL;
  }

  // \[X
  if( m_lyt_res_id != gfl::grp::g2d::LYTSYS_RESID_ERROR )
  {
    m_lyt_sys->ReleaseLytRes( m_lyt_res_id );
    m_lyt_res_id = gfl::grp::g2d::LYTSYS_RESID_ERROR;  // G[R[hŏ
  }

  // t@C
  if( m_lyt_file )
  {
    GFL_DELETE m_lyt_file;
    m_lyt_file = NULL;
  }

  // Env
  destroyLytEnv();

  // VXe
  if( m_lyt_sys )
  {
    GFL_DELETE m_lyt_sys;
    m_lyt_sys = NULL;
  }

  constructorLyt();
}

void KanaKanji2d::constructorLytEnv(void)
{
  m_lyt_env_upper = NULL;
  m_lyt_env_lower = NULL;
}

void KanaKanji2d::createLytEnv(b32 is_stereo)
{
	// ˉeݒiˉej
	static const gfl::grp::ProjectionParam proj[] =
	{
		{	// 
			gfl::grp::PROJECTION_ORTHO,
			{ -200.0f, 200.0f, -120.0f, 120.0f },
			0.1f,
			1000.0f,
			gfl::math::PIVOT_UPSIDE_TO_TOP,
		},
		{	// 
			gfl::grp::PROJECTION_ORTHO,
			{ -160.0f, 160.0f, -120.0f, 120.0f },
			0.1f,
			1000.0f,
			gfl::math::PIVOT_UPSIDE_TO_TOP,
		}
	};
	// r[ݒ
	static const gfl::grp::ViewParam view[] =
	{
		{	// ʁiځj
			gfl::math::VEC3(0,0,1),		// JW
			gfl::math::VEC3(0,1,0),		// 
			gfl::math::VEC3(0,0,0),		// ^[QbgW
		},
		{	// ʁiEځj
			//gfl::math::VEC3(10,0,1),	// JW  // Eɂė̎Ȃ悤ɂ邱Ƃɂ
			gfl::math::VEC3(0,0,1),		// JW
			gfl::math::VEC3(0,1,0),		// 
			//gfl::math::VEC3(10,0,0),	// ^[QbgW  // Eɂė̎Ȃ悤ɂ邱Ƃɂ
			gfl::math::VEC3(0,0,0),		// ^[QbgW
		},
		{	// 
			gfl::math::VEC3(0,-290,1),	// JW
			gfl::math::VEC3(0,1,0),			// 
			gfl::math::VEC3(0,-290,0),	// ^[QbgW
		},
	};

	// 
	m_lyt_env_upper = GFL_NEW(m_heap_memory) gfl::grp::g2d::Env();
  m_lyt_env_upper->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, proj[0], view[0] );
  if( is_stereo )
  {
    m_lyt_env_upper->SetCameraParam( gfl::grp::g2d::Env::CAMERA_RIGHT, proj[0], view[1] );
  }
	// 
  m_lyt_env_lower = GFL_NEW(m_heap_memory) gfl::grp::g2d::Env();
	m_lyt_env_lower->SetCameraParam( gfl::grp::g2d::Env::CAMERA_NORMAL, proj[1], view[2] );
}

void KanaKanji2d::destroyLytEnv(void)
{
  if( m_lyt_env_lower )
  {
    GFL_DELETE m_lyt_env_lower;
    m_lyt_env_lower = NULL;
  }

  if( m_lyt_env_upper )
  {
    GFL_DELETE m_lyt_env_upper;
    m_lyt_env_upper = NULL;
  }
  
  constructorLytEnv();
}

void KanaKanji2d::constructorMsg(void)
{
  m_msg_data = NULL;
  m_word_set = NULL;
}

void KanaKanji2d::createMsg(void)
{
  m_msg_data = GFL_NEW(m_heap_memory) gfl::str::MsgData( ARCID_MESSAGE, GARC_message_intro_DAT, m_heap_memory, gfl::str::MsgData::LOAD_FULL );
  m_word_set = GFL_NEW(m_heap_memory) WordSet(m_heap_memory);
}

void KanaKanji2d::destroyMsg(void)
{
  if( m_word_set )
  {
    GFL_DELETE m_word_set;
    m_word_set = NULL;
  }

  if( m_msg_data )
  {
    GFL_DELETE m_msg_data;
    m_msg_data = NULL;
  }

  constructorMsg();
}

void KanaKanji2d::constructorMsgWin(void)
{
  m_msg_win              = NULL;
  m_msg_win_str_buf      = NULL;
  m_msg_win_str_buf_temp = NULL;
  //m_msg_win_result;  // StartMsgWinŏB܂ł͍Ō̌ʂێ悤ɂĂB
}

void KanaKanji2d::createMsgWin(void)
{
  gfl::ui::DeviceManager*   device_manager  = m_game_manager->GetUiDeviceManager();

  m_msg_win = GFL_NEW(m_heap_memory) print::MsgWin(  // bZ[Wxprint::MsgWinNXێĂ
      device_manager,
      m_lyt_wk,
      2,
      m_heap_memory );
  m_msg_win->AddLinePaneIdx(kanakanji::PANENAME_INTRO_UPPER_PANE_INFO_TEXT_00);
  m_msg_win->AddLinePaneIdx(kanakanji::PANENAME_INTRO_UPPER_PANE_INFO_TEXT_01);
  m_msg_win->Clear();

  m_msg_win_str_buf = GFL_NEW(m_heap_memory) gfl::str::StrBuf(MSG_WIN_STRBUF_LENGTH, m_heap_memory);
  m_msg_win_str_buf_temp = GFL_NEW(m_heap_memory) gfl::str::StrBuf(MSG_WIN_STRBUF_LENGTH, m_heap_memory);
}

void KanaKanji2d::destroyMsgWin(void)
{
  if( m_msg_win )
  {
    GFL_DELETE m_msg_win;
    m_msg_win = NULL;
    //m_msg_win_result;  // StartMsgWinŏB܂ł͍Ō̌ʂێ悤ɂĂB
  }

  if( m_msg_win_str_buf )
  {
    GFL_DELETE m_msg_win_str_buf;
    m_msg_win_str_buf = NULL;
  }

  if( m_msg_win_str_buf_temp )
  {
    GFL_DELETE m_msg_win_str_buf_temp;
    m_msg_win_str_buf_temp = NULL;
  }

  constructorMsgWin();
}

void KanaKanji2d::constructorMenuWindow(void)
{
  m_menu_win_sys = NULL;
  m_menu_win     = NULL;
  for(s32 i=0; i<MENU_WIN_STRBUF_NUM; ++i)
  {
    m_menu_win_str_buf[i] = NULL;
  }
  //m_menu_win_result;  // StartMenuWinŏB܂ł͍Ō̌ʂێ悤ɂĂB
}

void KanaKanji2d::createMenuWindow(u32 str_id_0, u32 str_id_1)
{
  gfl::ui::DeviceManager*   device_manager  = m_game_manager->GetUiDeviceManager();
  gfl::grp::GraphicsSystem* graphics_system = m_game_manager->GetGraphicsSystem();

  for(s32 i=0; i<MENU_WIN_STRBUF_NUM; ++i)
  {
    m_menu_win_str_buf[i] = GFL_NEW(m_heap_memory) gfl::str::StrBuf(MENU_WIN_STRBUF_LENGTH, m_heap_memory);
  }
  m_msg_data->GetString(str_id_0, *(m_menu_win_str_buf[0]));
  m_msg_data->GetString(str_id_1, *(m_menu_win_str_buf[1]));

  m_menu_win_sys = GFL_NEW_LOW( m_heap_memory ) app::tool::MenuWindowSystem(
    m_heap_memory,
    m_device_memory,
    device_manager,
    graphics_system,
    m_lyt_sys,
    gamesystem::FRAMEMODE_30,
    &m_lyt_wk_setup,
    app::tool::MenuWindowSystem::INPUT_TYPE_RELEASE,
    app::tool::MenuWindowSystem::DESIGN_APP,
    app::tool::MenuWindowSystem::NOTIFY_AFTER_ANIME
  );
  app::tool::MenuWindow::MenuParameter menu_win_param =
  {
    gfl::grp::DISPLAY_UPPER,
    app::tool::MenuWindow::X_POSITION_TYPE_RIGHT,
    app::tool::MenuWindow::Y_POSITION_TYPE_BOTTOM,
    app::tool::YesNoMenu::DEFAULT_PX,
    app::tool::YesNoMenu::DEFAULT_PY,
    app::tool::MenuWindow::MIN_WINDOW_WIDTH,
    2,
    1,
    true
  };
  m_menu_win = GFL_NEW(m_heap_memory) app::tool::MenuWindow(
      m_heap_memory,
      menu_win_param
  );

  app::tool::MenuWindow::AlternativeParameter menu_win_alt_param[MENU_WIN_STRBUF_NUM] =
  {
    { 0, 0, 0, false, false },
    { 1, 0, 1, false, false },
  };
  m_menu_win->AddAlternative(
    menu_win_alt_param[0],
    m_menu_win_str_buf[0]  // @todo Addbuf폜ł炵{H
  );
  m_menu_win->AddAlternative(
    menu_win_alt_param[1],
    m_menu_win_str_buf[1]  // @todo Addbuf폜ł炵{H
  );

  m_menu_win_sys->SetMenuWindow(m_menu_win);
  m_menu_win_sys->Start();
  m_menu_win_sys->SetAutoDrawFlag(false);
}

void KanaKanji2d::destroyMenuWindow(void)
{
  if( m_menu_win_sys )
  {
    GFL_DELETE m_menu_win_sys;
    m_menu_win_sys = NULL;
  }
  if( m_menu_win )
  {
    GFL_DELETE m_menu_win;
    m_menu_win = NULL;
    //m_menu_win_result;  // StartMenuWinŏB܂ł͍Ō̌ʂێ悤ɂĂB
  }
  for(s32 i=0; i<MENU_WIN_STRBUF_NUM; ++i)
  {
    if( m_menu_win_str_buf[i] )
    {
      GFL_DELETE m_menu_win_str_buf[i];
      m_menu_win_str_buf[i] = NULL;
    }
  }
  
  constructorMenuWindow();
}


} // namespace intro
} // namespace app

