//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file   IntroMain.cpp
 *  @brief  Cg
 *  @author Koji Kawada
 *  @date   2012.08.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


// gflib
#include <gflib.h>

// kujira
#include "gamesystem/GameProc.h"
#include "print/system_font.h"
#include "dll/DllProc.h"
#include "print/WordSet.h"
#include "app/tool/app_tool_YesNoMenu.h"
#include "app/strinput/strinput.h"
#include "app/util/app_util_heap.h"
#include "app/util/app_util_Common.h"

// intro
//#include "Intro2d.h"
#include "Intro3d.h"
#include "IntroMain.h"

// arc
#include "arc/arc_def.h"            // ARCID_ 
#include "arc/message.gaix"
#include "arc/intro.gaix"

// message
#include "message/msg_intro.h"


namespace app {
namespace intro {


//-----------------------------------------------------------------------------
/**
 *          NX
 */
//-----------------------------------------------------------------------------

//-------------------------------------
/// CgMain
//=====================================
IntroMain::IntroMain(
  app::util::Heap*         util_heap,
  gfl::heap::HeapBase*     heap_memory,
  gfl::heap::HeapBase*     device_memory,
  gfl::heap::NwAllocator*  heap_allocator,
  gfl::heap::NwAllocator*  device_allocator,
  gamesystem::GameManager* game_manager
)
  : BaseMain(
      util_heap,
      heap_memory,
      device_memory,
      heap_allocator,
      device_allocator,
      game_manager
    )
{
  gfl::grp::GraphicsSystem* graphics_system = m_game_manager->GetGraphicsSystem();

  graphics_system->InitializeApplicationMemory( m_device_allocator );  // YVRAMAȂƂG[ɂȂ̂ŒӁIII

  /*
  m_2d = GFL_NEW(m_heap_memory) Intro2d(
    util_heap,
    heap_memory,
    device_memory,
    heap_allocator,
    device_allocator,
    m_game_manager
  );
  */
  m_3d = GFL_NEW(m_heap_memory) Intro3d(
    util_heap,
    heap_memory,
    device_memory,
    heap_allocator,
    device_allocator,
    m_game_manager
  );

  m_phase = PHASE_START;
  m_step = 0;
  m_enable_draw = false;
}

IntroMain::~IntroMain()
{
  gfl::grp::GraphicsSystem* graphics_system = m_game_manager->GetGraphicsSystem();
  
  GFL_DELETE m_3d;
  m_3d = NULL;
  /*
  GFL_DELETE m_2d;
  m_2d = NULL;
  */

  m_phase = PHASE_END;
  m_step = 0;
  m_enable_draw = false;
  
  graphics_system->FinalizeApplicationMemory();
}

b32 IntroMain::Update(gfl::proc::Manager * /*proc_manager*/)
{
  u32 confirm_str_id = 0;

  b32 onemore = false;
  do
  {
    onemore = false;
    switch(m_phase)
    {
    case PHASE_START:
      {
        //m_2d->Create();
        changePhase(PHASE_CREATE);
        onemore = true;
        break;
      }
    case PHASE_CREATE:
      {
        if( m_3d->IsAbleToPlay() )
        {
          m_enable_draw = true;
          xy_snd::StartBGM(STRM_BGM_STARTING2, 0);
          changePhase(PHASE_FADE_IN);
          onemore = true;
        }
        break;
      }
    case PHASE_FADE_IN:
      {
        onemore = exeFade(true, PHASE_BUTTON);
        break;
      }
    case PHASE_BUTTON:
      {
        gfl::ui::DeviceManager* device_manager = m_game_manager->GetUiDeviceManager();
        gfl::ui::Button*       button      = device_manager->GetButton( gfl::ui::CTR_DeviceManager::BUTTON_STANDARD );
        if( 
               button->IsRelease( gfl::ui::BUTTON_X )  // @todo `邩H
        )
        {
          changePhase(PHASE_FADE_OUT);
          onemore = true;
        }
        break;
      }
    case PHASE_FADE_OUT:
      {
        if( m_step == 0 ) xy_snd::StopBGM(FADE_SYNC);
        onemore = exeFade(false, PHASE_WAIT);
        break;
      }
    case PHASE_WAIT:
      {
        if( !xy_snd::IsBGMFade() )
        {
          changePhase(PHASE_END);
          onemore = true;
        }
        else
        {
          onemore = false;
        }
        break;
      }
    case PHASE_DISABLE_DRAW:
      {
        m_enable_draw = false;
        onemore = false;
        break;
      }
    case PHASE_END:
      {
        //m_2d->Destroy();
        onemore = false;
        break;
      }
    }
  }
  while(onemore);

  //m_2d->Update();
  m_3d->Update();
  
  if( m_phase == PHASE_END ) return false;
  return true;
}

void IntroMain::Draw(void)
{
  if( m_enable_draw )
  {
    //m_2d->Draw();
    m_3d->Draw();
  }
}

void IntroMain::changePhase(s32 next_phase)
{
  m_phase = next_phase;
  m_step = 0;
}

b32 IntroMain::exeFade(b32 is_fade_in, s32 next_phase)
{
  b32 onemore = false;
  switch(m_step)
  {
  case 0:
    if( is_fade_in )
    {
      gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_DOUBLE, FADE_SYNC );
    }
    else
    {
      gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_DOUBLE, gfl::grp::Fade::OUTTYPE_BLACK, FADE_SYNC );
    }
    ++m_step;
    //breakȂ
  case 1:
    if( gfl::grp::Fade_IsEnd() )
    {
      changePhase(next_phase);
      onemore = true;
    }
    else
    {
      onemore = false;
    }
    break;
  }
  return onemore;
}


} // namespace intro
} // namespace app

