//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file   Intro3d.cpp
 *  @brief  Cg
 *  @author Koji Kawada
 *  @date   2012.08.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


// gflib
#include <gflib.h>

// kujira
#include "gamesystem/GameProc.h"
#include "print/system_font.h"
#include "dll/DllProc.h"
#include "print/WordSet.h"
#include "app/tool/app_tool_YesNoMenu.h"
#include "app/strinput/strinput.h"
#include "app/util/app_util_heap.h"
#include "app/util/app_util_Common.h"
#include "trainer/TrModelManager.h"  // ogpg[i[fgpꍇ͂̃t@C#includeOKłB

// intro
#include "BaseModel.h"
#include "IntroBg.h"
#include "IntroPortrait.h"
#include "IntroBall.h"

#include "SeqCube.h"

#include "Intro3d.h"

// arc
#include "arc/arc_def.h"            // ARCID_ 
#include "arc/intro.gaix"


namespace app {
namespace intro {


//-----------------------------------------------------------------------------
/**
 *          NX
 */
//-----------------------------------------------------------------------------

//-------------------------------------
/// Cg3D
//=====================================
Intro3d::Intro3d(
  app::util::Heap*         util_heap,
  gfl::heap::HeapBase*     heap_memory,
  gfl::heap::HeapBase*     device_memory,
  gfl::heap::NwAllocator*  heap_allocator,
  gfl::heap::NwAllocator*  device_allocator,
  gamesystem::GameManager* game_manager    
)
  : m_util_heap(util_heap),
    m_heap_memory(heap_memory),
    m_device_memory(device_memory),
    m_heap_allocator(heap_allocator),
    m_device_allocator(device_allocator),
    m_game_manager(game_manager),
    m_state(STATE_NONE),
    m_g3d_util(NULL),
    m_light_num(0),
    m_light(NULL),
    m_light_set(NULL),
    m_camera(NULL),
    m_camera_anim(NULL),
    m_locator(NULL),
    m_seq_cube(NULL),
    m_bg(NULL),
    m_mirror(NULL),
    m_portrait(NULL),
    m_fx(NULL),
    m_ball(NULL),
    m_hakase(NULL),
    m_pokemon(NULL),
    m_tr_model_manager(NULL)
{
  // RXgN^qŏłȂ
  {
    for(s32 i=0; i<RES_MAX; ++i)
    {
      m_res_buffer[i] = NULL;
      m_res_buffer_size[i] = 0;
      m_res[i] = NULL;
    }
    for(s32 i=0; i<INTRO_TR_MODEL_MAX; ++i)
    {
      m_tr_model_finish[i] = false;
      m_tr_model[i] = NULL;
    }
  }
  
  createScene();
  startCreateRes();

  startCreateSeqCube();
  startCreateBg();
  startCreateMirror();
  startCreatePortrait();
  startCreateFx();
  startCreateBall();
  startCreateHakase();
  startCreatePokemon();
  startCreateTrModel();
 
  m_state = STATE_CREATING;
}

Intro3d::~Intro3d()
{ 
  GFL_ASSERT(m_state == STATE_PLAYING);

  GFL_SAFE_DELETE(m_pokemon);
  GFL_SAFE_DELETE(m_hakase);
  GFL_SAFE_DELETE(m_ball);
  GFL_SAFE_DELETE(m_fx);
  GFL_SAFE_DELETE(m_portrait);
  GFL_SAFE_DELETE(m_mirror);
  GFL_SAFE_DELETE(m_bg);
  GFL_SAFE_DELETE(m_seq_cube);
 
  destroyTrModel();
  destroyLocator(); 
  destroyCamera(); 
  destroyLight();
  destroyRes();
  destroyScene();

  m_state = STATE_NONE;  
}

void Intro3d::Update(void)
{
  m_seq_cube->Update();
  m_bg->Update();
  m_mirror->Update();
  m_portrait->Update();
  m_fx->Update();
  m_ball->Update();
  m_hakase->Update();
  m_pokemon->Update();
  updateTrModel();

  switch(m_state)
  {
  case STATE_NONE:
    {
      // Ȃ
      break;
    }
  case STATE_CREATING:
    {
      updateCreating();
      break;
    }
  case STATE_PLAYING:
    {
      break;
    }
  //case STATE_DESTROYING:
  //  {
  //    break;
  //  }
  }

  if( this->IsAbleToPlay() )
  {
    calcScene();
  }
  else
  {
    // @todo ̕򂪂܂ȂBƂ܂B`ƈēǂݍ݃[v܂킳ȂȂȂ̂ł͖t[KvB
    // g[i[f O
    m_tr_model_manager->CalculateBefore();
    // g[i[f 
    m_tr_model_manager->CalculateAfter();  // [V𔽉fɂbeforeScene::CalculateafterScene::SubmitViewƂԂłȂ΂ȂȂB
  }
}

void Intro3d::Draw(void)
{
  if( this->IsAbleToPlay() ) drawScene();
}

void Intro3d::updateCreating(void)
{
  gfl::fs::FileReadManager* file_read_manager = m_game_manager->GetFileReadManager();
 
  b32 is_able_to_play = true;

  // FileReadManager
  {
    b32 finish = true;
    for(s32 i=0; i<RES_MAX; ++i)
    {
      if( !m_res[i] )
      {
        if( file_read_manager->IsReadFinished(&m_res_buffer[i]) )
        {
          m_res[i] = GFL_NEW(m_heap_memory) gfl::grp::g3d::Resource;
          m_res[i]->AttachBuffer(m_device_allocator, m_res_buffer[i]);
          m_res[i]->Setup(m_device_allocator, NULL, gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT);
          switch(i)
          {
          case RES_LIGHT: createLight(); break;
          case RES_CAMERA: createCamera(); break;
          case RES_LOCATOR: createLocator(); break;
          }
        }
        else
        {
          finish = false;
        }
      }
    }
    if(!finish)
    {
      is_able_to_play = false;
    }
  }

  if( !(m_seq_cube->IsAbleToPlay()) ) is_able_to_play = false;
  if( !(m_bg->IsAbleToPlay()) ) is_able_to_play = false;
  if( !(m_mirror->IsAbleToPlay()) ) is_able_to_play = false;
  if( !(m_portrait->IsAbleToPlay()) ) is_able_to_play = false;
  if( !(m_fx->IsAbleToPlay()) ) is_able_to_play = false;
  if( !(m_ball->IsAbleToPlay()) ) is_able_to_play = false;
  if( !(m_hakase->IsAbleToPlay()) ) is_able_to_play = false;
  if( !(m_pokemon->IsAbleToPlay()) ) is_able_to_play = false;
  for(s32 i=0; i<INTRO_TR_MODEL_MAX; ++i)
  {
    if( !(m_tr_model_finish[i]) ) is_able_to_play = false;
  }

  if( is_able_to_play )
  {
    m_state = STATE_PLAYING;
  }
}

void Intro3d::createScene(void)
{
  gfl::grp::GraphicsSystem* graphics_system = m_game_manager->GetGraphicsSystem();

  // G3DUtil
  {
    m_g3d_util = GFL_NEW(m_heap_memory) app::util::G3DUtil;
    
    gfl::grp::g3d::System::Description system_desc;
    system_desc.resource_object_num_max = 1024;
    system_desc.res_anim_object_num_max = 1024;
    m_g3d_util->CreateG3dSystem(m_util_heap, &system_desc);

    app::util::G3DUtil::SCENE_CREATE_DATA scene_data;
    scene_data.user_calc_group_num = USER_CALC_GROUP_NUM;
    scene_data.user_draw_group_num = USER_DRAW_GROUP_NUM;
    m_g3d_util->CreateG3dScene( app::util::G3DUtil::ENVIRONMENT_RES_NONE, 0, m_util_heap, false, &scene_data );

    m_g3d_util->CreateEdgeSystem( graphics_system, app::util::G3DUtil::EDGE_SET_FLAG_UPPER, m_util_heap );
  }

  m_scene = m_g3d_util->GetScene();
}
void Intro3d::destroyScene(void)
{
  // G3DUtil
  {
    m_g3d_util->DeleteEdgeSystem();
    m_g3d_util->DeleteG3dScene();
    m_g3d_util->DeleteG3dSystem();
    GFL_DELETE m_g3d_util;
    m_g3d_util = NULL;
  }

  m_scene = NULL;
}

void Intro3d::calcScene(void)
{
  // G3DUtil
  if( m_g3d_util )
  {
    // g[i[f O
    m_tr_model_manager->CalculateBefore();

    // SCALC_GROUPCalculates
    m_g3d_util->CalculateG3dScene();  // Scene::Calculate

    // g[i[f 
    m_tr_model_manager->CalculateAfter();  // [V𔽉fɂbeforeScene::CalculateafterScene::SubmitViewƂԂłȂ΂ȂȂB

    // m_g3d_utilSetCameraĂJ̃J}gbNXXVA
    // m_g3d_utilSetCameraĂJDRAW_GROUP_MAINSubmitViews
    m_g3d_util->Update3D( false );  // Scene::SubmitView
 
    // DRAW_GROUP_MAINȊOSubmitViews
    //m_scene->SubmitView();Ȃ炱
  }
}

void Intro3d::drawScene(void)
{
  gfl::grp::GraphicsSystem* graphics_system = m_game_manager->GetGraphicsSystem();
 
  // G3DUtil
  if( m_g3d_util )
  {
    // m_g3d_utilSetCameraĂJDRAW_GROUP_MAINDraws
    m_g3d_util->Draw3D( graphics_system );
    
    // DRAW_GROUP_MAINȊODraws
    //m_scene->Draw();Ȃ炱
  }
}

void Intro3d::startCreateRes(void)
{
  gfl::fs::FileReadManager* file_read_manager = m_game_manager->GetFileReadManager();
  
  // FileReadManager
  {
    file_read_manager->AppendManageFile(
        m_heap_memory,
        ARCID_INTRO,
        false
    );
    
    gfl::fs::FileReadManager::ReadRequest req;
    req.arcID = ARCID_INTRO;
    req.heapForWork = m_heap_memory->GetLowerHandle();
    req.heapForUncomp = NULL;
    req.heapForBuffer = m_device_memory;
    req.destBufferAlignment = 128;

    static const gfl::fs::ArcFile::ARCID RES_ARCID[RES_MAX] =
    {
      GARC_intro_intro_lights_BCLGT,
      GARC_intro_intro_camera_BCCAM,
      GARC_intro_intro_locators_BCMDL,
    };

    for(s32 i=0; i<RES_MAX; ++i)
    {
      req.datID           = RES_ARCID[i];
      req.ppDestBuffer    = &(m_res_buffer[i]);
      req.pDestBufferSize = &(m_res_buffer_size[i]);

      file_read_manager->AddReadRequest(req);
    }
  }
}
void Intro3d::destroyRes(void)
{
  gfl::fs::FileReadManager* file_read_manager = m_game_manager->GetFileReadManager();
  
  for(s32 i=0; i<RES_MAX; ++i)
  {
    GFL_DELETE m_res[i];
    m_res[i] = NULL;
    GflHeapFreeMemory(m_res_buffer[i]);
    m_res_buffer[i] = NULL;
    m_res_buffer_size[i] = 0;
  }
  
  // FileReadManager
  {
    file_read_manager->RemoveManageFile(ARCID_INTRO);
  }
}

void Intro3d::startCreateSeqCube(void)
{
  gfl::fs::FileReadManager* file_read_manager = m_game_manager->GetFileReadManager();

  m_seq_cube = GFL_NEW(m_heap_memory) SeqCube(
      m_heap_memory,
      m_device_memory,
      m_heap_allocator,
      m_device_allocator,
      file_read_manager
  );
}

void Intro3d::startCreateBg(void)
{
  gfl::fs::FileReadManager* file_read_manager = m_game_manager->GetFileReadManager();

  BaseModel::ArcInfo info;
  {
    info.arcid = ARCID_INTRO;
    info.arcdatid[BaseModel::DATA_MDL]  = GARC_intro_BG_top_BCMDL;
    info.arcdatid[BaseModel::DATA_PACK_SKLA] = GARC_intro_intro_bg_skla_pack;
    info.arcdatid[BaseModel::DATA_PACK_MATA] = GARC_intro_intro_bg_mata_pack;
    info.arcdatid[BaseModel::DATA_PACK_MDLA] = GARC_intro_intro_bg_mdla_pack;
    //info.arcdatid[BaseModel::DATA_PACK_SHDR] = GARC_intro_intro_bg_shdr_pack;
  }
  m_bg = GFL_NEW(m_heap_memory) IntroBg(
      m_heap_memory,
      m_device_memory,
      m_heap_allocator,
      m_device_allocator,
      file_read_manager,
      m_scene,
      CALC_GROUP_MAIN,
      DRAW_GROUP_MAIN,
      info
  );
}
void Intro3d::startCreateMirror(void)
{
  gfl::fs::FileReadManager* file_read_manager = m_game_manager->GetFileReadManager();

  BaseModel::ArcInfo info;
  {
    info.arcid = ARCID_INTRO;
    info.arcdatid[BaseModel::DATA_MDL]  = GARC_intro_intro_mirrors_BCMDL;
    info.arcdatid[BaseModel::DATA_PACK_SKLA] = GARC_intro_intro_mirrors_skla_pack;
    info.arcdatid[BaseModel::DATA_PACK_MATA] = GARC_intro_intro_mirrors_mata_pack;
    //info.arcdatid[BaseModel::DATA_PACK_MDLA] = GARC_intro_intro_mirrors_mdla_pack;  // uAj[V̊֘AtɎs܂BvG[ɂȂB
    //info.arcdatid[BaseModel::DATA_PACK_SHDR] = GARC_intro_intro_mirrors_shdr_pack;
  }
  m_mirror = GFL_NEW(m_heap_memory) BaseModel(
      m_heap_memory,
      m_device_memory,
      m_heap_allocator,
      m_device_allocator,
      file_read_manager,
      m_scene,
      CALC_GROUP_MAIN,
      DRAW_GROUP_MAIN,
      info
  );
}
void Intro3d::startCreatePortrait(void)
{
  gfl::fs::FileReadManager* file_read_manager = m_game_manager->GetFileReadManager();

  BaseModel::ArcInfo info;
  {
    info.arcid = ARCID_INTRO;
    info.arcdatid[BaseModel::DATA_MDL]  = GARC_intro_intro_portraits_BCMDL;
    info.arcdatid[BaseModel::DATA_PACK_SKLA] = GARC_intro_intro_portraits_skla_pack;
    info.arcdatid[BaseModel::DATA_PACK_MATA] = GARC_intro_intro_portraits_mata_pack;
    //info.arcdatid[BaseModel::DATA_PACK_MDLA] = GARC_intro_intro_portraits_mdla_pack;  // uAj[V̊֘AtɎs܂BvG[ɂȂB
    //info.arcdatid[BaseModel::DATA_PACK_SHDR] = GARC_intro_intro_portraits_shdr_pack;
  }
  m_portrait = GFL_NEW(m_heap_memory) IntroPortrait(
      m_heap_memory,
      m_device_memory,
      m_heap_allocator,
      m_device_allocator,
      file_read_manager,
      m_scene,
      CALC_GROUP_MAIN,
      DRAW_GROUP_MAIN,
      info
  );
}
void Intro3d::startCreateFx(void)
{
  gfl::fs::FileReadManager* file_read_manager = m_game_manager->GetFileReadManager();

  BaseModel::ArcInfo info;
  {
    info.arcid = ARCID_INTRO;
    info.arcdatid[BaseModel::DATA_MDL]  = GARC_intro_FX_top_BCMDL;
    info.arcdatid[BaseModel::DATA_PACK_SKLA] = GARC_intro_intro_fx_skla_pack;
    info.arcdatid[BaseModel::DATA_PACK_MATA] = GARC_intro_intro_fx_mata_pack;
    info.arcdatid[BaseModel::DATA_PACK_MDLA] = GARC_intro_intro_fx_mdla_pack;
    //info.arcdatid[BaseModel::DATA_PACK_SHDR] = GARC_intro_intro_fx_shdr_pack;
  }
  m_fx = GFL_NEW(m_heap_memory) BaseModel(
      m_heap_memory,
      m_device_memory,
      m_heap_allocator,
      m_device_allocator,
      file_read_manager,
      m_scene,
      CALC_GROUP_MAIN,
      DRAW_GROUP_MAIN,
      info
  );
}
void Intro3d::startCreateBall(void)
{
  gfl::fs::FileReadManager* file_read_manager = m_game_manager->GetFileReadManager();

  BaseModel::ArcInfo info;
  {
    info.arcid = ARCID_INTRO;
    info.arcdatid[BaseModel::DATA_MDL]  = GARC_intro_intro_ball_BCMDL;
    info.arcdatid[BaseModel::DATA_PACK_SKLA] = GARC_intro_intro_ball_skla_pack;
    info.arcdatid[BaseModel::DATA_PACK_MATA] = GARC_intro_intro_ball_mata_pack;
    //info.arcdatid[BaseModel::DATA_PACK_MDLA] = GARC_intro_intro_ball_mdla_pack;  // uAj[V̊֘AtɎs܂BvG[ɂȂB
    //info.arcdatid[BaseModel::DATA_PACK_SHDR] = GARC_intro_intro_ball_shdr_pack;
  }
  m_ball = GFL_NEW(m_heap_memory) IntroBall(
      m_heap_memory,
      m_device_memory,
      m_heap_allocator,
      m_device_allocator,
      file_read_manager,
      m_scene,
      CALC_GROUP_MAIN,
      DRAW_GROUP_MAIN,
      info
  );
}
void Intro3d::startCreateHakase(void)
{
  gfl::fs::FileReadManager* file_read_manager = m_game_manager->GetFileReadManager();

  BaseModel::ArcInfo info;
  {
    info.arcid = ARCID_INTRO;
    info.arcdatid[BaseModel::DATA_MDL]  = GARC_intro_intro_hakase_BCMDL;
    info.arcdatid[BaseModel::DATA_PACK_SKLA] = GARC_intro_intro_hakase_skla_pack;
    info.arcdatid[BaseModel::DATA_PACK_MATA] = GARC_intro_intro_hakase_mata_pack;
    //info.arcdatid[BaseModel::DATA_PACK_MDLA] = GARC_intro_intro_hakase_mdla_pack;  // uAj[V̊֘AtɎs܂BvG[ɂȂB
    //info.arcdatid[BaseModel::DATA_PACK_SHDR] = GARC_intro_intro_hakase_shdr_pack;
  }
  m_hakase = GFL_NEW(m_heap_memory) BaseModel(
      m_heap_memory,
      m_device_memory,
      m_heap_allocator,
      m_device_allocator,
      file_read_manager,
      m_scene,
      CALC_GROUP_MAIN,
      DRAW_GROUP_MAIN,
      info
  );
}
void Intro3d::startCreatePokemon(void)
{
  gfl::fs::FileReadManager* file_read_manager = m_game_manager->GetFileReadManager();

  BaseModel::ArcInfo info;
  {
    info.arcid = ARCID_INTRO;
    info.arcdatid[BaseModel::DATA_MDL]  = GARC_intro_intro_pokemon_BCMDL;
    info.arcdatid[BaseModel::DATA_PACK_SKLA] = GARC_intro_intro_pokemon_skla_pack;
    info.arcdatid[BaseModel::DATA_PACK_MATA] = GARC_intro_intro_pokemon_mata_pack;
    info.arcdatid[BaseModel::DATA_PACK_MDLA] = GARC_intro_intro_pokemon_mdla_pack;
    //info.arcdatid[BaseModel::DATA_PACK_SHDR] = GARC_intro_intro_pokemon_shdr_pack;
  }
  m_pokemon = GFL_NEW(m_heap_memory) BaseModel(
      m_heap_memory,
      m_device_memory,
      m_heap_allocator,
      m_device_allocator,
      file_read_manager,
      m_scene,
      CALC_GROUP_MAIN,
      DRAW_GROUP_MAIN,
      info
  );
}

void Intro3d::startCreateTrModel(void)
{
  gfl::fs::FileReadManager* file_read_manager = m_game_manager->GetFileReadManager();

  // ւf
  xy_system::dress_up::DressUpManagerCreate(
      m_heap_memory,
      m_heap_memory,
      m_device_memory
  );

  // g[i[f
  trainer::TrModelManager::Param param;
  param.is_pokemon_shader_create = true;
  param.pokemon_shader_heap_memory_temp = m_heap_memory->GetLowerHandle();
  param.pokemon_shader_heap_allocator   = m_heap_allocator;
  param.pokemon_shader_device_allocator = m_device_allocator;
  m_tr_model_manager = GFL_NEW(m_heap_memory) trainer::TrModelManager(
    m_heap_memory,
    file_read_manager,
    &param
  );

  xy_system::dress_up::HeroineFashion heroine_fashion = xy_system::dress_up::GetHeroineFashionDefault();
  xy_system::dress_up::HeroFashion    hero_fashion    = xy_system::dress_up::GetHeroFashionDefault();
    
  xy_system::dress_up::Individual individual;
  individual.section_type = xy_system::dress_up::SECTION_TYPE_BATTLE;
  individual.fashion = &heroine_fashion;
  
  trainer::TrModel::Description desc =
  {
    TR_BT_GRA_0001,
    trainer::TrModel::MODEL_TYPE_BTL_DRESS,
    trainer::TrModel::MOTION_TYPE_OTHER,
    &individual
  };

  desc.id = TR_BT_GRA_0001;
  individual.model_type = xy_system::dress_up::MODEL_TYPE_HEROINE;
  individual.fashion = &heroine_fashion;
  m_tr_model[INTRO_TR_MODEL_HEROINE] = m_tr_model_manager->RequestCreateModel(
      m_heap_allocator,
      m_device_allocator,
      desc
  );
  
  desc.id = TR_BT_GRA_0002;
  individual.model_type = xy_system::dress_up::MODEL_TYPE_HERO;
  individual.fashion = &hero_fashion;
  m_tr_model[INTRO_TR_MODEL_HERO] = m_tr_model_manager->RequestCreateModel(
      m_heap_allocator,
      m_device_allocator,
      desc
  );
}
void Intro3d::destroyTrModel(void)
{
  // g[i[f
  for(s32 i=0; i<INTRO_TR_MODEL_MAX; ++i)
  {
    if( m_tr_model[i] )
    {
      GFL_ASSERT_MSG(m_tr_model_manager->IsAbleToDestroyModel(m_tr_model[i]), "g[i[f%dԂ폜ł܂B\n", i);
      m_tr_model_manager->DestroyModel(m_tr_model[i]);
      m_tr_model[i] = NULL;
      m_tr_model_finish[i] = false;
    }
  }

  GFL_ASSERT_MSG(m_tr_model_manager->IsAbleToDestroy(), "g[i[f}l[W폜ł܂B\n");
  GFL_DELETE m_tr_model_manager;
  m_tr_model_manager = NULL;

  // ւf
  xy_system::dress_up::DressUpManagerDestroy();
}

void Intro3d::updateTrModel(void)
{
  for(s32 i=0; i<INTRO_TR_MODEL_MAX; ++i)
  {
    if( !(m_tr_model_finish[i]) )
    {
      if( m_tr_model[i] )
      {
        if( m_tr_model_manager->IsModelCreated(m_tr_model[i]) )
        {
          m_tr_model[i]->AddModelToScene(
              m_scene,
              CALC_GROUP_MAIN,
              DRAW_GROUP_MAIN
          );
          //m_tr_model[i]->GetMotion()->SetSmoothFrameBefore(0);  // [VuhNȂ悤ɂĂB
                                                                // @todo OldMotionNumberقȂƃ[VuhĂ܂̎dl͂̂H
          m_tr_model[i]->ChangeMotion(TRMOT_OTHER_BA01_TOUJYOU01);  // [VuhNȂ悤2񓯂̂ݒ肷B
                                                                    // @todo ȗR2ݒ肵Ă̂H
          m_tr_model[i]->ChangeMotion(TRMOT_OTHER_BA01_TOUJYOU01);
          m_tr_model[i]->SetMotionLoop(true);
          m_tr_model_finish[i] = true;
        }
      }
    }
  }
}

void Intro3d::createLight(void)
{
  m_light_num = m_res[RES_LIGHT]->GetLightsCount();
  m_light = GFL_NEW_ARRAY(m_heap_memory) gfl::grp::g3d::Light*[m_light_num];
  for(s32 i=0; i<m_light_num; ++i)
  {
    m_light[i] = GFL_NEW(m_heap_memory) gfl::grp::g3d::Light;
    m_light[i]->Create(m_heap_allocator, m_device_allocator, m_res[RES_LIGHT], i);
    m_scene->AddNodeToCalc(m_light[i], CALC_GROUP_MAIN);
  }

  m_light_set = GFL_NEW(m_heap_memory) gfl::grp::g3d::LightSet;
  m_light_set->Create(m_device_allocator);
  for(s32 i=0; i<m_light_num; ++i)
  {
    m_light_set->AddLight(m_light[i]);
  }

  static const s32 LIGHT_SET_INDEX[LIGHT_SET_INDEX_NUM] =
  {
    LIGHT_SET_INDEX_MAIN,
    LIGHT_SET_INDEX_CHARA
  };
  for(s32 i=0; i<LIGHT_SET_INDEX_NUM; ++i)
  {
    m_scene->SetLightSet(i, m_light_set);
  }
}
void Intro3d::destroyLight(void)
{
  GFL_SAFE_DELETE(m_light_set);
  if( m_light )
  {
    for(s32 i=0; i<m_light_num; ++i)
    {
      GFL_SAFE_DELETE(m_light[i]);
    }
    GFL_SAFE_DELETE_ARRAY(m_light);
  }
}

void Intro3d::createCamera(void)
{
  gfl::grp::g3d::Camera::ResourceDescription camera_desc;
  camera_desc.animation_enable = true;
  camera_desc.animation_blend_unit_num = 1;
  camera_desc.animation_num_in_unit = 1;

  m_camera = GFL_NEW(m_heap_memory) gfl::grp::g3d::StereoCamera;
  m_camera->Create(
      m_heap_allocator,
      m_device_allocator,
      m_res[RES_CAMERA],
      0,
      &camera_desc
  );
  m_camera_anim = GFL_NEW(m_heap_memory) gfl::grp::g3d::ResAnim;
  m_res[RES_CAMERA]->GetResAnim(gfl::grp::g3d::Resource::ANIMATION_RESOURCE_TYPE_CAMERA, 0, m_camera_anim);

  m_camera->ChangeAnimation(
      m_device_allocator,
      m_camera_anim
  );

  m_scene->AddNodeToCalc(m_camera, CALC_GROUP_MAIN);
  m_scene->AssignCameraIndex(m_camera, CAMERA_INDEX_MAIN);

  m_g3d_util->SetCamera(app::util::G3DUtil::SETUP_CAMERA_UPPER, m_camera);
}
void Intro3d::destroyCamera(void)
{
  GFL_SAFE_DELETE(m_camera_anim);
  GFL_SAFE_DELETE(m_camera);
}

void Intro3d::createLocator(void)
{
  m_locator = GFL_NEW(m_heap_memory) gfl::grp::g3d::Model;
  m_locator->Create(
      m_heap_allocator,
      m_device_allocator,
      m_res[RES_LOCATOR],
      0
  );
}
void Intro3d::destroyLocator(void)
{
  GFL_SAFE_DELETE(m_locator);
}

} // namespace intro
} // namespace app

