//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file   BaseModel.cpp
 *  @brief  f̊NX
 *  @author Koji Kawada
 *  @date   2012.08.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


// gflib
#include <gflib.h>

// kujira
#include "gamesystem/GameProc.h"
#include "print/system_font.h"
#include "dll/DllProc.h"
#include "print/WordSet.h"
#include "app/tool/app_tool_YesNoMenu.h"
#include "app/strinput/strinput.h"
#include "app/util/app_util_heap.h"
#include "app/util/app_util_Common.h"

// intro
#include "BaseModel.h"

// arc
#include "arc/arc_def.h"            // ARCID_ 


namespace app {
namespace intro {


//-----------------------------------------------------------------------------
/**
 *          NX
 */
//-----------------------------------------------------------------------------

//-------------------------------------
/// wi
//=====================================
BaseModel::BaseModel(
  gfl::heap::HeapBase*      heap_memory,
  gfl::heap::HeapBase*      device_memory,
  gfl::heap::NwAllocator*   heap_allocator,
  gfl::heap::NwAllocator*   device_allocator,
  gfl::fs::FileReadManager* file_read_manager,
  gfl::grp::g3d::Scene*     scene,
  s32                       calc_group,
  s32                       draw_group,
  const ArcInfo&            arc_info
)
  : m_heap_memory(heap_memory),
    m_device_memory(device_memory),
    m_heap_allocator(heap_allocator),
    m_device_allocator(device_allocator),
    m_file_read_manager(file_read_manager),
    m_scene(scene),
    m_calc_group(calc_group),
    m_draw_group(draw_group),
    m_arc_info(arc_info),
    m_state(STATE_NONE),
    m_res_model(NULL),
    m_model(NULL),
    m_connector(NULL)
{
  // RXgN^qŏłȂ
  {
    for(s32 i=0; i<DATA_MAX; ++i)
    {
      m_data_buffer[i] = DataBuffer();
    }
    for(s32 i=0; i<ANIM_MAX; ++i)
    {
      m_pack_anim[i] = NULL;
    }
  }

  // FileReadManager
  {
    gfl::fs::FileReadManager::ReadRequest req;
    req.arcID = m_arc_info.arcid;  //   ARCID_???g悤ɂĂĉB
    req.heapForWork = m_heap_memory->GetLowerHandle();
    req.heapForUncomp = NULL;
    req.heapForBuffer = m_device_memory;
    req.destBufferAlignment = 128;

    for(s32 i=0; i<DATA_MAX; ++i)
    {
      if( m_arc_info.arcdatid[i] != gfl::fs::ArcFile::ARCID_NULL )
      {
        req.datID           = m_arc_info.arcdatid[i];
        req.ppDestBuffer    = &(m_data_buffer[i].buffer);
        req.pDestBufferSize = &(m_data_buffer[i].size);
   
        m_file_read_manager->AddReadRequest(req);
      }
      else
      {
        GFL_ASSERT_MSG( i != DATA_MDL, "f͕KvB\n" );
      }
    }
  }

  m_state = STATE_CREATING;
}

BaseModel::~BaseModel(void)
{
  GFL_ASSERT(m_state == STATE_PLAYING);

  GFL_SAFE_DELETE(m_connector);

  GFL_SAFE_DELETE(m_model);
  GFL_SAFE_DELETE(m_res_model);

  for(s32 i=0; i<ANIM_MAX; ++i)
  {
    GFL_SAFE_DELETE(m_pack_anim[i]);
  }

  for(s32 i=0; i<DATA_MAX; ++i)
  {
    if( m_arc_info.arcdatid[i] != gfl::fs::ArcFile::ARCID_NULL )
    {
      if( m_data_buffer[i].buffer )
      {
        GflHeapFreeMemory(m_data_buffer[i].buffer);
      }
      m_data_buffer[i] = DataBuffer();
    }
  }
  
  m_state = STATE_NONE;

  {
    m_heap_memory       = NULL;
    m_device_memory     = NULL;
    m_heap_allocator    = NULL;
    m_device_allocator  = NULL;
    m_file_read_manager = NULL;
    m_scene             = NULL;
    m_calc_group        = gfl::grp::g3d::SCENE_CALCULATE_GROUP_INDEX_NONE;
    m_draw_group        = gfl::grp::g3d::SCENE_DRAW_GROUP_INDEX_NONE;
    m_arc_info          = ArcInfo();
  }
}

void BaseModel::Update(void)
{
  switch(m_state)
  {
  case STATE_CREATING:
    {
      // FileReadManager
      {
        b32 finish = true;
        for(s32 i=0; i<DATA_MAX; ++i)
        {
          if( m_arc_info.arcdatid[i] != gfl::fs::ArcFile::ARCID_NULL )
          {
            if( !(m_data_buffer[i].finish) )
            {
              if( m_file_read_manager->IsReadFinished(&(m_data_buffer[i].buffer)) )
              {
                switch(i)
                {
                case DATA_MDL:
                  {
                    // f
                    m_res_model = GFL_NEW(m_heap_memory) gfl::grp::g3d::Resource;
                    m_res_model->AttachBuffer(m_device_allocator, m_data_buffer[i].buffer);
                    m_res_model->Setup(m_device_allocator, NULL, gfl::grp::g3d::Resource::COMMON_RESOURCE_DEFAULT_SHADER_BIT);
                   
                    gfl::grp::g3d::Model::Description model_desc;
                    model_desc.animation_slot_num = ANIM_MAX;
                    model_desc.animation_blend_unit_num = 1;
                    model_desc.animation_num_in_unit = 1;
                    m_model = GFL_NEW(m_heap_memory) gfl::grp::g3d::Model;
                    m_model->Create(m_heap_allocator, m_device_allocator, m_res_model, 0, &model_desc);
                    break;
                  }
                case DATA_PACK_SKLA:
                case DATA_PACK_MATA:
                case DATA_PACK_MDLA:
                //case DATA_PACK_SHDR:
                  {
                    // Aj[V
                    const gfl::grp::g3d::AnimationType TYPE[ANIM_MAX] =
                    {
                      gfl::grp::g3d::ANIMATION_TYPE_SKELETAL,
                      gfl::grp::g3d::ANIMATION_TYPE_MATERIAL,
                      gfl::grp::g3d::ANIMATION_TYPE_VISIBILITY,
                      //gfl::grp::g3d::ANIMATION_TYPE_NONE  // DATA_PACK_SHDR
                    };
                    s32 j = i - DATA_PACK_ANIM_START;  // DATA_???̔ԍANIM_???̔ԍɕϊ
                    m_pack_anim[j] = GFL_NEW(m_heap_memory) gfl::grp::g3d::PackAnim;
                    m_pack_anim[j]->Create(m_heap_allocator, m_device_allocator, TYPE[j], m_data_buffer[i].buffer);
                    break;
                  }
                }
                m_data_buffer[i].finish = true;
              }
              else
              {
                finish = false;
              }
            }
          }
        }

        if(finish)
        {
          // Aj[V
          m_connector = GFL_NEW(m_heap_memory) gfl::grp::g3d::ModelMultiPackAnimConnector;
          m_connector->SetModel(m_model);
          for(s32 i=0; i<ANIM_MAX; ++i)
          {
            if( m_pack_anim[i] )
            {
              m_connector->SetPackAnim(m_heap_allocator, m_device_allocator, i, m_pack_anim[i]);
            }
          }
          m_connector->ChangeAnimNo(0);

          // V[֒ǉ
          addToScene(m_scene, m_calc_group, m_draw_group);
          
          m_state = STATE_PLAYING;
        }
      }
      break;
    }
  case STATE_PLAYING:
    {
      break;
    }
  }
}

b32 BaseModel::IsAbleToPlay(void) const
{
  return (m_state==STATE_PLAYING);
}

void BaseModel::addToScene(gfl::grp::g3d::Scene* scene, s32 calc_group, s32 draw_group)
{
  scene->AddNodeToCalcAndDraw(m_model, calc_group, draw_group);
}


} // namespace intro
} // namespace app

