//==============================================================================
/**
 * @file  tradelist_comm.h
 * @brief ʐMXgʁ@ʐM
 * @author  Akito Mori
 * @data  2012/08/18
 */
// =============================================================================

#if !defined( __TRADELIST_COMM_H__ )
#define __TRADELIST_COMM_H__

#include <gflib.h>
#include <gflnet.h>


GFL_NAMESPACE_BEGIN( netapp )
GFL_NAMESPACE_BEGIN( tradelist )

class CommSystem{

public:

  //-------------------------------------
  /// MR}h
  //=====================================
  typedef enum {
    COMM_COMMAND_NONE,             ///< MR}h
    COMM_COMMAND_POKE,             ///< |Pf[^
    COMM_COMMAND_CANCEL_POKE,      ///< ɂ炵|PLZ
    COMM_COMMAND_REQUEST_END,      ///< INGXg
    COMM_COMMAND_END_ANSWER,       ///< Iԓ
    COMM_COMMAND_REQUEST_EXCHANGE, ///< NGXg
    COMM_COMMAND_EXCHANGE_ANSWER,  ///< ԓ
    COMM_COMMAND_NOW_CURSOR_POS,   ///< ݂̃J[\ʒu

    COMM_COMMAND_MAX,
  } COMM_COMMAND_TRADE;

  enum{
    COMM_ANSWER_NONE = 0,
    COMM_ANSWER_YES,        ///< MԓF͂
    COMM_ANSWER_NO,         ///< MԓF
  };

  //-------------------------------------
  /// ^C~O`
  //=====================================
  typedef enum {
    TIMING_NEXT_DEMO = 100,   ///< I`
    TIMING_TRADE_END,         ///< ogJnO`
    TIMING_MAX,
  } ENUM_COMM_TIMING;



public:
  // RXgN^
  CommSystem( app::util::Heap *p_heap );
  // fXgN^
  virtual ~CommSystem( void );

public:

  //----------------------------------------------------------------------------
  /**
   * @brief  ł
   * @return trueŏI
   */
  //----------------------------------------------------------------------------
  bool IsInitialize( void );

  //----------------------------------------------------------------------------
  /**
   * @brief  XV
   * @return trueŎM
   */
  //----------------------------------------------------------------------------
  bool Update( void );

  //----------------------------------------------------------------------------
  /**
   * @brief  tOM
   * @param   flag    MtO
   * 
   * @return Mtrue
   */
  //----------------------------------------------------------------------------
  bool SendData( COMM_COMMAND_TRADE command, char *buf, int size );

  //----------------------------------------------------------------------------
  /**
   * @brief  ^C~OR}h
   * @param   timingUniqueNo  ԍ
   */
  //----------------------------------------------------------------------------
  void TimingStart( ENUM_COMM_TIMING timingUniqueNo );

  //----------------------------------------------------------------------------
  /**
   * @brief  ^C~OR}hmF
   * @param   timingUniqueNo  ԍ
   * 
   * @return  bool ture
   */
  //----------------------------------------------------------------------------
  bool IsTimingEnd( ENUM_COMM_TIMING timingUniqueNo );
  
private:
  //--------------------------------------------------------------------------
  /**
   * @brief   Mۂ̍XV
   * @param   netId       MNetId
   * @param   recv_packet MpPbg
   */
  //--------------------------------------------------------------------------
  void RecvUpdate( int netId, COMM_COMMAND_TRADE command, u8 *recvbuf  );

  static const int RECV_BUF_SIZE = 300;
  static const int CONNECT_NUM   = 2;
  
private:

  gflnet::p2p::NetGame* m_netHandle;  ///< ʐMnh

  pml::pokepara::PokemonParam *m_myPoke;      ///< ̃|Pf[^
  pml::pokepara::PokemonParam *m_otherPoke;   ///< ̃|Pf[^

  u8  m_recvPoke[CONNECT_NUM];        ///< |P𑗂ςH
  u8  m_endReq[CONNECT_NUM];          ///< INGXg𑗂H
  u8  m_endAnswer[CONNECT_NUM];       ///< ImFɓH
  u8  m_exchangeRequest[CONNECT_NUM]; ///< NGXg𑗂H
  u8  m_exchangeAnswer[CONNECT_NUM];  ///< mFɓH
  u32 m_nowScrollPos[CONNECT_NUM];    ///< ݂̃{bNX莝XN[ʒu
  u8  m_nowTray[CONNECT_NUM];         ///< ݃J[\gC
  u8  m_nowCursorPos[CONNECT_NUM];    ///< ݃J[\ꏊ
  u8  m_recvbuf[RECV_BUF_SIZE];       ///< Mobt@

  u8  m_sendbuf[RECV_BUF_SIZE];       ///< Mf[^obt@
  COMM_COMMAND_TRADE  m_sendcommand;                  ///< MR}h
  int m_sendsize;                     ///< MTCY
};

GFL_NAMESPACE_END( tradelist )
GFL_NAMESPACE_END( app )

#endif  /* __TRADELIST_COMM_H__ */

