//==============================================================================
/**
 * @file  tradelist_comm.cpp
 * @brief ʐMXgʁ@ʐM
 * @author  Akito Mori
 * @data  2012/08/18
 */
// =============================================================================

#include "tradelist_comm.h"


GFL_NAMESPACE_BEGIN( netapp )
GFL_NAMESPACE_BEGIN( tradelist )


//=============================================================================================
/**
 * @brief RXgN^
 *
 * @param   heap    
 */
//=============================================================================================
CommSystem::CommSystem( app::util::Heap *heap )
{
  // [N
  for(int i=0;i<CONNECT_NUM;i++){
    m_recvPoke[i] = 0;        ///< |P𑗂ςH
    m_endReq[i] = 0;          ///< INGXg𑗂H
    m_endAnswer[i] = 0;       ///< ImFɓH
    m_exchangeRequest[i] = 0; ///< NGXg𑗂H
    m_exchangeAnswer[i] = 0;  ///< mFɓH
    m_nowScrollPos[i] = 0;    ///< ݂̃{bNX莝XN[ʒu
    m_nowTray[i] = 0;         ///< ݃J[\gC
    m_nowCursorPos[i] = 0;    ///< ݃J[\ꏊ
  }
  memset( m_recvbuf, 0, sizeof(RECV_BUF_SIZE) );
  memset( m_sendbuf, 0, sizeof(RECV_BUF_SIZE) );
  m_sendcommand = COMM_COMMAND_NONE;

  m_myPoke    = GFL_NEW(heap->pHeap) pml::pokepara::PokemonParam(heap->pHeap);
  m_otherPoke = GFL_NEW(heap->pHeap) pml::pokepara::PokemonParam(heap->pHeap);

  // ʐMݒ
  gflnet::p2p::GameInitialize initialize;
  initialize.max          = CONNECT_NUM;            // ڑMAX  4ł̂?
  initialize.pHeapSystem  = heap->pHeap; // ʐMŎgq[v

  // NetGameNX쐬
  m_netHandle = GFL_NEW( heap->pHeap ) gflnet::p2p::NetGame( &initialize, NULL );
  m_netHandle->Initialize();

  GFL_PRINT("NetGame쐬\n");
}

//=============================================================================================
/**
 * @brief fXgN^
 *
 * @param   none    
 */
//=============================================================================================
CommSystem::~CommSystem( void )
{
  GFL_DELETE m_otherPoke;
  GFL_DELETE m_myPoke;
  
  m_netHandle->Finalize( );
  GFL_SAFE_DELETE( m_netHandle );
  
  GFL_PRINT("CommSystem::~CommSystem();\n");
}

//----------------------------------------------------------------------------
/**
 * @brief  łǂ
 * @return łtrue
 */
//----------------------------------------------------------------------------
bool CommSystem::IsInitialize( void )
{
  return m_netHandle->IsInitialize();
}
  
//----------------------------------------------------------------------------
/**
 * @brief  XV
 * @return trueŎM
 */
//----------------------------------------------------------------------------
bool CommSystem::Update( void )
{

  // ĂȂꍇ
  if( IsInitialize() == false )
  {
    return false;
  }

  // MNGXg瑗M
  if( m_sendcommand != COMM_COMMAND_NONE )
  {
    // MtOOFF
    if( m_netHandle->SendDataCommand( reinterpret_cast<char*>(m_sendbuf), m_sendsize, static_cast<u8>(m_sendcommand)) == true ){
      m_sendcommand = COMM_COMMAND_NONE;
    }
  }

  // f[^M
  for( int i=0; i<CONNECT_NUM; i++ )
  {
    int netId;
    COMM_COMMAND_TRADE  command;
    bool ret = m_netHandle->RecvDataCommand( &netId, (char*)m_recvbuf, RECV_BUF_SIZE , reinterpret_cast<u8*>(&command) );
    if( ret == true )
    {
      // M
      RecvUpdate( netId, command, m_recvbuf );
    }
  }

  return true;
}

//----------------------------------------------------------------------------
/**
 * @brief  tOM
 * @param   flag    MtO
 * @param   buf     Mdata
 * @param   size    Mdata
 * 
 * @return Mtrue
 */
//----------------------------------------------------------------------------
bool CommSystem::SendData( COMM_COMMAND_TRADE command, char *buf, int size )
{
  // Mf[^Zbg
  if(m_sendcommand!=COMM_COMMAND_NONE){
    return false;
  }
  m_sendcommand = command;
  m_sendsize    = size;
  memcpy( m_sendbuf, buf, size );
  
  GFL_PRINT("R}hMN %d :%d %d %d %d \n", command, buf[0], buf[1], buf[2], buf[3] );

  return true;
}


//----------------------------------------------------------------------------
/**
 * @brief  ^C~OR}h
 * @param   timingUniqueNo  ԍ
 */
//----------------------------------------------------------------------------
void CommSystem::TimingStart( ENUM_COMM_TIMING timingUniqueNo )
{
  m_netHandle->TimingStart( timingUniqueNo );
}

//----------------------------------------------------------------------------
/**
 * @brief  ^C~OR}hmF
 * @param   timingUniqueNo  ԍ
 * 
 * @return  bool ture
 */
//----------------------------------------------------------------------------
bool CommSystem::IsTimingEnd( ENUM_COMM_TIMING timingUniqueNo )
{
  return m_netHandle->IsTimingEnd( timingUniqueNo );
}

//--------------------------------------------------------------------------
/**
 * @brief   Mۂ̍XV
 * @param   netId       MNetId
 * @param   recv_packet MpPbg
 */
//--------------------------------------------------------------------------
void CommSystem::RecvUpdate( int netId, COMM_COMMAND_TRADE command, u8 *recvbuf )
{
  int myNetId = m_netHandle->GetNetID();

  GFL_PRINT("MIII\n");
  GFL_PRINT("netId [%d] command[%d]\n", netId, command );

  switch( command ){
  ///< ꏊNGXg     eEqM
  case COMM_COMMAND_POKE:
    break;
  case COMM_COMMAND_CANCEL_POKE:
    break;
  ///< INGXg
  case COMM_COMMAND_REQUEST_END:      
    break;
  ///< Iԓ
  case COMM_COMMAND_END_ANSWER:       
    break;
  ///< NGXg
  case COMM_COMMAND_REQUEST_EXCHANGE: 
    break;
  ///< ԓ
  case COMM_COMMAND_EXCHANGE_ANSWER:  
    break;
  case COMM_COMMAND_NOW_CURSOR_POS:
    break;
  default:
    GFL_ASSERT(0);
    break;
  }
}
  


GFL_NAMESPACE_END( tradelist )
GFL_NAMESPACE_END( app )
