//=============================================================================
/**
 *
 *  @file   ScriptFuncSetSound.cpp
 *  @brief  XNvg߃ZbgFW߃Zbg TEhn
 *  @author Miyuki Iwasawa 
 *  @data   2012.08.20
 *
 *  ScriptFuncSetCommon.cpp番Aincludeėp
 */
//=============================================================================

//-----------------------------------------------------------------------------
/**
 *  @brief  BGMĐ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::BGMTrainerEyeBGM(AMX * amx, const cell * ptr)
{
  u32 eye_bgm = ptr[1];
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();

  xy_snd::StartTrainerEyeBGM(eye_bgm);

  // VSEI
  p_gman->GetWeatherManager()->GetEffectManager()->StopSE();

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  SEĐ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::SEPlay(AMX * amx, const cell * ptr)
{
  u32 sound_item_id = ptr[1];
  xy_snd::PlaySE(sound_item_id);
  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *	@brief  SE~
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::SEStop(AMX * amx, const cell * ptr)
{
  u32 sound_item_id = ptr[1];
  xy_snd::StopSE( sound_item_id );
  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *	@brief  SEĐ`FbN
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::SEIsPlaying(AMX * amx, const cell * ptr)
{
  u32 sound_item_id = ptr[1];
  xy_snd::IsSEPlaying( sound_item_id );
  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  MEĐ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MEPlay(AMX * amx, const cell * ptr)
{
  u32 sound_item_id = ptr[1];
  xy_snd::StartME(sound_item_id);
  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  MEĐ擾
 *
 *  @retval true:MEĐ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MEIsFinished(AMX * amx, const cell * ptr)
{
  u32 sound_item_id = ptr[1];
  return xy_snd::IsMEFinished(sound_item_id);
}

//-----------------------------------------------------------------------------
/**
 *  @brief  ME̍ĐIAƂBGMɕA
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MEReturnBGM(AMX * amx, const cell *)
{
  xy_snd::StartBaseBGMFromME();
  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  |P{CY̍Đ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::VoicePlay( AMX * amx , const cell * ptr )
{
  u16 monsno = ptr[1];
  u16 formno = ptr[2];
  
  // ǗԍŖ炵p
  xy_snd::PlayVoice( 0, static_cast<MonsNo>(monsno), static_cast<FormNo>(formno) );
  return NULL;
}

/* ------------------------------------------------------------------------- */
/**
 * @brief {CX̍ĐIH
 */
/* ------------------------------------------------------------------------- */
cell AMX_NATIVE_CALL FuncSetCommon::VoiceIsEnd( AMX * amx, const cell * ptr )
{
  // ǗԍŖ炵p
  return xy_snd::IsVoiceFinished( 0 );
}


//-----------------------------------------------------------------------------
/**
 *  @brief  Cxg̍Đ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::EventBGMStart(AMX * amx, const cell * ptr)
{
  u32 sound_item_id = ptr[1];
  xy_snd::StartEventBGM(sound_item_id);
  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  CxgBGM̍ĐIAƂBGMɕA
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::EventBGMEnd(AMX * amx, const cell *)
{
  System* p_this = System::GetInstance();
  gamesystem::GameManager* p_gman = p_this->GetGameManager();
  gamesystem::GameData* p_data = p_gman->GetGameData();
  FieldSound* p_sound = p_data->GetFieldSound();
  p_sound->EndEventBGM(p_data);
  return NULL;
}

