//=============================================================================
/**
 * @file    ScriptBufferManager.h
 * @brief   XNvgǂݍݗpobt@ǗNX
 * @author  tamada
 * @date    2012.08.19
 */
//=============================================================================
#if !defined(__SCRIPTBUFFERMANAGER_H__)
#define __SCRIPTBUFFERMANAGER_H__

#include <gflib.h>

GFL_NAMESPACE_BEGIN( field );
GFL_NAMESPACE_BEGIN( script );

struct ScriptBuffer;
//=============================================================================
/**
 * @class ScriptBufferManager
 * @brief XNvgǂݍݗpobt@ǗNX
 */
//=============================================================================
class ScriptBufferManager
{
private:
  u16     m_BufferNum;
  ScriptBuffer * m_pScrBuffer;
  gfl::fs::FileReadManager * m_pFileReadManager;

public:
  static const u32 NOT_FOUND = 0xffff;

  /// constructor
  ScriptBufferManager( gfl::heap::HeapBase * p_heap, u32 size );

  /// destructor
  ~ScriptBufferManager();

  void Setup( gfl::fs::FileReadManager * p_fileread, gfl::heap::HeapBase * p_heap, bool use_hio_flag );
  void Cleanup( void );

  u32 GetIndex( u16 amx_id ) const;
  u32 RequestReadFile( gfl::heap::HeapBase * p_heap, u16 amx_id );
  void * GetBuffer( u32 amx_id ) const;
  size_t GetBufferSize( u32 amx_id ) const;
  bool ReleaseBuffer( u32 amx_id );
  bool IsReadFinished( u32 amx_id ) const;
  bool IsReadAllFinished( void ) const;

};  //End of Class ScriptBufferManager

GFL_NAMESPACE_END( script );
GFL_NAMESPACE_END( field );

#endif  // __SCRIPTBUFFERMANAGER_H__
