//=============================================================================
/**
 * @file    ScriptBufferManager.h
 * @brief   XNvgǂݍݗpobt@ǗNX
 * @author  tamada
 * @date    2012.08.19
 */
//=============================================================================
#include <gflib.h>
#include "ScriptBufferManager.h"

//=============================================================================
//=============================================================================
GFL_NAMESPACE_BEGIN( field );
GFL_NAMESPACE_BEGIN( script );

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
struct ScriptBuffer {
  void * m_buffer;
  u32 m_size;
  u16 m_AmxId;
  u16 m_ArcId;

  ScriptBuffer() : m_buffer( NULL ), m_size( 0 ), m_AmxId( ScriptObject::AMX_ID_NULL ), m_ArcId(0) { }
  ~ScriptBuffer() { if ( m_buffer ) GflHeapSafeFreeMemory( m_buffer ); }
};


//-----------------------------------------------------------------------------
/// constructor
//-----------------------------------------------------------------------------
ScriptBufferManager::ScriptBufferManager( gfl::heap::HeapBase * p_heap, u32 size )
{
  m_BufferNum = size;
  m_pScrBuffer = GFL_NEW_ARRAY( p_heap ) ScriptBuffer[ m_BufferNum ];
  m_pFileReadManager = NULL;
}

//-----------------------------------------------------------------------------
/// destructor
//-----------------------------------------------------------------------------
ScriptBufferManager::~ScriptBufferManager()
{
  GFL_DELETE_ARRAY( m_pScrBuffer );
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void ScriptBufferManager::Setup( gfl::fs::FileReadManager * p_fileread, gfl::heap::HeapBase * p_heap, bool use_hio_flag )
{
  m_pFileReadManager = p_fileread;
  m_pFileReadManager->AppendManageFile( p_heap, ARCID_FIELD_SCRIPT, use_hio_flag );
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void ScriptBufferManager::Cleanup( void )
{
  m_pFileReadManager->RemoveManageFile( ARCID_FIELD_SCRIPT );
  m_pFileReadManager = NULL;
}
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
u32 ScriptBufferManager::GetIndex( u16 amx_id ) const
{
  for( int i = 0; i < m_BufferNum; i ++ )
  {
    if ( m_pScrBuffer[i].m_AmxId == amx_id )
    {
      return i;
    }
  }
  return NOT_FOUND;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
u32 ScriptBufferManager::RequestReadFile( gfl::heap::HeapBase * p_heap, u16 amx_id )
{
  //ǂݍݍς݂̏ꍇ͉Ȃ
  u32 index = GetIndex( amx_id );
  if (index != NOT_FOUND ) return index;

  for ( int i = 0; i < m_BufferNum; i ++ )
  {
    if ( m_pScrBuffer[i].m_AmxId == ScriptObject::AMX_ID_NULL )
    {
      m_pScrBuffer[i].m_AmxId = amx_id;
      m_pFileReadManager->AddReadRequest( &m_pScrBuffer[i].m_buffer,
          &m_pScrBuffer[i].m_size, p_heap, 4,
          ARCID_FIELD_SCRIPT, amx_id, false );
      return i;
    }
  }
  GFL_ASSERT( 0 );
  return NOT_FOUND;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void * ScriptBufferManager::GetBuffer( u32 amx_id ) const
{
  u32 index = GetIndex( amx_id );
  GFL_ASSERT( index != NOT_FOUND );
  GFL_ASSERT( m_pScrBuffer[index].m_AmxId != ScriptObject::AMX_ID_NULL );
  return m_pScrBuffer[index].m_buffer;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
size_t ScriptBufferManager::GetBufferSize( u32 amx_id ) const
{
  u32 index = GetIndex( amx_id );
  GFL_ASSERT( index != NOT_FOUND );
  GFL_ASSERT( m_pScrBuffer[index].m_AmxId != ScriptObject::AMX_ID_NULL );
  return m_pScrBuffer[index].m_size;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
bool ScriptBufferManager::ReleaseBuffer( u32 amx_id )
{
  u32 index = GetIndex( amx_id );
  GFL_ASSERT( index != NOT_FOUND );
  if (m_pScrBuffer[index].m_AmxId != ScriptObject::AMX_ID_NULL )
  {
    GflHeapSafeFreeMemory( m_pScrBuffer[index].m_buffer );
    m_pScrBuffer[index].m_AmxId = ScriptObject::AMX_ID_NULL;
    m_pScrBuffer[index].m_size = 0;
    m_pScrBuffer[index].m_buffer = NULL;
    return true;
  }
  return false;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
bool ScriptBufferManager::IsReadFinished( u32 amx_id ) const
{
  u32 index = GetIndex( amx_id );
  GFL_ASSERT( index != NOT_FOUND );
  return m_pFileReadManager->IsReadFinished( &m_pScrBuffer[index].m_buffer );
}
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
bool ScriptBufferManager::IsReadAllFinished( void ) const
{
  bool ret = true;
  for ( int i = 0; i < m_BufferNum; i ++ )
  {
    if( m_pFileReadManager->IsReadFinished( &m_pScrBuffer[i].m_buffer ) == false )
    {
      ret = false;
    }
  }
  return ret;
}


GFL_NAMESPACE_END( script );
GFL_NAMESPACE_END( field );

