//=======================================================================================
/**
 * @file app_puzzle_Bg.h
 * @brief pYQ[̔wiǗNX
 * @author takada_keisuke
 * @date 2012.08.07
 */
//=======================================================================================
#ifndef __APP_PUZZLE_BG_H__
#define __APP_PUZZLE_BG_H__

#include "system/background/bg_system.h"

namespace app {
  namespace puzzle {

    class Common;

    class Bg {
      GFL_FORBID_COPY_AND_ASSIGN(Bg); // Rs[֎~


    public:

      //-------------------------------------------------------------------------------
      // RXgN^EfXgN^
      //-------------------------------------------------------------------------------
      /**
       * @brief RXgN^
       */
      Bg(Common* common);

      /**
       * @brief fXgN^
       */
      virtual ~Bg();


      void Initialize(void);
      void Finalize(void);
      void Loading(void);
      bool IsEnable( void );
      void Update(void);
      void UpdateAfterCalc(void);
      void DrawBg(void);

      /**
       * @brief oϐZbg 
       */
      void ResetData(void);

    private:

      // ʃNX
      Common* mCommon;

      // V[
      gfl::grp::g3d::Scene* mScene;

      //BGVXe
      xy_system::bg::System *mBgSystem;

      //fobOp
      int mBgType;
      int mFarType;
      int mObjType;
      bool mUseSky;

      /**
       * @brief V[PXԍ
       */
      enum Sequence {
        SEQ_DEMO,
        SEQ_MAIN,
        SEQ_RESULT,
      };
      // V[PX
      Sequence mSeq;

      // SEQ_DEMO̍XV
      void UpdateSeq_DEMO(void);
      // SEQ_MAIN̍XV
      void UpdateSeq_MAIN(void);
      // SEQ_RESULT̍XV
      void UpdateSeq_RESULT(void);

      // V
      xy_system::skybox::Weather mWeatherState;

      // 
      gfl::std::DateTime mDateTime;

      // V𒊑I
      void RandWeather(void);

      /**
       * @brief ԂXV 
       */
      void UpdateDate(void);
    };

  } // namespace puzzle 
} // namespace app


#endif  // __APP_PUZZLE_BG_H__
