//=======================================================================================
/**
 * @file app_puzzle_Bg.cpp
 * @brief pYQ[̃J
 * @author takada_keisuke
 * @date 2012.03.07
 */
//=======================================================================================
#include <gflib.h>
#include <sound/sound.h>

#include <app/util/app_util.h>
#include "app_puzzle_Common.h"
#include "app_puzzle_Bg.h"
#include "gamesystem/GameManager.h"
#include "system/skybox/SkyboxDefine.h"

namespace app
{
  namespace puzzle
  {

    //-------------------------------------------------------------------------------
    /**
     * @brief RXgN^
     */
    //-------------------------------------------------------------------------------

    Bg::Bg( Common* common ) :
    mCommon( common ),
    mScene( common->GetScene( ) ),
    mBgSystem( NULL ),
    mSeq( SEQ_DEMO )
    {
      this->Initialize( );
    }

    /**
     * @brief oϐ 
     */
    void Bg::ResetData( void )
    {
      // Ԃ
      gfl::std::DateTime::GetNow( &mDateTime );
      mDateTime.SetHour( 7 );
      mDateTime.SetMinute( 0 );
      mDateTime.SetSecond( 0 );
      mDateTime.SetMilliSecond( 0 );
      // DateύX
      gfl::std::DateTime::Copy( &mDateTime, mBgSystem->GetSkyDate( ) );

      // V𒊑I
      //this->RandWeather( );
    }

    void Bg::Initialize( void )
    {
      //BGVXe
      mBgSystem = GFL_NEW( mCommon->GetRootHeap( ) )xy_system::bg::System;

      xy_system::bg::InitSystemParam initSysParam;

      initSysParam.heapAllocator = mCommon->GetRootNwAllocator( );
      initSysParam.deviceAllocator = mCommon->GetRootNwDeviceAllocator( );

      initSysParam.grpSys = mCommon->GetGraphicsSystem( );
      initSysParam.g3dSys = mCommon->GetG3dSystem( );
      initSysParam.scene = mCommon->GetScene( );
      initSysParam.camera = mCommon->GetCamera( );
      initSysParam.readMng = mCommon->GetGameManager( )->GetFileReadManager( );

      initSysParam.mdlCalcGroup = Common::CALCULATE_GROUP_MAIN;
      initSysParam.mdlDrawGroup = Common::DRAW_GROUP_BATTLE_FIELD;
      initSysParam.mdlObjDrawGroup = Common::DRAW_GROUP_BATTLE_FIELD;

      initSysParam.fieldLightSetNum = 12;
      initSysParam.useEnv = true;

      initSysParam.skyBox = mCommon->GetGameManager( )->GetSkybox( );
      initSysParam.lightMan = mCommon->GetGameManager( )->GetWeatherLightManager( );
      initSysParam.weatherMng = mCommon->GetGameManager( )->GetWeatherManager( );

      initSysParam.skyCalcGroup = Common::CALCULATE_GROUP_MAIN;
      initSysParam.skyDrawGroup = Common::DRAW_GROUP_SKYBOX;
      initSysParam.wheatherCalcGroup = Common::CALCULATE_GROUP_MAIN;
      initSysParam.wheatherDrawGroup = Common::DRAW_GROUP_WEATHER;

      initSysParam.isAutoWeather = true;
      initSysParam.isAutoTime = false;

      mBgSystem->Init( initSysParam );
	  
      // V𒊑I
      //this->RandWeather( );

      // Ԃ
      gfl::std::DateTime::GetNow( &mDateTime );
      mDateTime.SetHour( 7 );
      mDateTime.SetMinute( 0 );
      mDateTime.SetSecond( 0 );
      mDateTime.SetMilliSecond( 0 );
      // DateύX
      gfl::std::DateTime::Copy( &mDateTime, mBgSystem->GetSkyDate( ) );

      mBgType = 1;
      mFarType = 1;
      mObjType = 0;
      mUseSky = true;

      xy_system::bg::ComponentData initParam;
      initParam.groundId = ( xy_system::bg::GroundId )mBgType;
      initParam.farGroundId = ( xy_system::bg::FarGroundId )mFarType;
      initParam.objBaseId = mObjType;
      initParam.skyboxFlag = mUseSky;

      mBgSystem->StartLoad( initParam );
    }

    void Bg::RandWeather( void )
    {
      u8 type = xy_system::GflUse::GetPublicRand( xy_system::weather::TYPE_MAX );
#if 0
      mWeatherState.pre_type = mWeatherState.type;
      mWeatherState.type = static_cast < xy_system::weather::Type >( type );
      mWeatherState.end_rate = 0.0f;

      xy_system::skybox::Weather* weatherState = mBgSystem->GetWeatherState( );
      *weatherState = mWeatherState;
#else
      //mBgSystem->GetWeatherMng( )->RequestForce( static_cast < xy_system::weather::Type >( type ), gamesystem::PMSeason::DEFAULT, 0.0f );
      mBgSystem->GetWeatherMng( )->RequestForce( xy_system::weather::TYPE_SNOW_HEAVY, gamesystem::PMSeason::DEFAULT, 0.0f );
#endif
    }

    void Bg::Finalize( void )
    {
      mBgSystem->RemoveScene( );

      //BGVXe
      mBgSystem->Exit( );
      GFL_DELETE mBgSystem;
    }

    void Bg::Loading( void )
    {
      if ( mBgSystem->IsFinishLoad( ) )
      {
        mBgSystem->Create( );
        mBgSystem->AddScene( );
        mBgSystem->SetObjPos( gfl::math::VEC3( 0, 0, -480 ) );
      }
      mBgSystem->Update( );
    }

    /**
     * @brief 
     * @return 
     */
    bool Bg::IsEnable( void )
    {
      return mBgSystem->IsEnable( );
    }

    void Bg::Update( void )
    {
      mBgSystem->Update( );

      switch ( mSeq )
      {
        case SEQ_DEMO:
          UpdateSeq_DEMO( );
          break;

        case SEQ_MAIN:
          UpdateSeq_MAIN( );
          break;

        case SEQ_RESULT:
          UpdateSeq_RESULT( );
          break;
      }
    }

    void Bg::UpdateAfterCalc( void )
    {
      // _ɈˑXV RenderQueue ̍\zs܂B
      mScene->SubmitView( mCommon->GetCamera( ), true, true, Common::DRAW_GROUP_BATTLE_FIELD );
      mScene->SubmitView( mCommon->GetCamera( ), true, true, Common::DRAW_GROUP_SKYBOX );
      mScene->SubmitView( mCommon->GetCamera( ), true, true, Common::DRAW_GROUP_WEATHER );
    }

    /**
     * @brief SEQ_DEMO̍XV
     */
    void Bg::UpdateSeq_DEMO( void )
    {
      // fIĂ
      if ( mCommon->GetPuzzleGameData( )->isEndDemo == true )
      {
        mSeq = SEQ_MAIN;
        return;
      }
    }

    /**
     * @brief SEQ_MAIN̍XV
     */
    void Bg::UpdateSeq_MAIN( void )
    {
      // pYĂ
      if ( mCommon->GetPuzzleGameData( )->isPuzzleComplete == true ||
           mCommon->GetPuzzleGameData( )->isTimeUpForInfinite == true )
      {
        mSeq = SEQ_RESULT;
        return;
      }

      // DateύX
      gfl::std::DateTime::Copy( &mDateTime, mBgSystem->GetSkyDate( ) );

      this->UpdateDate( );
    }

    /**
     * @brief SEQ_RESULT̍XV
     */
    void Bg::UpdateSeq_RESULT( void )
    {
      // ǂIĂ
      if ( mCommon->GetPuzzleGameData( )->isSelectOnceAgain == true )
      {
        this->ResetData( );
        this->UpdateDate( );
        return;
      }
    }

    void Bg::DrawBg( void )
    {
      gfl::grp::GraphicsSystem* graphicsSystem = mCommon->GetGraphicsSystem( );
      gfl::grp::g3d::Camera* camera = mCommon->GetCamera( );
      gfl::grp::RenderTarget* offScreenRenderTarget = mCommon->GetOffScreenRenderTarget( );

      mBgSystem->Draw( offScreenRenderTarget );
      mScene->Draw( graphicsSystem, camera, offScreenRenderTarget, Common::DRAW_GROUP_BATTLE_FIELD );
    }

    /**
     * @brief ԂXV 
     */
    void Bg::UpdateDate( void )
    {
      u8 degreeOfDifficulty = mCommon->GetDegreeOfDifficulty( );
      s32 elapsedTime = mCommon->GetPuzzleGameData( )->elapsedTime;

      if ( elapsedTime < MAX_TIME[ degreeOfDifficulty ] )
      {
        f32 maxTime = static_cast < f32 >( MAX_TIME[ degreeOfDifficulty ] ) / 30.0f / 60.0f; // fps  min
        // ԂXV
        s32 msec = mDateTime.GetMilliSecond( ) + ( ( ( 60 * 12 ) / maxTime ) * ( ( 1 / 30.0f ) * 1000 ) );
        mDateTime.SetMilliSecond( msec % 1000 );
        if ( 1000 <= msec )
        {
          s32 sec = mDateTime.GetSecond( ) + ( msec / 1000.0f );
          mDateTime.SetSecond( sec % 60 );
          if ( 60 <= sec )
          {
            s32 min = mDateTime.GetMinute( ) + ( sec / 60.0f );
            mDateTime.SetMinute( min % 60 );
            if ( 60 <= min )
            {
              s32 hour = mDateTime.GetHour( ) + ( min / 60.0f );
              mDateTime.SetHour( hour % 24 );
            }
          }
        }
      }
    }

    /**
     * @brief fXgN^
     */
    Bg::~Bg( )
    {
    }

  } // namespace puzzle 
} // namespace app
