//============================================================================================
/**
 * @file		gts_pokename_search.h
 * @brief   񂩂|PJNO擾(݂Ȃ-1
 * @author	Akito Mori
 * @date		12.08.17
 *
 * namespace	app::gts::
 *
 */
//============================================================================================
#if !defined( __GTS_POKENAME_SEARCH_H__ )
#define __GTS_POKENAME_SEARCH_H__

#include <gflnet.h>
#include "app/util/app_util_heap.h"

namespace netapp {
namespace gts {
  
  class GtsPokeNameSearch
  {
  public:
    GtsPokeNameSearch( app::util::Heap *heap, savedata::ZukanData *pZukanData );
    ~GtsPokeNameSearch( void );
    
    
    //=========================================================================================
    /**
     * @brief nƃ|PNOTĕԂ
     *
     * @param   none
     *
     * @retval  int 0,  1-750:|PNO
     */
    //=========================================================================================
    int CheckString2PokeNo( gfl::str::StrBuf *name );

  private:
    void DeleteDakutenHandakuten( gfl::str::STRCODE *array );
    int  GetString2SearchKey( gfl::str::StrBuf *name );
    
  private:
    app::util::Heap   *m_heap;
    gfl::str::MsgData *m_gts_msg;      ///< GTSbZ[Wf[^
    gfl::str::MsgData *m_monsname_msg; ///< |PbZ[Wf[^
    gfl::str::StrBuf  *m_target_str;   ///< ϊpi[obt@
    gfl::str::StrBuf  *m_trans_str;    ///< ϊpi[obt@
    gfl::str::StrBuf  *m_search_str;   ///< ϊpi[obt@
    savedata::ZukanData *m_pZukanData; ///< }ӃtOZ[u|C^

    static const int TRANS_TOPWORD_TABLE_NUM_JP  = 31;  // E̐
    static const int SEARCH_TOPWORD_TABLE_NUM_JP = 89;  // ̐
  };
  
  } // gts
} // naetapp
#endif // __GTS_POKENAME_SEARCH_H__
