//============================================================================================
/**
 * @file    gts_pokename_search.cpp
 * @brief   |PNOϊi݂Ȃ-1)
 * @author  Akito Mori
 * @date    12.08.17
 *
 * namespace  app::gts::
 *
 */
//============================================================================================
#include "gts_input_graphic.h"

#include "arc/arc_def.h"
#include "arc/message.gaix"
#include "message/msg_gts.h"

#include "gts_pokename_search.h"
namespace netapp {
  namespace gts {

#include "zukan_sort_table_jp.cdat"

//=============================================================================================
/**
 * @brief	RXgN^
 *
 * @param   none		
 */
//=============================================================================================
GtsPokeNameSearch::GtsPokeNameSearch( app::util::Heap *heap, savedata::ZukanData *pZukanData )
{
  GFL_PRINT("heap=%08x, pZukanData=%08x\n", heap, pZukanData );
  
  m_heap = heap;

  // GTSbZ[Wnh
  m_gts_msg = GFL_NEW_LOW( heap->pHeap ) gfl::str::MsgData( ARCID_MESSAGE,
                                                        GARC_message_gts_DAT,
                                                        heap->pHeap,
                                                        gfl::str::MsgData::LOAD_PART );  

  // |PbZ[Wnh
  m_monsname_msg = GFL_NEW_LOW( heap->pHeap ) gfl::str::MsgData(
                                                        ARCID_MESSAGE,
                                                        GARC_message_monsname_DAT,
                                                        heap->pHeap,
                                                        gfl::str::MsgData::LOAD_PART );
  
  m_target_str = GFL_NEW_LOW(heap->pHeap) gfl::str::StrBuf( 
                                                        TRANS_TOPWORD_TABLE_NUM_JP*3, heap->pHeap );
  m_trans_str  = GFL_NEW_LOW(heap->pHeap) gfl::str::StrBuf( 
                                                        TRANS_TOPWORD_TABLE_NUM_JP*3, heap->pHeap );
  m_search_str = GFL_NEW_LOW(heap->pHeap) gfl::str::StrBuf( 
                                                        SEARCH_TOPWORD_TABLE_NUM_JP*3, heap->pHeap );
  
  m_pZukanData = pZukanData;

}

//=============================================================================================
/**
 * @brief	fXgN^
 *
 * @param   none		
 */
//=============================================================================================
GtsPokeNameSearch::~GtsPokeNameSearch(void)
{
  GFL_DELETE m_search_str;
  GFL_DELETE m_trans_str;
  GFL_DELETE m_target_str;
  GFL_DELETE m_monsname_msg;
  GFL_DELETE m_gts_msg;
}

//=============================================================================================
/**
 * @brief	̑_E_OiupEovunvɂj
 *
 * @param   array		
 */
//=============================================================================================
void GtsPokeNameSearch::DeleteDakutenHandakuten( gfl::str::STRCODE *array )
{
  const gfl::str::STRCODE *target, *trans;

  // E
  m_gts_msg->GetString( msg_gts_02A_047, *m_target_str );
  m_gts_msg->GetString( msg_gts_02A_048, *m_trans_str );

  target = m_target_str->GetPtr();  // 1r邽߂STRCODE|C^擾
  trans  = m_trans_str->GetPtr();

  // _E_邩r
  for(int i=0;i<TRANS_TOPWORD_TABLE_NUM_JP;i++){
    if(target[i]==array[0]){
      array[0] = trans[i];  // 珑
      GFL_PRINT("%dqbg %dɕϊ\n", target[i], trans[i]);
    }
  }
}

//=============================================================================================
/**
 * @brief	͂Ă|P̓擾ČL[ɕϊł邩`FbN
 *
 * @param   name  ͂|P
 *
 * @retval  int -1:YȂ 0-49: p̃L[NO
 */
//=============================================================================================
int GtsPokeNameSearch::GetString2SearchKey( gfl::str::StrBuf *name )
{
  int result = -1;
  int i;
  // ͂ĂȂΖ
  if(name->GetLength()==0){
    return result;  // -1
  }

  // ̓|P̓擾
  const gfl::str::STRCODE *p_src;
  gfl::str::STRCODE word;
  p_src    = name->GetPtr();
  word = p_src[0];            // ̂݃Rs[

  // _E_̏ꍇɕϊ
  DeleteDakutenHandakuten( &word );

  // bZ[WxŔr܂킷
  m_gts_msg->GetString( msg_gts_02A_049, *m_search_str );
  const gfl::str::STRCODE *p_table = m_search_str->GetPtr();

  // A`܂Ŕr
  for(i=0;i<msg_gts_02A_046-msg_gts_02A_003;i++){
    if(p_table[i] == word){
      result = i;
      break;
    }
  }
  GFL_PRINT("%d r\n",i);

  return result;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		ړ͂̃|P݂邩Ԃ
 * @return	1-795: |PNO,  0:Ȃ
 *
 */
//--------------------------------------------------------------------------------------------
int GtsPokeNameSearch::CheckString2PokeNo( gfl::str::StrBuf *string )
{
  int result = 0;
  int key    = GetString2SearchKey( string );

  if(key<0){
    GFL_PRINT( "O͂͂ĂȂ\n");
    return result;
  }
  
  // rp|Pobt@
  gfl::str::StrBuf *name = GFL_NEW_LOW(m_heap->pHeap) gfl::str::StrBuf( pml::MONS_NAME_BUFFER_SIZE,m_heap->pHeap );
  
  // |Pp[\if[^\[gNX
  poke_tool::PersonalSort *p_sort = GFL_NEW(m_heap->pHeap) poke_tool::PersonalSort( 
                                                              xy::GetLang(), 
                                                              m_pZukanData,
                                                              m_heap->pHeap, 
                                                              poke_tool::PersonalSort::LOAD_TYPE_FULL );
  p_sort->SetConditionZukan( poke_tool::PokemonSort::CONDITION_ZUKAN_SEE );
  p_sort->OrderByAIUEO( ZukanSortKeyTbl[key][0], ZukanSortKeyTbl[key][1] );
  GFL_PRINT("|P = %d", p_sort->GetSortedDataMax());
  for( int i=0; i<p_sort->GetSortedDataMax(); ++i )
  {
    // Y|P擾Ar
    MonsNo monsno = p_sort->GetSortedMonsNo( i );
    m_monsname_msg->GetString( static_cast<int>(monsno), *name );
    if(string->Compare( *name )){
      result = static_cast<int>(monsno);
      GFL_PRINT( "ԍ%d𔭌\n", monsno );
      break;
    }
  }
  GFL_DELETE p_sort;
  GFL_DELETE name;

  return result;
}

} // namespace gts
} // namespace netapp
