//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *  @file    debug_app_hologrammail_NetworkBossConfig.cpp
 *  @brief   lbg[NŃzOb̂̊ԂɒʐMݒ胁j[pRg[NX
 *  @author  suzuki_hisanao
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <Gamesystem/GameProcManager.h>
#include <app/util/app_util_Common.h>
#include "app/hologram_mail/network/app_hologrammail_NetworkParentView.h"
#include "app_hologrammail_NetworkBossConfig.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)
GFL_NAMESPACE_BEGIN(boss)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 *  @brief  RXgN^
 *  @param  param 
 */
NetworkBossConfig::NetworkBossConfig( app::util::Heap* heap, app::hologrammail::NetworkParentView* view ) :
  m_parent_view( view ),
  m_heap(heap),
  m_config(NULL)
{
}

/**
 *  @brief  fXgN^
 */
NetworkBossConfig::~NetworkBossConfig()
{
}



/**
 *  @brief  
 *
 *  @gameMgr Q[}l[W
 */
void NetworkBossConfig::Initialize( gamesystem::GameManager* gameMgr )
{
  m_config = gameMgr->GetGameData()->GetConfig();

  m_parent_view->SetVisibleList( false );
  m_parent_view->SetVisibleWindow( false );
  m_parent_view->SetVisibleTouchbar( false );

  //̂ɂāuLIVEv\肷H
  m_parent_view->SetVisibleLiveIcon( false );

  //Xi̓o^
  m_parent_view->SetListener( this );

  m_errorMgr = GFL_SINGLETON_INSTANCE(gflnet::err::ErrManager);

  // ̊ԂɒʐM̐ݒmF
  CheckEnableBoss();
}

/**
 *  @brief  I
 */
void NetworkBossConfig::Finalize( void )
{
}

/**
 *  @brief  PROCC
 */
bool NetworkBossConfig::Update( void )
{
  return this->UpdateSequence();
}

/**
 *  @brief  `
 */
void NetworkBossConfig::Draw( void )
{
}



//-----------------------------------------------------------------------
// PRIVATE
//-----------------------------------------------------------------------
/**
 * @brief V[PXXV
 */
bool NetworkBossConfig::UpdateSequence( void )
{
  switch(m_sequence)
  {
    case  SEQUENCE_REGISTING:        // BOSSo^
      RegistBoss();
      break;

    case  SEQUENCE_UNREGISTING:      // BOSS
      UnregistBoss();
      break;

    case  SEQUENCE_EULA_MENU:        // EULAAvbg
      DoMenuEULA();
      break;

    case  SEQUENCE_END:               // I
      m_parent_view->SetTimerIconVisible(false);
      return true;

    case  SEQUENCE_ASK_ENABLE:
    case  SEQUENCE_ASK_DISABLE:
      // YES/NOICxg҂܂傤
      break;

    case  SEQUENCE_EULA_ERROR:        // EULAG[
    case  SEQUENCE_REGIST_SUCCESS:    // o^
    case  SEQUENCE_UNREGIST_SUCCESS:  // 폜
    case  SEQUENCE_ERROR:             // G[
    default:
      // bZ[WICxg҂܂傤
      break;
  }

  return false;
}


/**
 * @brief ̊ԂɒʐM̗p
 */
void NetworkBossConfig::CheckEnableBoss( void )
{
  if( !m_config->IsEnableBoss() )
  {
    // o^H
    m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_BOSS_ASK_REGIST );
    m_sequence = SEQUENCE_ASK_ENABLE;
  }
  else
  {
    // H
    m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_BOSS_ASK_UNREGIST );
    m_sequence = SEQUENCE_ASK_DISABLE;
  }
}


/**
 * @brief BOSS̓o^
 */
void NetworkBossConfig::RegistBoss( void )
{
  if( ++m_dummyCounter > 100 )
  {
    m_config->SetBossEnable( true );
    m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_BOSS_REGIST_FINISH );
    m_sequence = SEQUENCE_REGIST_SUCCESS;
  }
}


/**
 * @brief BOSS̉
 */
void NetworkBossConfig::UnregistBoss( void )
{
  if( ++m_dummyCounter > 100 )
  {
    m_config->SetBossEnable( false );
    m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_BOSS_UNREGIST_FINISH );
    m_sequence = SEQUENCE_UNREGIST_SUCCESS;
  }
}


/**
 * @brief EULAANV
 */
void NetworkBossConfig::DoMenuEULA( void )
{
  nn::erreula::CTR::ReturnCode retCode;

  retCode = m_errorMgr->ErrorDispDirect( 0, nn::erreula::CTR::ERROR_TYPE_EULA );

  if( retCode == nn::erreula::CTR::RETURN_CODE_SUCCESS )
  {
    // bZ[WuBOSSo^v
    m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_BOSS_REGISTING );
    m_sequence = SEQUENCE_REGISTING;
  }
  else
  {
    m_sequence = SEQUENCE_END;
  }
}


/**
 * @brief EULAF؂ɏFĂH
 * @return FĂȂtrueԋp
 */
bool NetworkBossConfig::IsAgreeEULA( void )
{
  return nn::cfg::CTR::IsAgreedEula();
}


/**
 * @brief yA^Rg[ŁuC^[lbgʐMv֎~ĂH
 * @return ĂȂtrueԋp
 */
bool NetworkBossConfig::IsRestrictParental( void )
{
  return nn::cfg::CTR::IsRestrictP2pInternet();
}



/**
 * @brief Yes{^ꂽɌĂ΂
 */
// @override
void NetworkBossConfig::OnSelectedYesButton( void )
{
  if( SEQUENCE_ASK_DISABLE == m_sequence )
  {
    // bZ[Wuv
    m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_BOSS_UNREGISTING );
    m_sequence = SEQUENCE_UNREGISTING;
  }
  else if( SEQUENCE_ASK_ENABLE == m_sequence )
  {
    if( IsAgreeEULA() )
    {
      if( IsRestrictParental() )
      {
        // bZ[WuyA^ɂċ֎~v
        m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_RESTRICT_PARENTAL );
        m_sequence = SEQUENCE_ERROR;
      }
      else
      {
        // bZ[WuBOSSo^v
        m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_BOSS_REGISTING );
        m_sequence = SEQUENCE_REGISTING;
      }
    }
    else
    {
      // bZ[WuEULAG[v
      m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_CEC_EULA_ERROR );
      m_sequence = SEQUENCE_EULA_ERROR;
    }
  }
}


/**
 * @brief No{^ꂽɌĂ΂
 */
// @override
void NetworkBossConfig::OnSelectedNoButton( void )
{
  m_sequence = SEQUENCE_END;
}


/**
 * @brief bZ[W\I
 */
// @override
void NetworkBossConfig::OnPrintMessageFinished( void )
{
  if( (SEQUENCE_ASK_ENABLE == m_sequence) || (SEQUENCE_ASK_DISABLE == m_sequence) ){
    m_parent_view->StartYesNoMenu();
  }
  else if( SEQUENCE_EULA_ERROR == m_sequence ){
    m_sequence = SEQUENCE_EULA_MENU;
  }
  else{
    m_sequence = SEQUENCE_END;
  }
}







GFL_NAMESPACE_END(boss)
GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)

