//-----------------------------------------------------------------------------
/**
 *  @brief  bOBJ@̕Ɍ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::TalkMdlSetDir(AMX * amx, const cell * ptr)
{
  u16 dir = ptr[1];
  s16 obj_id = ptr[2];

  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  Work* p_script_work = p_obj->GetWork();
  mmodel::MoveModelBase* p_tmdl;

  if (obj_id == -1) {
    p_tmdl = p_script_work->GetTargetObj();
  }
  else {
    mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
    p_tmdl = p_mmdlman->SearchObjIdWork(obj_id);
  }

  if (p_tmdl) {
    //    mmodel::MoveModel* p_mdl = reinterpret_cast<mmodel::MoveModel*>( p_tmdl );
    //    p_mdl->SetAcmd( mmodel::AC_STAY_WALK_2F, static_cast<Dir>(dir) );
    p_tmdl->SetDirDisp(static_cast<Dir> (dir));
  }
  else {
    GFL_PRINT("TalkMdlSetDir : TalkMdl NULL obj_id=%d \n", obj_id );
  }

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  Y[I`FbN
 *
 *  @retval true:I
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::TalkMdlZoomIsEnd(AMX * amx, const cell * ptr)
{
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  FieldStereoCamera* p_camera = p_gman->GetFieldmap()->GetGraphics()->GetCamera();
  if (p_camera->IsExecutingFldCamAnmOffsetPos() == false) {
    p_camera->SetUserCameraControl(FieldStereoCamera::USER_CONTROL_NONE); // [U[Rg[I
    return true;
  }

  return false;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  Y[Jn
 *
 *  @retval true:Y[
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::TalkMdlZoomSet(AMX * amx, const cell * ptr)
{
  bool is_zoom_out = ptr[1]; // true = ZoomOut, false = ZoomIn
  s16 obj_id = ptr[2];
  f32 zoom_in_val = amx_ctof(ptr[3]); // _

  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  FieldStereoCamera* camera = p_gman->GetFieldmap()->GetGraphics()->GetCamera();
  Work* p_script_work = p_obj->GetWork();

  // JĂY[Ȃ
  {
    bool ZoomFlag = camera->IsCameraAreaControl();

    if (ZoomFlag) {
      return false;
    }
  }

  // [U[JRg[B
  camera->SetUserCameraControl(FieldStereoCamera::USER_CONTROL_NORMAL);

  if (is_zoom_out) {
    gfl::math::VEC3 campos;
    gfl::math::VEC3 camtar;
    gfl::math::VEC3 offset;
    gfl::math::VEC3 start_pos;
    gfl::math::VEC3 end_pos;

    camera->GetDefaultCameraPosition(&campos);
    camera->GetDefaultTargetPosition(&camtar);
    offset = campos - camtar;

    end_pos = offset;
    FieldStereoCamera::FldCamAnmOffsetPosArg arg;
    arg.zenkashiki.limit = 1.0f;
    arg.zenkashiki.bairitsu = 0.3f;
    camera->StartFldCamAnmOffsetPos(end_pos,
            FieldStereoCamera::FLD_CAM_ANM_OFFSETPOS_FUNCTION_ZENKASHIKI,
            arg);
  }
  else {
    mmodel::MoveModelBase* p_tmdl;

    if (obj_id == -1) {
      p_tmdl = p_script_work->GetTargetObj();
    }
    else {
      Fieldmap* p_fieldmap = p_gman->GetFieldmap();
      mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
      p_tmdl = p_mmdlman->SearchObjIdWork(obj_id);
    }

    // bfȂ΃Y[Ȃ
    if (p_tmdl == NULL) {
      GFL_PRINT("TalkMdlZoomSet : TalkMdl NULL\n");
      return false;
    }

    gfl::math::VEC3 campos;
    gfl::math::VEC3 offset;
    gfl::math::VEC3 start_pos;
    gfl::math::VEC3 end_pos;

    camera->GetCameraPosition(campos);
    gfl::math::VEC3 tar;
    p_tmdl->GetVectorPos(&tar);
    tar.y -= 200; // sb`グ
    tar.z += 50; //10
    gfl::math::VEC3 pos = tar - campos;
    gfl::math::VEC3Normalize(&pos, &pos);

    camera->GetParameterCameraOffsetPosition(&offset);

    end_pos = offset + pos * zoom_in_val;
    FieldStereoCamera::FldCamAnmOffsetPosArg arg;
    arg.zenkashiki.limit = 1.0f;
    arg.zenkashiki.bairitsu = 0.3f;
    camera->StartFldCamAnmOffsetPos(end_pos,
            FieldStereoCamera::FLD_CAM_ANM_OFFSETPOS_FUNCTION_ZENKASHIKI,
            arg);
  }

  return true;
}


//----------------------------------------------------------------------------
/**
 *  @brief  bƎ@̎킹B
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::TalkMdlSetEyeToEye(AMX * amx, const cell * ptr)
{
  s16 obj_id = ptr[1];

  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  PlayerGrid* p_player = p_gman->GetFieldmap()->GetFieldPlayer();
  Work* p_script_work = p_obj->GetWork();
  mmodel::MoveModel* p_tmdl;

  if (obj_id == -1) {
    p_tmdl = static_cast<mmodel::MoveModel*> (p_script_work->GetTargetObj());
  }
  else {
    Fieldmap* p_fieldmap = p_gman->GetFieldmap();
    mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
    p_tmdl = static_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));
  }


  // EyeEye킹B
  if (p_tmdl) {
    mmodel::MoveModel* p_pmdl = p_player->GetModel();
    mmodel::Move3DModel* p_3dmodel = p_pmdl->GetDrawModel();
    if (p_3dmodel && p_tmdl) {
      p_3dmodel->SetInterestView(p_tmdl);
      p_3dmodel->SetInterestMode(mmodel::Move3DModel::INTEREST_NEAR);
    }
    p_3dmodel = p_tmdl->GetDrawModel();
    if (p_3dmodel && p_pmdl) {
      p_3dmodel->SetInterestView(p_pmdl);
      p_3dmodel->SetInterestMode(mmodel::Move3DModel::INTEREST_NEAR);
    }
  }

  return false;
}

//----------------------------------------------------------------------------
/**
 *  @brief  bƎ@̎̂킹Ƃ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::TalkMdlClearEyeToEye(AMX * amx, const cell * ptr)
{
  s16 obj_id = ptr[1];

  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  PlayerGrid* p_player = p_gman->GetFieldmap()->GetFieldPlayer();
  Work* p_script_work = p_obj->GetWork();
  mmodel::MoveModel* p_tmdl;

  if (obj_id == -1) {
    p_tmdl = static_cast<mmodel::MoveModel*> (p_script_work->GetTargetObj());
  }
  else {
    Fieldmap* p_fieldmap = p_gman->GetFieldmap();
    mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
    p_tmdl = static_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));
  }


  // EyeEye킹B
  if (p_tmdl) {
    mmodel::MoveModel* p_pmdl = p_player->GetModel();
    mmodel::Move3DModel* p_3dmodel = p_pmdl->GetDrawModel();
    if (p_3dmodel) {
      if (p_3dmodel->IsInterestModelView()) {
        p_3dmodel->ClearInterestView();
        TOMOYA_PRINT("Player clear\n");
      }
    }
    p_3dmodel = p_tmdl->GetDrawModel();
    if (p_3dmodel) {
      if (p_3dmodel->IsInterestModelView()) {
        p_3dmodel->ClearInterestView();
        TOMOYA_PRINT("NPC clear\n");
      }
    }
  }

  return false;
}

//----------------------------------------------------------------------------
/**
 *  @brief  bƎ@̎킹B
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::TalkMdlSetEyeToPlayer(AMX * amx, const cell * ptr)
{
  s16 obj_id = ptr[1];

  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  PlayerGrid* p_player = p_gman->GetFieldmap()->GetFieldPlayer();
  Work* p_script_work = p_obj->GetWork();
  mmodel::MoveModel* p_tmdl;

  if (obj_id == -1) {
    p_tmdl = static_cast<mmodel::MoveModel*> (p_script_work->GetTargetObj());
  }
  else {
    Fieldmap* p_fieldmap = p_gman->GetFieldmap();
    mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
    p_tmdl = static_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));
  }

  // vC[
  if (p_tmdl) {
    mmodel::MoveModel* p_pmdl = p_player->GetModel();
    mmodel::Move3DModel* p_3dmodel = p_pmdl->GetDrawModel();

    p_3dmodel = p_tmdl->GetDrawModel();
    if (p_3dmodel) {
      p_3dmodel->SetInterestView(p_pmdl);
      p_3dmodel->SetInterestMode(mmodel::Move3DModel::INTEREST_NEAR);
    }
  }

  return false;
}

//----------------------------------------------------------------------------
/**
 *  @brief  bƎ@̎̂킹Ƃ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::TalkMdlClearEyeToPlayer(AMX * amx, const cell * ptr)
{
  s16 obj_id = ptr[1];

  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  PlayerGrid* p_player = p_gman->GetFieldmap()->GetFieldPlayer();
  Work* p_script_work = p_obj->GetWork();
  mmodel::MoveModel* p_tmdl;

  if (obj_id == -1) {
    p_tmdl = static_cast<mmodel::MoveModel*> (p_script_work->GetTargetObj());
  }
  else {
    Fieldmap* p_fieldmap = p_gman->GetFieldmap();
    mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
    p_tmdl = static_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));
  }

  // EyeEye킹B
  if (p_tmdl) {
    mmodel::Move3DModel* p_3dmodel;

    p_3dmodel = p_tmdl->GetDrawModel();
    if (p_3dmodel) {
      if (p_3dmodel->IsInterestModelView()) {
        p_3dmodel->ClearInterestView();
      }
    }
  }

  return false;
}

//----------------------------------------------------------------------------
/**
 *  @brief  b[V
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::TalkMdlSetTalkMotion(AMX * amx, const cell * ptr)
{
  s16 obj_id = ptr[1];

  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  PlayerGrid* p_player = p_gman->GetFieldmap()->GetFieldPlayer();
  Work* p_script_work = p_obj->GetWork();
  mmodel::MoveModel* p_tmdl;

  if (obj_id == -1) {
    p_tmdl = static_cast<mmodel::MoveModel*> (p_script_work->GetTargetObj());
  }
  else {
    Fieldmap* p_fieldmap = p_gman->GetFieldmap();
    mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
    p_tmdl = static_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));
  }


  // [VZbg
  if (p_tmdl) {
    p_tmdl->SetDrawStatus( mmodel::DRAWSTA_SPEAK01 );
  }

  return false;
}


//----------------------------------------------------------------------------
/**
 *  @brief  b鑊̏񂪂邩`FbN
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::IsTalkMdlExist(AMX * amx, const cell *)
{
  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  Work* p_script_work = p_obj->GetWork();
  mmodel::MoveModelBase* p_tmdl = p_script_work->GetTargetObj();

  if (p_tmdl) {
    return true;
  }
  return false;
}

//----------------------------------------------------------------------------
/**
 *  @brief  b̃g[i[ID擾@ig[i[̏ꍇɂ̂ݎgp\j
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::GetTalkMdlTrID(AMX * amx, const cell *)
{
  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  Work* p_script_work = p_obj->GetWork();
  mmodel::MoveModelBase* p_tmdl = p_script_work->GetTargetObj();

  if (p_tmdl) {
    // @todo X́AXNvgID狁߂B
    return p_tmdl->GetEventFlag();
  }
  return 0;
}

//----------------------------------------------------------------------------
/**
 *  @brief  bOBJID擾
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::GetTalkMdlObjID(AMX * amx, const cell *)
{
  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  Work* p_script_work = p_obj->GetWork();
  mmodel::MoveModelBase* p_tmdl = p_script_work->GetTargetObj();

  if (p_tmdl) {
    // @todo X́AXNvgID狁߂B
    return p_tmdl->GetOBJID();
  }
  return 0;
}

