static u32 ScriptMessageDatIdToArcDatID(u32 datid)
{
  switch (datid)
  {
    case SCRMSG_DATID_FLD_ITEM              : return GARC_script_message_fld_item_DAT;
    case SCRMSG_DATID_TRMSG                 : return GARC_message_trmsg_DAT;
    case SCRMSG_DATID_POKE_MEMORY           : return GARC_message_pokemon_memory_DAT;
    case SCRMSG_DATID_POKE_WAZA             : return GARC_script_message_poke_waza_DAT;
    case SCRMSG_DATID_POKE_WAZA_POWERFUL    : return GARC_script_message_poke_waza_powerful_DAT;
    case SCRMSG_DATID_POKE_WAZA_DRAGON      : return GARC_script_message_poke_waza_dragon_DAT;
    case SCRMSG_DATID_POKE_WAZA_COALESCENCE : return GARC_script_message_poke_waza_coalescence_DAT;
    case SCRMSG_DATID_COMMON                : return GARC_script_message_common_scr_DAT;
  }

  GFL_ASSERT(0);

  return 0;
}

/* ------------------------------------------------------------------------- */
/**
 * @brief bZ[W̃[h
 */
/* ------------------------------------------------------------------------- */
cell AMX_NATIVE_CALL FuncSetCommon::MsgLoad(AMX* amx, const cell * ptr)
{
  bool is_script_message = ptr[1];
  u32 datid = ptr[2];

  u32 arcid = ARCID_MESSAGE;

  if (is_script_message) {
    arcid = ARCID_SCRIPT_MESSAGE;
  }

  datid = ScriptMessageDatIdToArcDatID(datid);

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  
  //@todo TRMSGc HEAPID_EVENT ł͑ȂȂ̂ňUfoCXg
  //gfl::heap::HeapBase* p_heap = gfl::heap::Manager::GetHeapByHeapId(HEAPID_EVENT);
  gfl::heap::HeapBase* p_heap = gfl::heap::Manager::GetHeapByHeapId(HEAPID_EVENT_DEVICE);
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  gfl::fs::FileReadManager* p_fileman = p_fieldmap->GetFileReadManager();

  MsgWork* wk = GFL_NEW(p_heap) MsgWork();
  GFL_ASSERT(m_pMsgLoadWork == NULL);
  m_pMsgLoadWork = wk;

  p_fileman->AppendManageFile(p_heap, arcid);
  p_fileman->AddReadRequest(&wk->MsgBuf, NULL, p_heap, 4, arcid, datid, false);

#if PM_DEBUG
  m_load_msg_arc_id   = arcid;
  m_load_msg_data_id  = datid;
#endif

  return NULL;
}

cell AMX_NATIVE_CALL FuncSetCommon::MsgIsLoaded(AMX* amx, const cell * ptr)
{
  bool is_script_message = ptr[1];

  u32 arcid = ARCID_MESSAGE;

  if (is_script_message) {
    arcid = ARCID_SCRIPT_MESSAGE;
  }

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  gfl::fs::FileReadManager* p_fileman = p_fieldmap->GetFileReadManager();

  GFL_ASSERT(m_pMsgLoadWork);
  MsgWork* wk = m_pMsgLoadWork;

  if (p_fileman->IsReadFinished( &wk->MsgBuf ) )
  {
    p_fileman->RemoveManageFile(arcid);
    ONOUE_PRINT("obt@:%x\n",reinterpret_cast<u32> (wk->MsgBuf));
    return reinterpret_cast<u32> (wk->MsgBuf);
  }

  return false;
}

cell AMX_NATIVE_CALL FuncSetCommon::MsgRelease(AMX* amx, const cell * ptr)
{
  GFL_ASSERT(m_pMsgLoadWork);
  MsgWork* wk = m_pMsgLoadWork;

  GflHeapSafeFreeMemory(wk->MsgBuf);
  GFL_SAFE_DELETE(m_pMsgLoadWork);

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  bZ[WEBhE
 *  @note   0ԃEBhE܂
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MsgWinClose(AMX * amx, const cell *)
{
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  MsgWin* p_msgwin = p_fieldmap->GetMsgWin();
  
  _MsgWinClose( 0 );

  // ^C}[ݒ肳ĂȂEBhESĕĂOFF
  if( p_msgwin->IsAllSuspend( true ) )
  {
    pThis->GetSystemWork()->OffCheckBit( SCR_END_CHECK_BIT_WIN_OPEN );
  }
  
  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  bZ[WEBhE(ԍw)
 */
//-----------------------------------------------------------------------------
cell AMX_NATIVE_CALL FuncSetCommon::MsgWinCloseNo(AMX * amx, const cell * ptr)
{
  u16 no = ptr[1];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  MsgWin* p_msgwin = p_fieldmap->GetMsgWin();
  
  _MsgWinClose( no );

  // ^C}[ݒ肳ĂȂEBhESĕĂOFF
  if( p_msgwin->IsAllSuspend( true ) )
  {
    pThis->GetSystemWork()->OffCheckBit( SCR_END_CHECK_BIT_WIN_OPEN );
  }
  
  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  bZ[WEBhE
 */
//-----------------------------------------------------------------------------
cell AMX_NATIVE_CALL FuncSetCommon::MsgWinAllClose(AMX * amx, const cell * ptr)
{
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  MsgWin* p_msgwin = p_fieldmap->GetMsgWin();

  if( ptr[1] )
  {
    p_msgwin->CloseNoTimer();
  }
  else
  {
    p_msgwin->CloseAll();
  }

  // ׂĕ̂ŃrbgĂ܂
  if( pThis->GetSystemWork()->CheckBit( SCR_END_CHECK_BIT_WIN_OPEN ) )
  {
    pThis->GetSystemWork()->OffCheckBit( SCR_END_CHECK_BIT_WIN_OPEN );
  }
  
  return NULL;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief EBhËʒuݒ
 */
/* -------------------------------------------------------------------------*/
cell AMX_NATIVE_CALL FuncSetCommon::SetMoneyWinPos(AMX * amx, const cell * ptr)
{
  s32 win_pos_x = ptr[1];
  s32 win_pos_y = ptr[2];

  if( m_pMsgWinWork )
  {
    GFL_ASSERT_MSG(0,"bZ[W̃[N𑽏dɍ쐬邱Ƃ͂ł܂\n");
    GFL_SAFE_DELETE(m_pMsgWinWork);
    return NULL;
  }
  // AP[g[Nɒlݒ
  u32 size = sizeof( MsgWin::MsgWinTmpWork );
  void * p_result = GflHeapAllocMemory( HEAPID_EVENT, size );
  m_pMsgWinWork = reinterpret_cast<MsgWin::MsgWinTmpWork*>(p_result);
  m_pMsgWinWork->tmp_win_pos.x = win_pos_x;
  m_pMsgWinWork->tmp_win_pos.y = win_pos_y;
  m_pMsgWinWork->tmp_win_pos.z = 0;

  return NULL;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief EBhËʒu擾X
 */
/* -------------------------------------------------------------------------*/
cell AMX_NATIVE_CALL FuncSetCommon::GetMoneyWinPosX(AMX * amx, const cell * ptr)
{
  if( m_pMsgWinWork )
  {
    return m_pMsgWinWork->tmp_win_pos.x;
  }
  GFL_ASSERT_MSG(0,"bZ[W̃[N݂܂\n");
  return 0;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief EBhËʒu擾Y
 */
/* -------------------------------------------------------------------------*/
cell AMX_NATIVE_CALL FuncSetCommon::GetMoneyWinPosY(AMX * amx, const cell * ptr)
{
  if( m_pMsgWinWork )
  {
    return m_pMsgWinWork->tmp_win_pos.y;
  }
  GFL_ASSERT_MSG(0,"bZ[W̃[N݂܂\n");
  return 0;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief EBhE[N
 */
/* -------------------------------------------------------------------------*/
cell AMX_NATIVE_CALL FuncSetCommon::ReleaseWinWork(AMX * amx, const cell * ptr)
{
  GFL_SAFE_DELETE(m_pMsgWinWork);
  return NULL;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief   ׂẴEBhETXyhԂ`FbN
 *
 * @return truêƂׂẴEBhETXyh
 */
/* -------------------------------------------------------------------------*/
cell AMX_NATIVE_CALL FuncSetCommon::CheckWinAllSuspend(AMX * amx, const cell * ptr)
{
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  MsgWin* p_msgwin = p_fieldmap->GetMsgWin();
  
  // ׂẴEBhEҋ@Ԃ`FbN
  if (p_msgwin->IsAllSuspend( false )) {
    return true;
  }
  return false;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief   EBhETXyhԂ`FbN
 *
 *  ptr[1]  int  win_id EBhEID
 *
 * @return truêƂׂẴEBhETXyh
 */
/* -------------------------------------------------------------------------*/
cell AMX_NATIVE_CALL FuncSetCommon::CheckWinSuspend(AMX * amx, const cell * ptr)
{
  u16 win_id = ptr[1];
  
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  MsgWin* p_msgwin = p_fieldmap->GetMsgWin();
  
  // EBhEҋ@Ԃ`FbN
  if (p_msgwin->IsWinSuspend( win_id ,false )) {
    return true;
  }
  return false;
}


//----------------------------------------------------------------------------
/**
 *	@brief  L[҂}[Nij\
 *
 *	@param	amx
 *	@param	cell * ptr
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
cell AMX_NATIVE_CALL FuncSetCommon::SetKeyWaitMark(AMX* amx, const cell * ptr)
{
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  MsgWin* p_msgwin = p_fieldmap->GetMsgWin();

  if( p_msgwin )
  {
    p_msgwin->SetMark();
  }
  return 0;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  bZ[WEBhE
 */
//-----------------------------------------------------------------------------
void FuncSetCommon::_MsgWinClose( u8 win_id )
{
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  MsgWin* p_msgwin = p_fieldmap->GetMsgWin();
  
  // N[Y
  p_msgwin->Close( win_id );
}
  
//--------------------------------------------------------------
/// OBJb V[PXp[N
//==============================================================

struct TalkMdlMsgSeq
{
  gfl::str::MsgData* MsgData;
  const gfl::math::VEC3* TalkPos;
  const gfl::math::VEC3* PlayerPos;
};

//-----------------------------------------------------------------------------
/**
 *  @brief  OBJb
 *
 *  @retval true:I
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::TalkMdlMsg_Seq(AMX * amx, const cell * ptr)
{
  s32 str_id    = ptr[1];
  u8  win_id    = ptr[2];
  s16 obj_id    = ptr[3];
  u16 win_type  = ptr[4];
  s32 win_pos_x = ptr[5];
  s32 win_pos_y = ptr[6];
  s32 win_pos_z = ptr[7];
  s32 win_ofs_x = ptr[8];
  s32 win_ofs_y = ptr[9];
  s32 win_ofs_z = ptr[10];
  s32 tail_pos_ang          = ptr[11];
  s32 tail_ang              = ptr[12];
  bool is_win_pos_auto      = ptr[13];
  bool is_mdl_follow        = ptr[14];
  bool is_set_tail_param    = ptr[15];
  bool is_use_mdl           = ptr[16];
  s32  timer                = ptr[17];
  void* p_msgbuf            = reinterpret_cast<void*> (ptr[18]);
  s32 option                = ptr[19];

  ONOUE_PRINT("buf2:%x\n",ptr[18]);

  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Work* p_script_work = p_obj->GetWork();
  void** UserWork = p_script_work->GetUserWork();
  mmodel::MoveModelBase* p_tmdl;

  if( is_use_mdl )
  {
    if (obj_id == -1) {
      p_tmdl = p_script_work->GetTargetObj();
    }
    else {
      Fieldmap* p_fieldmap = p_gman->GetFieldmap();
      mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
      p_tmdl = p_mmdlman->SearchObjIdWork(obj_id);
    }

    if (p_tmdl == NULL) {
      GFL_PRINT("TalkMdlMsg_Seq : TalkMdl NULL obj_id=%d \n", obj_id );
      return true;
    }
  }
  else
  {
    p_tmdl = NULL;
  }


  gfl::heap::HeapBase* p_heap = gfl::heap::Manager::GetHeapByHeapId(HEAPID_EVENT);
  u32 msg_arc_id = p_script_work->GetMsgArcId();
  u32 msg_dat_id = p_script_work->GetMsgDatId();

  TalkMdlMsgSeq* wk = GFL_NEW(p_heap) TalkMdlMsgSeq();

  // obt@w肳Ăꍇ͎gp
  if (p_msgbuf) {
    wk->MsgData = GFL_NEW(p_heap) gfl::str::MsgData(p_msgbuf, p_heap);
  }
  else
  {
    wk->MsgData = GFL_NEW(p_heap) gfl::str::MsgData(
        msg_arc_id, msg_dat_id, p_heap, gfl::str::MsgData::LOAD_PART);
  }

  const u32 STRBUF_MAX = 1014;
  gfl::str::StrBuf* msgbuf = GFL_NEW( p_heap ) gfl::str::StrBuf( STRBUF_MAX, p_heap );
  gfl::str::StrBuf* tmpbuf = GFL_NEW( p_heap ) gfl::str::StrBuf( STRBUF_MAX, p_heap );
  WordSet* wset = pThis->GetSystemWork()->GetWordSet();
  if( str_id != -1 ) // -1͖l
  {
    wk->MsgData->GetString(str_id, *tmpbuf);
  }
  wset->Expand(msgbuf, tmpbuf);

  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  MsgWin* p_msgwin = p_fieldmap->GetMsgWin();
  
  // NGXgf[^쐬ANGXg𔭍s
  MsgWinUnit::WindowCallParam param;
  param.win_pos.x         = win_pos_x;
  param.win_pos.y         = win_pos_y;
  param.win_pos.z         = win_pos_z;
  param.win_type          = win_type;
  param.timer             = timer;
  param.win_pos_ofs       = gfl::math::VEC3(win_ofs_x,win_ofs_y,win_ofs_z);
  param.is_mdl_follow     = is_mdl_follow;
  param.is_win_pos_auto   = is_win_pos_auto;
  param.is_set_tail_param = is_set_tail_param;
  param.tail_pos_ang      = tail_pos_ang;
  param.tail_ang          = tail_ang;
  param.win_id            = win_id;

  // ꊇ\
  if( option&WIN_OPTION_STR_ONE_TIME )
  {
    param.is_one_time_draw  = true;
  }else{
    param.is_one_time_draw  = false;
  }

  // {p\
  if( option&WIN_OPTION_STR_DOUBLE )
  {
    param.is_font_big  = true;
  }else{
    param.is_font_big  = false;
  }

  
  // E
  if( option&WIN_OPTION_MSG_POS_RIGHT )
  {
    param.is_set_right  = true;
  }
  else
  {
    param.is_set_right  = false;
  }

  // {p\
  if( option&WIN_OPTION_CENTER )
  {
    // {pɂ͋ꊇ\
    param.is_set_center     = true;
    param.is_one_time_draw  = true;
  }else{
    param.is_set_center  = false;
  }

  // p[^̏
  param.win_fit.is_fit_up     = false;
  param.win_fit.is_fit_down   = false;
  param.win_fit.is_fit_left   = false;
  param.win_fit.is_fit_right  = false;
  param.win_fit.is_fit_center = false;

  // KȂ
  if( option&WIN_NO_TAIL )
  {
    param.is_no_tail = true;
  }
  else
  {
    param.is_no_tail = false;
  }

  // ʒuw\
  if( option&WIN_POS_AUTO_UL )
  {
    param.win_fit.is_fit_up = true;
    param.win_fit.is_fit_left = true;
  }
  else if( option&WIN_POS_AUTO_UR )
  {
    param.win_fit.is_fit_up = true;
    param.win_fit.is_fit_right = true;
  }
  else if( option&WIN_POS_AUTO_UC )
  {
    param.win_fit.is_fit_up = true;
    param.win_fit.is_fit_center = true;
  }
  else if( option&WIN_POS_AUTO_DL )
  {
    param.win_fit.is_fit_down = true;
    param.win_fit.is_fit_left = true;
  }
  else if( option&WIN_POS_AUTO_DR )
  {
    param.win_fit.is_fit_down = true;
    param.win_fit.is_fit_right = true;
  }
  else if( option&WIN_POS_AUTO_DC )
  {
    param.win_fit.is_fit_down = true;
    param.win_fit.is_fit_center = true;
  }
  
  // Ǐ]̏
  param.follow_pos_dir = MsgWinUnit::FOLLOW_WIN_POS_AUTO;
  // Œ
  if( option&WIN_OPTION_FOLLOW_POS_LU )
  {
    param.follow_pos_dir = MsgWinUnit::FOLLOW_WIN_POS_LU;
  }
  // EŒ
  if( option&WIN_OPTION_FOLLOW_POS_RU )
  {
    param.follow_pos_dir = MsgWinUnit::FOLLOW_WIN_POS_RU;
  }
  // Œ
  if( option&WIN_OPTION_FOLLOW_POS_LD )
  {
    param.follow_pos_dir = MsgWinUnit::FOLLOW_WIN_POS_LD;
  }
  // EŒ
  if( option&WIN_OPTION_FOLLOW_POS_RD )
  {
    param.follow_pos_dir = MsgWinUnit::FOLLOW_WIN_POS_RD;
  }
  // EBhEIDŏ
  if( option&WIN_OPTION_ID_AUTO )
  {
    param.win_id = WIN_ID_AUTO;
  }
  
  param.p_move_mode       = static_cast<mmodel::MoveModel*> (p_tmdl);

  param.p_msgbuf   = msgbuf;

#if PM_DEBUG
  // fobOp[^
  // obt@ɂ͓ǂݍł̂𔽉f
  param.msg_id = str_id;
  if (p_msgbuf)
  {
    param.msg_arc_id  = m_load_msg_arc_id;
    param.msg_data_id = m_load_msg_data_id;
  }
  else
  {
    param.msg_arc_id = msg_arc_id;
    param.msg_data_id = msg_dat_id;
  }
#endif

  // ^C}[ݒ肳ĂȂEBhEoꍇON
  if( timer <= 0 )
  {
    pThis->GetSystemWork()->OnCheckBit( SCR_END_CHECK_BIT_WIN_OPEN );
  }

  win_id = p_msgwin->SetMessageRequest( param );
  
  GFL_SAFE_DELETE(tmpbuf);
  GFL_SAFE_DELETE(msgbuf);
  GFL_SAFE_DELETE(wk->MsgData);
  GFL_SAFE_DELETE(wk);
  p_script_work->ClearUserWork();

  return win_id;
}

//===============================================================================
// fXgN^֐
//===============================================================================

bool FuncSetCommon::SCREND_CheckEndWin( gamesystem::GameManager* p_gman )
{
  System* pThis = System::GetInstance();
  //gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  MsgWin* p_msgwin = p_fieldmap->GetMsgWin();
    
  p_msgwin->CloseNoTimer();
    
  pThis->GetSystemWork()->OffCheckBit( SCR_END_CHECK_BIT_WIN_OPEN );
  
  return true;
}

