
//-----------------------------------------------------------------------------
/**
 *  @brief  ANVR}ho^Jn
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlAcmdInit(AMX * amx, const cell * ptr)
{
  s16 obj_id = ptr[1];

  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  Work* p_script_work = p_obj->GetWork();

  if (obj_id == -1) {
    mmodel::MoveModelBase* p_tmdl;
    p_tmdl = p_script_work->GetTargetObj();
    if (p_tmdl) {
      obj_id = p_tmdl->GetOBJID();
    }
    else {
      GFL_PRINT("MdlAcmdInit : TalkMdl NULL\n");
      obj_id = 0;
    }
  }
  GFL_PRINT("MdlAcmdInit : TalkMdl =%d\n", obj_id);

  p_script_work->StartStackAcmdList(obj_id);

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  ANVR}h Zbg
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlAcmdSet(AMX * amx, const cell * ptr)
{
  u16 acmd = ptr[1]; // mmodel::Acmd
  u8 dir = ptr[2]; // field::Dir
  u16 num = ptr[3];

  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  Work* p_script_work = p_obj->GetWork();

  p_script_work->StackAcmdList(acmd, dir, num);

  return NULL;
}

// map̍쐬
static bool RouteSearchMapSetByMoveModel_Elem( Grid& grid, bool * map, RouteSearch::Pos& base, u32 width, u32 size )
{
  s32 gx, gz;
  
  grid.GetPlanePos(&gx, &gz); 

  gx -= base.gx;
  gz -= base.gz;

  if ( gx >= 0 && gz >= 0 )
  {
    u32 elem = gz * width + gx;
    if (elem < size)
    {
      map[ elem ] = true;
      return true;
    }
  }
  
  return false;
}

static void RouteSearchMapSetByMoveModel( mmodel::Manager* p_mmdlman, Grid& grid, bool * map, RouteSearch::Pos& area, RouteSearch::Pos& base, u16 obj_id )
{
  mmodel::MoveModelBase* cp_wk;
  u32 size = area.gx * area.gz;
  
  u32 count = 0;
  
  while( (cp_wk = p_mmdlman->SearchUseWork( &count, mmodel::Manager::SEARCH_USE_MSK_FELLOW_HIT )) != NULL )
  {
    // Ƃ͎Ȃ
    if (cp_wk->GetOBJID() == obj_id)
    {
      continue;
    }
    
    cp_wk->GetGridPos(&grid);
    RouteSearchMapSetByMoveModel_Elem( grid, map, base, area.gx, size );
    
    cp_wk->GetOldGridPos(&grid);
    RouteSearchMapSetByMoveModel_Elem( grid, map, base, area.gx, size );
  }
}


/* ------------------------------------------------------------------------- */
/**
 * @brief oHTŃANVR}h𔭍s
 */
/* ------------------------------------------------------------------------- */
cell AMX_NATIVE_CALL FuncSetCommon::MdlAcmdMakeRoute( AMX* amx, const cell *ptr)
{
  u16 acmd = ptr[1];
  s32 tar_gx = ptr[2];
  s32 tar_gy = ptr[3];
  s32 tar_gz = ptr[4];
  bool is_onegrid = ptr[5];
  u32 size = ptr[6];
  
  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  Work* p_script_work = p_obj->GetWork();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  const Mapper* cp_mapper = p_fieldmap->GetMapper();
  const RailSystem* cp_railsys = cp_mapper->GetRailSystem();
  
  gfl::heap::HeapBase* p_heap = gfl::heap::Manager::GetHeapByHeapId(HEAPID_EVENT);

  u16 obj_id = p_script_work->GetAcmdObjID();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));

  // fȂ珈f
  if (p_mmdl == NULL) {
    GFL_PRINT("MdlAcmdMakeMove : Model NULL obj_id=%d\n", obj_id);
    return NULL;
  }
  
  GFL_DEBUG_TICK_SET_FLAG( SCRIPT_COMMON, true );
  GFL_DEBUG_TICK_RESET( SCRIPT_COMMON );
        
  /*
  HOSAKA_PRINT( "base(%d,%d) start(%d,%d)(%d,%d), goal(%d,%d)(%d,%d)\n",
      mx, mz,
      gx, gz,
      gx - mx, gz - mz,
      tar_gx, tar_gz,
      tar_gx - mx, tar_gz - mz
  );
  */
    
  // 샂f̍W擾
  s32 gx, gz;
  Grid grid(cp_railsys, cp_mapper);
  p_mmdl->GetGridPos(&grid);
  grid.GetPlanePos(&gx, &gz);

  // S[͈͊OȂ␳
  if (gfl::math::FAbs(tar_gx - gx) >= size )
  {
    s32 vec = ( tar_gx - gx );
    vec /= vec;
    tar_gx =  gx + (size-1) * vec;
  }
  if (gfl::math::FAbs(tar_gz - gz) >= size )
  {
    s32 vec = ( tar_gz - gz );
    vec /= vec;
    tar_gz =  gz + (size-1) * vec;
  }
  
  // @ƒǐՎ҂̍x[Xɂ
  s32 mx = ( gx < tar_gx ) ? gx : tar_gx;
  s32 mz = ( gz < tar_gz ) ? gz : tar_gz;
  
  RouteSearch::Pos area(size, size);
  RouteSearch::Pos start(gx, gz);
  RouteSearch::Pos goal(tar_gx, tar_gz);
  RouteSearch::Pos base(mx, mz);
  
  GFL_DEBUG_TICK_START( SCRIPT_COMMON, DEBUG_TICK_PRINT_ROUTE_ALL, "route" );
  GFL_DEBUG_TICK_START( SCRIPT_COMMON, DEBUG_TICK_PRINT_ROUTE_MAP, "map" );
  
  u32 dir_cnt = 0;
  
  GFL_ASSERT( p_heap->Check() );

  Dir* dirs = GFL_NEW_ARRAY( p_heap ) Dir[ area.gx * area.gz ];
  bool* map = GFL_NEW_ARRAY( p_heap ) bool[ area.gx * area.gz ];
  
  GFL_ASSERT( p_heap->Check() );
         

  // map̍쐬
  // 샂f̓蔻
  {
    GFL_DEBUG_TICK_START( SCRIPT_COMMON, DEBUG_TICK_PRINT_MDL_SEARCH, "mdl" );
    
    RouteSearchMapSetByMoveModel( p_mmdlman, grid, map, area, base, obj_id );
    
    GFL_DEBUG_TICK_END( SCRIPT_COMMON, DEBUG_TICK_PRINT_MDL_SEARCH );
  }

  // Agr[g̓蔻
  {
    GFL_DEBUG_TICK_START( SCRIPT_COMMON, DEBUG_TICK_PRINT_ATTR_GET, "attr" );
    
    for (u32 z = 0; z < area.gz; z++)
    {
      for (u32 x = 0; x < area.gx; x++)
      {
        s32 map_x = base.gx + x;
        s32 map_z = base.gz + z;
          
        // ɗĂꏊ͂̂܂܂ɂ
        if( map[ z * area.gx + x ] == false )
        {
          map[ z*area.gx + x ] = p_fieldmap->GetRouteMap()->IsMapHitch( map_x, map_z );
        }

      } // for (u32 x ...
    } // for (u32 z ...

    GFL_DEBUG_TICK_END( SCRIPT_COMMON, DEBUG_TICK_PRINT_ATTR_GET );
  }
  
  GFL_DEBUG_TICK_END( SCRIPT_COMMON, DEBUG_TICK_PRINT_ROUTE_MAP );
  
#if 0
  // }bvvg
  int cnt = 0;
  for (u32 z = 0; z < area.gz; z++)
  {
    for (u32 x = 0; x < area.gx; x++)
    {
      HOSAKA_PRINT( "%d ", map[ cnt ] );
      cnt++;
    }
    HOSAKA_PRINT("\n");
  }
#endif
  
  GFL_DEBUG_TICK_START( SCRIPT_COMMON, DEBUG_TICK_PRINT_ROUTE_CALC, "route_calc" );
  
  GFL_ASSERT( p_heap->Check() );
  
  RouteSearch* p_route = GFL_NEW( p_heap ) RouteSearch( p_heap, base, area, start, goal, map );
  
  GFL_ASSERT( p_heap->Check() );
  
  // vZ
  bool ret =p_route->Calculate();
  
  if( ret )
  {
    RouteSearch::Node* p_node = p_route->GetGoalNode();
  
    // ܂łǂ
    do
    {
      dirs[ dir_cnt ] = p_node->GetDir();
      dir_cnt++;
      p_node = p_node->GetParentNode();
    } while( p_node->GetParentNode() != NULL );
    
    // X^[gn_o
    u32 loop = dir_cnt;
    if (is_onegrid)
    {
      loop = 1;
    }
    
    for (u32 i = 0; i < loop; i++)
    {
      Dir dir = dirs[ dir_cnt-1 ];
      p_script_work->StackAcmdList(acmd, dir, 1);
      dir_cnt--;
    }
  }
  
  GFL_SAFE_DELETE( p_route );
  GFL_SAFE_DELETE_ARRAY( map );
  GFL_SAFE_DELETE_ARRAY( dirs );
  
  GFL_DEBUG_TICK_END(SCRIPT_COMMON, DEBUG_TICK_PRINT_ROUTE_CALC);
  GFL_DEBUG_TICK_END(SCRIPT_COMMON, DEBUG_TICK_PRINT_ROUTE_ALL);
  
  s32 tick_all = GFL_DEBUG_TICK_US_GET(SCRIPT_COMMON, DEBUG_TICK_PRINT_ROUTE_ALL);
  s32 tick_map = GFL_DEBUG_TICK_US_GET(SCRIPT_COMMON, DEBUG_TICK_PRINT_ROUTE_MAP);
  s32 tick_calc = GFL_DEBUG_TICK_US_GET(SCRIPT_COMMON, DEBUG_TICK_PRINT_ROUTE_CALC);
  s32 tick_mdl = GFL_DEBUG_TICK_US_GET(SCRIPT_COMMON, DEBUG_TICK_PRINT_MDL_SEARCH);
  s32 tick_attr = GFL_DEBUG_TICK_US_GET(SCRIPT_COMMON, DEBUG_TICK_PRINT_ATTR_GET);
  
  HOSAKA_PRINT( "route tick mdl=%d us attr=%d us\n", tick_mdl, tick_attr );
  HOSAKA_PRINT( "route tick map = %d us, calc = %d us, all = %d us \n",
      tick_map, tick_calc, tick_all );
  
  return ret;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  wWɈړANVR}h𐶐
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlAcmdMakeMove(AMX * amx, const cell * ptr)
{
  u16 acmd = ptr[1];
  s32 tar_gx = ptr[2];
  s32 tar_gy = ptr[3];
  s32 tar_gz = ptr[4];
  bool is_onegrid = ptr[5];

  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  Work* p_script_work = p_obj->GetWork();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  const Mapper* cp_mapper = p_fieldmap->GetMapper();

  u16 obj_id = p_script_work->GetAcmdObjID();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));

  // fȂ珈f
  if (p_mmdl == NULL) {
    GFL_PRINT("MdlAcmdMakeMove : Model NULL obj_id=%d\n", obj_id);
    return NULL;
  }

  s32 mgx, mgz;
  Position pos( cp_mapper->GetRailSystem(), cp_mapper );
//  Grid grid(cp_mapper->GetRailSystem(), cp_mapper);
//  p_mmdl->GetGridPos(&grid);
//  grid.GetPlanePos(&mgx, &mgz);
  
  p_mmdl->GetVectorPos( &pos );

  gfl::math::VEC3 posvec;
  pos.GetTranslate( &posvec );

  mgx = posvec.x / GRID_SIZE;
  mgz = posvec.z / GRID_SIZE;

  s16 gx = tar_gx - mgx;
  s16 gy = 0;
  s16 gz = tar_gz - mgz;

    ONOUE_PRINT( "mgx=%d mgz=%d tar_gx=%d tar_gz=%d gx=%d gy=%d gz=%d \n",
        mgx, mgz, tar_gx, tar_gz,
        gx, gy, gz );

  s16 abs_gx = gfl::math::FAbs(gx);
  s16 abs_gz = gfl::math::FAbs(gz);

  s16 min = gfl::math::Min(abs_gx, abs_gz);
  s16 max = gfl::math::Max(abs_gx, abs_gz);

  Dir dir;
  u16 num;
  gfl::math::VEC3 vec;

  // Ƀii
  if (min > 0) {
    vec.x = gx / abs_gx * min;
    vec.y = gy;
    vec.z = gz / abs_gz * min;
    mmodel::MoveModelBase::CalcVecToDir(vec, &dir);
       ONOUE_PRINT( "vec=%f, %f, %f dir=%d \n", vec.x, vec.y, vec.z, dir);

    num = min;
    p_script_work->StackAcmdList(acmd, dir, num);
       ONOUE_PRINT( "acmd=%d, dir=%d num=%d\n", acmd, dir, num );
    if (is_onegrid) {
      return NULL;
    }
  }

  // \ړ
  if ((abs_gx - min) > 0 || (abs_gz - min) > 0) {
    vec.x = gx / abs_gx * (abs_gx - min);
    vec.y = gy;
    vec.z = gz / abs_gz * (abs_gz - min);
    mmodel::MoveModelBase::CalcVecToDir(vec, &dir);
       // ONOUE_PRINT( "vec=%f, %f, %f dir=%d \n", vec.x, vec.y, vec.z, dir);

    num = max - min;
    p_script_work->StackAcmdList(acmd, dir, num);
       ONOUE_PRINT( "acmd=%d, dir=%d num=%d\n", acmd, dir, num );
    if (is_onegrid) {
      return NULL;
    }
  }

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  ANVR}h Zbg
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlAcmdSetEnd(AMX * amx, const cell * ptr)
{
  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  Work* p_script_work = p_obj->GetWork();

  u16 obj_id = p_script_work->GetAcmdObjID();
  u16 cnt = p_script_work->GetAcmdCnt();
  const mmodel::MoveModelAcmdList* list = p_script_work->GetAcmdObjListHeader();

  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));

  if (p_mmdl) {
    p_mmdl->SetAcmdList(list, cnt);
  }
  else {
    GFL_PRINT("MdlAcmdSetEnd : Model NULL objid=%d \n", obj_id);
  }

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  ANVR}h Zbg
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlAcmdSetToOtherMdl(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];
  
  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  Work* p_script_work = p_obj->GetWork();

  u16 cnt = p_script_work->GetAcmdCnt();
  const mmodel::MoveModelAcmdList* list = p_script_work->GetAcmdObjListHeader();

  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));

  if (p_mmdl) {
    p_mmdl->SetAcmdList(list, cnt);
  }
  else {
    GFL_PRINT("MdlAcmdSetCopy : Model NULL objid=%d \n", obj_id);
  }

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  ANVR}h XV
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlAcmdUpdate(AMX * amx, const cell * ptr)
{
  s32 objid = ptr[1];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();

  u32 no = 0;
  mmodel::MoveModel* p_mmdl;
  bool is_end = true;

  while ((p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchUseWork(&no))) != NULL) {
    if (objid != -1 && objid != p_mmdl->GetOBJID()) {
      continue;
    }
    // Abvf[g
    // UpdateMoveModelManagerł悤ɂȂ
    //    p_mmdl->UpdateAcmdList();
    // ŝ̂邩ׂ
    if (p_mmdl->IsAcmdListEnd() == false) {
      is_end = false;
    }
  }

  return is_end;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  ANVR}h̏I`FbN
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlAcmdIsEnd(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));

  if (p_mmdl) {
    return p_mmdl->IsAcmdEnd();
  }

  return true;
}

//-----------------------------------------------------------------------------
/**
 *  @brief
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::AcmdListClear(AMX * amx, const cell * ptr)
{
  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  Work* p_script_work = p_obj->GetWork();


  p_script_work->ClearAcmdList();

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  f̒ړ_Zbg
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlInterestViewSet(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];
  f32 px = amx_ctof(ptr[2]); // _
  f32 py = amx_ctof(ptr[3]); // _
  f32 pz = amx_ctof(ptr[4]); // _

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));

  if (p_mmdl) {
    gfl::math::VEC3 pos(px, py, pz);
    mmodel::Move3DModel* p_dmdl = p_mmdl->GetDrawModel();
    p_dmdl->SetInterestView(pos);
  }
  else {
    GFL_PRINT("MdlInterestViewSet:obj_id=%d is notfound\n", obj_id);
  }

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  f̒ړ_NA
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlInterestViewClear(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));

  if (p_mmdl) {
    mmodel::Move3DModel* p_dmdl = p_mmdl->GetDrawModel();
    p_dmdl->ClearInterestView();
  }
  else {
    GFL_PRINT("MdlInterestViewClear:obj_id=%d is notfound\n", obj_id);
  }

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  f̒ړ_݂邩`FbN
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlInterestViewIsEnable(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));

  if (p_mmdl) {
    mmodel::Move3DModel* p_dmdl = p_mmdl->GetDrawModel();
    return p_dmdl->IsInterestView();
  }
  else {
    GFL_PRINT("MdlInterestViewIsEnable:obj_id=%d is notfound\n", obj_id);
  }

  return false;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  f̒ڃ[hݒ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlInterestViewSetMode(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];
  u16 mode = ptr[2];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));

  if (p_mmdl) {
    mmodel::Move3DModel* p_dmdl = p_mmdl->GetDrawModel();
    mmodel::Move3DModel::InterestMode mode2 = mmodel::Move3DModel::INTEREST_NEAR;

    switch (mode)
    {
      case mmodel::INTEREST_NEAR: mode2 = mmodel::Move3DModel::INTEREST_NEAR;
        break;
      case mmodel::INTEREST_FAR: mode2 = mmodel::Move3DModel::INTEREST_FAR;
        break;
      case mmodel::INTEREST_CLOSE: mode2 = mmodel::Move3DModel::INTEREST_CLOSE;
        break;
      case mmodel::INTEREST_FREE: mode2 = mmodel::Move3DModel::INTEREST_FREE;
        break;
      default: GFL_ASSERT(0);
    }

    p_dmdl->SetInterestMode(mode2);
  }
  else {
    GFL_PRINT("MdlInterestViewSetMode:obj_id=%d is notfound\n", obj_id);
  }

  return NULL;
}
//-----------------------------------------------------------------------------
/**
 *  @brief  f̕\E\ݒ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlVisible(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];
  u16 is_visible = ptr[2];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));

  if (p_mmdl) {
    if (is_visible) {
      p_mmdl->OffStatusBit(field::mmodel::MoveModelBase::STABIT_VANISH);
    }
    else {
      p_mmdl->OnStatusBit(field::mmodel::MoveModelBase::STABIT_VANISH);
    }
  }
  else {
    GFL_PRINT("MdlInterestViewSetMode:obj_id=%d is notfound\n", obj_id);
  }

  return NULL;
}
//-----------------------------------------------------------------------------
/**
 *  @brief  f̃Aj~
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlPauseAnim(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];
  u16 is_pause = ptr[2];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));

  if (p_mmdl) {
    if (is_pause) {
      p_mmdl->PauseAnim();
    }
    else {
      p_mmdl->RestartAnim();
    }
  }
  else {
    GFL_PRINT("MdlInterestViewSetMode:obj_id=%d is notfound\n", obj_id);
  }

  return NULL;
}
//-----------------------------------------------------------------------------
/**
 *  @brief  f̃Aj~
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlPauseAnimNo(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];
  u16 is_pause = ptr[2];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));

  if (p_mmdl) {
    if (is_pause) {
      p_mmdl->PauseAnimNo();
    }
    else {
      p_mmdl->RestartAnimNo();
    }
  }
  else {
    GFL_PRINT("MdlInterestViewSetMode:obj_id=%d is notfound\n", obj_id);
  }

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  f̓Dir擾
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlGetDirMove(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));
  Dir dir = DIR_NOT;
  if (p_mmdl) {
    dir = p_mmdl->GetDirMove();
  }
  else {
    GFL_PRINT("MdlGetDirMove obj_id[%d] none \n", obj_id);
  }

  return dir;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  f̑x0ȂtrueԂ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlIsMoveSpeedZero(AMX * amx, const cell * ptr)
{
  static const f32 MIN_VALUE = 0.000001f;

  u16 obj_id = ptr[1];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));
  if (p_mmdl) {
    gfl::math::VEC3 speed;
    p_mmdl->GetMoveSpeed(&speed);
    if (speed.Length() < MIN_VALUE) {
      return true;
    }
    else {
      return false;
    }
  }
  else {
    GFL_PRINT("MdlIsMoveSpeedZero obj_id[%d] none \n", obj_id);
    return false;
  }
}

//-----------------------------------------------------------------------------
/**
 *  @brief  f̑x0ɂ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlSetMoveSpeedZero(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));
  if (p_mmdl) {
    gfl::math::VEC3 speed(0.0f, 0.0f, 0.0f);
    p_mmdl->SetMoveSpeed(speed);
  }
  else {
    GFL_PRINT("MdlSetMoveSpeedZero obj_id[%d] none \n", obj_id);
  }

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *	@brief  f̃^CvAI^ׂ
 *
 *	@retval
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlEventTypeIsAI(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));

  if (p_mmdl) {
    return p_mmdl->GetEventType() == mmodel::EV_TYPE_AI;
  }
  else {
    GFL_PRINT("MdlEventTypeIsAI obj_id[%d] none \n", obj_id);
  }

  return false;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  MoveModelManagerPauseɋIDrawStateDEFAULT_STOPɂ@\ONEOFF
 *          ftHgON@MoveModelManagerPauseMoveProcĂԂтONɂȂB
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlSetPauseAutoWaitAnime(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];
  u16 flag = ptr[2];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
  mmodel::MoveModel* p_mmdl = reinterpret_cast<mmodel::MoveModel*> (p_mmdlman->SearchObjIdWork(obj_id));
  if (p_mmdl) {
    if (flag) {
      p_mmdl->OffMoveBit(mmodel::MoveModelBase::MOVEBIT_NOT_PAUSE_DRAWSTATE_STOP);
    }
    else {
      p_mmdl->OnMoveBit(mmodel::MoveModelBase::MOVEBIT_NOT_PAUSE_DRAWSTATE_STOP);
    }
  }
  else {
    GFL_PRINT("MdlSetMoveSpeedZero obj_id[%d] none \n", obj_id);
  }

  return NULL;
}


//-----------------------------------------------------------------------------
/**
 *  @brief  CxgAjI`FbN
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::BuildMdlEventAnimeIsEnd(AMX * amx, const cell * ptr)
{
  BuildModel* p_bmdl = reinterpret_cast<BuildModel*> (ptr[1]);
  u32 idx = ptr[2];

  if (p_bmdl) {
    return p_bmdl->WaitEventAnime(idx);
  }

  return true;
}

//----------------------------------------------------------------------------
/**
 *  @brief \̕ύX
 */
//-----------------------------------------------------------------------------
cell AMX_NATIVE_CALL FuncSetCommon::ChangeFace(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];
  FACE_TYPE type = (FACE_TYPE)(ptr[2]);
  //wOBJR[h̕\w̕\^CvɕύX
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  mmodel::MoveModel* p_mdl = static_cast<mmodel::MoveModel*> (p_gman->GetFieldmap()->GetMoveModelManager()->SearchObjIdWork(obj_id));

  if (p_mdl)
  {
    p_mdl->ChangeFace( type );
  }

  return NULL;
}

//----------------------------------------------------------------------------
/**
 *  @brief ꃂ[VĐ
 */
//-----------------------------------------------------------------------------
cell AMX_NATIVE_CALL FuncSetCommon::PlaySpMotion(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];
  SP_MOTION motion = (SP_MOTION)(ptr[2]);
  //wOBJR[h̕\w̕\^CvɕύX
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  mmodel::MoveModel* p_mdl = static_cast<mmodel::MoveModel*> (p_gman->GetFieldmap()->GetMoveModelManager()->SearchObjIdWork(obj_id));

  if (p_mdl)
  {
    p_mdl->PlaySpMotion( motion );
  }

  return NULL;
}


//-----------------------------------------------------------------------------
/**
 *  @brief  bɂȂgݍ킹`FbN
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::MdlIsHalfSitSkelPreset(AMX * amx, const cell * ptr)
{
  s16 obj_id = ptr[1];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();

  PlayerGrid* p_player = p_fieldmap->GetFieldPlayer();
  mmodel::MoveModelBase* p_player_mdl;
  p_player_mdl = p_player->GetModel();
  // tB[hvC[̃XPgvZbg
  mmodel::SkelPreset player_sp = static_cast<mmodel::SkelPreset> (p_player_mdl->GetObjCodeParam()->skelton_preset);
  // tB[hvC[̓tH
  FieldUnit::PlayerForm player_form = p_player->GetMoveForm();

  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  Work* p_script_work = p_obj->GetWork();
  mmodel::MoveModelBase* p_other_mdl;
  if (obj_id == -1) {
    p_other_mdl = p_script_work->GetTargetObj();
  }
  else {
    mmodel::Manager* p_mmdlman = p_fieldmap->GetMoveModelManager();
    p_other_mdl = p_mmdlman->SearchObjIdWork(obj_id);
  }

  if( p_other_mdl )
  {
    // tHsԂ[[XP[gԂłȂ΂Ⴊ܂Ȃ
    if( ( player_form != FieldUnit::MOVE_FORM_NORMAL ) &&
        ( player_form != FieldUnit::MOVE_FORM_ROLLER ) )
    {
      return false;
    }

    // bOBJ̃XPgvZbg
    mmodel::SkelPreset other_sp = static_cast<mmodel::SkelPreset> (p_other_mdl->GetObjCodeParam()->skelton_preset);
    // bɂȂgݍ킹`FbN
    return mmodel::MoveModelBase::IsHalfSitSkelPreset(player_sp, other_sp);
  }
  else
  {
    GFL_PRINT("MdlIsHalfSitSkelPreset :  obj_id[%d] none \n", obj_id);
  }

  return NULL;
}

/* ------------------------------------------------------------------------- */
/**
 * @brief ANVR}hINGXgs
 */ 
/* ------------------------------------------------------------------------- */
cell AMX_NATIVE_CALL FuncSetCommon::MdlAcmdEndRequest(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];
  
  System* pThis = System::GetInstance();
  ScriptMoveModelController* p_mmc = pThis->GetSMMController();
  
  p_mmc->RequestAcmdEnd( obj_id );
  
  return NULL;
}

/* ------------------------------------------------------------------------- */
/**
 * @brief ANVR}h̏Im֐
 *
 * @param p_sys
 *
 * @return 
 */
/* ------------------------------------------------------------------------- */
/*
static bool WaitMdlAcmdEnd( System* p_sys )
{
  ScriptMoveModelController* p_mmc = p_sys->GetSMMController();
  
  ScriptObject* p_obj = p_sys->GetObject();
  Work* p_script_work = p_obj->GetWork();
  
  u16 obj_id = p_script_work->GetAcmdEndWaitObjID();

  return p_mmc->WaitAcmdEnd( obj_id ) == false;
}
*/

/* ------------------------------------------------------------------------- */
/**
 * @brief ANVR}hINGXg ҂
 */ 
/* ------------------------------------------------------------------------- */
cell AMX_NATIVE_CALL FuncSetCommon::MdlAcmdEndWait(AMX * amx, const cell * ptr)
{
  u16 obj_id = ptr[1];
  
  System* pThis = System::GetInstance();
  ScriptMoveModelController* p_mmc = pThis->GetSMMController();
  
  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  Work* p_script_work = p_obj->GetWork();

  p_script_work->SetAcmdEndWaitObjID( obj_id );
  
//  pThis->SetWaitFunc( WaitMdlAcmdEnd );
  
  if ( p_mmc->WaitAcmdEnd( obj_id ) )
  {
    return true;
  }
  
  // f
  amx_RaiseError( amx, AMX_ERR_SLEEP );
      
  return false;
}



