//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static void InitPetitCameraParam( FieldStereoCamera * p_camera, SystemWork * pSysWork )
{
  pSysWork->GetStartCameraParam()->Reset();
  pSysWork->GetEndCameraParam()->Reset();
}

static void SetDefaultStartSetting( FieldStereoCamera * p_camera, SystemWork * pSysWork )
{
  InitPetitCameraParam( p_camera, pSysWork );
  xy_system::CCameraPetitAnime::SCameraParam * start = pSysWork->GetStartCameraParam();
  // JWXgA
  gfl::math::VEC3 pos;
  
  p_camera->GetCameraPosition(pos);
  start->m_inCameraPosi = pos;

  p_camera->GetTargetPosition(pos);
  start->m_inLookAtPosi = pos;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  J Jn XNvg
 *
 *  @retval true:I
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CameraStart(AMX * amx, const cell * ptr)
{
  System* pThis = System::GetInstance();
  SystemWork * pSysWork = pThis->GetSystemWork();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  FieldStereoCamera* p_camera = p_gman->GetFieldmap()->GetGraphics()->GetCamera();
  
  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  Work* p_script_work = p_obj->GetWork();
  
  // JJn
  pThis->GetSystemWork()->OnCheckBit( SCR_END_CHECK_BIT_CAMERA );

  // [U[J
  p_camera->SetUserCameraControl(FieldStereoCamera::USER_CONTROL_NORMAL);
  
  // JWXgA
  gfl::math::VEC3 pos;
  
  p_camera->GetCameraPosition(pos);
  p_script_work->SetTempCameraPosition(pos);

  p_camera->GetTargetPosition(pos);
  p_script_work->SetTempTargetPosition(pos);

  return NULL;
}


//-----------------------------------------------------------------------------
/**
 *  @brief  J I XNvg𗣂
 *
 *  @retval true:I
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CameraEnd(AMX *, const cell * ptr)
{
  _CameraEnd();

  return NULL;
}



//-----------------------------------------------------------------------------
/**
 *  @brief  J sړ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CameraTrans(AMX *, const cell * ptr)
{
  gfl::math::VEC3 trans;
  trans.x = amx_ctof(ptr[1]);
  trans.y = amx_ctof(ptr[2]);
  trans.z = amx_ctof(ptr[3]);
  u32 frame = ptr[4];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  FieldStereoCamera* p_camera = p_gman->GetFieldmap()->GetGraphics()->GetCamera();

  FieldStereoCamera::FldCamAnmTransArg arg;
  arg.liner.frame = frame;
  arg.liner.is_rowdata = false;
  p_camera->StartFldCamAnmTrans(trans,
          FieldStereoCamera::FLD_CAM_ANM_TRANS_FUNCTION_LINER,
          arg);

  return NULL;
}

/* ------------------------------------------------------------------------- */
/**
 * @brief Jړ ڍ׎w
 */
/* ------------------------------------------------------------------------- */
cell AMX_NATIVE_CALL FuncSetCommon::CameraTransEx(AMX * amx, const cell * ptr )
{
  f32 pitch = amx_ctof(ptr[1]);
  f32 yaw   = amx_ctof(ptr[2]);
  f32 dist  = amx_ctof(ptr[3]);
  f32 x     = amx_ctof(ptr[4]);
  f32 y     = amx_ctof(ptr[5]);
  f32 z     = amx_ctof(ptr[6]);
  u32 frame = ptr[7];

  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  Work* p_script_work = p_obj->GetWork();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  FieldStereoCamera* p_camera = p_gman->GetFieldmap()->GetGraphics()->GetCamera();

  gfl::math::VEC3 tarpos(x,y,z);

  FieldStereoCamera::FldCamAnmTransArg arg;
  arg.liner.frame = frame;
  arg.liner.is_rowdata = true;
  p_camera->StartFldCamAnmTrans( pitch, yaw, dist, tarpos,
          FieldStereoCamera::FLD_CAM_ANM_TRANS_FUNCTION_LINER,
          arg);
  
  return NULL;
}


//-----------------------------------------------------------------------------
/**
 *  @brief  Jsړ ̏ꏊ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CameraTransRestore(AMX * amx, const cell * ptr)
{
  u32 frame = ptr[1];

  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  Work* p_script_work = p_obj->GetWork();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  FieldStereoCamera* camera = p_gman->GetFieldmap()->GetGraphics()->GetCamera();

  gfl::math::VEC3 campos;
  gfl::math::VEC3 tarpos;

  p_script_work->GetTempCameraPosition(campos);
  p_script_work->GetTempTargetPosition(tarpos);

  FieldStereoCamera::FldCamAnmTransArg arg;
  arg.liner.frame = frame;
  arg.liner.is_rowdata = true;
  camera->StartFldCamAnmTransPosTar( campos, tarpos,
          FieldStereoCamera::FLD_CAM_ANM_TRANS_FUNCTION_LINER,
          arg);

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  Jsړ I`FbN
 *
 *  @retval true:I
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CameraTransIsEnd(AMX *, const cell * ptr)
{
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  FieldStereoCamera* camera = p_gman->GetFieldmap()->GetGraphics()->GetCamera();

  if (camera->IsExecutingFldCamAnmTrans() == false) {
    return true;
  }

  return false;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  J̍Wۑ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CameraStorePos(AMX * amx, const cell *)
{
  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  Work* p_script_work = p_obj->GetWork();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  FieldStereoCamera* camera = p_gman->GetFieldmap()->GetGraphics()->GetCamera();

  gfl::math::VEC3 pos;

  camera->GetCameraPosition(pos);
  p_script_work->SetTempCameraPosition(pos);

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  J̒_ۑ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CameraStoreTar(AMX * amx, const cell *)
{
  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  Work* p_script_work = p_obj->GetWork();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  FieldStereoCamera* camera = p_gman->GetFieldmap()->GetGraphics()->GetCamera();

  gfl::math::VEC3 pos;

  camera->GetTargetPosition(pos);
  p_script_work->SetTempTargetPosition(pos);

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  J̍WXgAW
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CameraRestorePos(AMX * amx, const cell *)
{
  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  Work* p_script_work = p_obj->GetWork();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  FieldStereoCamera* camera = p_gman->GetFieldmap()->GetGraphics()->GetCamera();

  gfl::math::VEC3 pos;

  p_script_work->GetTempCameraPosition(pos);
  camera->SetCameraPosition(pos);

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  J̒_XgAW
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CameraRestoreTar(AMX * amx, const cell *)
{
  ScriptObject* p_obj = ScriptObject::GetClass<ScriptObject*>(amx);
  System* pThis = System::GetInstance();
  Work* p_script_work = p_obj->GetWork();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  FieldStereoCamera* camera = p_gman->GetFieldmap()->GetGraphics()->GetCamera();

  gfl::math::VEC3 pos;

  p_script_work->GetTempTargetPosition(pos);
  camera->SetTargetPosition(pos);

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  J̍Wݒ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CameraSetPos(AMX * amx, const cell * ptr)
{
  gfl::math::VEC3 pos;
  pos.x = amx_ctof(ptr[1]);
  pos.y = amx_ctof(ptr[2]);
  pos.z = amx_ctof(ptr[3]);

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  FieldStereoCamera* camera = p_gman->GetFieldmap()->GetGraphics()->GetCamera();

  camera->SetCameraPosition(pos);

  GFL_PRINT("camera setpos = {%f,%f,%f}\n", pos.x, pos.y, pos.z);

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  J̒_ݒ
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CameraSetTarget(AMX * amx, const cell * ptr)
{
  gfl::math::VEC3 pos;
  pos.x = amx_ctof(ptr[1]);
  pos.y = amx_ctof(ptr[2]);
  pos.z = amx_ctof(ptr[3]);

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  FieldStereoCamera* camera = p_gman->GetFieldmap()->GetGraphics()->GetCamera();

  camera->SetTargetPosition(pos);

  GFL_PRINT("camera settar = {%f,%f,%f}\n", pos.x, pos.y, pos.z);

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  JvZ
 *
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CameraCalculate(AMX * amx, const cell *)
{
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  FieldStereoCamera* camera = p_gman->GetFieldmap()->GetGraphics()->GetCamera();

  // JvZ
  camera->UpdateCameraMatrices();

  return NULL;
}

/* ------------------------------------------------------------------------- */
/**
 * @brief JI
 */
/* ------------------------------------------------------------------------- */
void FuncSetCommon::_CameraEnd( void )
{
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  FieldStereoCamera* p_camera = p_gman->GetFieldmap()->GetGraphics()->GetCamera();
  
  pThis->GetSystemWork()->OffCheckBit( SCR_END_CHECK_BIT_CAMERA );
  
  // [U[슮
  p_camera->SetUserCameraControl(FieldStereoCamera::USER_CONTROL_NONE);
}

//===============================================================================
// fXgN^֐
//===============================================================================

bool FuncSetCommon::SCREND_CheckEndCamera( gamesystem::GameManager* p_gman )
{
  Fieldmap* p_fieldmap = p_gman->GetFieldmap();
  FieldStereoCamera* p_camera = p_gman->GetFieldmap()->GetGraphics()->GetCamera();
  _CameraEnd();
  
  return true;
}

