//-----------------------------------------------------------------------------
/**
 *  @brief  WCJĂяo
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CallGyroCamera(AMX * amx, const cell * ptr)
{
  System* pThis = System::GetInstance();

  gamesystem::GameEventManager* evman;
  EventGyro* event;

  evman = pThis->GetGameManager()->GetGameEventManager();
  event = SCRIPT_EVENT_CALL<gamesystem::GameEventManager, EventGyro > (evman);

  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  WCxgĂяo
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CallEventGymFighting(AMX * amx, const cell * ptr)
{
#if 0 //@todo 20120815 del  
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  gamesystem::GameEventManager* evman = p_gman->GetGameEventManager();

  EventGymFighting* event = SCRIPT_EVENT_CALL<gamesystem::GameEventManager, EventGymFighting > (evman);
  event->SetParameter(p_gman->GetFieldmap());
#endif
  return NULL;
}
//-----------------------------------------------------------------------------
/**
 *  @brief  ߊlfĂяo
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CallCaptureDemo(AMX * amx, const cell * ptr)
{
  System* pThis = System::GetInstance();

  gamesystem::GameEventManager* evman;
  EventCaptureCall* event;

  evman = pThis->GetGameManager()->GetGameEventManager();
  //event = SCRIPT_EVENT_CALL<gamesystem::GameEventManager, EventAppCall > (evman);
  //event->SetCallTargetApplication(EventAppCall::CALL_TARGET_CAPTURE_DEMO);
  //event->SetFadeFlag(false);
  event = SCRIPT_EVENT_CALL<gamesystem::GameEventManager, EventCaptureCall > (evman);

  return NULL;
}

/* ------------------------------------------------------------------------- */
/**
 * @brief zO[̌Ăяo
 */
/* ------------------------------------------------------------------------- */
cell AMX_NATIVE_CALL FuncSetCommon::CallAppHologramMail( AMX* amx, const cell * ptr )
{
  u16 mail_play_no = ptr[1];
  
  gfl::heap::HeapBase* p_heap = gfl::heap::Manager::GetHeapByHeapId(HEAPID_EVENT);
  System* pThis = System::GetInstance();

  gamesystem::GameEventManager* evman;
  EventCallHologramMail* p_event;

  evman = pThis->GetGameManager()->GetGameEventManager();
  
  p_event = SCRIPT_EVENT_CALL<gamesystem::GameEventManager, EventCallHologramMail >( evman );
  p_event->SetParam( app::hologrammail::Proc::MODE_PLAY_MAIL, mail_play_no );

  return NULL;
}

//----------------------------------------------------------------------------
/**
 *  @brief v[VrfIp
 */
//-----------------------------------------------------------------------------
cell AMX_NATIVE_CALL FuncSetCommon::CallPromotion(AMX * amx, const cell * ptr)
{
  System* pThis = System::GetInstance();

  gamesystem::GameEventManager* evman;
  EventAppCall* event;

  evman = pThis->GetGameManager()->GetGameEventManager();
  event = SCRIPT_EVENT_CALL<gamesystem::GameEventManager, EventAppCall > (evman);
  event->SetCallTargetApplication(EventAppCall::CALL_TARGET_PROMOTION);
  
  return NULL;
}

static void callback_wazaomoidashi( EventAppCall::CALLBACK_WORK* wk, gamesystem::GameManager* p_gman )
{
  System* pThis = System::GetInstance();
  ScriptObject* p_obj = pThis->GetObject();
  Work* p_work = p_obj->GetWork();
  
  app::wazaomoidashi::Proc::PARAM* p_param = static_cast<app::wazaomoidashi::Proc::PARAM*>( wk->p_param );
  
  u32 ret = SCR_WAZA_OMOIDASHI_RET_DECIDE;
  
  if( p_param->result == app::wazaomoidashi::Proc::RESULT_CANCEL ) 
  {
    ret = SCR_WAZA_OMOIDASHI_RET_CANCEL;
  }
  
  p_work->SetEventWorkValue( wk->ret_wk1, ret );
  
  GflHeapSafeFreeMemory( wk->p_param );
}

/* ------------------------------------------------------------------------- */
/**
 * @brief ZvoĂяo
 */
/* ------------------------------------------------------------------------- */
cell AMX_NATIVE_CALL FuncSetCommon::CallWazaOmoidashi(AMX* amx, const cell * ptr)
{
  u16 pos = ptr[1]; // |PCfbNX
  u16 ret_wk_code = ptr[2]; 
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  
  pml::PokeParty* party = p_gman->GetGameData()->GetPlayerParty();
  pml::pokepara::PokemonParam* p_pp = party->GetMemberPointer(pos);
  
  u32 size = sizeof( app::wazaomoidashi::Proc::PARAM );
  app::wazaomoidashi::Proc::PARAM* p_param = 
    static_cast<app::wazaomoidashi::Proc::PARAM*>(GflHeapAllocMemory( HEAPID_EVENT, size ));
  
  p_param->pokeparam = p_pp;

  gamesystem::GameEventManager* evman;
  EventAppCall* p_event;

  evman = pThis->GetGameManager()->GetGameEventManager();
  p_event = SCRIPT_EVENT_CALL<gamesystem::GameEventManager, EventAppCall > (evman);
  p_event->SetCallTargetApplication(EventAppCall::CALL_TARGET_WAZA_OMOIDASHI, p_param, callback_wazaomoidashi );
  p_event->SetRetWork( ret_wk_code );
  
  return NULL;
}

/* ------------------------------------------------------------------------- */
/**
 * @brief UYĂяo IR[obN
 *
 * @param wk
 * @param p_gman
 */
/* ------------------------------------------------------------------------- */
static void callback_wazawasure( EventAppCall::CALLBACK_WORK* wk, gamesystem::GameManager* p_gman )
{
  System* pThis = System::GetInstance();
  ScriptObject* p_obj = pThis->GetObject();
  Work* p_work = p_obj->GetWork();
  
  app::wazawasure::Param* p_param = static_cast<app::wazawasure::Param*>( wk->p_param );
  
  p_work->SetEventWorkValue( wk->ret_wk1, p_param->result.waza_removed );
  p_work->SetEventWorkValue( wk->ret_wk2, p_param->result.removed_waza_index );
  
  GflHeapSafeFreeMemory( wk->p_param );
}

/* ------------------------------------------------------------------------- */
/**
 * @brief UYĂяo
 */
/* ------------------------------------------------------------------------- */
cell AMX_NATIVE_CALL FuncSetCommon::CallWazaWasure(AMX* amx, const cell * ptr)
{
  u16 pos = ptr[1]; // |PCfbNX
  u16 ret_wk_removed = ptr[2]; 
  u16 ret_wk_waza_idx = ptr[3]; 
  
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  
  pml::PokeParty* party = p_gman->GetGameData()->GetPlayerParty();
  pml::pokepara::PokemonParam* p_pp = party->GetMemberPointer(pos);
  
  u32 size = sizeof( app::wazawasure::Param );
  app::wazawasure::Param* p_param = 
    static_cast<app::wazawasure::Param*>(GflHeapAllocMemory( HEAPID_EVENT, size ));
  
  p_param->pokeparam = p_pp;

  gamesystem::GameEventManager* evman;
  EventAppCall* p_event;

  evman = pThis->GetGameManager()->GetGameEventManager();
  p_event = SCRIPT_EVENT_CALL<gamesystem::GameEventManager, EventAppCall > (evman);
  p_event->SetCallTargetApplication(EventAppCall::CALL_TARGET_WAZA_WASURE, p_param, callback_wazawasure );
  p_event->SetRetWork( ret_wk_removed, ret_wk_waza_idx );
  
  return NULL;
}

/* ------------------------------------------------------------------------- */
/**
 * @brief UYĂяo IR[obN
 *
 * @param wk
 * @param p_gman
 */
/* ------------------------------------------------------------------------- */
static void callback_wazaoboe( EventAppCall::CALLBACK_WORK* wk, gamesystem::GameManager* p_gman )
{
  System* pThis = System::GetInstance();
  ScriptObject* p_obj = pThis->GetObject();
  Work* p_work = p_obj->GetWork();

  app::wazaoboe::Param* p_param = static_cast<app::wazaoboe::Param*>( wk->p_param );
  
  p_work->SetEventWorkValue( wk->ret_wk1, p_param->result.waza_removed );
  p_work->SetEventWorkValue( wk->ret_wk2, p_param->result.removed_waza_index );
  
  GflHeapSafeFreeMemory( wk->p_param );
}

/* ------------------------------------------------------------------------- */
/**
 * @brief UoĂяo
 */
/* ------------------------------------------------------------------------- */
cell AMX_NATIVE_CALL FuncSetCommon::CallWazaOboe(AMX* amx, const cell * ptr)
{
  u16 pos = ptr[1]; // |PCfbNX
  WazaNo wazano = static_cast<WazaNo>( ptr[2] );
  u16 ret_wk_removed = ptr[3]; 
  u16 ret_wk_waza_idx = ptr[4]; 
  
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  
  pml::PokeParty* party = p_gman->GetGameData()->GetPlayerParty();
  pml::pokepara::PokemonParam* p_pp = party->GetMemberPointer(pos);
  
  u32 size = sizeof( app::wazaoboe::Param );
  app::wazaoboe::Param* p_param = 
    static_cast<app::wazaoboe::Param*>(GflHeapAllocMemory( HEAPID_EVENT, size ));
  
  p_param->pokeparam = p_pp;
  p_param->wazano = wazano;

  gamesystem::GameEventManager* evman;
  EventAppCall* p_event;

  evman = pThis->GetGameManager()->GetGameEventManager();
  p_event = SCRIPT_EVENT_CALL<gamesystem::GameEventManager, EventAppCall > (evman);
  p_event->SetCallTargetApplication(EventAppCall::CALL_TARGET_WAZA_OBOE, p_param, callback_wazaoboe );
  p_event->SetRetWork( ret_wk_removed, ret_wk_waza_idx );
  
  return NULL;
}

/* ------------------------------------------------------------------------- */
/**
 * @brief |P̃jbNl[͗pR[obN
 */
/* ------------------------------------------------------------------------- */
static void callback_pokeparty_name_input( EventAppCall::CALLBACK_WORK* wk, gamesystem::GameManager* p_gman )
{
  System* pThis = System::GetInstance();
  ScriptObject* p_obj = pThis->GetObject();
  Work* p_work = p_obj->GetWork();
  
  app::strinput::APP_PARAM* p_param = static_cast<app::strinput::APP_PARAM*>(wk->p_param);
  
  p_work->SetEventWorkValue( wk->ret_wk1, p_param->changeFlag );

  // jbNl[𔽉f
  if (p_param->changeFlag) 
  {
    p_param->cp->SetNickName( p_param->strBuf );
  }
  
  // @todo R[hZ
  
  GFL_SAFE_DELETE( p_param->strBuf );
}

/* ------------------------------------------------------------------------- */
/**
 * @brief |P̃jbNl[
 */
/* ------------------------------------------------------------------------- */
cell AMX_NATIVE_CALL FuncSetCommon::CallPokePartyNameInput(AMX * amx, const cell * ptr )
{
  u16 ret_wk_is_decide = ptr[1];
  u16 pos = ptr[2];
  bool is_fade = ptr[3];
  
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  gamesystem::GameEventManager* p_evman = pThis->GetGameManager()->GetGameEventManager();
  
  pml::PokeParty* party = p_gman->GetGameData()->GetPlayerParty();
  pml::pokepara::PokemonParam* p_pp = party->GetMemberPointer(pos);
  
  gfl::heap::HeapBase* p_heap = gfl::heap::Manager::GetHeapByHeapId(HEAPID_EVENT);
  
  void*buf;
  EventAppCall* p_event;
  p_event = SCRIPT_EVENT_CALL<gamesystem::GameEventManager, EventAppCall> (p_evman);
  buf = p_event->SetCallTargetApplicationAndAllocParam(EventAppCall::CALL_TARGET_STRINPUT, sizeof(app::strinput::APP_PARAM), callback_pokeparty_name_input);
  
  app::strinput::APP_PARAM* p_param = static_cast<app::strinput::APP_PARAM*> ( buf );
  p_param->pSaveMisc = p_gman->GetGameData()->GetMisc();
  p_param->strBuf = GFL_NEW(p_heap) gfl::str::StrBuf(gamesystem::STRLEN_PERSON_NAME + gamesystem::EOM_LEN, p_heap);
  p_param->type = app::strinput::TYPE_POKEMON_NAME; // |P
  p_param->cp = p_pp;
  
  p_event->SetFadeFlag( is_fade );
  p_event->SetRetWork( ret_wk_is_decide );
  
  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  RCIĂяo
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CallPoke3Select(AMX * amx, const cell * ptr)
{
  System* pThis = System::GetInstance();
  gamesystem::GameEventManager* evman = pThis->GetGameManager()->GetGameEventManager();
  EventPoke3SelectCall* event = SCRIPT_EVENT_CALL<gamesystem::GameEventManager, EventPoke3SelectCall > (evman);
  return NULL;
}

//-----------------------------------------------------------------------------
/**
 *  @brief  PCĂяo
 */
//-----------------------------------------------------------------------------

cell AMX_NATIVE_CALL FuncSetCommon::CallPC(AMX * amx, const cell * ptr) 
{
  System* pThis = System::GetInstance();

  gamesystem::GameEventManager* evman;
  EventAppCall* event;

  evman = pThis->GetGameManager()->GetGameEventManager();
  event = SCRIPT_EVENT_CALL<gamesystem::GameEventManager, EventAppCall > (evman);
  event->SetCallTargetApplication(EventAppCall::CALL_TARGET_BOX);
  
  return NULL;
}

/* ------------------------------------------------------------------------- */
/**
 * @brief obOĂяopR[obN
 *
 * @param wk
 * @param p_gman
 */
/* ------------------------------------------------------------------------- */
static void callback_bag( EventAppCall::CALLBACK_WORK* wk, gamesystem::GameManager* p_gman )
{
  System* pThis = System::GetInstance();
  ScriptObject* p_obj = pThis->GetObject();
  Work* p_work = p_obj->GetWork();
  
  app::bag::APP_PARAM* p_param = static_cast<app::bag::APP_PARAM*>(wk->p_param);
  
  p_work->SetEventWorkValue( wk->ret_wk1, p_param->selItem );
  p_work->SetEventWorkValue( wk->ret_wk2, p_param->endMode );
  
  GflHeapSafeFreeMemory( wk->p_param );
}

//-----------------------------------------------------------------------------
/**
 *  @brief  obNĂяo
 */
//-----------------------------------------------------------------------------
cell AMX_NATIVE_CALL FuncSetCommon::CallBag(AMX * amx, const cell * ptr) 
{
  u8 mode     = ptr[1];
  u16 ret_wk_no_sel_item = ptr[2];
  u16 ret_wk_no_end_mode = ptr[3];
  
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  gamesystem::GameData* p_gdata = p_gman->GetGameData();
  
  app::bag::APP_PARAM* p_param;
  p_param = static_cast<app::bag::APP_PARAM*>(GflHeapAllocMemory( HEAPID_EVENT, sizeof(app::bag::APP_PARAM)));
  
  p_param->callMode    = mode;
  p_param->pokePos     = 0;
  p_param->pocketNo    = BAG_INIT_POCKET_NONE;
  p_param->place       = 0;		// @todo }bvIDĂ
  p_param->pMyStatus   = p_gdata->GetPlayerStatus();
  p_param->pPokemon    = p_gdata->GetPlayerParty();
  p_param->pSaveMyItem = p_gdata->GetMyItem();
  p_param->pSaveBag    = p_gdata->GetBag();
  p_param->pPlayData   = p_gdata->GetBagPlayData();
  p_param->pMisc       = p_gdata->GetMisc();

  gamesystem::GameEventManager* evman;
  EventAppCall* event;

  evman = p_gman->GetGameEventManager();
  event = SCRIPT_EVENT_CALL<gamesystem::GameEventManager, EventAppCall > (evman);
  event->SetCallTargetApplication(EventAppCall::CALL_TARGET_BAG, p_param, callback_bag );
  event->SetRetWork( ret_wk_no_sel_item, ret_wk_no_end_mode );
  
  return NULL;
}

/* ------------------------------------------------------------------------- */
/**
 * @brief |PIĂяopR[obN
 *
 * @param wk R[obN[N
 * @param p_gman Q[}l[W[
 */
/* ------------------------------------------------------------------------- */
static void callback_pokeselect( EventAppCall::CALLBACK_WORK* wk, gamesystem::GameManager* p_gman )
{
  System* pThis = System::GetInstance();
  ScriptObject* p_obj = pThis->GetObject();
  Work* p_work = p_obj->GetWork();

  app::pokelist::Result* p_result = static_cast<app::pokelist::Result*>( wk->p_param );

  
  s32 select = p_result->poke_index;
  
  if( p_result->canceled )
  {
    select = SCR_POKE_SELECT_RET_CANCEL;
  }
  
  p_work->SetEventWorkValue( wk->ret_wk1, select ); 
  
  GflHeapSafeFreeMemory( wk->p_context );
  GflHeapSafeFreeMemory( wk->p_param );
}

/* ------------------------------------------------------------------------- */
/**
 * @brief |PIĂяo
 */
/* ------------------------------------------------------------------------- */
cell AMX_NATIVE_CALL FuncSetCommon::CallPokeSelect(AMX* amx, const cell * ptr )
{
  u32 mode = ptr[1];
  u32 ret_wk_select = ptr[2];
  u32 param = ptr[3];

  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  u32 size;
  
  size = sizeof( app::pokelist::Context );
  app::pokelist::Context* p_context = static_cast<app::pokelist::Context*>(GflHeapAllocMemory( HEAPID_EVENT, size ));
  p_context->my_party = p_gman->GetGameData()->GetPlayerParty();
  
  switch (mode)
  {
  case SCR_POKE_SELECT_MODE_NORMAL:
    p_context->mode     = app::pokelist::MODE_FIELD;
    break;
  case SCR_POKE_SELECT_MODE_SIMPLE :
    p_context->mode     = app::pokelist::MODE_SIMPLE;
    break;
  case SCR_POKE_SELECT_MODE_WAZA:
    {
      p_context->mode     = app::pokelist::MODE_WAZA;
      for (u32 i = 0; i < p_context->my_party->GetMemberCount(); ++i)
      {
        pml::pokepara::PokemonParam* p_pp = p_context->my_party->GetMemberPointer(i);
        p_context->waza_set_param[i] = FuncSetInit::CheckWazaOshieMons( p_pp, param );
      }
    }
    break;
  default : GFL_ASSERT(0);
  }
  
  size = sizeof( app::pokelist::Result );
  void * p_result = GflHeapAllocMemory( HEAPID_EVENT, size );
        
  EventAppCall* p_event = SCRIPT_EVENT_CALL<gamesystem::GameEventManager, EventAppCall>( p_gman->GetGameEventManager() );
  p_event->SetCallTargetApplication( EventAppCall::CALL_TARGET_POKELIST, p_result, callback_pokeselect );
  p_event->SetContext( p_context );
  p_event->SetRetWork( ret_wk_select );

  return NULL;
}

/* ------------------------------------------------------------------------- */
/**
 * @brief {bNX̃|PIAvĂяo
 */
/* ------------------------------------------------------------------------- */
cell AMX_NATIVE_CALL FuncSetCommon::CallBoxSelect(AMX * amx, const cell * ptr)
{
  u16 ret_wk_is_select = ptr[1];
  u32 ret_wk_select_pos = ptr[2];
  u32 ret_wk_select_idx = ptr[3];
  
  System* pThis = System::GetInstance();
  gamesystem::GameManager* p_gman = pThis->GetGameManager();
  gamesystem::GameData* p_gdata = p_gman->GetGameData();
  gamesystem::GameEventManager* p_evman = p_gman->GetGameEventManager();
  
  ScriptObject* p_obj = pThis->GetObject();
  Work* p_work = p_obj->GetWork();

  EventAppCall* p_event;
  p_event = SCRIPT_EVENT_CALL<gamesystem::GameEventManager, EventAppCall > (p_evman);
  app_call::SetupBoxSelect( p_event, p_gdata, p_work, ret_wk_is_select, ret_wk_select_pos, ret_wk_select_idx );
  
  return NULL;
}

