//==============================================================================
/**
 * @file	battle_match_proc_manager.h
 * @brief	og}b`@TuvZX̊Ǘ}l[W
 * @author	ichiraku_katsuhiko
 * @data	2012/08/16, 19:03
 */
// =============================================================================

#if !defined( __BATTLE_MATCH_PROC_MANAGER_H__ )
#define	__BATTLE_MATCH_PROC_MANAGER_H__

#include <gflib.h>
#include "battle_match_proc_base.h"

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match )

class ProcManager
{
	GFL_FORBID_COPY_AND_ASSIGN(ProcManager);

private:
	//-------------------------------------
  ///	TuvbÑV[PX`
  //=====================================
	typedef enum {
		PROCSEQ_INIT = 0,		///< 
		PROCSEQ_UPDATE,			///< XV
		PROCSEQ_EXIT,				///< I
	}ENUM_PROC_SEQ;

public:
  // RXgN^
  ProcManager( app::util::Heap *heap, gamesystem::GameManager *game_manager );
  // fXgN^
  virtual ~ProcManager( void );

public:

  //--------------------------------------------------------------------------
  /**
   *	@brief	
   *	@param	next		ŏɓ삷TuvZX
   *	@param	view		r[̃|C^
   */
  //--------------------------------------------------------------------------
	void Init( PROC_BASE_NEXT next, ViewWork *view );

  //--------------------------------------------------------------------------
  /**
   *	@brief	XV
   */
  //--------------------------------------------------------------------------
	bool Update( void );


private:

  //--------------------------------------------------------------------------
	/**
	 * @brief		TuvbN쐬
   * @param next
   */
  //--------------------------------------------------------------------------
	void CreateSubProc( PROC_BASE_NEXT next );


private:
	app::util::Heap*					m_heap;						///< q[v
	gamesystem::GameManager*	m_game_manager;		///< Q[}l[W
	ViewWork*									m_view;						///< {̃r[[N
	ProcBase*									m_proc;						///< vbNx[X
	ENUM_PROC_SEQ							m_proc_seq;				///< TuvZXV[PX

};

				
GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)

#endif	/* __BATTLE_MATCH_PROC_MANAGER_H__ */

