//==============================================================================
/**
 * @file	battle_match_proc_manager.cpp
 * @brief	og}b`@TuvZX̊Ǘ}l[W
 * @author	ichiraku_katsuhiko
 * @data	2012/08/16, 19:04
 */
// =============================================================================

#include "battle_match_proc_manager.h"

// eTuvZX
#include "battle_match_proc/battle_match_proc_select_match.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match )

// RXgN^
ProcManager::ProcManager( app::util::Heap *heap, gamesystem::GameManager *game_manager ) :
				m_heap( heap ),
				m_game_manager( game_manager ),
				m_view( NULL ),
				m_proc( NULL ),
				m_proc_seq( PROCSEQ_INIT )
{
}

// fXgN^
ProcManager::~ProcManager( void )
{
	GFL_SAFE_DELETE( m_proc );
}

//--------------------------------------------------------------------------
/**
 *	@brief	
 *	@param	next		ŏɓ삷TuvZX
 *	@param	view		r[̃|C^
 */
//--------------------------------------------------------------------------
void ProcManager::Init( PROC_BASE_NEXT next, ViewWork *view )
{
	GFL_ASSERT(view);
	m_view = view;

	CreateSubProc( next );
}

//--------------------------------------------------------------------------
/**
 *	@brief	XV
 */
//--------------------------------------------------------------------------
bool ProcManager::Update( void )
{
	if( m_proc == NULL )
	{
		return true;
	}

	// vbNXVƕύX
	switch( m_proc_seq ){
	case PROCSEQ_INIT:				///< 
		{
			if( m_proc->InitFunc() == RESULT_FINISH )
			{
				m_proc_seq = PROCSEQ_UPDATE;
			}
		}
		break;

	case PROCSEQ_UPDATE:			///< XV
		{
			if( m_proc->UpdateFunc() == RESULT_FINISH )
			{
				m_proc_seq = PROCSEQ_EXIT;
			}
		}
		break;

	case PROCSEQ_EXIT:				///< I
		{
			if( m_proc->ExitFunc() == RESULT_FINISH )
			{
				PROC_BASE_NEXT next = m_proc->GetNext();
				if( next == NEXT_EXIT )
				{
					return true;
				}
				else
				{
					// ̃TuvZX쐬
					GFL_SAFE_DELETE( m_proc );
					CreateSubProc( next );

					m_proc_seq = PROCSEQ_INIT;
				}
			}
		}
		break;
	}

	return false;
}

//==========================================================================
/**
 *					private֐
 */
//==========================================================================
//--------------------------------------------------------------------------
/**
 * @brief		TuvbN쐬
 * @param next
 */
//--------------------------------------------------------------------------
void ProcManager::CreateSubProc( PROC_BASE_NEXT next )
{
	switch( next ){
	case NEXT_SELECT_MATCH:				///< _}b`/΂ƂI
		m_proc = GFL_NEW( m_heap->pHeap ) proc::ProcSelectMatch();
		break;
	case NEXT_SELECT_MODE_1:				///< og[hI
		break;
	case NEXT_SELECT_MODE_2:				///< _}b`[hI
		break;
	case NEXT_SELECT_RULE:					///< og[I
		break;
	case NEXT_SELECT_POKE:					///< og{bNX/莝I
		break;
	case NEXT_CHALLENGE:						///< ̃|PŒ킵܂H
		break;
	case NEXT_SEARCH:							///< ΐ푊T
		break;
	}

	GFL_ASSERT_MSG( m_view, "r[[NnĂȂI\n");

	// ʏ
	m_proc->InitBase( m_view, m_game_manager );
}

GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)

