//==============================================================================
/**
 * @file	battle_match_proc_base.h
 * @brief	og}b`@ẽx[XNX
 * @author	ichiraku_katsuhiko
 * @data	2012/08/15, 18:34
 */
// =============================================================================

#if !defined( __BATTLE_MATCH_PROC_BASE_H__ )
#define	__BATTLE_MATCH_PROC_BASE_H__

#include <gflib.h>
#include <netapp/battle_match/battle_match_next_type.h>

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)

// O錾
class ViewWork;

typedef enum{
	RESULT_CONTINUE,			///< 
	RESULT_FINISH,				///< I
}RESULT;

class ProcBase
{
	GFL_FORBID_COPY_AND_ASSIGN(ProcBase);

public:
  // RXgN^
  ProcBase( void );
  // fXgN^
  virtual ~ProcBase( void );

public:
	//--------------------------------------------------------------------------
	/**
	 * @brief			֐
   * @return		result
	 * 
	 * @note			RES_FINISHԂƂUpdateFuncɐi
   */
  //--------------------------------------------------------------------------
	virtual RESULT InitFunc( void ) = 0;

	//--------------------------------------------------------------------------
	/**
	 * @brief			XV֐
   * @return		result
	 * 
	 * @note			RES_FINISHԂƂExitFuncɐi
   */
  //--------------------------------------------------------------------------
	virtual RESULT UpdateFunc( void ) = 0;

	//--------------------------------------------------------------------------
	/**
	 * @brief			I֐
   * @return		result
	 * 
	 * @note			RES_FINISHԂƂUpdateFuncɐi
   */
  //--------------------------------------------------------------------------
	virtual RESULT ExitFunc( void ) = 0;

public:

  //--------------------------------------------------------------------------
	/**
	 * @brief		NX̏ݒ
	 * 
   * @param		view						r[NX̃|C^
   * @param		game_manager		Q[}l[W
	 * 
	 * @note		NX̍쐬ɌĂԂƁI
   */
  //--------------------------------------------------------------------------
	void InitBase( ViewWork* view, gamesystem::GameManager* game_manager );

  //--------------------------------------------------------------------------
	/**
	 * @brief		INGXg
   * @param		next		̏
   */
  //--------------------------------------------------------------------------
	void SetFinish( PROC_BASE_NEXT next );

  //--------------------------------------------------------------------------
	/**
	 * @brief			̃vbN擾
   * @return		next		̏
   */
  //--------------------------------------------------------------------------
	PROC_BASE_NEXT GetNext( void ) const;

protected:
	gamesystem::GameManager*			m_game_manager;		///< Q[}l[W
	ViewWork*											m_view;						///< r[̃|C^
	int														m_seq;						///< V[PX
	bool													m_isEnd;					///< ItO

private:
	PROC_BASE_NEXT								m_next;						///< ̃TuvbN

};


GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)

#endif	/* __BATTLE_MATCH_PROC_BASE_H__ */

