//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldPlayerActionQueue.cpp
 *	@brief  @ANVL[
 *	@author	tomoya takahaashi
 *	@date		2012.08.16
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include "field/FieldTypes.h"
#include "FieldPlayerActionQueue.h"

#include "field/movemodel/FieldMoveModelBase.h"


namespace field{


//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
  static const PlayerActionData sc_ActionDataTbl[PL_ACTION_MAX] = {
    // PL_ACTION_NONE
    {
      -1,
      -1,
      mmodel::AC_NONE,
      mmodel::AC_NONE,
    },
    // PL_ACTION_ROLLER_SPIN_R,    ///< BXs@E]
    {
      15,
      15,
      mmodel::AC_NONE,
      mmodel::AC_NONE,
    },
    //PL_ACTION_ROLLER_SPIN_L,    ///< BXs@]
    {
      15,
      15,
      mmodel::AC_NONE,
      mmodel::AC_NONE,
    },
    //PL_ACTION_ROLLER_PARALLEL,  ///< p
    {
      15,
      7,
      mmodel::AC_NONE,
      mmodel::AC_NONE,
    },
    //PL_ACTION_ROLLER_DASH,      ///< _bV
    {
      15,
      7,
      mmodel::AC_NONE,
      mmodel::AC_NONE,
    },
  };

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
  const PlayerActionData& PlayerAction_GetData( PlayerAction action )
  {
    if( action < PL_ACTION_MAX ){
      return sc_ActionDataTbl[action];
    }else{
      GFL_ASSERT( action < PL_ACTION_MAX );
    }
    
    return sc_ActionDataTbl[0];
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  RXgN^
   */
  //-----------------------------------------------------------------------------
  PlayerActionQueue::PlayerActionQueue( gfl::heap::HeapBase* p_heap ) : 
    m_StickQueue( p_heap, STICK_QUEUE_MAX ),
    m_ActionQueue( p_heap, ACTION_QUEUE_MAX ),
    m_ActionDequeueCount(CONST_DEQUEUE_COUNT),
    m_pCallBack(NULL)
  {
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  fXgN^
   */
  //-----------------------------------------------------------------------------
  PlayerActionQueue::~PlayerActionQueue()
  {
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  XV
   */
  //-----------------------------------------------------------------------------
  void PlayerActionQueue::Update( const gfl::math::VEC3& stick )
  {
    // GL[
    {
      if( m_StickQueue.IsFull() ){
        m_StickQueue.Dequeue();
      }
      Key key;
      KEY_Initialize( &key, stick );
      m_StickQueue.Enqueue( key );
    }
    
    // ANVR}h`FbN
    PlayerAction action = this->check();
    if( action != PL_ACTION_NONE ){
      if( m_ActionQueue.IsFull() ){
        m_ActionQueue.Dequeue();
      }
      TOMOYA_PRINT( "Enqueue Acton %d\n", action );
      m_ActionQueue.Enqueue( action );

      // dANVsȂ悤ɁA܂ł̃L[jB
      m_StickQueue.Clear();

      // 
      m_ActionDequeueCount = CONST_DEQUEUE_COUNT;
    }

    // IɃfL[
    --m_ActionDequeueCount;
    if( m_ActionDequeueCount <= 0 ){
      if( !m_ActionQueue.IsEmpty() ){
        m_ActionQueue.Dequeue();
      }
    }
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  ݂̃ANVNGXg̎擾
   */
  //-----------------------------------------------------------------------------
  PlayerAction PlayerActionQueue::GetActionRequest( void ) const
  {
    if( !m_ActionQueue.IsEmpty() ){
      return m_ActionQueue.GetData(0);
    }
    return PL_ACTION_NONE;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  ANVNGXg̔j
   */
  //-----------------------------------------------------------------------------
  void PlayerActionQueue::DequeueActionRequest( void )
  {
    if( !m_ActionQueue.IsEmpty() ){
      m_ActionQueue.Dequeue();
    }
    // 
    m_ActionDequeueCount = CONST_DEQUEUE_COUNT;
  } 

  //----------------------------------------------------------------------------
  /**
   *	@brief  NA
   */
  //-----------------------------------------------------------------------------
  void PlayerActionQueue::Clear(void)
  {
    if( !m_StickQueue.IsEmpty() ){
      m_StickQueue.Clear();
    }
    if( !m_ActionQueue.IsEmpty() ){
      m_ActionQueue.Clear();
    }
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  eANṼ`FbNs𐧌䂷R[obN
   */
  //-----------------------------------------------------------------------------
  void PlayerActionQueue::SetCallback( PlayerActionQueueCallBack* p_callback )
  {
    m_pCallBack = p_callback;
  }

#if PM_DEBUG

  // 
  //----------------------------------------------------------------------------
  /**
   *	@brief  ANVR}h̃fobO\
   */
  //-----------------------------------------------------------------------------
  void PlayerActionQueue::DebugPrint( Graphics* p_graphics )
  {
    gfl::grp::GraphicsSystem * pGraphicsSystem = p_graphics->GetGraphicsSystem();
    gfl::grp::RenderTarget* pUpperBuf = pGraphicsSystem->GetCurrentFrameBuffer(gfl::grp::DISPLAY_UPPER);
    if( pGraphicsSystem->BindCurrentCommandList(pUpperBuf) )
    {
      gfl::grp::util::DrawUtil::BeginRender(pUpperBuf);

      static const int KEY_X = 2;
      static const int KEY_Y = 64;
      static const int KEY_Y_OFS = 10;
      static const int ACT_Y_OFS = 15;
      static const int ACT_X = 300;

      static wchar_t s_StringBuffer[64];

      // L[
      static const wchar_t* sc_DirString[DIR_MAX]  = {
        L"@",
        L"@",
        L"@",
        L"@",
        L"",
        L"",
        L"",
        L"",
      };
      // ANV
      static const wchar_t* sc_ActionString[ PL_ACTION_MAX ] = {
        L"none",
        L"spin r",
        L"spin l",
        L"parallel",
        L"dash",
      };

      int x = KEY_X;
      int y = KEY_Y;
      Key key;

      s32 datanum = m_StickQueue.GetDataNum();

      gfl::grp::util::DrawUtil::SetTextScale(0.4f, 0.4f);
      gfl::grp::util::DrawUtil::SetTextColor(VEC4_COLOR_RED);
      
      // L[́@Max
      for( s32 i=datanum-1; i>=0; --i ){
        key = m_StickQueue.GetData(i);
        if( key.dir < DIR_MAX ){
          swprintf( s_StringBuffer, 64, L"%ls [%d]", sc_DirString[key.dir], key.length );
        }else{
          swprintf( s_StringBuffer, 64, L"non [0]" );
        }
        gfl::grp::util::DrawUtil::DrawText(x, y, s_StringBuffer);
        y += KEY_Y_OFS;
      }
      
      
      // ANV@Max2
      x = ACT_X;
      y = KEY_Y;

      gfl::grp::util::DrawUtil::SetTextScale(0.5f, 0.5f);
      gfl::grp::util::DrawUtil::SetTextColor(VEC4_COLOR_WHITE);

      PlayerAction action;

      datanum = m_ActionQueue.GetDataNum();

      for( s32 i=datanum-1; i>=0; --i ){
        action = m_ActionQueue.GetData(i);
        if( action < PL_ACTION_MAX ){
          gfl::grp::util::DrawUtil::DrawText(x, y,sc_ActionString[action]);
        }
        y += ACT_Y_OFS;
      }

      gfl::grp::util::DrawUtil::EndRender();
    }

  }
    
    
#endif // PM_DEBUG



  //-----------------------------------------------------------------------------
  /**
   *    private   ֐Q
   */
  //-----------------------------------------------------------------------------

  //----------------------------------------------------------------------------
  /**
   *	@brief  eANV̎s`FbN
   */
  //-----------------------------------------------------------------------------
  PlayerAction PlayerActionQueue::check( void )
  {
    static bool (PlayerActionQueue::*pFunc[PL_ACTION_MAX])( void ) const =
    {
      NULL,
      &PlayerActionQueue::checkRollerSpinR,
      &PlayerActionQueue::checkRollerSpinL,
      &PlayerActionQueue::checkRollerParallel,
      &PlayerActionQueue::checkRollerDash,
    };
    bool result;

    for( u32 i=0; i<PL_ACTION_MAX; ++i ){
      if( pFunc[i] ){
        
        // R[obNŁAANVPPON/OFFłB
        if( (m_pCallBack == NULL) || 
            (m_pCallBack && m_pCallBack->IsCheck(static_cast<PlayerAction>(i))) ){
          result = (this->*pFunc[i])();

          if( result ){
            return static_cast<PlayerAction>(i);
          }
        }
      }
    }
    
    return PL_ACTION_NONE;
  }

  //----------------------------------------------------------------------------
  /**
   *	@brief  [[XP[g@XsR̃`FbN
   */
  //-----------------------------------------------------------------------------
  bool PlayerActionQueue::checkRollerSpinR( void ) const
  {
    static const u32 MIN_LENGTH = 128;///< ȏ̑傫ȂƂȂB
    static const s32 SKIP_COUNT = 3;  ///< ̐܂ł́A]łOK
    static const u32 OK_ROT_COUNT = 8; ///< ̉45x]A1ƂB


    // XeBbŃARȏȂƂȂB
    u32 datanum = m_StickQueue.GetDataNum();
    if( datanum < ((8 / SKIP_COUNT) + 1) ){
      return false;
    }
    
    // L[̒gԂɌĂAׂẴL[A
    // {ɑJڂāA360xȏ]ĂAZB
    // ԂAł̂́A+SKIP_COUNT܂ŁB

    Key lastKey;
    Key nowKey;
    s32 rot_count;
    s32 total_rot;

    lastKey = m_StickQueue.GetData(0);
    total_rot = 0; // A8ȏJEg邱ƂłOKƂȂB

    for( u32 i=1; i<datanum; ++i ){
      nowKey = m_StickQueue.GetData(i);

      rot_count = mmodel::MoveModelBase::GetTurnCount( static_cast<Dir>(lastKey.dir), static_cast<Dir>(nowKey.dir) );
      
      // Zs
      if( (rot_count < 0) || (rot_count > SKIP_COUNT) || (nowKey.length < MIN_LENGTH) ){
        // ŃZbgB
        total_rot = 0;
      }
      // p
      else{
        // `FbNp
        // g[^̉]`FbN
        total_rot += rot_count;

        if( total_rot >= OK_ROT_COUNT ){
          return true;  // E]III
        }
      }
      
      lastKey = nowKey;
    }
    
    return false;
  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief  [[XP[g@XsL̃`FbN
   */
  //-----------------------------------------------------------------------------
  bool PlayerActionQueue::checkRollerSpinL( void ) const
  {
    static const u32 MIN_LENGTH = 128;///< ȏ̑傫ȂƂȂB
    static const s32 SKIP_COUNT = -3;  ///< ̐܂ł́A]łOK
    static const s32 OK_ROT_COUNT = -8; ///< ̉45x]A1ƂB


    // XeBbŃARȏȂƂȂB
    u32 datanum = m_StickQueue.GetDataNum();
    if( datanum < ((8 / gfl::math::Abs(SKIP_COUNT)) + 1) ){
      return false;
    }
    
    // L[̒gԂɌĂAׂẴL[A
    // {ɑJڂāA360xȏ]ĂAZB
    // ԂAł̂́A+SKIP_COUNT܂ŁB

    Key lastKey;
    Key nowKey;
    s32 rot_count;
    s32 total_rot;

    lastKey = m_StickQueue.GetData(0);
    total_rot = 0; // A8ȏJEg邱ƂłOKƂȂB

    for( u32 i=1; i<datanum; ++i ){
      nowKey = m_StickQueue.GetData(i);

      rot_count = mmodel::MoveModelBase::GetTurnCount( static_cast<Dir>(lastKey.dir), static_cast<Dir>(nowKey.dir) );
      
      // Zs
      if( (rot_count > 0) || (rot_count < SKIP_COUNT) || (nowKey.length < MIN_LENGTH) ){

        // UZbg
        total_rot = 0;
      }
      else{

        // `FbNp
        // g[^̉]`FbN
        total_rot += rot_count;

        if( total_rot <= OK_ROT_COUNT ){
          return true;  // ]III
        }
      }
        
      lastKey = nowKey;
    }
    
    return false;
  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief  [[XP[g@p̃`FbN
   */
  //-----------------------------------------------------------------------------
  bool PlayerActionQueue::checkRollerParallel( void ) const
  {
    static const u32 MAX_FRAME = 6;       ///< R}h͉\@őt[
    static const u32 NEED_LENGHT = 1020;  ///< pɕKvȃL[͂̑傫
    static const u32 OFF_LENGHT = 600;    ///< ǂ܂ŃL[߂΁AǂB
    static const s32 KEY_WAY_DIFF_OK = 1; ///< ܂ł́AL[ςĂOK

    // XeBbŃA3ȏȂƂȂB
    u32 datanum = m_StickQueue.GetDataNum();
    if( datanum < 3 ){
      return false;
    }
    
    // 6fs ȓɁ@Ɂ@2x@lengthMax@oB
    Key startKey;
    Key lastKey;
    Key nowKey;
    s32 rot_count;
    s32 frame = 1;

    b8  is_length_off = false;
    b8  is_length_max = false;
    b8  is_length_off2 = false;
    b8  is_length_max2= false;

    lastKey = m_StickQueue.GetData(0);
    
    for( u32 i=1; i<datanum; ++i ){
      nowKey = m_StickQueue.GetData(i);

      if( lastKey.dir == DIR_NOT ){
        rot_count = 0;
      }else{
        rot_count = mmodel::MoveModelBase::GetTurnCount( static_cast<Dir>(lastKey.dir), static_cast<Dir>(nowKey.dir) );
      }
      
      // Zs
      if( (gfl::math::Abs(rot_count) > KEY_WAY_DIFF_OK) || (frame > MAX_FRAME) ){
        // UZbg
        frame = 0;
        is_length_off = false;
        is_length_max = false;
        is_length_off2 = false;
        is_length_max2= false;
      }
      else{

        // ܂ UXeBbNɂ߂ĂȂ
        if( !is_length_off ){
          if( nowKey.length < OFF_LENGHT ){
            is_length_off = true;
          }
        }
        // ܂1ڂMaxĂȂ
        else if( !is_length_max ){
          if( nowKey.length >= NEED_LENGHT ){
            lastKey = nowKey; // ŃL[vB
            is_length_max = true;
          }
        }
        // ܂ UXeBbNɂ߂ĂȂ
        else if( !is_length_off2 ){
          if( nowKey.length < OFF_LENGHT ){
            is_length_off2 = true;
          }
        }
        // ܂A2ڂMaxoĂȂ
        else if( !is_length_max2 ){
          // ԂɍI@
          if( nowKey.length >= NEED_LENGHT ){
            return true;
          }
        }
      }
      
      ++frame;

      if( !is_length_max ){
        lastKey = nowKey;
      }
    }
    
    return false;
  }
  
  //----------------------------------------------------------------------------
  /**
   *	@brief  [[XP[g@_bṼ`FbN
   */
  //-----------------------------------------------------------------------------
  bool PlayerActionQueue::checkRollerDash( void ) const
  {
    static const u32 DASH_OFF_TO_ON_COUNT  = 3;   ///< t[ȓMaxɂ΂悢̂H
    static const u32 DASH_PUSH_COUNT  = 6;        ///< t[MaxɂȂĂKv邩H
    static const u32 DASH_PUSH_LENGHT = 1020;     ///< ܂ŏグOKƂB
    static const u32 DASH_PUSH_OFF    = 600;      ///< o_
    static const u32 DASH_KEY_DIFF_OK = 1;        ///< L[ςĂ

    // XeBbŃA3ȏȂƂȂB
    u32 datanum = m_StickQueue.GetDataNum();
    if( datanum < 3 ){
      return false;
    }

    Key lastKey;
    Key nowKey;
    s32 rot_count;
    s32 push_on_frame = 0;
    bool error = false;

    b8  is_length_off = false;
    b8  is_length_max = false;

    lastKey = m_StickQueue.GetData(0);
    
    for( u32 i=1; i<datanum; ++i ){
      nowKey = m_StickQueue.GetData(i);

      error = false;

      //DIR_NOT́Am[JEg
      if( lastKey.dir == DIR_NOT ){
        rot_count = 0;
      }else{
        rot_count = mmodel::MoveModelBase::GetTurnCount( static_cast<Dir>(lastKey.dir), static_cast<Dir>(nowKey.dir) );
      }

      // L[͕ςI
      if( (gfl::math::Abs(rot_count) > 0) ){
        error = true;
      }
      else{
      
        // Z`FbN
        // OffԁB
        if( !is_length_off ){
          if( nowKey.length <= DASH_PUSH_OFF ){
            is_length_off = true;
            push_on_frame = 0;
          }
        }
        // OKԂցB
        else if( !is_length_max ){

          ++push_on_frame;
          
          // 񂾁I
          if( nowKey.length >= DASH_PUSH_LENGHT ){
            is_length_max = true;
            push_on_frame = 0;
          }
          // Ԑ؂
          else if( push_on_frame >= DASH_OFF_TO_ON_COUNT ){
            error = true;
          }
        }
        else{
          ++push_on_frame;
          // ȂB
          if( nowKey.length < DASH_PUSH_LENGHT ){
            error = true;
          }
          // 
          else if( push_on_frame >= DASH_PUSH_COUNT ){
            return true;
          }
        }
      }
      
      // Zs
      if( error ){
        // UZbg
        push_on_frame = 0;
        is_length_max = false;
        is_length_off = false;
      }
      
      lastKey = nowKey;
    }
    
    return false;
  }


  //----------------------------------------------------------------------------
  /**
   *	@brief  L[
   */
  //-----------------------------------------------------------------------------
  void PlayerActionQueue::KEY_Initialize( Key* p_key, const gfl::math::VEC3& stick )
  {
    f32 length;
    
    length        = stick.Length() * static_cast<f32>(STICK_LENGTH_MAX);
    if( length > static_cast<f32>(STICK_LENGTH_MAX) ){
      length = static_cast<f32>(STICK_LENGTH_MAX);
    }
    p_key->length = static_cast<u16>(length);

    if( p_key->length != 0 ){
      p_key->dir    = static_cast<u16>(WayToDir( stick ));
    }else{
      p_key->dir    = DIR_NOT;
    }
  }




} // namespace field

