//=============================================================================
/**
 *
 *	@file		funcset_elevator.inc
 *	@brief  XNvg߃ZbgFGx[^[Zbg
 *	@author iwasawa 
 *	@data		2012.08.14
 *
 */
//=============================================================================

//===================================================
//OQ
//===================================================
forward _ElevatorMain( floor_data[], floor_max, talk_pos );

//Gx[^[tAxp[^
enum{
  FLOOR_PARAM_MSG,
  FLOOR_PARAM_ZONE,
  FLOOR_PARAM_X,
  FLOOR_PARAM_Y,
  FLOOR_PARAM_Z,
  FLOOR_PARAM_MAX,
}
#define ELEVATOR_TALK_BOARD 0
#define ELEVATOR_TALK_FRONT 1

#define ElevatorMain(%1,%2) ( _ElevatorMain(%1,sizeof(%1),(%2)) )

/* ------------------------------------------------------------------------- */
/**
* @brief Gx[^j[Ăяo
*
* @param %1 data[]   : Kwf[^z
* @param %2 talk_pos : b|Cg
*/
/* ------------------------------------------------------------------------- */
#define ElevatorMain(%1,%2) ( _ElevatorMain(%1,sizeof(%1),(%2)) )

//======================================================================
//
//    Gx[^[ʏ
//
//======================================================================
/**************************************************************/
/*    Gx[^[C                                         */
/**************************************************************/
stock _ElevatorMain( floor_data[], floor_max, talk_pos )
{
	new ret;
	
	TalkStartSEPlay()
	
	//Gx[^[ɏ荞
	_ElevatorIn( talk_pos );
	
	//tAI
	SysMsg( msg_elevator_start, SYS_WIN_POS_D );	// Kɍs܂H
	ListMenuInit( MENU_X2, MENU_Y2, 0, true, false, NULL );
	for( new i=0; i<floor_max; i+=1 )
	{
    ListMenuAdd( floor_data[i*FLOOR_PARAM_MAX+FLOOR_PARAM_MSG], i );
	}
	ListMenuAdd( msg_elevator_cancel, SCR_LISTMENU_CANCEL );
	ret = ListMenuStart();
	MsgClose();
	
	if( ret != SCR_LISTMENU_CANCEL ){
  	//wtA}bvɈړ
	  _ElevatorMapChangeSelectFloor( floor_data, ret );
	
	  //^CEFCg
	  TimeWait(15);
	
	  //Gx[^
	  SEPlay( SEQ_SE_FLD_009 );
	  SEWait( SEQ_SE_FLD_009 );
	}
	
	//Gx[^[oĂ
	_ElevatorOut()
}

//====================================================
// Gx[^[@IKw̃][Ƀ}bv`FW
//====================================================
stock _ElevatorMapChangeSelectFloor( data[], sel )
{
	new zone = data[sel*FLOOR_PARAM_MAX+FLOOR_PARAM_ZONE];
	new x    = data[sel*FLOOR_PARAM_MAX+FLOOR_PARAM_X];
	new y    = data[sel*FLOOR_PARAM_MAX+FLOOR_PARAM_Y];
	new z    = data[sel*FLOOR_PARAM_MAX+FLOOR_PARAM_Z];
	
  MapChange( zone, x, y, z, DIR_DOWN );
}

/**************************************************************/
/*    Gx[^[ɏ荞                                         */
/**************************************************************/
stock _ElevatorIn( talk_pos )
{
	new gx = PlayerGetFrontGridPosX();
	new gz = PlayerGetFrontGridPosZ();
  new bm_handle = BuildMdlGetHandleByGPos( gx, gz );

	//Gx[^[J
  BuildMdlEventAnimeStart( bm_handle, 0, 1.0 );
	BuildMdlEventAnimeWait( bm_handle, 0 );
	
	//Gx[^[Ɉړ
	switch( talk_pos )
	{
	case ELEVATOR_TALK_BOARD:
	{
		new anm_board[] = {
			AC_WALK_8F, DIR_RIGHT, 1,
			AC_WALK_8F, DIR_UP, 2,
		}
		MdlAnime( OBJID_PLAYER, anm_board );
	}
	case ELEVATOR_TALK_FRONT:
	{
		new anm_front[] = {
			AC_WALK_8F, DIR_UP, 2,
		}
		MdlAnime( OBJID_PLAYER, anm_front );		
	}
	}
	MdlAnimeWait();
	
	//Gx[^[܂
  BuildMdlEventAnimeInvStart( bm_handle, 0, 1.0 );
	BuildMdlEventAnimeWait( bm_handle, 0 );
	
	new anm_turn_down[] = {
		AC_DIR, DIR_DOWN, 1,		
	}
	MdlAnime( OBJID_PLAYER, anm_turn_down );
	MdlAnimeWait();
}

/**************************************************************/
/*    Gx[^[~                                         */
/**************************************************************/
stock _ElevatorOut()
{
	new gx = PlayerGetFrontGridPosX();
	new gz = PlayerGetFrontGridPosZ();
  new bm_handle = BuildMdlGetHandleByGPos( gx, gz );

	//Gx[^[J
  BuildMdlEventAnimeStart( bm_handle, 0, 1.0 );
	BuildMdlEventAnimeWait( bm_handle, 0 );
	
	//Gx[^[OɈړ
	new anm_turn_down[] = {
		AC_WALK_8F, DIR_DOWN, 2,		
	}
	MdlAnime( OBJID_PLAYER, anm_turn_down );
	MdlAnimeWait();	
	
	//Gx[^[܂
  BuildMdlEventAnimeInvStart( bm_handle, 0, 1.0 );
	BuildMdlEventAnimeWait( bm_handle, 0 );
}

