//==============================================================================
/**
 * @file	battle_match_view.h
 * @brief	og}b`O OtBbN
 * @author	ichiraku_katsuhiko
 * @data	2012/08/14, 16:26
 */
// =============================================================================

#if !defined( __BATTLE_MATCH_VIEW_H__ )
#define	__BATTLE_MATCH_VIEW_H__


#include <app/util/app_util_heap.h>
#include <app/util/app_util_2d.h>
#include <app/ui/UIView.h>
#include <app/ui/UIInputListener.h>

#include "BattleMatchUIListener.h"

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)

/**
 *	r[
 */
class ViewWork : public app::ui::UIView, public app::ui::UIInputListener
{
	GFL_FORBID_COPY_AND_ASSIGN(ViewWork);
public:

	//-------------------------------------
  ///	{^`
  //=====================================


	///< ʃAjID ()
	enum {
		ANMID_UPPER_1 = 0,	
		ANMID_UPPER_2,
		ANMID_UPPER_3,
		ANMID_UPPER_4,

		ANMID_UPPER_MAX,
	}E_ANMID_UPPER;

	///< ʃAjID ()
	enum {
		ANMID_LOWER_1 = 0,	
		ANMID_LOWER_2,
		ANMID_LOWER_3,
		ANMID_LOWER_4,
		ANMID_LOWER_5,
		ANMID_LOWER_6,
		ANMID_LOWER_7,
		ANMID_LOWER_8,
		ANMID_LOWER_9,
		ANMID_LOWER_10,
		ANMID_LOWER_11,
		ANMID_LOWER_12,
		ANMID_LOWER_13,
		ANMID_LOWER_14,
		ANMID_LOWER_15,
		ANMID_LOWER_16,
		ANMID_LOWER_17,
		ANMID_LOWER_18,
		
		ANMID_LOWER_MAX,
	}E_ANMID_LOWER;

private:
	typedef enum{
		LAYOUT_ID_UPPER,
		LAYOUT_ID_LOWER,
		LAYOUT_ID_MAX,
	}LAYOUT_ID;


public:
  // RXgN^
  ViewWork( app::util::Heap * heap );

  // fXgN^
  virtual ~ViewWork( void );

public:
	void SetBattleMatchUIListener( BattleMatchUIListener *listener );

public:
	virtual void Update( void );
	virtual void Draw( void );

public:
  // yCANVʒmpXi
  virtual bool OnLayoutPaneEvent( const u32 painId );
  // L[͒ʒmpXi
  virtual bool OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick);

private:
	void Initialize2D( app::util::Heap *heap );

private:
	static const gfl::grp::g2d::LytArcIndex UpperAnmIndex[ ANMID_UPPER_MAX ];	///< Aj[Ve[u
	static const gfl::grp::g2d::LytArcIndex LowerAnmIndex[ ANMID_LOWER_MAX ];	///< Aj[Ve[u

	BattleMatchUIListener*		m_uiListener;		///< UICxgXi
};

GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)


#endif	/* __BATTLE_MATCH_VIEW_H__ */

