//==============================================================================
/**
 * @file	battle_match_view.cpp
 * @brief	og}b`O OtBbN
 * @author	ichiraku_katsuhiko
 * @data	2012/08/14, 16:27
 */
// =============================================================================


#include "battle_match_main.h"

// resource
#include <arc/arc_def.h>
#include <arc/battle_match_res.gaix>
#include <message/message.gaix>
#include <message/msg_battle_match.h>
#include "battle_match_gra.h"
#include "battle_match_gra_pane.h"

#include "common_res/msg_window_res.h"

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)

// Ajf[^()
const gfl::grp::g2d::LytArcIndex ViewWork::UpperAnmIndex[ ViewWork::ANMID_UPPER_MAX ] = {
	LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_UPPER_ANIME_A_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_UPPER_ANIME_B_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_UPPER_ANIME_C_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_UPPER_ANIME_D_BCLAN,
};

// Ajf[^iʁj
const gfl::grp::g2d::LytArcIndex ViewWork::LowerAnmIndex[ ViewWork::ANMID_LOWER_MAX ] = {
	// wb_[̏ԂƓɂ
	LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_RESULT_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_A_1_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_A_2_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_A_3_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_A_4_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_B_1_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_B_2_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_B_3_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_B_4_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_C_1_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_C_2_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_C_3_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_C_4_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_D_1_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_D_2_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_D_3_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_TYPE_D_4_BCLAN,
  LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_YES_NO_BCLAN,
};

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *    ButtonManagerpBoundbox Xg`
 */
//-----------------------------------------------------------------------------

// RXgN^
ViewWork::ViewWork( app::util::Heap * heap ) :
										app::ui::UIView( heap, heap->pDevHeapAllocator, heap->pDevHeapAllocator )
{
	m_uiListener = NULL;

	CreateGraphicsSystem( heap );
	Initialize2D( heap );

	// {^}l[W
	//u32 paneNum = sizeof(ButtonInfoList) / sizeof(app::ui::ButtonInfo);
	//CreateButtonManager( heap, GetLayoutWork(LAYOUT_ID_LOWER),
										 //ButtonInfoList, paneNum );

	SetInputListener( this );
}

// fXgN^
ViewWork::~ViewWork( void )
{
	Delete2D();
	DeleteGraphicsSystem();
}

//--------------------------------------------------------------------------
/**
 * @brief		UICxgpXi̓o^
 */
//--------------------------------------------------------------------------
void ViewWork::SetBattleMatchUIListener( BattleMatchUIListener *listener )
{
	m_uiListener = listener;
}

//--------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 */
//--------------------------------------------------------------------------
void ViewWork::Update(void)
{
  app::ui::UIView::Update();
}

//--------------------------------------------------------------------------
/**
 * @brief		`
 */
//--------------------------------------------------------------------------
void ViewWork::Draw(void)
{
  m_g2dUtil->Draw2D( m_graphicSystem, LAYOUT_ID_UPPER );
  m_g2dUtil->Draw2D( m_graphicSystem, LAYOUT_ID_LOWER );
}

//------------------------------------------------------------------
/**
* @brief   yCCxǧm
*
* @param  layoutId ʒm󂯂郌CAEghc
* @param  painId   ʒm󂯂yChc
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// overwride
bool ViewWork::OnLayoutPaneEvent( const u32 painId )
{
	if( m_uiListener == NULL ){
		return true;
	}

#if 0
  switch( painId ){
		case PANENAME_ASSIST_POWER_LOWER_PANE_ASSIST_BOUND_01:	// p[1
			m_uiListener->OnSelectPowerAction( 0 );
			return false;
		case PANENAME_ASSIST_POWER_LOWER_PANE_ASSIST_BOUND_02:	// p[2
			m_uiListener->OnSelectPowerAction( 1 );
			return false;
    case PANENAME_ASSIST_POWER_LOWER_PANE_ASSIST_BOUND_03:	// p[3
			m_uiListener->OnSelectPowerAction( 2 );
			return false;
    case PANENAME_ASSIST_POWER_LOWER_PANE_ASSIST_BOUND_04:	// p[4
			m_uiListener->OnSelectPowerAction( 3 );
			return false;

    case PANENAME_ASSIST_POWER_LOWER_PANE_WINDOW01:	// ԂɎg{^
			GFL_PRINT("Ɏg{^\n");
			m_uiListener->OnSelectBottomAction( BOTTOM_BUTTON_MINE );
			return false;
    case PANENAME_ASSIST_POWER_LOWER_PANE_WINDOW02:	// ĂɎg{^
			GFL_PRINT("Ɏg{^\n");
			m_uiListener->OnSelectBottomAction( BOTTOM_BUTTON_OTHER );
			return false;
    case PANENAME_ASSIST_POWER_LOWER_PANE_WINDOW03:	// ߂{^
			GFL_PRINT("߂{^\n");
			m_uiListener->OnSelectBottomAction( BOTTOM_BUTTON_RETURN );
			return false;
  }

#endif

  return true;
}


//------------------------------------------------------------------
/**
* @brief   L[͂̌m
*
* @param  pKey    \L[
* @param  pStick  AiOXeBbN
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// overwride
bool ViewWork::OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick)
{
  if( m_uiListener != NULL )
  {
    if( pKey->IsTrigger( gfl::ui::BUTTON_B ) ){
      m_uiListener->OnReturnAction();
      return false;
    }
  }
  return true;
}

//==========================================================================
/**
 *				private֐					
 */
//==========================================================================
//--------------------------------------------------------------------------
/**
 * @brief		2D֘A쐬
 *
 * @param		heap		q[v
 *
 * @return	none
 */
//--------------------------------------------------------------------------
void ViewWork::Initialize2D( app::util::Heap * heap )
{
	static const u32 BATTLE_MATCH_RES_ADD_MAX = LYTRES_MSG_WINDOW_RES_END;

	// A[JCuIDe[u
	static const app::util::G2DUtil::LYT_RES_DATA resTbl[]={
		{ ARCID_BATTLE_MATCH_GRA,	0, BATTLE_MATCH_RES_ADD_MAX, app::util::G2DUtil::ATTACH_ROOT     },
		{ ARCID_COMMON_MSGWINDOW, 0,												0, app::util::G2DUtil::ATTACH_RESOURCE }, // 01: ʃ\[X: bZ[WEBhE
		
	};

	static const app::util::G2DUtil::LYTWK_DATA layoutData[] =
	{
		{	// 
			0,
			LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_UPPER_BCLYT,			// resID̃CAEgf[^ID
      UpperAnmIndex,
      GFL_NELEMS(UpperAnmIndex),
      GFL_NELEMS(UpperAnmIndex),
			false,
			app::util::G2DUtil::SETUP_UPPER,						// fBXvC
			true,																				// \ݒ
		},
		{	// 
			0,
			LYTRES_BATTLE_MATCH_GRA_BATTLEMATCH_LOWER_BCLYT,
      LowerAnmIndex,
      GFL_NELEMS(LowerAnmIndex),
      GFL_NELEMS(LowerAnmIndex),
			false,
			app::util::G2DUtil::SETUP_LOWER,
			true,
		},
	};

	Create2D( heap, NULL, LAYOUT_ID_MAX,
						resTbl, GFL_NELEMS(resTbl),
						layoutData, GFL_NELEMS(layoutData),
						GARC_message_battle_match_DAT );
}

GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)
