//==============================================================================
/**
 * @file	battle_match_main.h
  @brief	og}b`O C
 * @author	ichiraku_katsuhiko
 * @data	2012/08/14, 16:16
 */
// =============================================================================

#if !defined( __BATTLE_MATCH_MAIN_H__ )
#define	__BATTLE_MATCH_MAIN_H__


#include <netapp/battle_match/battle_match.h>

#include "battle_match_view.h"
#include "BattleMatchUIListener.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)

class MainSystem : public BattleMatchUIListener
{
private:
	//-------------------------------------
	/// CV[PX`
  //=====================================
	typedef enum {
		MAINSEQ_INIT = 0,
		MAINSEQ_MAIN,
		MAINSEQ_FADE_OUT,
		MAINSEQ_RELEASE,
		MAINSEQ_END,
	}ENUM_MAIN_SEQ;

public:
  // RXgN^
  MainSystem( APP_PARAM *prm );
  // fXgN^
  virtual ~MainSystem( void );

public:
	bool Update( void );
	void Draw( void );

	//--------------------------------------------------------------
	// UIXi[
	virtual void OnReturnAction( void );

private:
	void CreateSubWork( void );
	void DeleteSubWork( void );

	void SetFadeIn( void );
	void SetFadeOut( void );
	void SetFinish( void );	// Iݒ
	void SetMainSeq( ENUM_MAIN_SEQ seq );
	
	bool DoSeqProcess( void );

private:
	// CV[PX
	void MainSeq_Init( void );
	bool MainSeq_Release( void );
	void MainSeq_Fade( ENUM_MAIN_SEQ seq );
	void MainSeq_Main( void );

private:
  static const u32 APP_HEAP_SIZE    = 0x12000;   // Avp[Jq[vTCY
  static const u32 DEVICE_HEAP_SIZE = 0xD8000;   // Avp[JfoCXq[vTCY

private:
	ViewWork*								m_view;						///< `Ǘ
  app::util::Heap         m_heap;           ///< q[vǗ
  APP_PARAM*              m_appParam;       ///< Np[^
  ENUM_MAIN_SEQ 					m_seq;						///< JgV[PX
  bool                    m_isFinish;       ///< fItO

};

GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)


#endif	/* __BATTLE_MATCH_MAIN_H__ */

