//==============================================================================
/**
 * @file	battle_match_main.cpp
  @brief	og}b`O C
 * @author	ichiraku_katsuhiko
 * @data	2012/08/14, 16:17
 */
// =============================================================================

#include "battle_match_main.h"
#include <gamesystem/ForcedReturnManager.h>

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)

// RXgN^
MainSystem::MainSystem( APP_PARAM *prm )
{
	m_view			= NULL;
	m_isFinish	= false;
	m_appParam	= prm;

	SetMainSeq( MAINSEQ_INIT );
}

// fXgN^
MainSystem::~MainSystem( void )
{
	DeleteSubWork();
}

//--------------------------------------------------------------------------
/**
 * @brief		Abvf[g
 * 
 * @retval	true:
 * @retval	false:ȊO
 */
//--------------------------------------------------------------------------
bool MainSystem::Update( void )
{
	bool isRunning = DoSeqProcess();

	if( m_view != NULL ) 
	{
		m_view->Update();
	}

	return isRunning;
}

//--------------------------------------------------------------------------
/**
 * @brief		`揈
 */
//--------------------------------------------------------------------------
void MainSystem::Draw( void )
{
	if( m_view != NULL )
	{
		m_view->Draw();
	}
}

//--------------------------------------------------------------------------
/**
 * @brief		^[ʒm
 */
//--------------------------------------------------------------------------
void MainSystem::OnReturnAction( void )
{
  //xy_snd::PlaySE( ASSIST_POWER_SE_RETURN );
	ICHI_PRINT("^[ꂽ\n");
	SetFinish();
}

//--------------------------------------------------------------------------
/**
 * @brief		V[PXʃvZX
 * 
 * @retval	true:
 * @retval	false:ȊO
 */
//--------------------------------------------------------------------------
bool MainSystem::DoSeqProcess( void )
{
	switch( m_seq ){
	case MAINSEQ_INIT:			MainSeq_Init();											break;
	case MAINSEQ_MAIN:			MainSeq_Main();											break;
	case MAINSEQ_FADE_OUT:	MainSeq_Fade( MAINSEQ_RELEASE );		break;
	case MAINSEQ_RELEASE:
		if( !MainSeq_Release()	){
			break;
		}
		/* break through */
	case MAINSEQ_END:
		return false;
	}
	return true;
}

//--------------------------------------------------------------------------
/**
 * @brief		Tu[N쐬
 */
//--------------------------------------------------------------------------
void MainSystem::CreateSubWork( void )
{
#if 1 // q[vcʃ`FbN
	{
      gfl::heap::HeapBase* app_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP );
      gfl::heap::HeapBase* dev_heap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE );
      GFL_PRINT( "HEAPID_FREE: 0x%x/0x%x, 0x%x/0x%x\n", 
          app_heap->GetTotalFreeSize(), app_heap->GetTotalSize(),
          dev_heap->GetTotalFreeSize(), dev_heap->GetTotalSize() );
	}
#endif
	

  m_heap.Create( gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP ),
	               gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP_DEVICE ),
	               HEAPID_BATTLE_MATCH_APP, APP_HEAP_SIZE, HEAPID_BATTLE_MATCH_DEVICE, DEVICE_HEAP_SIZE );


	m_view = GFL_NEW( m_heap.pHeap ) ViewWork( &m_heap );

	m_view->SetBattleMatchUIListener( this );
}

//--------------------------------------------------------------------------
/**
 * @brief		Tu[N폜
 */
//--------------------------------------------------------------------------
void MainSystem::DeleteSubWork( void )
{
	GFL_SAFE_DELETE( m_view );
	m_heap.Delete();
}

//--------------------------------------------------------------------------
/**
 * @brief		tF[hCZbg
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------
void MainSystem::SetFadeIn( void )
{
  gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );
}

//--------------------------------------------------------------------------
/**
 * @brief		tF[hAEgZbg
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------
void MainSystem::SetFadeOut( void )
{
  gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_LOWER, gfl::grp::Fade::OUTTYPE_CAPTURE, 1, false );
}

//==========================================================================
/**
 *					CV[PX
 */
//==========================================================================
//--------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @return	̃V[PX
 */
//--------------------------------------------------------------------------
void MainSystem::MainSeq_Init( void )
{
	m_isFinish	= false;

	// Tu[N쐬
	CreateSubWork();

	// tF[hC
	SetFadeIn();
	SetMainSeq( MAINSEQ_MAIN );
}

//--------------------------------------------------------------------------
/**
 * @brief		CV[PXF
 *
 * @param		none
 *
 * @retval	true:
 * @retval	true:쒆
 */
//--------------------------------------------------------------------------
bool MainSystem::MainSeq_Release( void )
{
	// Tu[N폜
	DeleteSubWork();
	SetMainSeq( MAINSEQ_END );

	return true;
}

//--------------------------------------------------------------------------
/**
 * @brief		CV[PXFtF[h҂
 *
 * @param		seq	̃V[PX
 */
//--------------------------------------------------------------------------
void MainSystem::MainSeq_Fade( ENUM_MAIN_SEQ seq )
{
	if( gfl::grp::Fade_IsEnd() ){
	  SetMainSeq( seq );
	}
}

//--------------------------------------------------------------------------
/**
 * @brief		CV[PXFtF[h҂
 *
 * @param		seq	̃V[PX
 */
//--------------------------------------------------------------------------
void MainSystem::MainSeq_Main( void )
{
  if( m_isFinish ||
      GFL_SINGLETON_INSTANCE(gamesystem::ForcedReturnManager)->IsReturn(gamesystem::ForcedReturnManager::FORCERETURN_APP) )
  {
    //if( m_appParam->m_endMode != END_MODE_RETURN ){
      SetFadeOut();
    //}
    SetMainSeq( MAINSEQ_FADE_OUT );
  }
}

//------------------------------------------------------------------
/**
 * @brief CV[PXݒ
 *
 * @param  seq   ؂ւΏۂƂȂV[PX
 */
//------------------------------------------------------------------
void MainSystem::SetMainSeq( ENUM_MAIN_SEQ seq )
{
  m_seq = seq;
}

//------------------------------------------------------------------
/**
 * @brief  j[̏Iݒ
 * @param		retCode IR[h
 */
//------------------------------------------------------------------
void MainSystem::SetFinish( void )
{
  m_isFinish = true;

  // ȍ~̃L[֎~
  m_view->SetInputEnabled( false );
}

GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)
