//==============================================================================
/**
 * @file	battle_match.cpp
 * @brief	og}b`O
 * @author	ichiraku_katsuhiko
 * @data	2012/08/14, 15:58
 */
// =============================================================================


#include "netapp/battle_match/battle_match.h"
#include "battle_match_main.h"

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)

// RXgN^
Proc::Proc( APP_PARAM *prm )
{
	m_appParam  = prm;
  CreateHeap();
	pMain = GFL_NEW( pHeap )	MainSystem( prm );
}

// fXgN^

Proc::~Proc( void )
{
	DeleteHeap();
}

//--------------------------------------------------------------------------
/**
 * @brief		Proc
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------
gfl::proc::Result Proc::InitFunc( gfl::proc::Manager * )
{
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------
/**
 * @brief		ProcI
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------
gfl::proc::Result Proc::EndFunc( gfl::proc::Manager * )
{
	GFL_DELETE	pMain;
	return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------
/**
 * @brief		ProcAbvf[g
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	gfl::proc::Result
 */
//--------------------------------------------------------------------------
gfl::proc::Result Proc::UpdateFunc( gfl::proc::Manager * )
{
	if( pMain->Update() )
	{
	  return gfl::proc::RES_CONTINUE;
	}
  return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------
/**
 * @brief		Proc`揈
 *
 * @param		proc_manager		gfl::proc::Manager
 *
 * @return	none
 */
//--------------------------------------------------------------------------
void Proc::DrawFunc( gfl::proc::Manager * )
{
	pMain->Draw();
}

//--------------------------------------------------------------------------
/**
 * @brief		VXeq[v쐬
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------
void Proc::CreateHeap(void)
{
	pHeap = GFL_CREATE_HEAP( gfl::heap::Manager::GetHeapByHeapId( HEAPID_APP ),
                           HEAPID_BATTLE_MATCH_SYS, SYS_HEAP_SIZE, gfl::heap::HEAP_TYPE_EXP, false );
}

//--------------------------------------------------------------------------
/**
 * @brief		VXeq[v폜
 *
 * @param		none
 *
 * @return	none
 */
//--------------------------------------------------------------------------
void Proc::DeleteHeap(void)
{
	gfl::heap::Manager::DeleteHeap( pHeap );
}				
				
GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)
