//==============================================================================
/**
 * @file	EventBattleMatch.cpp
 * @brief	og}b`OCxg
 * @author	ichiraku_katsuhiko
 * @data	2012/08/15, 11:47
 */
// =============================================================================


#include <gflib.h>
#include <system/main.h>
#include <gamesystem/GameEvent.h>

// eт
#include <netapp/battle_match/battle_match.h>

#include "EventBattleMatch.h"

GFL_NAMESPACE_BEGIN( field )

// RXgN^
EventBattleMatch::EventBattleMatch( gfl::heap::HeapBase* heap ) :
  gamesystem::GameEvent( heap ),
  m_seq( 0 )
{
	m_heap = heap;
  GFL_PRINT("EventBattleMatch::EventBattleMatch()\n");
}
// fXgN^
EventBattleMatch::~EventBattleMatch()
{
  GFL_PRINT("EventBattleMatch::~EventBattleMatch()\n");
}

//--------------------------------------------------------------
// Cxg𓮂Ă悢ǂ̔֐ z֐
//--------------------------------------------------------------
bool EventBattleMatch::BootChk( gamesystem::GameManager* game_manager )
{
  GFL_UNUSED( game_manager );
  return true;
}

//--------------------------------------------------------------
// bootchktruȅꍇɂĂяo鏉֐ z֐
//--------------------------------------------------------------
void EventBattleMatch::InitFunc( gamesystem::GameManager* game_manager )
{
  GFL_UNUSED( game_manager );
}

//--------------------------------------------------------------
// Ăяo֐ z֐
//--------------------------------------------------------------
gamesystem::GMEVENT_RESULT EventBattleMatch::MainFunc( gamesystem::GameManager* game_manager )
{
  gamesystem::GameProcManager* proc_manager = game_manager->GetProcManager();
	gamesystem::GameData* game_data = game_manager->GetGameData();

  switch( m_seq ) {
	case SEQ_INIT:							///< 
    {
			m_seq = SEQ_CALL_PROC;
		}
		break;

	case SEQ_CALL_PROC:			///< vbNĂяo
    {
			netapp::battle_match::APP_PARAM *p_param = static_cast<netapp::battle_match::APP_PARAM *>(this->AllocParam(sizeof(netapp::battle_match::APP_PARAM)));

			dll::CallBattleMatchProc( proc_manager, p_param );

			m_seq = SEQ_CALL_PROC_WAIT;
		}
    break;

  case SEQ_CALL_PROC_WAIT: ///< vbNI҂
    {
      GAMESYSTEM_EVENT_CALL<gamesystem::GameEventManager, EventProcessCall>( game_manager->GetGameEventManager() );
      m_seq = SEQ_CALL_PROC_RET;
    }
    break;

  case SEQ_CALL_PROC_RET:  ///< vbNIJ
    {
      m_seq = SEQ_END;
		}
    break;
  case SEQ_END:
		return gamesystem::GMEVENT_RES_FINISH;

  default:
    GFL_ASSERT(0);
    break;
  }

  return gamesystem::GMEVENT_RES_CONTINUE;
}

//--------------------------------------------------------------
// Ăяo֐ z֐
//--------------------------------------------------------------
void EventBattleMatch::EndFunc( gamesystem::GameManager* game_manager )
{
  GFL_UNUSED( game_manager );

	this->FreeParam();
}

//----------------------------------------------------------------------------
/**
 *	@brief  vZX̃p[^𐶐
 *
 *	@param	size  TCY
 */
//-----------------------------------------------------------------------------
void* EventBattleMatch::AllocParam( u32 size )
{
  void * p_work = GflHeapAllocMemory( HEAPID_EVENT, size );
  m_param = p_work;
  m_param_alloc_flag = true;
  return p_work;
}

//----------------------------------------------------------------------------
/**
 *	@brief  vZX̃p[^j
 */
//-----------------------------------------------------------------------------
void EventBattleMatch::FreeParam( void )
{
  if( m_param_alloc_flag ){
    GflHeapFreeMemory( m_param );
    m_param = NULL;
    m_param_alloc_flag = false;
  }
}

GFL_NAMESPACE_END( field )
