//=============================================================================
/**
 * @class   ScriptMoveModelController.cpp
 * @brief
 * @date    2012.08.14
 * @author  tamada GAMEFREAK inc.
 */
//=============================================================================


#include "./ScriptMoveModelController.h"

GFL_NAMESPACE_BEGIN(field);
GFL_NAMESPACE_BEGIN(script);


//=============================================================================
//=============================================================================
class MMDL_INFO
{
private:
  static const u32 OBJID_DISABLE = 0x100;  //@todo decide value
  bool m_bEVUse;
  bool m_bIEUse;
  bool m_bAIUse;
  u32       m_ObjId;

public:
  MMDL_INFO() { Clear(); }
  ~MMDL_INFO() {}

  void Clear(void)
  {
    m_bEVUse  = FALSE;
    m_bAIUse  = FALSE;
    m_bIEUse  = FALSE;
    m_ObjId   = OBJID_DISABLE;
  }

  u32 GetObjId(void) { return m_ObjId; }

  MMDL_OWNER GetOwner(void)
  {
    if (m_bEVUse) return MMDL_OWNER_EVENT;
    if (m_bIEUse) return MMDL_OWNER_IE;
    if (m_bAIUse) return MMDL_OWNER_AI;
    return MMDL_OWNER_FREE;
  }

  void SetOwner( MMDL_OWNER owner )
  {
    switch ( owner )
    {
    case MMDL_OWNER_EVENT:
      m_bEVUse = true;
      break;
    case MMDL_OWNER_IE:
      m_bIEUse = true;
      break;
    case MMDL_OWNER_AI:
      m_bAIUse = true;
      break;
    }
  }
  void ResetOwner( MMDL_OWNER owner )
  {
    switch ( owner )
    {
    case MMDL_OWNER_EVENT:
      m_bEVUse = false;
      break;
    case MMDL_OWNER_IE:
      m_bIEUse = false;
      break;
    case MMDL_OWNER_AI:
      m_bAIUse = false;
      break;
    }
  }

};

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
ScriptMoveModelController::ScriptMoveModelController( gfl::heap::HeapBase * p_heap )
{
  m_MmdlInfo = GFL_NEW_ARRAY( p_heap ) MMDL_INFO[ ENTRY_MAX ];
  this->Clear();
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
ScriptMoveModelController::~ScriptMoveModelController()
{
  GFL_DELETE_ARRAY( m_MmdlInfo );
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void ScriptMoveModelController::Clear()
{
  for (int i = 0; i < ENTRY_MAX; i ++ )
  {
    m_MmdlInfo[i].Clear();
  }
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
u32 ScriptMoveModelController::GetIndex( u32 objId )
{
  for (int i = 0; i < ENTRY_MAX; i ++ )
  {
    if ( m_MmdlInfo[i].GetObjId() == objId ) return i;
  }
  return ENTRY_MAX;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
bool ScriptMoveModelController::Acquire( MMDL_OWNER owner, u32 objId )
{
  u32 index = GetIndex( objId );
  if ( index != ENTRY_MAX )
  {
    if (m_MmdlInfo[index].GetOwner() < owner )
    {
      m_MmdlInfo[index].SetOwner( owner );
      return true;
    }
    return false; //priority NG
  }
  for ( int i = 0; i < ENTRY_MAX; i ++ )
  {
    if ( m_MmdlInfo[i].GetOwner() == MMDL_OWNER_FREE )
    {
      m_MmdlInfo[i].SetOwner( owner );
      return true;
    }
  }
  GFL_ASSERT( 0 );  //
  return false;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void ScriptMoveModelController::Release( MMDL_OWNER owner, u32 objId )
{
  u32 index = GetIndex( objId );
  if( index == ENTRY_MAX )
  {
    GFL_ASSERT(0);
    return;
  }
  m_MmdlInfo[index].ResetOwner( owner );
}

GFL_NAMESPACE_END(script);
GFL_NAMESPACE_END(field);


