//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *  @file    debug_app_hologrammail_NetworkCEC.cpp
 *  @brief   lbg[NŃzOb̃CRg[NX
 *  @author  suzuki_hisanao
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <Gamesystem/GameProcManager.h>
#include <app/util/app_util_Common.h>
#include <netapp/cec/CecSystem.h>
#include "app/hologram_mail/network/app_hologrammail_NetworkParentView.h"
#include "app_hologrammail_CecMain.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)
GFL_NAMESPACE_BEGIN(cec)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 *  @brief  RXgN^
 *  @param  param 
 */
NetworkCEC::NetworkCEC( app::util::Heap* heap, app::hologrammail::NetworkParentView* view ) :
  m_parent_view( view ),
  m_heap(heap),
  m_cecSys(NULL)
{
}

/**
 *  @brief  fXgN^
 */
NetworkCEC::~NetworkCEC()
{
}



/**
 *  @brief  
 *
 *  @gameMgr Q[}l[W
 */
void NetworkCEC::Initialize( gamesystem::GameManager* gameMgr )
{
  m_cecSys = GFL_NEW( m_heap->GetSystemHeap() ) netapp::cec::CecSystem();
  m_cecSys->Initialize( m_heap->GetSystemHeap() );

  m_parent_view->SetVisibleList( false );
  m_parent_view->SetVisibleWindow( false );
  m_parent_view->SetVisibleTouchbar( false );

  //Xi̓o^
  m_parent_view->SetListener( this );

  m_errorMgr = GFL_SINGLETON_INSTANCE(gflnet::err::ErrManager);

  // ႢBOXLmF
  SearchMessageBox();
}

/**
 *  @brief  I
 */
void NetworkCEC::Finalize( void )
{
  if( m_cecSys != NULL )
  {
    m_cecSys->Finalize();
    GFL_SAFE_DELETE( m_cecSys );
  }
}

/**
 *  @brief  PROCC
 */
bool NetworkCEC::Update( void )
{
  return this->UpdateSequence();
}

/**
 *  @brief  `
 */
void NetworkCEC::Draw( void )
{
}



//-----------------------------------------------------------------------
// PRIVATE
//-----------------------------------------------------------------------
/**
 * @brief V[PXXV
 */
bool NetworkCEC::UpdateSequence( void )
{
  switch(m_sequence)
  {
    case  SEQUENCE_CREATE_BOX:        // ႢBOX̍쐬
      CreateMessageBox();
      break;

    case  SEQUENCE_CHECK_MAIL:        // Ⴂ[̊mF
      CheckMessageBox();
      break;

    case  SEQUENCE_READ_MAIL:         // Ⴂ[̓ǂݍ
      LoadMessageBox();
      break;

    case  SEQUENCE_EULA_MENU:        // EULAAvbg
      DoMenuEULA();
      break;

    case  SEQUENCE_END:               // I
      m_parent_view->SetTimerIconVisible(false);
      return true;

    case  SEQUENCE_ASK_CREATE:
      // YES/NOICxg҂܂傤
      break;

    case  SEQUENCE_EULA_ERROR:        // EULAG[
    case  SEQUENCE_CREATE_SUCCESS:    // ႢBOX̍쐬
    case  SEQUENCE_ERROR:             // G[
    default:
      // bZ[WICxg҂܂傤
      break;
  }

  return false;
}


/**
 * @brief ႢBOX̗LmF
 */
void NetworkCEC::SearchMessageBox( void )
{
  nn::Result ret = m_cecSys->IsCreateBox();

  if( ret.IsSuccess() )
  {
    // bZ[WumFv
    m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_CEC_CHECKING );
    m_sequence = SEQUENCE_CHECK_MAIL;
  }
  else if( ret == nn::cec::ResultNoData() )         // ꂿBOXȂ
  {
    m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_CEC_ASK_CREATE );
    m_sequence = SEQUENCE_ASK_CREATE;
  }
  else if( ret == nn::cec::ResultNotAuthorized() )  // PrivateIDsvI
  {
    // bZ[WuG[v
    m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_CEC_FAILED );
    m_sequence = SEQUENCE_ERROR;
  }
  else
  {
    // bZ[WuG[v
    m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_CEC_FAILED );
    m_sequence = SEQUENCE_ERROR;
  }
}


/**
 * @brief ႢBOX̍쐬
 */
void NetworkCEC::CreateMessageBox( void )
{
  bool isSuccess = m_cecSys->CreateBox();

  if( isSuccess )
  {
    // bZ[Wu쐬܂v
    m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_CEC_CREATE_FINISH );
    m_sequence = SEQUENCE_CREATE_SUCCESS;
  }
  else
  {
    // bZ[Wuȏ쐬łȂv
    m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_CEC_CREATE_LIMIT );
    m_sequence = SEQUENCE_ERROR;
  }
}


/**
 * @brief ႢBOX̒gmF
 */
void NetworkCEC::CheckMessageBox( void )
{
  int dataNum = m_cecSys->GetRecvMessage();

  if( dataNum > 0 )
  {
    GFL_PRINT( "GetRecvMessage() is success[%u]!\n", dataNum );
    // bZ[Wuǂݍݒv
    m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_CEC_LOADING );
    m_sequence = SEQUENCE_READ_MAIL;
  }
  else if( dataNum == 0 )
  {
    GFL_PRINT( "GetRecvMessage() is Empty!\n" );
    m_sequence = SEQUENCE_END;
  }
  else
  {
    GFL_PRINT( "GetRecvMessage() failed!\n" );
    m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_CEC_FAILED );
    m_sequence = SEQUENCE_ERROR;
  }
}


/**
 * @brief ႢBOX̒gǂݍ
 */
void NetworkCEC::LoadMessageBox( void )
{
  netapp::cec::CecSystem::BoxBuffer* boxBuf = m_cecSys->GetBoxData();
  m_sequence = SEQUENCE_END;
}


/**
 * @brief EULAANV
 */
void NetworkCEC::DoMenuEULA( void )
{
  nn::erreula::CTR::ReturnCode retCode;

  retCode = m_errorMgr->ErrorDispDirect( 0, nn::erreula::CTR::ERROR_TYPE_EULA );

  if( retCode == nn::erreula::CTR::RETURN_CODE_SUCCESS )
  {
    // ႢBOXLmF
    SearchMessageBox();
  }
  else
  {
    m_sequence = SEQUENCE_END;
  }
}

/**
 * @brief EULAF؂ɏFĂH
 * @return FĂȂtrueԋp
 */
bool NetworkCEC::IsAgreeEULA( void )
{
  return nn::cfg::CTR::IsAgreedEula();
}



/**
 * @brief Yes{^ꂽɌĂ΂
 */
// @override
void NetworkCEC::OnSelectedYesButton( void )
{
  if( IsAgreeEULA() )
  {
    // bZ[Wu{bNX쐬v
    m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_CEC_CREATING );
    m_sequence = SEQUENCE_CREATE_BOX;
  }
  else
  {
    // bZ[WuEULAG[v
    m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_CEC_EULA_ERROR );
    m_sequence = SEQUENCE_EULA_ERROR;
  }
}

/**
 * @brief No{^ꂽɌĂ΂
 */
// @override
void NetworkCEC::OnSelectedNoButton( void )
{
  m_sequence = SEQUENCE_END;
}

/**
 * @brief bZ[W\I
 */
// @override
void NetworkCEC::OnPrintMessageFinished( void )
{
  if( SEQUENCE_ASK_CREATE == m_sequence ){
    m_parent_view->StartYesNoMenu();
  }
  else if( SEQUENCE_EULA_ERROR == m_sequence ){
    m_sequence = SEQUENCE_EULA_MENU;
  }
  else{
    m_sequence = SEQUENCE_END;
  }
}







GFL_NAMESPACE_END(cec)
GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)

