//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *  @file    debug_app_hologrammail_NetworkMain.cpp
 *  @brief   lbg[NŃzObBOSSRg[NX
 *  @author  suzuki_hisanao
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <Gamesystem/GameProcManager.h>
#include <app/util/app_util_Common.h>
#include "app/hologram_mail/network/app_hologrammail_NetworkParentView.h"
#include "app_hologrammail_BossMain.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)
GFL_NAMESPACE_BEGIN(boss)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 *  @brief  RXgN^
 *  @param  param 
 */
NetworkBoss::NetworkBoss( app::util::Heap* heap, app::hologrammail::NetworkParentView* view ) :
  m_list_data( NULL ),
  m_parent_view( view ),
  m_heap(heap),
  m_sequence( SEQUENCE_START ),
  m_list_data_num(0),
  m_talk_message(NULL)
{

}

/**
 *  @brief  fXgN^
 */
NetworkBoss::~NetworkBoss()
{
}



/**
 *  @brief  
 *
 *  @gameMgr Q[}l[W
 */
void NetworkBoss::Initialize( gamesystem::GameManager* gameMgr )
{
  //Xi̓o^
  m_parent_view->SetListener( this );

  //̂ɂāuLIVEv\肷H
  m_parent_view->SetVisibleLiveIcon( true );

  //ʃXg̃f[^
  this->CreateListData();

  //ʃXg̐ݒs
  m_parent_view->SetupList( 0, 0, m_list_data, m_list_data_num );

  // ^b`o[\
  m_parent_view->SetVisibleTouchbar( true );

  // bZ[WEChE\
  m_parent_view->SetVisibleWindow( false );

  //ʂɕ\镶쐬Ă
  m_talk_message  = GFL_NEW(m_heap->GetSystemHeap()) gfl::str::StrBuf( L"̂悤Ɂ@Ђ傤܂\r", m_heap->GetSystemHeap() );
}

/**
 *  @brief  I
 */
void NetworkBoss::Finalize( void )
{
  if( m_talk_message != NULL )
  {
    GFL_SAFE_DELETE( m_talk_message );
    m_talk_message = NULL;
  }
  //Xỉ
  m_parent_view->SetListener( NULL );

  this->DeleteListData();
}

/**
 *  @brief  PROCC
 */
bool NetworkBoss::Update( void )
{
  return this->UpdateSequence();
}

/**
 *  @brief  `
 */
void NetworkBoss::Draw( void )
{
}



//-----------------------------------------------------------------------
// ParentViewListener̎
//-----------------------------------------------------------------------
/**
 * @brief Xg莞ɌĂ΂
 *        Xg͒~[hɈڍsA
 *        NetworkParentView::RestartListĂ΂ȂƍĊJȂB
 *
 * @param list_index  Xg̃CfbNX
 */
void NetworkBoss::OnSelectedList( u16 list_index )
{
  //XgAʂɕ\be
  NetworkHologramView::LoadDataParameters param =
  {
    m_talk_message,//const gfl::str::StrBuf *message;  ///<be
    NetworkHologramView::BACK_BOARD_TYPE_PRESET_PGL,//BackBoardType back_board_type;    ///<wi̎
    NULL,//const void *board_jpeg_data;      ///<wiJPEGf[^iBACK_BOARD_TYPE_DATÂ݁j
    0,//u32 board_jpeg_size;              ///<wiJPEGTCYiBACK_BOARD_TYPE_DATÂ݁j
  };

  m_parent_view->StartTalkCharacter( param );

  //b̓Xg\
  m_parent_view->SetVisibleList( false );

  //b̓^b`o[\
  m_parent_view->SetVisibleTouchbar( false );
}
/**
 * @brief ʂ̘bA̗ꂪIɌĂ΂
 *        bA̗NetworkParentView::StartTalkCharacterԂƂŊJn
 */
void NetworkBoss::OnEndTalkCharacter( void )
{
  //XgăX^[g
  m_parent_view->ReStartList();

  //\ɂĂ̂Ƃɖ߂
  m_parent_view->SetVisibleList( true );
  m_parent_view->SetVisibleTouchbar( true );
}

/**
 * @brief Exit{^ꂽɌĂ΂
 */
void NetworkBoss::OnSelectedExitButton( void )
{
  m_sequence  = SEQUENCE_END;
}
/**
 * @brief Return{^ꂽɌĂ΂
 */
void NetworkBoss::OnSelectedReturnButton( void )
{
  m_sequence  = SEQUENCE_END;
}

//-----------------------------------------------------------------------
// PRIVATE
//-----------------------------------------------------------------------
/**
 * @brief V[PXXV
 */
bool NetworkBoss::UpdateSequence( void )
{
  switch( m_sequence )
  {
  case SEQUENCE_START:
    // fall
  case SEQUENCE_LOAD:
    m_sequence = SEQUENCE_MAIN;
    break;
  case SEQUENCE_MAIN:
    //Xi[ɂďԑJڂ
    break;
  case SEQUENCE_END:
    return true;
  default:
    GFL_ASSERT(0);
  }

  return false;
}



/**
 * @brief Xgf[^
 */
void NetworkBoss::CreateListData( void )
{
  m_list_data_num = 10;
  m_list_data = GFL_NEW_ARRAY( m_heap->GetSystemHeap() ) app::hologrammail::NetworkMailListView::ListData[m_list_data_num];

  //ȉʃXgɕ\̂̐
  //͍̑sVłcB
  for( int i=0; i<m_list_data_num; ++i )
  {
    m_list_data[i].is_new = i%2; // XǵɁuNEWvƕ\邩ǂ

    gfl::str::STRCODE name[128];
    nn::nstd::TSPrintf( name, L"[%d", i );
    m_list_data[i].string = GFL_NEW(m_heap->GetSystemHeap()) gfl::str::StrBuf( name, m_heap->GetSystemHeap() ); // Xgɕ\镶
  }
}



/**
 * @brief Xgf[^j
 */
void NetworkBoss::DeleteListData( void )
{
  for( int i=0; i<m_list_data_num;++i )
  {
    GFL_SAFE_DELETE( m_list_data[i].string );
  }

  GFL_DELETE_ARRAY m_list_data;
}





GFL_NAMESPACE_END(boss)
GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)

