#!/usr/bin/ruby
#===================================================================
#
# @brief  쐶pogݒRo[^
#
# @data   12.7.24
# @author hosaka_genya->iwasawa
#
#===================================================================

# R[hw
$KCODE = 'SJIS'

#-----------------------------------------------------------------------------
# require
#-----------------------------------------------------------------------------
#CSVǂݍ
require "csv"

# |P̓{ꖼmonsno𓾂rubynbV
require "#{ENV["PROJECT_ROOT"]}/lib/pmlib/tools/hash/monsno_hash.rb"

#===================================================================
# 萔
#===================================================================
FILE_IN = ARGV[0]
FILE_IN_MONSNUM = ARGV[1]
FILE_IN_ITEMSYM = ARGV[2]
FILE_OUT_CDAT = ARGV[3]
FILE_OUT_H    = ARGV[4]

DST_FILENAME = "#{ File::basename(__FILE__).gsub(/\.rb/,"") }"  #o̓t@C
DST_BRIEF = "V{쐶pogݒ"
DST_AUTOR = "iwasawa"
DST_NOTE = "̃t@C #{__FILE__} ɂĎꂽ̂łB"

ROW_ID_NO = 0
ROW_ID_LABEL = 1
ROW_ID_NAME = 2
ROW_ID_FORM = 3
ROW_ID_LEVEL = 4
ROW_ID_RARE = 5
ROW_ID_SEX = 6
ROW_ID_SPABI = 7
ROW_ID_ITEM = 8
ROW_ID_MSG = 9
ROW_ID_FAR_BG = 10
ROW_ID_NEAR_BG = 11
ROW_ID_BTL_EFF = 12
ROW_ID_COMMENT = 13

#\[X̒` src/field/encount/EncountPokeSet.h
$def_rare_hash = {
 "_" => "RARE_REQ_DEFAULT",
 "AŒ" => "RARE_REQ_MUST",
 "m[}Œ" => "RARE_REQ_NOT",
}
$def_sex_hash = {
 "_" => "SEX_REQ_DEFAULT",
 "IXŒ" => "SEX_REQ_MALE",
 "XŒ" => "SEX_REQ_FEMALE",
}
$def_spabi_hash = {
 "_" => "SPABI_REQ_DEFAULT",
 "1" => "SPABI_REQ_01",
 "2" => "SPABI_REQ_02",
 "3" => "SPABI_REQ_03",
}
$def_item_hash = {
 "_" => "ITEM_REQ_DEFAULT",
 "" => "ITEM_REQ_NONE",
}
$def_btlmsg_hash = {
 "ftHg" => "0",
 "b" => "1",
 "`" => "2",
}

#===================================================================
# ֐
#===================================================================
#f[^\
$_enc_data = Struct.new("EncData", \
  :label, :monsname, :mons_sym, :rare, :form, :level, :sex, :spabi, :item, :msg, :far_bg, :near_bg, :btl_eff, :comment)

class CSymbolEncData

  def initialize
    @dataArray = Array.new
  end #initialize

  #------------------------------------------------------------
  # |PS}No擾
  #------------------------------------------------------------
  def getMonsNo( poke_name )
    return $monsno_hash.fetch(poke_name, nil )
  end  #getMonsNo

  #------------------------------------------------------------
  # ACe,X^[V{ID擾
  #------------------------------------------------------------
  def getSymbol( f_path, str_item )
    symbol = nil
    file = File.open( f_path, "r")
	  file.pos = 0
	
    while line = file.gets
		  if( line =~ /\A#define/ && line.include?(str_item) )
			  len = line.length
			  str = line.split() #󔒕ȊO
			  symbol = str[1] #1 V{
        break
      end
    end
    if symbol == nil then
      puts( "#{str_item} is not found ." );
      exit 1
    end
    file.close()
	  return symbol
  end  #getSymbol
  
  #------------------------------------------------------------
  # nbVL[擾
  #------------------------------------------------------------
  def getHash( hash, key, comment )
    value = hash.fetch( key, nil )
    if value == nil then
      puts( "#{comment} `lł->\"#{key}\"" )
      exit 1
    end
    return value
  end #getHash()

  #------------------------------------------------------------
  # tO𐶐
  #------------------------------------------------------------
  def getSetupFlag( row )
    str = "WILD_ENC_FLAG_NONE"
  
    if row[ ROW_ID_LEGEND ] == ""
      str += " | WILD_ENC_FLAG_LEGEND"
    end
    if row[ ROW_ID_RARE ] == ""
      str += " | WILD_ENC_FLAG_RARE"
    end
    if row[ ROW_ID_NOT_ITEM ] == ""
      str += " | WILD_ENC_FLAG_ITEMNONE"
    end
    if row[ ROW_ID_SP3 ] == ""
      str += " | WILD_ENC_FLAG_SPEABI3"
    end
    if row[ ROW_ID_NOT_RARE ] == ""
      str += " | WILD_ENC_FLAG_NOT_RARE"
    end
    if row[ ROW_ID_MALE ] == ""
      str += " | WILD_ENC_FLAG_MALE"
    end
    if row[ ROW_ID_FEMALE ] == ""
      str += " | WILD_ENC_FLAG_FEMALE"
    end
    if row[ ROW_ID_TALK ] == ""
      str += " | WILD_ENC_FLAG_TALK"
    end
  
    if str == ""  
      str = "WILD_ENC_FLAG_NONE"
    end
  
    return str
  end #getSetupFlag()

  #===================================================================
  # 又
  #===================================================================
  def get_data
    puts ">#{FILE_IN}"
    puts ">#{FILE_IN_MONSNUM}"
    puts ">#{FILE_OUT_CDAT}"
    puts ">#{FILE_OUT_H}"

    @dataArray = Array.new

    reader = CSV.open( FILE_IN, "r" )
    reader.shift

    reader.each { |row|
      #Im
      if /#END/ =~ row[0] then
        break
      end
      # 󗓂̓XLbv
      if row[0] == nil 
        next
      end
      @dataArray << $_enc_data.new()

      cp = @dataArray.last()
      cp.label = row[ROW_ID_LABEL].upcase()
      cp.monsname = row[ROW_ID_NAME]
      cp.mons_sym = getSymbol( FILE_IN_MONSNUM, cp.monsname )
      cp.form  = row[ROW_ID_FORM]
      cp.level = row[ROW_ID_LEVEL]
      cp.rare  = getHash( $def_rare_hash, row[ROW_ID_RARE], "Aw" )
      cp.sex   = getHash( $def_sex_hash, row[ROW_ID_SEX], "ʎw" )
      cp.spabi = getHash( $def_spabi_hash, row[ROW_ID_SPABI], "w" )

      cp.item = $def_item_hash.fetch( row[ROW_ID_ITEM], nil )
      if cp.item == nil then
        cp.item = getSymbol( FILE_IN_ITEMSYM, row[ROW_ID_ITEM] )
      end
      cp.msg = "0"
      cp.far_bg =  "xy_system::bg::#{row[ROW_ID_FAR_BG]}"
      cp.near_bg = "xy_system::bg::#{row[ROW_ID_NEAR_BG]}"
      cp.btl_eff = "BATTLE_EFFECT_#{row[ROW_ID_BTL_EFF]}"
    }
    reader.close()
  end #get_data()

  def output_header
    # `𐶐
    File.open( FILE_OUT_H, "w" ){ |file| 
      #wb_o
      file.puts("//=========================================================================")
      file.puts("/**")
      file.puts(" * @file\t" + DST_FILENAME + ".h")
      file.puts(" * @brief\t" + DST_BRIEF)
      file.puts(" * @autor\t" + DST_AUTOR)
      file.puts(" * @note\t" + DST_NOTE)
      file.puts("**/")
      file.puts("//=========================================================================")
      file.puts("#if !defined(__#{DST_FILENAME.upcase}_H__)")
      file.puts("#define __#{DST_FILENAME.upcase}_H__")
      file.puts("\nenum\n{\n")
  
      # f[^
      @dataArray.each{ |data|
        file.puts("\tSYMBOL_ENCOUNT_#{data.label},")
      }
    
      #tb^o
      file.puts("\tSYMBOL_ENCOUNT_MAX,")
      file.puts("};\n")
      file.puts("#endif // __#{DST_FILENAME.upcase}_H__\n")
    }
  end #output_header()

  def output_cdat
    # e[u𐶐
    File.open( FILE_OUT_CDAT, "w" ){ |file| 
      #wb_o
      file.puts("//=========================================================================")
      file.puts("/**")
      file.puts(" * @file\t" + DST_FILENAME + ".cdat")
      file.puts(" * @brief\t" + DST_BRIEF)
      file.puts(" * @autor\t" + DST_AUTOR)
      file.puts(" * @note\t" + DST_NOTE)
      file.puts("**/")
      file.puts("//=========================================================================")
      file.puts("#if !defined(__#{DST_FILENAME.upcase}_CDAT__)")
      file.puts("#define __#{DST_FILENAME.upcase}_CDAT__")
      file.puts("\nstatic const SYMBOL_ENCOUNT_PARAM sc_SymbolEncountTbl[ SYMBOL_ENCOUNT_MAX ] =\n{")
  
      # f[^
      file.puts("  //Monsno,form,level,item,rare,sex,spabi,msg")
      @dataArray.each{ |data|
        file.printf("  { // SYMBOL_ENCOUNT_%s <%s> %s\n", data.label, data.monsname, data.comment )
        file.printf("    %s, %d, %d,  //monsno,form,level\n", data.mons_sym, data.form.to_i, data.level.to_i )
        file.printf("    %s, %s, %s, %s, %s,  //item,rare,sex,spabi,msg\n", data.item, data.rare, data.sex, data.spabi,data.msg )
        file.printf("    %s, %s, %s  //far_bg, near_bg, btl_eff\n", data.far_bg, data.near_bg, data.btl_eff )
        file.printf("  },\n")
      }
      
      #tb^o
      file.puts("};\n")
      file.puts("#endif // __#{DST_FILENAME.upcase}_CDAT__\n")
    }
  end #output_cdat

end  #CSymbolEncData

def convert
  c_enc = CSymbolEncData.new()
  c_enc.get_data()
  c_enc.output_header()
  c_enc.output_cdat()
end  #convert()

convert
