//=============================================================================
/**
 * @file    ScriptInfo.cpp
 * @brief   tB[hXNvg̏ǗNX
 * @author  tamada GAMEFREAK
 * @date    2012.08.10
 */
//=============================================================================

#include <gflib.h>
#include <gfl_debug.h>
#include "ScriptInfo.h"

#include "field/script/FieldScriptSystem.h"

#include "arc/script_message.gaix"
#include "arc/debug_message.gaix"

#include "funcset_id.h"
#include "scr_offset_id.h" // for XNvgID̃ItZbg` ID_XXX

GFL_NAMESPACE_BEGIN( field );
GFL_NAMESPACE_BEGIN( script );

struct SCRIPT_ARC_TABLE
{ 
  u16 scrid_start;
  u16 scrid_end;
  u16 amx_id;
  u16 message_arc_id;
  u16 message_dat_id;
  b32 b_resident;         // 풓tO
};

#include "scr_offset.cdat" // for sc_ScriptArcTable

#include "AIMessage.cdat" // for sc_AIMessageDatTable
#include "FileNameList.cdat" // for sc_ScriptFileNameXXX

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
ScriptInfo::ScriptInfo() :
  m_ScriptType(SCRIPT_TYPE_NONE),
  m_ScriptId(SCRID_DEFAULT),
  m_MsgArcId(ARCID_SCRIPT_MESSAGE),
  m_MsgDatId(0),
  m_RegFuncId(0),
  m_ZoneID(0),
  m_AmxId(ScriptObject::AMX_ID_NULL),
  m_AmxFileName(NULL),

  m_NextTblId(0)
{
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
ScriptInfo::~ScriptInfo()
{
}

//-----------------------------------------------------------------------------
/**
 *	@brief  XNvgID玟ǂݍރf[^o
 *
 *	@param	u32 scrid XNvgID
 */
//-----------------------------------------------------------------------------
void ScriptInfo::SetScriptInfo( u16 zoneId, SCRIPTID scrid, const ZoneDataLoader * zone )
{
  // ʃXNvgǂݍ
  for( u32 i=0; i< GFL_NELEMS( sc_ScriptArcTable ); ++i )
  {
    // SP̓][XNvg
    if( scrid >= SCRID_SP_START && scrid < SCRID_SP_END )
    {
      break;
    }
    const SCRIPT_ARC_TABLE * tbl = sc_ScriptArcTable;
    if( scrid >= tbl[i].scrid_start )
    {
      GFL_ASSERT_STOP_MSG( scrid <= tbl[i].scrid_end, "id=%d end=%d", scrid, tbl[i].scrid_end );
      m_NextTblId   = i;
      m_ScriptId    = scrid;
      m_ScriptType  =  SCRIPT_TYPE_COMMON;
      m_MsgArcId    = tbl[i].message_arc_id;
      m_MsgDatId    = tbl[i].message_dat_id;
      m_ZoneID      = zoneId;
      m_AmxId       = tbl[i].amx_id;
      m_AmxFileName = sc_ScriptFileNameCommon[ m_AmxId ];
      m_RegFuncId   = ScriptObject::GetRegistID( m_ZoneID, m_AmxId, ScriptObject::AMX_ID_NULL );
      //GFL_PRINT( "Common : scrInfo->m_MsgDatId()=%d\n", m_MsgDatId );
      //tbl[i].b_resident 
      return;
    }
  }
  
  // ][XNvgǂݍ
  if( scrid >= ID_START_SCR_OFFSET )
  {
    m_ScriptId    = scrid;
    m_ScriptType  = SCRIPT_TYPE_ZONE;
    m_MsgArcId    = ARCID_SCRIPT_MESSAGE;
    m_MsgDatId    = zone->GetMessageArcID();
    m_ZoneID      = zoneId;
    m_AmxId       = ScriptObject::AMX_ID_NULL;
    m_AmxFileName = sc_ScriptFileNameZone[ m_ZoneID ];
    m_RegFuncId   = ScriptObject::GetRegistID( m_ZoneID, ScriptObject::AMX_ID_NULL, ScriptObject::AMX_ID_NULL );
    //GFL_PRINT( "Zone : scrInfo->m_MsgDatId()=%d\n", m_MsgDatId );
    return;
  }
}

//-----------------------------------------------------------------------------
/**
 *	@brief  AI^̎ǂݍރf[^ݒ肷
 */
//-----------------------------------------------------------------------------
void ScriptInfo::SetScriptInfoAI( SCRIPTID scrid )
{ 
  GFL_ASSERT( GFL_NELEMS( sc_AIMessageDatTable ) > scrid );
  
  m_ScriptId     = scrid;
  m_ScriptType   = SCRIPT_TYPE_AI;
  m_MsgArcId     = ARCID_SCRIPT_MESSAGE;
  m_MsgDatId     = sc_AIMessageDatTable[ scrid ];
  m_AmxId        = ScriptObject::AMX_ID_NULL;
  m_AmxFileName  = sc_ScriptFileNameAI[ m_ScriptId ];
  m_RegFuncId    = ScriptObject::GetRegistID( m_ZoneID, m_AmxId, scrid );
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
const char * ScriptInfo::GetAmxName( SCRIPT_TYPE scrType, u16 index )
{
  static const char * dummy_string = "";
  switch ( scrType )
  {
  case SCRIPT_TYPE_ZONE:
    GFL_ASSERT( index < GFL_NELEMS(sc_ScriptFileNameZone) );
    return sc_ScriptFileNameZone[ index ];

  case SCRIPT_TYPE_COMMON:
    GFL_ASSERT( index < GFL_NELEMS(sc_ScriptFileNameCommon) );
    return sc_ScriptFileNameCommon[ index ];

  case SCRIPT_TYPE_AI:
    GFL_ASSERT( index < GFL_NELEMS(sc_ScriptFileNameAI) );
    return sc_ScriptFileNameAI[ index ];

  case SCRIPT_TYPE_ZONEINIT:
    GFL_ASSERT( index < GFL_NELEMS(sc_ScriptFileNameZoneInit) );
    return sc_ScriptFileNameZoneInit[ index ];
  }
  GFL_ASSERT_MSG(0, "scrType=%d, index=%d\n", scrType, index);
  return dummy_string;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
u32 ScriptInfo::GetCommonAmxNum( void ) { return GFL_NELEMS(sc_ScriptArcTable); }

GFL_NAMESPACE_END( script );
GFL_NAMESPACE_END( field );

