//=============================================================================
/**
 *
 *	@file		RouteMap.cpp
 *	@brief  oHTp}bvNX
 *	@author hosaka genya
 *	@data		2012.08.09
 *
 */
//=============================================================================

#include "RouteMap.h" 

GFL_NAMESPACE_BEGIN( field );

enum 
{ 
  DEBUG_TICK_PRINT_CREATE_MAP,
  
  DEBUG_TICK_PRINT_MAX,
};
GFL_DEBUG_TICK_SETUP(DT_ROUTEMAP, DEBUG_TICK_PRINT_MAX);

RouteMap::RouteMap( void ) :
  m_pMap( NULL ),
  m_MapSize(0)
{

}

RouteMap::~RouteMap()
{
  DeleteMap();
}

static bool AddMapData( const Mapper* cp_mapper, bool * m_pMap, Position& pos, gfl::math::VEC3& vec, u32 cnt )
{
  pos.SetTranslate( &vec );
  
  gfl::grp::map::AttrInfo info;
  Attr attr;
  
  if (cp_mapper->GetAttrInfoOnly( pos, &info ) )
  {
    attr = info.mapAttr[0].attr; // K0Ԃ
    m_pMap[cnt] = AttrData::IsHitch( attr );
    // next x
    vec.x += GRID_SIZE;
    
    return true;
  }
  
  return false;
}

void RouteMap::CreateMap( const Mapper* cp_mapper, gfl::heap::HeapBase* p_heap )
{
  GFL_DEBUG_TICK_SET_FLAG( DT_ROUTEMAP, true );
  GFL_DEBUG_TICK_RESET( DT_ROUTEMAP );
  
  GFL_DEBUG_TICK_START( DT_ROUTEMAP, DEBUG_TICK_PRINT_CREATE_MAP, "createmap" );
  
  // m
  u32 block_num  = cp_mapper->GetBlockNum();
  f32 block_size = cp_mapper->GetBlockSize() / GRID_SIZE;
  u32 attr_num   = block_num * block_size * block_size;
  
  m_MapSize = attr_num;
  
  GFL_ASSERT( m_pMap == NULL );
  
  m_pMap = GFL_NEW_ARRAY( p_heap ) bool[ attr_num ];
  
  // f[^
  gfl::math::VEC3 vec(0,0,0);
  Position pos( cp_mapper->GetRailSystem(), cp_mapper );
  
  u32 line = 0;
  for (u32 cnt = 0; cnt < attr_num; cnt++)
  {
    // 1}Xׂ
    if (AddMapData(cp_mapper, m_pMap, pos, vec, cnt) == false)
    {
      // s
      u32 new_line = ( vec.x / GRID_SIZE ); 
      if( line < new_line )
      {
        line = new_line;
      }
      // next z
      vec.x = 0;
      vec.z += GRID_SIZE;
      
      // ̃}X𒲂ׂ
      if (AddMapData(cp_mapper, m_pMap, pos, vec, cnt) == false)
      {
        break;
      }
    }
  }
  
  // ̐ێ
  m_Line = line;
  
  GFL_DEBUG_TICK_END( DT_ROUTEMAP, DEBUG_TICK_PRINT_CREATE_MAP );
  
#if 0
  s32 tick_createmap = GFL_DEBUG_TICK_US_GET(DT_ROUTEMAP, DEBUG_TICK_PRINT_CREATE_MAP);
  
  // }bvvg
  HOSAKA_PRINT( "=== Route Map ===\n" );
  HOSAKA_PRINT( "create %d us, block size=%f num=%d line=%d \n",
      tick_createmap, block_size, block_num, line );
  for (u32 cnt = 0; cnt < attr_num; cnt++)
  {
    if (cnt % line == 0)
    {
      HOSAKA_PRINT( "\n" );
    }
    HOSAKA_PRINT( "%d ", m_pMap[cnt] );
  }
#endif

}

void RouteMap::DeleteMap( void )
{
  GFL_SAFE_DELETE( m_pMap );
}

bool RouteMap::IsMapHitch( s32 gx, s32 gz ) const
{
  u32 elem = gz * m_Line + gx;

  if (elem < m_MapSize )
  {
    return m_pMap[ elem ];
  }
    
  GFL_ASSERT(0);
  
  return 0;
}
  
GFL_NAMESPACE_END( field );
