//=============================================================================
/**
 * @file   PokemonValidationListener.h
 *
 * @brief  |Ps`FbNpCxgXi
 *
 * @author hisanao suzuki
 */
//=============================================================================

#ifndef __POKEMON_VALIDATION_LISTENER_H__
#define __POKEMON_VALIDATION_LISTENER_H__

#include <gflib.h>
#include <gflnet.h>


namespace netapp {
namespace validation {


class PokemonValidationListener
{
public:
  //------------------------------------------------------------------
  /**
   * @brief |Ps`FbN̊Cxgm
   *
   * @note  {CxgIA[checkResult]z͉
   *
   * @param  resultCode  s`FbÑXe[^XR[h
   * @param  checkResult X̃|P̌ʂzŊi[B
   * @param  resultCode  ʔz̐
   */
  //------------------------------------------------------------------
   virtual void OnPokemonValidationSuccess( const u8 resultCode, const nn::nex::qInt32* checkResult, const u32 resultNum ) = 0;

   //------------------------------------------------------------------
   /**
   * @brief |Ps`FbÑG[Cxgm
   *
   * @note  HTTPʐM̃Xe[^XR[h200ԑȌꍇ̃G[ʒm
   *
   * @param htttpStatus T[oԋpꂽHTTPXe[^XR[h
   */
   //------------------------------------------------------------------
   virtual void OnPokemonValidationError( const s32 htttpStatus ) = 0;

   //------------------------------------------------------------------
   /**
   * @brief |Ps`FbÑG[Cxgm
   *
   * @param  result G[e
   */
   //------------------------------------------------------------------
   virtual void OnPokemonValidationError( const nn::Result &result ) = 0;
};


}	// validation
}	// netapp


#endif // __POKEMON_VALIDATION_LISTENER_H__
