//======================================================================
/**
 * @file  PokemonValidation.cpp
 *
 * @author  suzuki
 */
//======================================================================

#include <netapp/validation/PokemonValidation.h>


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(validation)


//--------------------------------------------------------------------------------------------
/**
* @brief RXgN^
*
* @param none
*
* @return none
*/
//--------------------------------------------------------------------------------------------
PokemonValidation::PokemonValidation( void ) : m_isInit(false), m_postBuffer(NULL), m_caBuffer(NULL)
{
}

//--------------------------------------------------------------------------------------------
/**
* @brief fXgN^
*
* @param none
*
* @return none
*/
//--------------------------------------------------------------------------------------------
PokemonValidation::~PokemonValidation()
{
}

//--------------------------------------------------------------------------------------------
/**
* @brief (ubN֐)
*
* @param heap    obt@mۗpɎgpq[v
* @param devHeap ؖǂݍ݂ɎgpfoCXq[v
*
* @return ȂtrueAsȂfalseԋp
*/
//--------------------------------------------------------------------------------------------
bool PokemonValidation::Initialize( gfl::heap::HeapBase *heap, gfl::heap::HeapBase* devHeap )
{
  if( !m_isInit )
  {
    m_caBuffer   = GflHeapAllocMemoryAlign( heap, CA_BUFFER_SIZE, 4 );
    m_postBuffer = GflHeapAllocMemoryAlign4096( heap, POST_BUFF_SIZE );

    if( (m_caBuffer == NULL) || (m_postBuffer == NULL) )
    {
      Finalize();
      return false;
    }
    if( !LoadCertifyFile() )
    {
      GFL_PRINT( "Load Cert File is Failed!\n" );
      return false;
    }

    m_isInit = true;
  }

  return true;
}

//--------------------------------------------------------------------------------------------
/**
* @brief I
*
* @param none
*
* @return none
*/
//--------------------------------------------------------------------------------------------
void PokemonValidation::Finalize()
{
  GflHeapSafeFreeMemory( m_postBuffer );
  GflHeapSafeFreeMemory( m_caBuffer   );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief ؖt@C̓ǂݍ
 *
 * @param devHeap [hɎgpfoCX
 *
 * @return [hɐȂtrueԋp
 */
//--------------------------------------------------------------------------------------------
bool PokemonValidation::LoadCertifyFile( gfl::heap::HeapBase * devHeap )
{
  if( m_caBuffer == NULL ){
    return false;
  }
  gfl::fs::ArcFile * af = GFL_NEW( devHeap ) gfl::fs::ArcFile( devHeap, ARCID_TOWNMAP_INFO, gfl::fs::ArcFile::OPEN );
  size_t size = af->GetDataSize( itemId );

  if( size == 0 ){
    return false;
  }

  size_t loadSize = af->LoadData( itemId, m_caBuffer );
  GFL_DELETE  af;

  return loadSize == size;
}


//--------------------------------------------------------------------------------------------
/**
* @brief F؃g[N̎擾iubN֐j
*
* @note  InitializeA1񂾂{֐R[Ă
*
* @param none
*
* @return none
*/
//--------------------------------------------------------------------------------------------
bool  PokemonValidation::GetAuthenticationToken( void )
{

}

//--------------------------------------------------------------------------------------------
/**
* @brief ғԔ
*
* @param none
*
* @return ғԂɂȂtrueAғԂȂfalseԋp
*/
//--------------------------------------------------------------------------------------------
bool PokemonValidation::IsEnable( void )
{
  return m_isInit;
}



GFL_NAMESPACE_END(subscription)
GFL_NAMESPACE_END(netapp)
